/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.antlr.runtime.TokenRewriteStream;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;

class UnparseTranslator {
    private final NavigableMap<Integer, Translation> translations = new TreeMap<Integer, Translation>();
    private final List<CopyTranslation> copyTranslations = new ArrayList<CopyTranslation>();
    private boolean enabled;

    void enable() {
        this.enabled = true;
    }

    boolean isEnabled() {
        return this.enabled;
    }

    void addTranslation(ASTNode node, String replacementText) {
        if (!this.enabled) {
            return;
        }
        if (node.getOrigin() != null) {
            return;
        }
        int tokenStartIndex = node.getTokenStartIndex();
        int tokenStopIndex = node.getTokenStopIndex();
        Translation translation = new Translation();
        translation.tokenStopIndex = tokenStopIndex;
        translation.replacementText = replacementText;
        assert (tokenStopIndex >= tokenStartIndex);
        Map.Entry<Integer, Translation> existingEntry = this.translations.floorEntry(tokenStartIndex);
        boolean prefix = false;
        if (existingEntry != null) {
            if (existingEntry.getKey().equals(tokenStartIndex)) {
                if (existingEntry.getValue().tokenStopIndex == tokenStopIndex) {
                    if (existingEntry.getValue().replacementText.equals(replacementText)) {
                        return;
                    }
                } else if (tokenStopIndex > existingEntry.getValue().tokenStopIndex) {
                    prefix = replacementText.startsWith(existingEntry.getValue().replacementText);
                    assert (prefix);
                } else {
                    prefix = existingEntry.getValue().replacementText.startsWith(replacementText);
                    assert (prefix);
                    return;
                }
            }
            if (!prefix) assert (existingEntry.getValue().tokenStopIndex < tokenStartIndex);
        }
        if (!prefix && (existingEntry = this.translations.ceilingEntry(tokenStartIndex)) != null) assert (existingEntry.getKey() > tokenStopIndex);
        existingEntry = this.translations.floorEntry(tokenStopIndex);
        if (existingEntry != null && existingEntry.getKey().equals(tokenStopIndex) && tokenStartIndex < existingEntry.getKey() && tokenStopIndex == existingEntry.getKey()) {
            assert (replacementText.endsWith(existingEntry.getValue().replacementText));
            this.translations.remove(tokenStopIndex);
        }
        this.translations.put(tokenStartIndex, translation);
    }

    void addTableNameTranslation(ASTNode tableName, String currentDatabaseName) {
        if (!this.enabled) {
            return;
        }
        if (tableName.getToken().getType() == 26) {
            this.addIdentifierTranslation(tableName);
            return;
        }
        assert (tableName.getToken().getType() == 786);
        assert (tableName.getChildCount() <= 2);
        if (tableName.getChildCount() == 2) {
            this.addIdentifierTranslation((ASTNode)tableName.getChild(0));
            this.addIdentifierTranslation((ASTNode)tableName.getChild(1));
        } else {
            StringBuilder replacementText = new StringBuilder();
            replacementText.append(HiveUtils.unparseIdentifier(currentDatabaseName));
            replacementText.append('.');
            ASTNode identifier = (ASTNode)tableName.getChild(0);
            String identifierText = BaseSemanticAnalyzer.unescapeIdentifier(identifier.getText());
            replacementText.append(HiveUtils.unparseIdentifier(identifierText));
            this.addTranslation(identifier, replacementText.toString());
        }
    }

    void addIdentifierTranslation(ASTNode identifier) {
        if (!this.enabled) {
            return;
        }
        assert (identifier.getToken().getType() == 26);
        String replacementText = identifier.getText();
        replacementText = BaseSemanticAnalyzer.unescapeIdentifier(replacementText);
        replacementText = HiveUtils.unparseIdentifier(replacementText);
        this.addTranslation(identifier, replacementText);
    }

    void addCopyTranslation(ASTNode targetNode, ASTNode sourceNode) {
        if (!this.enabled) {
            return;
        }
        if (targetNode.getOrigin() != null) {
            return;
        }
        CopyTranslation copyTranslation = new CopyTranslation();
        copyTranslation.targetNode = targetNode;
        copyTranslation.sourceNode = sourceNode;
        this.copyTranslations.add(copyTranslation);
    }

    void applyTranslations(TokenRewriteStream tokenRewriteStream) {
        for (Map.Entry entry : this.translations.entrySet()) {
            tokenRewriteStream.replace(((Integer)entry.getKey()).intValue(), ((Translation)entry.getValue()).tokenStopIndex, (Object)((Translation)entry.getValue()).replacementText);
        }
        for (CopyTranslation copyTranslation : this.copyTranslations) {
            String replacementText = tokenRewriteStream.toString(copyTranslation.sourceNode.getTokenStartIndex(), copyTranslation.sourceNode.getTokenStopIndex());
            String currentText = tokenRewriteStream.toString(copyTranslation.targetNode.getTokenStartIndex(), copyTranslation.targetNode.getTokenStopIndex());
            if (currentText.equals(replacementText)) continue;
            this.addTranslation(copyTranslation.targetNode, replacementText);
            tokenRewriteStream.replace(copyTranslation.targetNode.getTokenStartIndex(), copyTranslation.targetNode.getTokenStopIndex(), (Object)replacementText);
        }
    }

    private static class CopyTranslation {
        ASTNode targetNode;
        ASTNode sourceNode;

        private CopyTranslation() {
        }
    }

    private static class Translation {
        int tokenStopIndex;
        String replacementText;

        private Translation() {
        }

        public String toString() {
            return "" + this.tokenStopIndex + " -> " + this.replacementText;
        }
    }
}

