/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public final class ParseUtils {
    public static boolean isJoinToken(ASTNode node) {
        switch (node.getToken().getType()) {
            case 629: 
            case 657: 
            case 659: 
            case 724: {
                return true;
            }
        }
        return false;
    }

    public static ASTNode findRootNonNullToken(ASTNode tree) {
        while (tree.getToken() == null && tree.getChildCount() > 0) {
            tree = (ASTNode)tree.getChild(0);
        }
        return tree;
    }

    private ParseUtils() {
    }

    public static List<String> validateColumnNameUniqueness(List<FieldSchema> fieldSchemas) throws SemanticException {
        Iterator<FieldSchema> iterCols = fieldSchemas.iterator();
        ArrayList<String> colNames = new ArrayList<String>();
        while (iterCols.hasNext()) {
            String colName = iterCols.next().getName();
            for (String oldColName : colNames) {
                if (!colName.equalsIgnoreCase(oldColName)) continue;
                throw new SemanticException(ErrorMsg.DUPLICATE_COLUMN_NAMES.getMsg(oldColName));
            }
            colNames.add(colName);
        }
        return colNames;
    }
}

