/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.ArchiveUtils;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.index.HiveIndex;
import org.apache.hadoop.hive.ql.index.HiveIndexHandler;
import org.apache.hadoop.hive.ql.io.IgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcBlockMergeInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcMergeMapper;
import org.apache.hadoop.hive.ql.io.rcfile.merge.RCFileBlockMergeInputFormat;
import org.apache.hadoop.hive.ql.io.rcfile.merge.RCFileMergeMapper;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.AlterTablePartMergeFilesDesc;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AddPartitionDesc;
import org.apache.hadoop.hive.ql.plan.AlterDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.AlterIndexDesc;
import org.apache.hadoop.hive.ql.plan.AlterTableAlterPartDesc;
import org.apache.hadoop.hive.ql.plan.AlterTableDesc;
import org.apache.hadoop.hive.ql.plan.AlterTableSimpleDesc;
import org.apache.hadoop.hive.ql.plan.CreateDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.CreateIndexDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.DescDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.DescFunctionDesc;
import org.apache.hadoop.hive.ql.plan.DescTableDesc;
import org.apache.hadoop.hive.ql.plan.DropDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.DropIndexDesc;
import org.apache.hadoop.hive.ql.plan.DropTableDesc;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.GrantDesc;
import org.apache.hadoop.hive.ql.plan.GrantRevokeRoleDDL;
import org.apache.hadoop.hive.ql.plan.ListBucketingCtx;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.LockTableDesc;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.plan.MsckDesc;
import org.apache.hadoop.hive.ql.plan.PartitionSpec;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.PrincipalDesc;
import org.apache.hadoop.hive.ql.plan.PrivilegeDesc;
import org.apache.hadoop.hive.ql.plan.PrivilegeObjectDesc;
import org.apache.hadoop.hive.ql.plan.RenamePartitionDesc;
import org.apache.hadoop.hive.ql.plan.RevokeDesc;
import org.apache.hadoop.hive.ql.plan.RoleDDLDesc;
import org.apache.hadoop.hive.ql.plan.ShowColumnsDesc;
import org.apache.hadoop.hive.ql.plan.ShowCreateTableDesc;
import org.apache.hadoop.hive.ql.plan.ShowDatabasesDesc;
import org.apache.hadoop.hive.ql.plan.ShowFunctionsDesc;
import org.apache.hadoop.hive.ql.plan.ShowGrantDesc;
import org.apache.hadoop.hive.ql.plan.ShowIndexesDesc;
import org.apache.hadoop.hive.ql.plan.ShowLocksDesc;
import org.apache.hadoop.hive.ql.plan.ShowPartitionsDesc;
import org.apache.hadoop.hive.ql.plan.ShowTableStatusDesc;
import org.apache.hadoop.hive.ql.plan.ShowTablesDesc;
import org.apache.hadoop.hive.ql.plan.ShowTblPropertiesDesc;
import org.apache.hadoop.hive.ql.plan.StatsWork;
import org.apache.hadoop.hive.ql.plan.SwitchDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TruncateTableDesc;
import org.apache.hadoop.hive.ql.plan.UnlockTableDesc;
import org.apache.hadoop.hive.ql.security.authorization.Privilege;
import org.apache.hadoop.hive.ql.security.authorization.PrivilegeRegistry;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.TextInputFormat;

public class DDLSemanticAnalyzer
extends BaseSemanticAnalyzer {
    private static final Log LOG = LogFactory.getLog(DDLSemanticAnalyzer.class);
    private static final Map<Integer, String> TokenToTypeName = new HashMap<Integer, String>();
    private final Set<String> reservedPartitionValues = new HashSet<String>();

    public static String getTypeName(int token) throws SemanticException {
        if (token == 600 || token == 601) {
            throw new SemanticException(ErrorMsg.UNSUPPORTED_TYPE.getMsg());
        }
        return TokenToTypeName.get(token);
    }

    public DDLSemanticAnalyzer(HiveConf conf) throws SemanticException {
        super(conf);
        this.reservedPartitionValues.add(HiveConf.getVar(conf, HiveConf.ConfVars.DEFAULTPARTITIONNAME));
        this.reservedPartitionValues.add(HiveConf.getVar(conf, HiveConf.ConfVars.DEFAULT_ZOOKEEPER_PARTITION_NAME));
        this.reservedPartitionValues.add(HiveConf.getVar(conf, HiveConf.ConfVars.METASTORE_INT_ORIGINAL));
        this.reservedPartitionValues.add(HiveConf.getVar(conf, HiveConf.ConfVars.METASTORE_INT_ARCHIVED));
        this.reservedPartitionValues.add(HiveConf.getVar(conf, HiveConf.ConfVars.METASTORE_INT_EXTRACTED));
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        switch (ast.getToken().getType()) {
            case 563: {
                ASTNode tablePart = (ASTNode)ast.getChild(0);
                TablePartition tblPart = new TablePartition(tablePart);
                String tableName = tblPart.tableName;
                HashMap<String, String> partSpec = tblPart.partSpec;
                ast = (ASTNode)ast.getChild(1);
                if (ast.getToken().getType() == 561) {
                    this.analyzeAlterTableFileFormat(ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() == 556) {
                    this.analyzeAlterTableProtectMode(ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() == 562) {
                    this.analyzeAlterTableLocation(ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() == 555) {
                    this.analyzeAlterTablePartMergeFiles(tablePart, ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() == 570) {
                    this.analyzeAlterTableSerde(ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() == 569) {
                    this.analyzeAlterTableSerdeProps(ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() == 567) {
                    this.analyzeAlterTableRenamePart(ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() == 574) {
                    this.analyzeAlterTableSkewedLocation(ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() == 767) {
                    this.analyzeAlterTableBucketNum(ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() != 559) break;
                this.analyzeAlterTableClusterSort(ast, tableName, partSpec);
                break;
            }
            case 617: {
                this.analyzeDropTable(ast, false);
                break;
            }
            case 801: {
                this.analyzeTruncateTable(ast);
                break;
            }
            case 590: {
                this.analyzeCreateIndex(ast);
                break;
            }
            case 615: {
                this.analyzeDropIndex(ast);
                break;
            }
            case 607: {
                this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
                this.analyzeDescribeTable(ast);
                break;
            }
            case 735: {
                this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
                this.analyzeShowDatabases(ast);
                break;
            }
            case 740: {
                this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
                this.analyzeShowTables(ast);
                break;
            }
            case 734: {
                this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
                this.analyzeShowColumns(ast);
                break;
            }
            case 744: {
                this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
                this.analyzeShowTableStatus(ast);
                break;
            }
            case 745: {
                this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
                this.analyzeShowTableProperties(ast);
                break;
            }
            case 736: {
                this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
                this.analyzeShowFunctions(ast);
                break;
            }
            case 738: {
                this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
                this.analyzeShowLocks(ast);
                break;
            }
            case 606: {
                this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
                this.analyzeDescFunction(ast);
                break;
            }
            case 605: {
                this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
                this.analyzeDescDatabase(ast);
                break;
            }
            case 670: {
                this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
                this.analyzeMetastoreCheck(ast);
                break;
            }
            case 619: {
                this.analyzeDropTable(ast, true);
                break;
            }
            case 578: {
                this.analyzeAlterTableProps(ast, true, false);
                break;
            }
            case 620: {
                this.analyzeAlterTableProps(ast, true, true);
                break;
            }
            case 575: {
                this.analyzeAlterTableAddParts((ASTNode)ast.getChild(0), true);
                break;
            }
            case 577: {
                this.analyzeAlterTableDropParts((ASTNode)ast.getChild(0), true);
                break;
            }
            case 579: {
                this.analyzeAlterTableRename((ASTNode)ast.getChild(0), true);
                break;
            }
            case 565: {
                this.analyzeAlterTableRename(ast, false);
                break;
            }
            case 572: {
                this.analyzeAlterTableTouch(ast);
                break;
            }
            case 557: {
                this.analyzeAlterTableArchive(ast, false);
                break;
            }
            case 573: {
                this.analyzeAlterTableArchive(ast, true);
                break;
            }
            case 552: {
                this.analyzeAlterTableModifyCols(ast, AlterTableDesc.AlterTableTypes.ADDCOLS);
                break;
            }
            case 568: {
                this.analyzeAlterTableModifyCols(ast, AlterTableDesc.AlterTableTypes.REPLACECOLS);
                break;
            }
            case 566: {
                this.analyzeAlterTableRenameCol(ast);
                break;
            }
            case 553: {
                this.analyzeAlterTableAddParts(ast, false);
                break;
            }
            case 560: {
                this.analyzeAlterTableDropParts(ast, false);
                break;
            }
            case 554: {
                this.analyzeAlterTableAlterParts(ast);
                break;
            }
            case 564: {
                this.analyzeAlterTableProps(ast, false, false);
                break;
            }
            case 618: {
                this.analyzeAlterTableProps(ast, false, true);
                break;
            }
            case 551: {
                this.analyzeAlterIndexRebuild(ast);
                break;
            }
            case 550: {
                this.analyzeAlterIndexProps(ast);
                break;
            }
            case 739: {
                this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
                this.analyzeShowPartitions(ast);
                break;
            }
            case 741: {
                this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
                this.analyzeShowCreateTable(ast);
                break;
            }
            case 737: {
                this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
                this.analyzeShowIndexes(ast);
                break;
            }
            case 667: {
                this.analyzeLockTable(ast);
                break;
            }
            case 805: {
                this.analyzeUnlockTable(ast);
                break;
            }
            case 588: {
                this.analyzeCreateDatabase(ast);
                break;
            }
            case 613: {
                this.analyzeDropDatabase(ast);
                break;
            }
            case 758: {
                this.analyzeSwitchDatabase(ast);
                break;
            }
            case 549: {
                this.analyzeAlterDatabase(ast);
                break;
            }
            case 592: {
                this.analyzeCreateRole(ast);
                break;
            }
            case 616: {
                this.analyzeDropRole(ast);
                break;
            }
            case 743: {
                this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
                this.analyzeShowRoleGrant(ast);
                break;
            }
            case 634: {
                this.analyzeGrantRevokeRole(true, ast);
                break;
            }
            case 723: {
                this.analyzeGrantRevokeRole(false, ast);
                break;
            }
            case 633: {
                this.analyzeGrant(ast);
                break;
            }
            case 742: {
                this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
                this.analyzeShowGrant(ast);
                break;
            }
            case 722: {
                this.analyzeRevoke(ast);
                break;
            }
            case 571: {
                this.analyzeAltertableSkewedby(ast);
                break;
            }
            default: {
                throw new SemanticException("Unsupported command.");
            }
        }
    }

    private void analyzeGrantRevokeRole(boolean grant, ASTNode ast) {
        List<PrincipalDesc> principalDesc = this.analyzePrincipalListDef((ASTNode)ast.getChild(0));
        ArrayList<String> roles = new ArrayList<String>();
        for (int i = 1; i < ast.getChildCount(); ++i) {
            roles.add(DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(i).getText()));
        }
        String roleOwnerName = "";
        if (SessionState.get() != null && SessionState.get().getAuthenticator() != null) {
            roleOwnerName = SessionState.get().getAuthenticator().getUserName();
        }
        GrantRevokeRoleDDL grantRevokeRoleDDL = new GrantRevokeRoleDDL(grant, roles, principalDesc, roleOwnerName, PrincipalType.USER, true);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), grantRevokeRoleDDL), this.conf, new Task[0]));
    }

    private void analyzeShowGrant(ASTNode ast) throws SemanticException {
        ASTNode child;
        PrivilegeObjectDesc privHiveObj = null;
        ASTNode principal = (ASTNode)ast.getChild(0);
        PrincipalType type = PrincipalType.USER;
        switch (principal.getType()) {
            case 806: {
                type = PrincipalType.USER;
                break;
            }
            case 636: {
                type = PrincipalType.GROUP;
                break;
            }
            case 725: {
                type = PrincipalType.ROLE;
            }
        }
        String principalName = DDLSemanticAnalyzer.unescapeIdentifier(principal.getChild(0).getText());
        PrincipalDesc principalDesc = new PrincipalDesc(principalName, type);
        List<String> cols = null;
        if (ast.getChildCount() > 1 && (child = (ASTNode)ast.getChild(1)).getToken().getType() == 713) {
            privHiveObj = new PrivilegeObjectDesc();
            privHiveObj.setObject(DDLSemanticAnalyzer.unescapeIdentifier(child.getChild(0).getText()));
            if (child.getChildCount() > 1) {
                for (int i = 1; i < child.getChildCount(); ++i) {
                    ASTNode grandChild = (ASTNode)child.getChild(i);
                    if (grandChild.getToken().getType() == 699) {
                        privHiveObj.setPartSpec(DDLSemanticAnalyzer.getPartSpec(grandChild));
                        continue;
                    }
                    if (grandChild.getToken().getType() == 763) {
                        cols = this.getColumnNames(grandChild);
                        continue;
                    }
                    privHiveObj.setTable(child.getChild(i) != null);
                }
            }
        }
        if (privHiveObj == null && cols != null) {
            throw new SemanticException("For user-level privileges, column sets should be null. columns=" + cols.toString());
        }
        ShowGrantDesc showGrant = new ShowGrantDesc(this.ctx.getResFile().toString(), principalDesc, privHiveObj, cols);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showGrant), this.conf, new Task[0]));
    }

    private void analyzeGrant(ASTNode ast) throws SemanticException {
        List<PrivilegeDesc> privilegeDesc = this.analyzePrivilegeListDef((ASTNode)ast.getChild(0));
        List<PrincipalDesc> principalDesc = this.analyzePrincipalListDef((ASTNode)ast.getChild(1));
        boolean grantOption = false;
        PrivilegeObjectDesc privilegeObj = null;
        if (ast.getChildCount() > 2) {
            for (int i = 2; i < ast.getChildCount(); ++i) {
                ASTNode astChild = (ASTNode)ast.getChild(i);
                if (astChild.getType() == 635) {
                    grantOption = true;
                    continue;
                }
                if (astChild.getType() != 712) continue;
                privilegeObj = this.analyzePrivilegeObject(astChild, this.getOutputs());
            }
        }
        String userName = null;
        if (SessionState.get() != null && SessionState.get().getAuthenticator() != null) {
            userName = SessionState.get().getAuthenticator().getUserName();
        }
        GrantDesc grantDesc = new GrantDesc(privilegeObj, privilegeDesc, principalDesc, userName, PrincipalType.USER, grantOption);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), grantDesc), this.conf, new Task[0]));
    }

    private void analyzeRevoke(ASTNode ast) throws SemanticException {
        List<PrivilegeDesc> privilegeDesc = this.analyzePrivilegeListDef((ASTNode)ast.getChild(0));
        List<PrincipalDesc> principalDesc = this.analyzePrincipalListDef((ASTNode)ast.getChild(1));
        PrivilegeObjectDesc hiveObj = null;
        if (ast.getChildCount() > 2) {
            ASTNode astChild = (ASTNode)ast.getChild(2);
            hiveObj = this.analyzePrivilegeObject(astChild, this.getOutputs());
        }
        RevokeDesc revokeDesc = new RevokeDesc(privilegeDesc, principalDesc, hiveObj);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), revokeDesc), this.conf, new Task[0]));
    }

    private PrivilegeObjectDesc analyzePrivilegeObject(ASTNode ast, HashSet<WriteEntity> outputs) throws SemanticException {
        PrivilegeObjectDesc subject = new PrivilegeObjectDesc();
        subject.setObject(DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText()));
        if (ast.getChildCount() > 1) {
            for (int i = 0; i < ast.getChildCount(); ++i) {
                ASTNode astChild = (ASTNode)ast.getChild(i);
                if (astChild.getToken().getType() == 699) {
                    subject.setPartSpec(DDLSemanticAnalyzer.getPartSpec(astChild));
                    continue;
                }
                subject.setTable(ast.getChild(0) != null);
            }
        }
        if (subject.getTable()) {
            Table tbl = this.getTable(subject.getObject(), true);
            if (subject.getPartSpec() != null) {
                Partition part = this.getPartition(tbl, subject.getPartSpec(), true);
                outputs.add(new WriteEntity(part));
            } else {
                outputs.add(new WriteEntity(tbl));
            }
        }
        return subject;
    }

    private List<PrincipalDesc> analyzePrincipalListDef(ASTNode node) {
        ArrayList<PrincipalDesc> principalList = new ArrayList<PrincipalDesc>();
        for (int i = 0; i < node.getChildCount(); ++i) {
            ASTNode child = (ASTNode)node.getChild(i);
            PrincipalType type = null;
            switch (child.getType()) {
                case 806: {
                    type = PrincipalType.USER;
                    break;
                }
                case 636: {
                    type = PrincipalType.GROUP;
                    break;
                }
                case 725: {
                    type = PrincipalType.ROLE;
                }
            }
            String principalName = DDLSemanticAnalyzer.unescapeIdentifier(child.getChild(0).getText());
            PrincipalDesc principalDesc = new PrincipalDesc(principalName, type);
            principalList.add(principalDesc);
        }
        return principalList;
    }

    private List<PrivilegeDesc> analyzePrivilegeListDef(ASTNode node) throws SemanticException {
        ArrayList<PrivilegeDesc> ret = new ArrayList<PrivilegeDesc>();
        for (int i = 0; i < node.getChildCount(); ++i) {
            ASTNode privilegeDef = (ASTNode)node.getChild(i);
            ASTNode privilegeType = (ASTNode)privilegeDef.getChild(0);
            Privilege privObj = PrivilegeRegistry.getPrivilege(privilegeType.getType());
            if (privObj == null) {
                throw new SemanticException("undefined privilege " + privilegeType.getType());
            }
            List<String> cols = null;
            if (privilegeDef.getChildCount() > 1) {
                cols = this.getColumnNames((ASTNode)privilegeDef.getChild(1));
            }
            PrivilegeDesc privilegeDesc = new PrivilegeDesc(privObj, cols);
            ret.add(privilegeDesc);
        }
        return ret;
    }

    private void analyzeCreateRole(ASTNode ast) {
        String roleName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        RoleDDLDesc createRoleDesc = new RoleDDLDesc(roleName, RoleDDLDesc.RoleOperation.CREATE_ROLE);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), createRoleDesc), this.conf, new Task[0]));
    }

    private void analyzeDropRole(ASTNode ast) {
        String roleName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        RoleDDLDesc createRoleDesc = new RoleDDLDesc(roleName, RoleDDLDesc.RoleOperation.DROP_ROLE);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), createRoleDesc), this.conf, new Task[0]));
    }

    private void analyzeShowRoleGrant(ASTNode ast) {
        ASTNode child = (ASTNode)ast.getChild(0);
        PrincipalType principalType = PrincipalType.USER;
        switch (child.getType()) {
            case 806: {
                principalType = PrincipalType.USER;
                break;
            }
            case 636: {
                principalType = PrincipalType.GROUP;
                break;
            }
            case 725: {
                principalType = PrincipalType.ROLE;
            }
        }
        String principalName = DDLSemanticAnalyzer.unescapeIdentifier(child.getChild(0).getText());
        RoleDDLDesc createRoleDesc = new RoleDDLDesc(principalName, principalType, RoleDDLDesc.RoleOperation.SHOW_ROLE_GRANT, null);
        createRoleDesc.setResFile(this.ctx.getResFile().toString());
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), createRoleDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterDatabase(ASTNode ast) throws SemanticException {
        String dbName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        HashMap<String, String> dbProps = null;
        block3: for (int i = 1; i < ast.getChildCount(); ++i) {
            ASTNode childNode = (ASTNode)ast.getChild(i);
            switch (childNode.getToken().getType()) {
                case 599: {
                    dbProps = DDLSemanticAnalyzer.getProps((ASTNode)childNode.getChild(0));
                    continue block3;
                }
                default: {
                    throw new SemanticException("Unrecognized token in CREATE DATABASE statement");
                }
            }
        }
        AlterDatabaseDesc alterDesc = new AlterDatabaseDesc(dbName, null, null, false);
        alterDesc.setDatabaseProperties(dbProps);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterDesc), this.conf, new Task[0]));
    }

    private void analyzeCreateDatabase(ASTNode ast) throws SemanticException {
        String dbName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        boolean ifNotExists = false;
        String dbComment = null;
        String dbLocation = null;
        HashMap<String, String> dbProps = null;
        block6: for (int i = 1; i < ast.getChildCount(); ++i) {
            ASTNode childNode = (ASTNode)ast.getChild(i);
            switch (childNode.getToken().getType()) {
                case 646: {
                    ifNotExists = true;
                    continue block6;
                }
                case 597: {
                    dbComment = DDLSemanticAnalyzer.unescapeSQLString(childNode.getChild(0).getText());
                    continue block6;
                }
                case 599: {
                    dbProps = DDLSemanticAnalyzer.getProps((ASTNode)childNode.getChild(0));
                    continue block6;
                }
                case 598: {
                    dbLocation = DDLSemanticAnalyzer.unescapeSQLString(childNode.getChild(0).getText());
                    continue block6;
                }
                default: {
                    throw new SemanticException("Unrecognized token in CREATE DATABASE statement");
                }
            }
        }
        CreateDatabaseDesc createDatabaseDesc = new CreateDatabaseDesc(dbName, dbComment, dbLocation, ifNotExists);
        if (dbProps != null) {
            createDatabaseDesc.setDatabaseProperties(dbProps);
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), createDatabaseDesc), this.conf, new Task[0]));
    }

    private void analyzeDropDatabase(ASTNode ast) throws SemanticException {
        String dbName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        boolean ifExists = false;
        boolean ifCascade = false;
        if (null != ast.getFirstChildWithType(645)) {
            ifExists = true;
        }
        if (null != ast.getFirstChildWithType(584)) {
            ifCascade = true;
        }
        DropDatabaseDesc dropDatabaseDesc = new DropDatabaseDesc(dbName, ifExists, ifCascade);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), dropDatabaseDesc), this.conf, new Task[0]));
    }

    private void analyzeSwitchDatabase(ASTNode ast) {
        String dbName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        SwitchDatabaseDesc switchDatabaseDesc = new SwitchDatabaseDesc(dbName);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), switchDatabaseDesc), this.conf, new Task[0]));
    }

    private void analyzeDropTable(ASTNode ast, boolean expectView) throws SemanticException {
        boolean ifExists;
        boolean throwException;
        String tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        Table tab = this.getTable(tableName, throwException = !(ifExists = ast.getFirstChildWithType(645) != null) && !HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.DROPIGNORESNONEXISTENT));
        if (tab != null) {
            this.inputs.add(new ReadEntity(tab));
            this.outputs.add(new WriteEntity(tab));
        }
        DropTableDesc dropTblDesc = new DropTableDesc(tableName, expectView, ifExists, true);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), dropTblDesc), this.conf, new Task[0]));
    }

    private void analyzeTruncateTable(ASTNode ast) throws SemanticException {
        ASTNode root = (ASTNode)ast.getChild(0);
        String tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)root.getChild(0));
        Table table = this.getTable(tableName, true);
        if (table.getTableType() != TableType.MANAGED_TABLE) {
            throw new SemanticException(ErrorMsg.TRUNCATE_FOR_NON_MANAGED_TABLE.format(tableName));
        }
        if (table.isNonNative()) {
            throw new SemanticException(ErrorMsg.TRUNCATE_FOR_NON_NATIVE_TABLE.format(tableName));
        }
        if (!table.isPartitioned() && root.getChildCount() > 1) {
            throw new SemanticException(ErrorMsg.PARTSPEC_FOR_NON_PARTITIONED_TABLE.format(tableName));
        }
        HashMap<String, String> partSpec = DDLSemanticAnalyzer.getPartSpec((ASTNode)root.getChild(1));
        if (partSpec == null) {
            if (!table.isPartitioned()) {
                this.outputs.add(new WriteEntity(table));
            } else {
                for (Partition partition : this.getPartitions(table, null, false)) {
                    this.outputs.add(new WriteEntity(partition));
                }
            }
        } else if (this.isFullSpec(table, partSpec)) {
            Partition partition = this.getPartition(table, partSpec, true);
            this.outputs.add(new WriteEntity(partition));
        } else {
            for (Partition partition : this.getPartitions(table, partSpec, false)) {
                this.outputs.add(new WriteEntity(partition));
            }
        }
        TruncateTableDesc truncateTblDesc = new TruncateTableDesc(tableName, partSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), truncateTblDesc), this.conf, new Task[0]));
    }

    private boolean isFullSpec(Table table, Map<String, String> partSpec) {
        for (FieldSchema partCol : table.getPartCols()) {
            if (partSpec.get(partCol.getName()) != null) continue;
            return false;
        }
        return true;
    }

    private void analyzeCreateIndex(ASTNode ast) throws SemanticException {
        String indexName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        String typeName = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(1).getText());
        String tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(2));
        List<String> indexedCols = this.getColumnNames((ASTNode)ast.getChild(3));
        HiveIndex.IndexType indexType = HiveIndex.getIndexType(typeName);
        if (indexType != null) {
            typeName = indexType.getHandlerClsName();
        } else {
            try {
                Class.forName(typeName);
            }
            catch (Exception e) {
                throw new SemanticException("class name provided for index handler not found.", e);
            }
        }
        String indexTableName = null;
        boolean deferredRebuild = false;
        String location = null;
        HashMap<String, String> tblProps = null;
        HashMap<String, String> idxProps = null;
        String indexComment = null;
        BaseSemanticAnalyzer.RowFormatParams rowFormatParams = new BaseSemanticAnalyzer.RowFormatParams();
        BaseSemanticAnalyzer.StorageFormat storageFormat = new BaseSemanticAnalyzer.StorageFormat();
        BaseSemanticAnalyzer.AnalyzeCreateCommonVars shared = new BaseSemanticAnalyzer.AnalyzeCreateCommonVars();
        block12: for (int idx = 4; idx < ast.getChildCount(); ++idx) {
            ASTNode child = (ASTNode)ast.getChild(idx);
            if (storageFormat.fillStorageFormat(child, shared)) continue;
            switch (child.getToken().getType()) {
                case 776: {
                    rowFormatParams.analyzeRowFormat(shared, child);
                    continue block12;
                }
                case 591: {
                    ASTNode ch = (ASTNode)child.getChild(0);
                    indexTableName = DDLSemanticAnalyzer.getUnescapedName(ch);
                    continue block12;
                }
                case 604: {
                    deferredRebuild = true;
                    continue block12;
                }
                case 771: {
                    location = DDLSemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    continue block12;
                }
                case 773: {
                    tblProps = DDLSemanticAnalyzer.getProps((ASTNode)child.getChild(0));
                    continue block12;
                }
                case 650: {
                    idxProps = DDLSemanticAnalyzer.getProps((ASTNode)child.getChild(0));
                    continue block12;
                }
                case 781: {
                    child = (ASTNode)child.getChild(0);
                    shared.serde = DDLSemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    if (child.getChildCount() != 2) continue block12;
                    DDLSemanticAnalyzer.readProps((ASTNode)child.getChild(1).getChild(0), shared.serdeProps);
                    continue block12;
                }
                case 649: {
                    child = (ASTNode)child.getChild(0);
                    indexComment = DDLSemanticAnalyzer.unescapeSQLString(child.getText());
                }
            }
        }
        storageFormat.fillDefaultStorageFormat(shared);
        CreateIndexDesc crtIndexDesc = new CreateIndexDesc(tableName, indexName, indexedCols, indexTableName, deferredRebuild, storageFormat.inputFormat, storageFormat.outputFormat, storageFormat.storageHandler, typeName, location, idxProps, tblProps, shared.serde, shared.serdeProps, rowFormatParams.collItemDelim, rowFormatParams.fieldDelim, rowFormatParams.fieldEscape, rowFormatParams.lineDelim, rowFormatParams.mapKeyDelim, indexComment);
        Task<DDLWork> createIndex = TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), crtIndexDesc), this.conf, new Task[0]);
        this.rootTasks.add(createIndex);
    }

    private void analyzeDropIndex(ASTNode ast) throws SemanticException {
        boolean throwException;
        String indexName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        String tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(1));
        boolean ifExists = ast.getFirstChildWithType(645) != null;
        boolean bl = throwException = !ifExists && !HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.DROPIGNORESNONEXISTENT);
        if (throwException) {
            try {
                Index idx = this.db.getIndex(tableName, indexName);
            }
            catch (HiveException e) {
                throw new SemanticException(ErrorMsg.INVALID_INDEX.getMsg(indexName));
            }
        }
        DropIndexDesc dropIdxDesc = new DropIndexDesc(indexName, tableName);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), dropIdxDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterIndexRebuild(ASTNode ast) throws SemanticException {
        String baseTableName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        String indexName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText());
        HashMap<String, String> partSpec = null;
        Tree part = ast.getChild(2);
        if (part != null) {
            partSpec = this.extractPartitionSpecs(part);
        }
        List<Task<?>> indexBuilder = this.getIndexBuilderMapRed(baseTableName, indexName, partSpec);
        this.rootTasks.addAll(indexBuilder);
        AlterIndexDesc alterIdxDesc = new AlterIndexDesc(AlterIndexDesc.AlterIndexTypes.UPDATETIMESTAMP);
        alterIdxDesc.setIndexName(indexName);
        alterIdxDesc.setBaseTableName(baseTableName);
        alterIdxDesc.setDbName(this.db.getCurrentDatabase());
        alterIdxDesc.setSpec(partSpec);
        Task<DDLWork> tsTask = TaskFactory.get(new DDLWork(alterIdxDesc), this.conf, new Task[0]);
        for (Task<?> t : indexBuilder) {
            t.addDependentTask(tsTask);
        }
    }

    private void analyzeAlterIndexProps(ASTNode ast) throws SemanticException {
        String baseTableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        String indexName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText());
        HashMap<String, String> mapProp = DDLSemanticAnalyzer.getProps((ASTNode)ast.getChild(2).getChild(0));
        AlterIndexDesc alterIdxDesc = new AlterIndexDesc(AlterIndexDesc.AlterIndexTypes.ADDPROPS);
        alterIdxDesc.setProps(mapProp);
        alterIdxDesc.setIndexName(indexName);
        alterIdxDesc.setBaseTableName(baseTableName);
        alterIdxDesc.setDbName(this.db.getCurrentDatabase());
        this.rootTasks.add(TaskFactory.get(new DDLWork(alterIdxDesc), this.conf, new Task[0]));
    }

    private List<Task<?>> getIndexBuilderMapRed(String baseTableName, String indexName, HashMap<String, String> partSpec) throws SemanticException {
        try {
            String dbName = this.db.getCurrentDatabase();
            Index index = this.db.getIndex(dbName, baseTableName, indexName);
            Table indexTbl = this.getTable(index.getIndexTableName());
            String baseTblName = index.getOrigTableName();
            Table baseTbl = this.getTable(baseTblName);
            String handlerCls = index.getIndexHandlerClass();
            HiveIndexHandler handler = HiveUtils.getIndexHandler(this.conf, handlerCls);
            ArrayList<Partition> indexTblPartitions = null;
            List<Partition> baseTblPartitions = null;
            if (indexTbl != null) {
                indexTblPartitions = new ArrayList<Partition>();
                baseTblPartitions = this.preparePartitions(baseTbl, partSpec, indexTbl, this.db, indexTblPartitions);
            }
            List<Task<?>> ret = handler.generateIndexBuildTaskList(baseTbl, index, indexTblPartitions, baseTblPartitions, indexTbl, this.getInputs(), this.getOutputs());
            return ret;
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
    }

    private List<Partition> preparePartitions(Table baseTbl, HashMap<String, String> partSpec, Table indexTbl, Hive db, List<Partition> indexTblPartitions) throws HiveException, MetaException {
        List<Partition> baseTblPartitions = new ArrayList<Partition>();
        if (partSpec != null) {
            Partition part = db.getPartition(baseTbl, partSpec, false);
            if (part == null) {
                throw new HiveException("Partition " + Warehouse.makePartName(partSpec, (boolean)false) + " does not exist in table " + baseTbl.getTableName());
            }
            baseTblPartitions.add(part);
            Partition indexPart = db.getPartition(indexTbl, partSpec, false);
            if (indexPart == null) {
                indexPart = db.createPartition(indexTbl, partSpec);
            }
            indexTblPartitions.add(indexPart);
        } else if (baseTbl.isPartitioned()) {
            baseTblPartitions = db.getPartitions(baseTbl);
            for (Partition basePart : baseTblPartitions) {
                LinkedHashMap<String, String> pSpec = basePart.getSpec();
                Partition indexPart = db.getPartition(indexTbl, pSpec, false);
                if (indexPart == null) {
                    indexPart = db.createPartition(indexTbl, pSpec);
                }
                indexTblPartitions.add(indexPart);
            }
        }
        return baseTblPartitions;
    }

    private void validateAlterTableType(Table tbl, AlterTableDesc.AlterTableTypes op) throws SemanticException {
        this.validateAlterTableType(tbl, op, false);
    }

    private void validateAlterTableType(Table tbl, AlterTableDesc.AlterTableTypes op, boolean expectView) throws SemanticException {
        block7: {
            block6: {
                if (!tbl.isView()) break block6;
                if (!expectView) {
                    throw new SemanticException(ErrorMsg.ALTER_COMMAND_FOR_VIEWS.getMsg());
                }
                switch (op) {
                    case ADDPARTITION: 
                    case DROPPARTITION: 
                    case RENAMEPARTITION: 
                    case ADDPROPS: 
                    case DROPPROPS: 
                    case RENAME: {
                        break block7;
                    }
                    default: {
                        throw new SemanticException(ErrorMsg.ALTER_VIEW_DISALLOWED_OP.getMsg(op.toString()));
                    }
                }
            }
            if (expectView) {
                throw new SemanticException(ErrorMsg.ALTER_COMMAND_FOR_TABLES.getMsg());
            }
        }
        if (tbl.isNonNative()) {
            throw new SemanticException(ErrorMsg.ALTER_TABLE_NON_NATIVE.getMsg(tbl.getTableName()));
        }
    }

    private void analyzeAlterTableProps(ASTNode ast, boolean expectView, boolean isUnset) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        HashMap<String, String> mapProp = DDLSemanticAnalyzer.getProps((ASTNode)ast.getChild(1).getChild(0));
        AlterTableDesc alterTblDesc = null;
        if (isUnset) {
            alterTblDesc = new AlterTableDesc(AlterTableDesc.AlterTableTypes.DROPPROPS, expectView);
            if (ast.getChild(2) != null) {
                alterTblDesc.setDropIfExists(true);
            }
        } else {
            alterTblDesc = new AlterTableDesc(AlterTableDesc.AlterTableTypes.ADDPROPS, expectView);
        }
        alterTblDesc.setProps(mapProp);
        alterTblDesc.setOldName(tableName);
        this.addInputsOutputsAlterTable(tableName, null, alterTblDesc);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableSerdeProps(ASTNode ast, String tableName, HashMap<String, String> partSpec) throws SemanticException {
        HashMap<String, String> mapProp = DDLSemanticAnalyzer.getProps((ASTNode)ast.getChild(0).getChild(0));
        AlterTableDesc alterTblDesc = new AlterTableDesc(AlterTableDesc.AlterTableTypes.ADDSERDEPROPS);
        alterTblDesc.setProps(mapProp);
        alterTblDesc.setOldName(tableName);
        alterTblDesc.setPartSpec(partSpec);
        this.addInputsOutputsAlterTable(tableName, partSpec, alterTblDesc);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableSerde(ASTNode ast, String tableName, HashMap<String, String> partSpec) throws SemanticException {
        String serdeName = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(0).getText());
        AlterTableDesc alterTblDesc = new AlterTableDesc(AlterTableDesc.AlterTableTypes.ADDSERDE);
        if (ast.getChildCount() > 1) {
            HashMap<String, String> mapProp = DDLSemanticAnalyzer.getProps((ASTNode)ast.getChild(1).getChild(0));
            alterTblDesc.setProps(mapProp);
        }
        alterTblDesc.setOldName(tableName);
        alterTblDesc.setSerdeName(serdeName);
        alterTblDesc.setPartSpec(partSpec);
        this.addInputsOutputsAlterTable(tableName, partSpec, alterTblDesc);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableFileFormat(ASTNode ast, String tableName, HashMap<String, String> partSpec) throws SemanticException {
        String inputFormat = null;
        String outputFormat = null;
        String storageHandler = null;
        String serde = null;
        ASTNode child = (ASTNode)ast.getChild(0);
        switch (child.getToken().getType()) {
            case 770: {
                inputFormat = DDLSemanticAnalyzer.unescapeSQLString(((ASTNode)child.getChild(0)).getToken().getText());
                outputFormat = DDLSemanticAnalyzer.unescapeSQLString(((ASTNode)child.getChild(1)).getToken().getText());
                try {
                    Class.forName(inputFormat);
                    Class.forName(outputFormat);
                    break;
                }
                catch (ClassNotFoundException e) {
                    throw new SemanticException(e);
                }
            }
            case 751: {
                storageHandler = DDLSemanticAnalyzer.unescapeSQLString(((ASTNode)child.getChild(1)).getToken().getText());
                try {
                    Class.forName(storageHandler);
                    break;
                }
                catch (ClassNotFoundException e) {
                    throw new SemanticException(e);
                }
            }
            case 794: {
                inputFormat = SEQUENCEFILE_INPUT;
                outputFormat = SEQUENCEFILE_OUTPUT;
                break;
            }
            case 795: {
                inputFormat = TEXTFILE_INPUT;
                outputFormat = TEXTFILE_OUTPUT;
                break;
            }
            case 793: {
                inputFormat = RCFILE_INPUT;
                outputFormat = RCFILE_OUTPUT;
                serde = COLUMNAR_SERDE;
                break;
            }
            case 792: {
                inputFormat = ORCFILE_INPUT;
                outputFormat = ORCFILE_OUTPUT;
                serde = ORCFILE_SERDE;
                break;
            }
            case 626: {
                this.handleGenericFileFormat(child);
            }
        }
        AlterTableDesc alterTblDesc = new AlterTableDesc(tableName, inputFormat, outputFormat, serde, storageHandler, partSpec);
        this.addInputsOutputsAlterTable(tableName, partSpec, alterTblDesc);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void addInputsOutputsAlterTable(String tableName, Map<String, String> partSpec) throws SemanticException {
        this.addInputsOutputsAlterTable(tableName, partSpec, null);
    }

    private void addInputsOutputsAlterTable(String tableName, Map<String, String> partSpec, AlterTableDesc desc) throws SemanticException {
        Table tab = this.getTable(tableName, true);
        if (partSpec == null || partSpec.isEmpty()) {
            this.inputs.add(new ReadEntity(tab));
            this.outputs.add(new WriteEntity(tab));
        } else {
            this.inputs.add(new ReadEntity(tab));
            if (desc == null || desc.getOp() != AlterTableDesc.AlterTableTypes.ALTERPROTECTMODE) {
                Partition part = this.getPartition(tab, partSpec, true);
                this.outputs.add(new WriteEntity(part));
            } else {
                for (Partition part : this.getPartitions(tab, partSpec, true)) {
                    this.outputs.add(new WriteEntity(part));
                }
            }
        }
        if (desc != null) {
            this.validateAlterTableType(tab, desc.getOp(), desc.getExpectView());
            if (desc.getOp() == AlterTableDesc.AlterTableTypes.DROPPROPS && !desc.getIsDropIfExists()) {
                for (String currKey : desc.getProps().keySet()) {
                    if (tab.getTTable().getParameters().containsKey(currKey)) continue;
                    String errorMsg = "The following property " + currKey + " does not exist in " + tab.getTableName();
                    throw new SemanticException(ErrorMsg.ALTER_TBL_UNSET_NON_EXIST_PROPERTY.getMsg(errorMsg));
                }
            }
        }
    }

    private void analyzeAlterTableLocation(ASTNode ast, String tableName, HashMap<String, String> partSpec) throws SemanticException {
        String newLocation = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(0).getText());
        AlterTableDesc alterTblDesc = new AlterTableDesc(tableName, newLocation, partSpec);
        this.addInputsOutputsAlterTable(tableName, partSpec, alterTblDesc);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableProtectMode(ASTNode ast, String tableName, HashMap<String, String> partSpec) throws SemanticException {
        AlterTableDesc alterTblDesc = new AlterTableDesc(AlterTableDesc.AlterTableTypes.ALTERPROTECTMODE);
        alterTblDesc.setOldName(tableName);
        alterTblDesc.setPartSpec(partSpec);
        ASTNode child = (ASTNode)ast.getChild(0);
        switch (child.getToken().getType()) {
            case 621: {
                alterTblDesc.setProtectModeEnable(true);
                break;
            }
            case 610: {
                alterTblDesc.setProtectModeEnable(false);
                break;
            }
            default: {
                throw new SemanticException("Set Protect mode Syntax parsing error.");
            }
        }
        ASTNode grandChild = (ASTNode)child.getChild(0);
        switch (grandChild.getToken().getType()) {
            case 675: {
                alterTblDesc.setProtectModeType(AlterTableDesc.ProtectModeType.OFFLINE);
                break;
            }
            case 673: {
                if (grandChild.getChildCount() > 0) {
                    alterTblDesc.setProtectModeType(AlterTableDesc.ProtectModeType.NO_DROP_CASCADE);
                    break;
                }
                alterTblDesc.setProtectModeType(AlterTableDesc.ProtectModeType.NO_DROP);
                break;
            }
            case 718: {
                throw new SemanticException("Potect mode READONLY is not implemented");
            }
            default: {
                throw new SemanticException("Only protect mode NO_DROP or OFFLINE supported");
            }
        }
        this.addInputsOutputsAlterTable(tableName, partSpec, alterTblDesc);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTablePartMergeFiles(ASTNode tablePartAST, ASTNode ast, String tableName, HashMap<String, String> partSpec) throws SemanticException {
        AlterTablePartMergeFilesDesc mergeDesc = new AlterTablePartMergeFilesDesc(tableName, partSpec);
        ArrayList<String> inputDir = new ArrayList<String>();
        Path oldTblPartLoc = null;
        Path newTblPartLoc = null;
        Table tblObj = null;
        ListBucketingCtx lbCtx = null;
        try {
            List<Index> indexes;
            tblObj = this.getTable(tableName);
            List<String> bucketCols = null;
            Class<? extends InputFormat> inputFormatClass = null;
            boolean isArchived = false;
            boolean checkIndex = HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_CONCATENATE_CHECK_INDEX);
            if (checkIndex && (indexes = this.db.getIndexes(tblObj.getDbName(), tableName, (short)Short.MAX_VALUE)) != null && indexes.size() > 0) {
                throw new SemanticException("can not do merge because source table " + tableName + " is indexed.");
            }
            if (tblObj.isPartitioned()) {
                if (partSpec == null) {
                    throw new SemanticException("source table " + tableName + " is partitioned but no partition desc found.");
                }
                Partition part = this.getPartition(tblObj, partSpec, false);
                if (part == null) {
                    throw new SemanticException("source table " + tableName + " is partitioned but partition not found.");
                }
                bucketCols = part.getBucketCols();
                inputFormatClass = part.getInputFormatClass();
                isArchived = ArchiveUtils.isArchived(part);
                Path tabPath = tblObj.getPath();
                Path partPath = part.getPartitionPath();
                newTblPartLoc = new Path(tabPath.toUri().getScheme(), tabPath.toUri().getAuthority(), partPath.toUri().getPath());
                oldTblPartLoc = partPath;
                lbCtx = this.constructListBucketingCtx(part.getSkewedColNames(), part.getSkewedColValues(), part.getSkewedColValueLocationMaps(), part.isStoredAsSubDirectories(), this.conf);
            } else {
                inputFormatClass = tblObj.getInputFormatClass();
                bucketCols = tblObj.getBucketCols();
                oldTblPartLoc = tblObj.getPath();
                newTblPartLoc = tblObj.getPath();
                lbCtx = this.constructListBucketingCtx(tblObj.getSkewedColNames(), tblObj.getSkewedColValues(), tblObj.getSkewedColValueLocationMaps(), tblObj.isStoredAsSubDirectories(), this.conf);
            }
            if (inputFormatClass.equals(RCFileInputFormat.class)) {
                mergeDesc.setMergeMapperClass(RCFileMergeMapper.class);
                mergeDesc.setMergeInputFormatClass(RCFileBlockMergeInputFormat.class);
            } else if (inputFormatClass.equals(OrcInputFormat.class)) {
                mergeDesc.setMergeMapperClass(OrcMergeMapper.class);
                mergeDesc.setMergeInputFormatClass(OrcBlockMergeInputFormat.class);
            } else {
                throw new SemanticException("Only RCFileFormat and OrcFileFormat are supportted right now.");
            }
            if (bucketCols != null && bucketCols.size() > 0) {
                throw new SemanticException("Merge can not perform on bucketized partition/table.");
            }
            if (isArchived) {
                throw new SemanticException("Merge can not perform on archived partitions.");
            }
            inputDir.add(oldTblPartLoc.toString());
            mergeDesc.setInputDir(inputDir);
            mergeDesc.setLbCtx(lbCtx);
            this.addInputsOutputsAlterTable(tableName, partSpec);
            DDLWork ddlWork = new DDLWork(this.getInputs(), this.getOutputs(), mergeDesc);
            ddlWork.setNeedLock(true);
            Task<DDLWork> mergeTask = TaskFactory.get(ddlWork, this.conf, new Task[0]);
            TableDesc tblDesc = Utilities.getTableDesc(tblObj);
            String queryTmpdir = this.ctx.getExternalTmpFileURI(newTblPartLoc.toUri());
            mergeDesc.setOutputDir(queryTmpdir);
            LoadTableDesc ltd = new LoadTableDesc(queryTmpdir, queryTmpdir, tblDesc, partSpec == null ? new HashMap() : partSpec);
            ltd.setLbCtx(lbCtx);
            Task<MoveWork> moveTsk = TaskFactory.get(new MoveWork(null, null, ltd, null, false), this.conf, new Task[0]);
            mergeTask.addDependentTask(moveTsk);
            if (this.conf.getBoolVar(HiveConf.ConfVars.HIVESTATSAUTOGATHER)) {
                StatsWork statDesc;
                if (oldTblPartLoc.equals((Object)newTblPartLoc)) {
                    BaseSemanticAnalyzer.tableSpec tablepart = new BaseSemanticAnalyzer.tableSpec(this.db, this.conf, tablePartAST);
                    statDesc = new StatsWork(tablepart);
                } else {
                    statDesc = new StatsWork(ltd);
                }
                statDesc.setNoStatsAggregator(true);
                statDesc.setStatsReliable(this.conf.getBoolVar(HiveConf.ConfVars.HIVE_STATS_RELIABLE));
                Task<StatsWork> statTask = TaskFactory.get(statDesc, this.conf, new Task[0]);
                moveTsk.addDependentTask(statTask);
            }
            this.rootTasks.add(mergeTask);
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
    }

    private void analyzeAlterTableClusterSort(ASTNode ast, String tableName, HashMap<String, String> partSpec) throws SemanticException {
        this.addInputsOutputsAlterTable(tableName, partSpec);
        switch (ast.getChild(0).getType()) {
            case 671: {
                AlterTableDesc alterTblDesc = new AlterTableDesc(tableName, -1, new ArrayList<String>(), new ArrayList<Order>(), partSpec);
                this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
                break;
            }
            case 672: {
                AlterTableDesc alterTblDesc = new AlterTableDesc(tableName, true, partSpec);
                this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
                break;
            }
            case 767: {
                ASTNode buckets = (ASTNode)ast.getChild(0);
                List<String> bucketCols = this.getColumnNames((ASTNode)buckets.getChild(0));
                ArrayList<Order> sortCols = new ArrayList();
                int numBuckets = -1;
                if (buckets.getChildCount() == 2) {
                    numBuckets = Integer.valueOf(buckets.getChild(1).getText());
                } else {
                    sortCols = this.getColumnNamesOrder((ASTNode)buckets.getChild(1));
                    numBuckets = Integer.valueOf(buckets.getChild(2).getText());
                }
                if (numBuckets <= 0) {
                    throw new SemanticException(ErrorMsg.INVALID_BUCKET_NUMBER.getMsg());
                }
                AlterTableDesc alterTblDesc = new AlterTableDesc(tableName, numBuckets, bucketCols, sortCols, partSpec);
                this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
            }
        }
    }

    static HashMap<String, String> getProps(ASTNode prop) {
        HashMap<String, String> mapProp = new HashMap<String, String>();
        DDLSemanticAnalyzer.readProps(prop, mapProp);
        return mapProp;
    }

    private FetchTask createFetchTask(String schema) {
        Properties prop = new Properties();
        prop.setProperty("serialization.format", "9");
        prop.setProperty("serialization.null.format", " ");
        String[] colTypes = schema.split("#");
        prop.setProperty("columns", colTypes[0]);
        prop.setProperty("columns.types", colTypes[1]);
        FetchWork fetch = new FetchWork(this.ctx.getResFile().toString(), new TableDesc(LazySimpleSerDe.class, TextInputFormat.class, IgnoreKeyTextOutputFormat.class, prop), -1);
        fetch.setSerializationNullFormat(" ");
        return (FetchTask)TaskFactory.get(fetch, this.conf, new Task[0]);
    }

    private void validateDatabase(String databaseName) throws SemanticException {
        try {
            if (!this.db.databaseExists(databaseName)) {
                throw new SemanticException(ErrorMsg.DATABASE_NOT_EXISTS.getMsg(databaseName));
            }
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.DATABASE_NOT_EXISTS.getMsg(databaseName), e);
        }
    }

    private void validateTable(String tableName, Map<String, String> partSpec) throws SemanticException {
        Table tab = this.getTable(tableName);
        if (partSpec != null) {
            this.getPartition(tab, partSpec, true);
        }
    }

    private void analyzeDescribeTable(ASTNode ast) throws SemanticException {
        ASTNode tableTypeExpr = (ASTNode)ast.getChild(0);
        String qualifiedName = QualifiedNameUtil.getFullyQualifiedName((ASTNode)tableTypeExpr.getChild(0));
        String tableName = QualifiedNameUtil.getTableName(this.db, (ASTNode)tableTypeExpr.getChild(0));
        String dbName = QualifiedNameUtil.getDBName(this.db, (ASTNode)tableTypeExpr.getChild(0));
        Map<String, String> partSpec = QualifiedNameUtil.getPartitionSpec(this.db, tableTypeExpr, tableName);
        String colPath = QualifiedNameUtil.getColPath(this.db, tableTypeExpr, (ASTNode)tableTypeExpr.getChild(0), qualifiedName, partSpec);
        if (dbName != null) {
            this.validateDatabase(dbName);
        }
        if (partSpec != null) {
            this.validateTable(tableName, partSpec);
        }
        DescTableDesc descTblDesc = new DescTableDesc(this.ctx.getResFile(), tableName, partSpec, colPath);
        if (ast.getChildCount() == 2) {
            int descOptions = ast.getChild(1).getType();
            descTblDesc.setFormatted(descOptions == 105);
            descTblDesc.setExt(descOptions == 94);
            descTblDesc.setPretty(descOptions == 178);
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), descTblDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(DescTableDesc.getSchema()));
        LOG.info((Object)"analyzeDescribeTable done");
    }

    private void analyzeDescDatabase(ASTNode ast) throws SemanticException {
        boolean isExtended;
        String dbName;
        if (ast.getChildCount() == 1) {
            dbName = DDLSemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
            isExtended = false;
        } else if (ast.getChildCount() == 2) {
            dbName = DDLSemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
            isExtended = true;
        } else {
            throw new SemanticException("Unexpected Tokens at DESCRIBE DATABASE");
        }
        DescDatabaseDesc descDbDesc = new DescDatabaseDesc(this.ctx.getResFile(), dbName, isExtended);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), descDbDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(descDbDesc.getSchema()));
    }

    private static HashMap<String, String> getPartSpec(ASTNode partspec) throws SemanticException {
        if (partspec == null) {
            return null;
        }
        LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
        for (int i = 0; i < partspec.getChildCount(); ++i) {
            ASTNode partspec_val = (ASTNode)partspec.getChild(i);
            String key = partspec_val.getChild(0).getText();
            String val = null;
            if (partspec_val.getChildCount() > 1) {
                val = DDLSemanticAnalyzer.stripQuotes(partspec_val.getChild(1).getText());
            }
            partSpec.put(key.toLowerCase(), val);
        }
        return partSpec;
    }

    private void analyzeShowPartitions(ASTNode ast) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        List<Map<String, String>> partSpecs = this.getPartitionSpecs(ast);
        assert (partSpecs.size() <= 1);
        Map<String, String> partSpec = null;
        if (partSpecs.size() > 0) {
            partSpec = partSpecs.get(0);
        }
        this.validateTable(tableName, null);
        ShowPartitionsDesc showPartsDesc = new ShowPartitionsDesc(tableName, this.ctx.getResFile(), partSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showPartsDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showPartsDesc.getSchema()));
    }

    private void analyzeShowCreateTable(ASTNode ast) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        ShowCreateTableDesc showCreateTblDesc = new ShowCreateTableDesc(tableName, this.ctx.getResFile().toString());
        Table tab = this.getTable(tableName);
        if (tab.getTableType() == TableType.INDEX_TABLE) {
            throw new SemanticException(ErrorMsg.SHOW_CREATETABLE_INDEX.getMsg(tableName + " has table type INDEX_TABLE"));
        }
        this.inputs.add(new ReadEntity(tab));
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showCreateTblDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showCreateTblDesc.getSchema()));
    }

    private void analyzeShowDatabases(ASTNode ast) throws SemanticException {
        ShowDatabasesDesc showDatabasesDesc;
        if (ast.getChildCount() == 1) {
            String databasePattern = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(0).getText());
            showDatabasesDesc = new ShowDatabasesDesc(this.ctx.getResFile(), databasePattern);
        } else {
            showDatabasesDesc = new ShowDatabasesDesc(this.ctx.getResFile());
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showDatabasesDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showDatabasesDesc.getSchema()));
    }

    private void analyzeShowTables(ASTNode ast) throws SemanticException {
        ShowTablesDesc showTblsDesc;
        String dbName = this.db.getCurrentDatabase();
        String tableNames = null;
        if (ast.getChildCount() > 3) {
            throw new SemanticException(ErrorMsg.GENERIC_ERROR.getMsg());
        }
        switch (ast.getChildCount()) {
            case 1: {
                tableNames = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(0).getText());
                showTblsDesc = new ShowTablesDesc(this.ctx.getResFile(), dbName, tableNames);
                break;
            }
            case 2: {
                assert (ast.getChild(0).getType() == 628);
                dbName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText());
                this.validateDatabase(dbName);
                showTblsDesc = new ShowTablesDesc(this.ctx.getResFile(), dbName);
                break;
            }
            case 3: {
                assert (ast.getChild(0).getType() == 628);
                dbName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText());
                tableNames = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(2).getText());
                this.validateDatabase(dbName);
                showTblsDesc = new ShowTablesDesc(this.ctx.getResFile(), dbName, tableNames);
                break;
            }
            default: {
                showTblsDesc = new ShowTablesDesc(this.ctx.getResFile(), dbName);
            }
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showTblsDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showTblsDesc.getSchema()));
    }

    private void analyzeShowColumns(ASTNode ast) throws SemanticException {
        String dbName = null;
        String tableName = null;
        switch (ast.getChildCount()) {
            case 1: {
                tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
                break;
            }
            case 2: {
                dbName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
                tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(1));
                break;
            }
        }
        Table tab = this.getTable(dbName, tableName, true);
        this.inputs.add(new ReadEntity(tab));
        ShowColumnsDesc showColumnsDesc = new ShowColumnsDesc(this.ctx.getResFile(), dbName, tableName);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showColumnsDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showColumnsDesc.getSchema()));
    }

    private void analyzeShowTableStatus(ASTNode ast) throws SemanticException {
        String tableNames = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        String dbName = this.db.getCurrentDatabase();
        int children = ast.getChildCount();
        HashMap<String, String> partSpec = null;
        if (children >= 2) {
            if (children > 3) {
                throw new SemanticException(ErrorMsg.GENERIC_ERROR.getMsg());
            }
            for (int i = 1; i < children; ++i) {
                ASTNode child = (ASTNode)ast.getChild(i);
                if (child.getToken().getType() == 26) {
                    dbName = DDLSemanticAnalyzer.unescapeIdentifier(child.getText());
                    continue;
                }
                if (child.getToken().getType() == 699) {
                    partSpec = DDLSemanticAnalyzer.getPartSpec(child);
                    continue;
                }
                throw new SemanticException(ErrorMsg.GENERIC_ERROR.getMsg());
            }
        }
        if (partSpec != null) {
            this.validateTable(tableNames, partSpec);
        }
        ShowTableStatusDesc showTblStatusDesc = new ShowTableStatusDesc(this.ctx.getResFile().toString(), dbName, tableNames, partSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showTblStatusDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showTblStatusDesc.getSchema()));
    }

    private void analyzeShowTableProperties(ASTNode ast) throws SemanticException {
        String tableNames = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        String dbName = this.db.getCurrentDatabase();
        String propertyName = null;
        if (ast.getChildCount() > 1) {
            propertyName = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(1).getText());
        }
        this.validateTable(tableNames, null);
        ShowTblPropertiesDesc showTblPropertiesDesc = new ShowTblPropertiesDesc(this.ctx.getResFile().toString(), tableNames, propertyName);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showTblPropertiesDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showTblPropertiesDesc.getSchema()));
    }

    private void analyzeShowIndexes(ASTNode ast) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        ShowIndexesDesc showIndexesDesc = new ShowIndexesDesc(tableName, this.ctx.getResFile());
        if (ast.getChildCount() == 2) {
            int descOptions = ast.getChild(1).getType();
            showIndexesDesc.setFormatted(descOptions == 105);
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showIndexesDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showIndexesDesc.getSchema()));
    }

    private void analyzeShowFunctions(ASTNode ast) throws SemanticException {
        ShowFunctionsDesc showFuncsDesc;
        if (ast.getChildCount() == 1) {
            String funcNames = DDLSemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
            showFuncsDesc = new ShowFunctionsDesc(this.ctx.getResFile(), funcNames);
        } else {
            showFuncsDesc = new ShowFunctionsDesc(this.ctx.getResFile());
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showFuncsDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showFuncsDesc.getSchema()));
    }

    private void analyzeShowLocks(ASTNode ast) throws SemanticException {
        String tableName = null;
        HashMap<String, String> partSpec = null;
        boolean isExtended = false;
        if (ast.getChildCount() >= 1) {
            for (int i = 0; i < ast.getChildCount(); ++i) {
                ASTNode child = (ASTNode)ast.getChild(i);
                if (child.getType() == 791) {
                    ASTNode tableTypeExpr = child;
                    tableName = QualifiedNameUtil.getFullyQualifiedName((ASTNode)tableTypeExpr.getChild(0));
                    if (tableTypeExpr.getChildCount() != 2) continue;
                    ASTNode partspec = (ASTNode)tableTypeExpr.getChild(1);
                    partSpec = DDLSemanticAnalyzer.getPartSpec(partspec);
                    continue;
                }
                if (child.getType() != 94) continue;
                isExtended = true;
            }
        }
        ShowLocksDesc showLocksDesc = new ShowLocksDesc(this.ctx.getResFile(), tableName, partSpec, isExtended);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showLocksDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showLocksDesc.getSchema()));
        this.ctx.setNeedLockMgr(true);
    }

    private void analyzeLockTable(ASTNode ast) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0)).toLowerCase();
        String mode = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText().toUpperCase());
        List<Map<String, String>> partSpecs = this.getPartitionSpecs(ast);
        assert (partSpecs.size() <= 1);
        Map<String, String> partSpec = null;
        if (partSpecs.size() > 0) {
            partSpec = partSpecs.get(0);
        }
        LockTableDesc lockTblDesc = new LockTableDesc(tableName, mode, partSpec, HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVEQUERYID));
        lockTblDesc.setQueryStr(this.ctx.getCmd());
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), lockTblDesc), this.conf, new Task[0]));
        this.ctx.setNeedLockMgr(true);
    }

    private void analyzeUnlockTable(ASTNode ast) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        List<Map<String, String>> partSpecs = this.getPartitionSpecs(ast);
        assert (partSpecs.size() <= 1);
        Map<String, String> partSpec = null;
        if (partSpecs.size() > 0) {
            partSpec = partSpecs.get(0);
        }
        UnlockTableDesc unlockTblDesc = new UnlockTableDesc(tableName, partSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), unlockTblDesc), this.conf, new Task[0]));
        this.ctx.setNeedLockMgr(true);
    }

    private void analyzeDescFunction(ASTNode ast) throws SemanticException {
        boolean isExtended;
        String funcName;
        if (ast.getChildCount() == 1) {
            funcName = DDLSemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
            isExtended = false;
        } else if (ast.getChildCount() == 2) {
            funcName = DDLSemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
            isExtended = true;
        } else {
            throw new SemanticException("Unexpected Tokens at DESCRIBE FUNCTION");
        }
        DescFunctionDesc descFuncDesc = new DescFunctionDesc(this.ctx.getResFile(), funcName, isExtended);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), descFuncDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(descFuncDesc.getSchema()));
    }

    private void analyzeAlterTableRename(ASTNode ast, boolean expectView) throws SemanticException {
        String tblName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        AlterTableDesc alterTblDesc = new AlterTableDesc(tblName, DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(1)), expectView);
        this.addInputsOutputsAlterTable(tblName, null, alterTblDesc);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableRenameCol(ASTNode ast) throws SemanticException {
        String tblName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        String newComment = null;
        String newType = null;
        newType = DDLSemanticAnalyzer.getTypeStringFromAST((ASTNode)ast.getChild(3));
        boolean first = false;
        String flagCol = null;
        ASTNode positionNode = null;
        if (ast.getChildCount() == 6) {
            newComment = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(4).getText());
            positionNode = (ASTNode)ast.getChild(5);
        } else if (ast.getChildCount() == 5) {
            if (ast.getChild(4).getType() == 282) {
                newComment = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(4).getText());
            } else {
                positionNode = (ASTNode)ast.getChild(4);
            }
        }
        if (positionNode != null) {
            if (positionNode.getChildCount() == 0) {
                first = true;
            } else {
                flagCol = DDLSemanticAnalyzer.unescapeIdentifier(positionNode.getChild(0).getText());
            }
        }
        String oldColName = ast.getChild(1).getText();
        String newColName = ast.getChild(2).getText();
        Table tab = this.getTable(tblName);
        SkewedInfo skewInfo = tab.getTTable().getSd().getSkewedInfo();
        if (null != skewInfo && null != skewInfo.getSkewedColNames() && skewInfo.getSkewedColNames().contains(oldColName)) {
            throw new SemanticException(oldColName + ErrorMsg.ALTER_TABLE_NOT_ALLOWED_RENAME_SKEWED_COLUMN.getMsg());
        }
        AlterTableDesc alterTblDesc = new AlterTableDesc(tblName, DDLSemanticAnalyzer.unescapeIdentifier(oldColName), DDLSemanticAnalyzer.unescapeIdentifier(newColName), newType, newComment, first, flagCol);
        this.addInputsOutputsAlterTable(tblName, null, alterTblDesc);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableRenamePart(ASTNode ast, String tblName, HashMap<String, String> oldPartSpec) throws SemanticException {
        HashMap<String, String> newPartSpec = this.extractPartitionSpecs((Tree)((ASTNode)ast.getChild(0)));
        if (newPartSpec == null) {
            throw new SemanticException("RENAME PARTITION Missing Destination" + ast);
        }
        Table tab = this.getTable(tblName, true);
        this.validateAlterTableType(tab, AlterTableDesc.AlterTableTypes.RENAMEPARTITION);
        this.inputs.add(new ReadEntity(tab));
        ArrayList<Map<String, String>> partSpecs = new ArrayList<Map<String, String>>();
        partSpecs.add(oldPartSpec);
        partSpecs.add(newPartSpec);
        this.addTablePartsOutputs(tblName, partSpecs);
        RenamePartitionDesc renamePartitionDesc = new RenamePartitionDesc(this.db.getCurrentDatabase(), tblName, oldPartSpec, newPartSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), renamePartitionDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableBucketNum(ASTNode ast, String tblName, HashMap<String, String> partSpec) throws SemanticException {
        Table tab = this.getTable(tblName, true);
        if (tab.getBucketCols() == null || tab.getBucketCols().isEmpty()) {
            throw new SemanticException(ErrorMsg.ALTER_BUCKETNUM_NONBUCKETIZED_TBL.getMsg());
        }
        this.validateAlterTableType(tab, AlterTableDesc.AlterTableTypes.ALTERBUCKETNUM);
        this.inputs.add(new ReadEntity(tab));
        int bucketNum = Integer.parseInt(ast.getChild(0).getText());
        AlterTableDesc alterBucketNum = new AlterTableDesc(tblName, partSpec, bucketNum);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterBucketNum), this.conf, new Task[0]));
    }

    private void analyzeAlterTableModifyCols(ASTNode ast, AlterTableDesc.AlterTableTypes alterType) throws SemanticException {
        String tblName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        List<FieldSchema> newCols = this.getColumns((ASTNode)ast.getChild(1));
        AlterTableDesc alterTblDesc = new AlterTableDesc(tblName, newCols, alterType);
        this.addInputsOutputsAlterTable(tblName, null, alterTblDesc);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableDropParts(ASTNode ast, boolean expectView) throws SemanticException {
        boolean ignoreProtection;
        String tblName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        List<PartitionSpec> partSpecs = this.getFullPartitionSpecs(ast);
        Table tab = this.getTable(tblName, true);
        this.validateAlterTableType(tab, AlterTableDesc.AlterTableTypes.DROPPARTITION, expectView);
        this.inputs.add(new ReadEntity(tab));
        boolean stringPartitionColumns = true;
        List<FieldSchema> partCols = tab.getPartCols();
        for (FieldSchema partCol : partCols) {
            if (partCol.getType().toLowerCase().equals("string")) continue;
            stringPartitionColumns = false;
            break;
        }
        if (!stringPartitionColumns) {
            for (PartitionSpec partSpec : partSpecs) {
                if (!partSpec.isNonEqualityOperator()) continue;
                throw new SemanticException(ErrorMsg.DROP_PARTITION_NON_STRING_PARTCOLS_NONEQUALITY.getMsg());
            }
        }
        boolean bl = ignoreProtection = ast.getFirstChildWithType(647) != null;
        if (partSpecs != null) {
            boolean ifExists = ast.getFirstChildWithType(645) != null;
            boolean throwException = !ifExists && !HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.DROPIGNORESNONEXISTENT);
            this.addTableDropPartsOutputs(tblName, partSpecs, throwException, stringPartitionColumns, ignoreProtection);
        }
        DropTableDesc dropTblDesc = new DropTableDesc(tblName, partSpecs, expectView, stringPartitionColumns, ignoreProtection);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), dropTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableAlterParts(ASTNode ast) throws SemanticException {
        String tblName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        Table tab = null;
        try {
            tab = this.db.getTable(this.db.getCurrentDatabase(), tblName, true);
            this.inputs.add(new ReadEntity(tab));
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tblName));
        }
        this.validateAlterTableType(tab, AlterTableDesc.AlterTableTypes.ALTERPARTITION, false);
        ASTNode colAst = (ASTNode)ast.getChild(1);
        assert (colAst.getChildCount() == 2);
        FieldSchema newCol = new FieldSchema();
        String name = colAst.getChild(0).getText().toLowerCase();
        newCol.setName(DDLSemanticAnalyzer.unescapeIdentifier(name));
        ASTNode typeChild = (ASTNode)colAst.getChild(1);
        newCol.setType(DDLSemanticAnalyzer.getTypeStringFromAST(typeChild));
        boolean fFoundColumn = false;
        for (FieldSchema col : tab.getTTable().getPartitionKeys()) {
            if (col.getName().compareTo(newCol.getName()) != 0) continue;
            fFoundColumn = true;
        }
        if (!fFoundColumn) {
            throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(newCol.getName()));
        }
        AlterTableAlterPartDesc alterTblAlterPartDesc = new AlterTableAlterPartDesc(this.db.getCurrentDatabase(), tblName, newCol);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblAlterPartDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableAddParts(CommonTree ast, boolean expectView) throws SemanticException {
        String tblName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        Table tab = this.getTable(tblName, true);
        boolean isView = tab.isView();
        this.validateAlterTableType(tab, AlterTableDesc.AlterTableTypes.ADDPARTITION, expectView);
        this.inputs.add(new ReadEntity(tab));
        List<Map<String, String>> partSpecs = this.getPartitionSpecs(ast);
        this.addTablePartsOutputs(tblName, partSpecs);
        Iterator<Map<String, String>> partIter = partSpecs.iterator();
        String currentLocation = null;
        Map<String, String> currentPart = null;
        boolean ifNotExists = false;
        ArrayList<AddPartitionDesc> partitionDescs = new ArrayList<AddPartitionDesc>();
        int numCh = ast.getChildCount();
        block9: for (int num = 1; num < numCh; ++num) {
            CommonTree child = (CommonTree)ast.getChild(num);
            switch (child.getToken().getType()) {
                case 646: {
                    ifNotExists = true;
                    continue block9;
                }
                case 699: {
                    if (currentPart != null) {
                        this.validatePartitionValues(currentPart);
                        AddPartitionDesc addPartitionDesc = new AddPartitionDesc(this.db.getCurrentDatabase(), tblName, currentPart, currentLocation, ifNotExists, expectView);
                        partitionDescs.add(addPartitionDesc);
                    }
                    currentLocation = null;
                    currentPart = partIter.next();
                    continue block9;
                }
                case 698: {
                    currentLocation = DDLSemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    continue block9;
                }
                default: {
                    throw new SemanticException("Unknown child: " + child);
                }
            }
        }
        if (currentPart != null) {
            this.validatePartitionValues(currentPart);
            AddPartitionDesc addPartitionDesc = new AddPartitionDesc(this.db.getCurrentDatabase(), tblName, currentPart, currentLocation, ifNotExists, expectView);
            partitionDescs.add(addPartitionDesc);
        }
        for (AddPartitionDesc addPartitionDesc : partitionDescs) {
            try {
                tab.isValidSpec(addPartitionDesc.getPartSpec());
            }
            catch (HiveException ex) {
                throw new SemanticException(ErrorMsg.INVALID_PARTITION_SPEC.getMsg(ex.getMessage()));
            }
            this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), addPartitionDesc), this.conf, new Task[0]));
        }
        if (isView) {
            StringBuilder cmd = new StringBuilder();
            cmd.append("SELECT * FROM ");
            cmd.append(HiveUtils.unparseIdentifier(tblName));
            cmd.append(" WHERE ");
            boolean firstOr = true;
            for (AddPartitionDesc partitionDesc : partitionDescs) {
                try {
                    tab.isValidSpec(partitionDesc.getPartSpec());
                }
                catch (HiveException ex) {
                    throw new SemanticException(ErrorMsg.INVALID_PARTITION_SPEC.getMsg(ex.getMessage()));
                }
                if (firstOr) {
                    firstOr = false;
                } else {
                    cmd.append(" OR ");
                }
                boolean firstAnd = true;
                cmd.append("(");
                for (Map.Entry<String, String> entry : partitionDesc.getPartSpec().entrySet()) {
                    if (firstAnd) {
                        firstAnd = false;
                    } else {
                        cmd.append(" AND ");
                    }
                    cmd.append(HiveUtils.unparseIdentifier(entry.getKey()));
                    cmd.append(" = '");
                    cmd.append(HiveUtils.escapeString(entry.getValue()));
                    cmd.append("'");
                }
                cmd.append(")");
            }
            Driver driver = new Driver(this.conf);
            int rc = driver.compile(cmd.toString());
            if (rc != 0) {
                throw new SemanticException(ErrorMsg.NO_VALID_PARTN.getMsg());
            }
            this.inputs.addAll(driver.getPlan().getInputs());
        }
    }

    private void analyzeAlterTableTouch(CommonTree ast) throws SemanticException {
        String tblName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        Table tab = this.getTable(tblName, true);
        this.validateAlterTableType(tab, AlterTableDesc.AlterTableTypes.TOUCH);
        this.inputs.add(new ReadEntity(tab));
        List<Map<String, String>> partSpecs = this.getPartitionSpecs(ast);
        if (partSpecs.size() == 0) {
            AlterTableSimpleDesc touchDesc = new AlterTableSimpleDesc(this.db.getCurrentDatabase(), tblName, null, AlterTableDesc.AlterTableTypes.TOUCH);
            this.outputs.add(new WriteEntity(tab));
            this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), touchDesc), this.conf, new Task[0]));
        } else {
            this.addTablePartsOutputs(tblName, partSpecs);
            for (Map<String, String> partSpec : partSpecs) {
                AlterTableSimpleDesc touchDesc = new AlterTableSimpleDesc(this.db.getCurrentDatabase(), tblName, partSpec, AlterTableDesc.AlterTableTypes.TOUCH);
                this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), touchDesc), this.conf, new Task[0]));
            }
        }
    }

    private void analyzeAlterTableArchive(CommonTree ast, boolean isUnArchive) throws SemanticException {
        if (!this.conf.getBoolVar(HiveConf.ConfVars.HIVEARCHIVEENABLED)) {
            throw new SemanticException(ErrorMsg.ARCHIVE_METHODS_DISABLED.getMsg());
        }
        String tblName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        List<Map<String, String>> partSpecs = this.getPartitionSpecs(ast);
        Table tab = this.getTable(tblName, true);
        this.addTablePartsOutputs(tblName, partSpecs, true);
        this.validateAlterTableType(tab, AlterTableDesc.AlterTableTypes.ARCHIVE);
        this.inputs.add(new ReadEntity(tab));
        if (partSpecs.size() > 1) {
            throw new SemanticException(isUnArchive ? ErrorMsg.UNARCHIVE_ON_MULI_PARTS.getMsg() : ErrorMsg.ARCHIVE_ON_MULI_PARTS.getMsg());
        }
        if (partSpecs.size() == 0) {
            throw new SemanticException(ErrorMsg.ARCHIVE_ON_TABLE.getMsg());
        }
        Map<String, String> partSpec = partSpecs.get(0);
        try {
            this.isValidPrefixSpec(tab, partSpec);
        }
        catch (HiveException e) {
            throw new SemanticException(e.getMessage(), e);
        }
        AlterTableSimpleDesc archiveDesc = new AlterTableSimpleDesc(this.db.getCurrentDatabase(), tblName, partSpec, isUnArchive ? AlterTableDesc.AlterTableTypes.UNARCHIVE : AlterTableDesc.AlterTableTypes.ARCHIVE);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), archiveDesc), this.conf, new Task[0]));
    }

    private void analyzeMetastoreCheck(CommonTree ast) throws SemanticException {
        String tableName = null;
        boolean repair = false;
        if (ast.getChildCount() > 0) {
            boolean bl = repair = ast.getChild(0).getType() == 193;
            if (!repair) {
                tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
            } else if (ast.getChildCount() > 1) {
                tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(1));
            }
        }
        List<Map<String, String>> specs = this.getPartitionSpecs(ast);
        MsckDesc checkDesc = new MsckDesc(tableName, specs, this.ctx.getResFile(), repair);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), checkDesc), this.conf, new Task[0]));
    }

    private List<Map<String, String>> getPartitionSpecs(CommonTree ast) throws SemanticException {
        ArrayList<Map<String, String>> partSpecs = new ArrayList<Map<String, String>>();
        int childIndex = 0;
        for (childIndex = 1; childIndex < ast.getChildCount(); ++childIndex) {
            Tree partspec = ast.getChild(childIndex);
            if (partspec.getType() != 699) continue;
            partSpecs.add(DDLSemanticAnalyzer.getPartSpec((ASTNode)partspec));
        }
        return partSpecs;
    }

    private List<PartitionSpec> getFullPartitionSpecs(CommonTree ast) throws SemanticException {
        ArrayList<PartitionSpec> partSpecList = new ArrayList<PartitionSpec>();
        for (int childIndex = 1; childIndex < ast.getChildCount(); ++childIndex) {
            Tree partSpecTree = ast.getChild(childIndex);
            if (partSpecTree.getType() != 699) continue;
            PartitionSpec partSpec = new PartitionSpec();
            for (int i = 0; i < partSpecTree.getChildCount(); ++i) {
                CommonTree partSpecSingleKey = (CommonTree)partSpecTree.getChild(i);
                assert (partSpecSingleKey.getType() == 700);
                String key = partSpecSingleKey.getChild(0).getText().toLowerCase();
                String operator = partSpecSingleKey.getChild(1).getText();
                String val = partSpecSingleKey.getChild(2).getText();
                partSpec.addPredicate(key, operator, val);
            }
            partSpecList.add(partSpec);
        }
        return partSpecList;
    }

    private void validatePartitionValues(Map<String, String> partSpec) throws SemanticException {
        for (Map.Entry<String, String> e : partSpec.entrySet()) {
            for (String s : this.reservedPartitionValues) {
                if (!e.getValue().contains(s)) continue;
                throw new SemanticException(ErrorMsg.RESERVED_PART_VAL.getMsg("(User value: " + e.getValue() + " Reserved substring: " + s + ")"));
            }
        }
    }

    private void addTablePartsOutputs(String tblName, List<Map<String, String>> partSpecs) throws SemanticException {
        this.addTablePartsOutputs(tblName, partSpecs, false, false, null);
    }

    private void addTablePartsOutputs(String tblName, List<Map<String, String>> partSpecs, boolean allowMany) throws SemanticException {
        this.addTablePartsOutputs(tblName, partSpecs, false, allowMany, null);
    }

    private void addTablePartsOutputs(String tblName, List<Map<String, String>> partSpecs, boolean throwIfNonExistent, boolean allowMany, ASTNode ast) throws SemanticException {
        Table tab = this.getTable(tblName);
        Iterator<Map<String, String>> i = partSpecs.iterator();
        int index = 1;
        while (i.hasNext()) {
            Map<String, String> partSpec = i.next();
            List<Object> parts = null;
            if (allowMany) {
                try {
                    parts = this.db.getPartitions(tab, partSpec);
                }
                catch (HiveException e) {
                    LOG.error((Object)"Got HiveException during obtaining list of partitions");
                }
            } else {
                parts = new ArrayList();
                try {
                    Partition p = this.db.getPartition(tab, partSpec, false);
                    if (p != null) {
                        parts.add(p);
                    }
                }
                catch (HiveException e) {
                    LOG.debug((Object)"Wrong specification");
                }
            }
            if (parts.isEmpty() && throwIfNonExistent) {
                throw new SemanticException(ErrorMsg.INVALID_PARTITION.getMsg(ast.getChild(index)));
            }
            for (Partition partition : parts) {
                this.outputs.add(new WriteEntity(partition));
            }
            ++index;
        }
    }

    private void addTableDropPartsOutputs(String tblName, List<PartitionSpec> partSpecs, boolean throwIfNonExistent, boolean stringPartitionColumns, boolean ignoreProtection) throws SemanticException {
        Table tab = this.getTable(tblName);
        Iterator<PartitionSpec> i = partSpecs.iterator();
        int index = 1;
        while (i.hasNext()) {
            PartitionSpec partSpec = i.next();
            List<Partition> parts = null;
            if (stringPartitionColumns) {
                try {
                    parts = this.db.getPartitionsByFilter(tab, partSpec.toString());
                }
                catch (Exception e) {
                    throw new SemanticException(ErrorMsg.INVALID_PARTITION.getMsg(partSpec.toString()), e);
                }
            }
            try {
                parts = this.db.getPartitions(tab, partSpec.getPartSpecWithoutOperator());
            }
            catch (Exception e) {
                throw new SemanticException(ErrorMsg.INVALID_PARTITION.getMsg(partSpec.toString()), e);
            }
            if (parts.isEmpty() && throwIfNonExistent) {
                throw new SemanticException(ErrorMsg.INVALID_PARTITION.getMsg(partSpec.toString()));
            }
            for (Partition p : parts) {
                if (!ignoreProtection && !p.canDrop()) {
                    throw new SemanticException(ErrorMsg.DROP_COMMAND_NOT_ALLOWED_FOR_PARTITION.getMsg(p.getCompleteName()));
                }
                this.outputs.add(new WriteEntity(p));
            }
            ++index;
        }
    }

    private void analyzeAltertableSkewedby(ASTNode ast) throws SemanticException {
        HiveConf hiveConf = SessionState.get().getConf();
        String tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        Table tab = this.getTable(tableName, true);
        this.inputs.add(new ReadEntity(tab));
        this.outputs.add(new WriteEntity(tab));
        this.validateAlterTableType(tab, AlterTableDesc.AlterTableTypes.ADDSKEWEDBY);
        if (ast.getChildCount() == 1) {
            AlterTableDesc alterTblDesc = new AlterTableDesc(tableName, true, new ArrayList<String>(), new ArrayList<List<String>>());
            alterTblDesc.setStoredAsSubDirectories(false);
            this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
        } else {
            switch (((ASTNode)ast.getChild(1)).getToken().getType()) {
                case 782: {
                    this.handleAlterTableSkewedBy(ast, tableName, tab);
                    break;
                }
                case 752: {
                    this.handleAlterTableDisableStoredAsDirs(tableName, tab);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
    }

    private void handleAlterTableDisableStoredAsDirs(String tableName, Table tab) throws SemanticException {
        List<String> skewedColNames = tab.getSkewedColNames();
        List<List<String>> skewedColValues = tab.getSkewedColValues();
        if (skewedColNames == null || skewedColNames.size() == 0 || skewedColValues == null || skewedColValues.size() == 0) {
            throw new SemanticException(ErrorMsg.ALTER_TBL_STOREDASDIR_NOT_SKEWED.getMsg(tableName));
        }
        AlterTableDesc alterTblDesc = new AlterTableDesc(tableName, false, skewedColNames, skewedColValues);
        alterTblDesc.setStoredAsSubDirectories(false);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void handleAlterTableSkewedBy(ASTNode ast, String tableName, Table tab) throws SemanticException {
        List<String> skewedColNames = new ArrayList<String>();
        ArrayList<List<String>> skewedValues = new ArrayList<List<String>>();
        ASTNode skewedNode = (ASTNode)ast.getChild(1);
        skewedColNames = this.analyzeSkewedTablDDLColNames(skewedColNames, skewedNode);
        this.analyzeDDLSkewedValues(skewedValues, skewedNode);
        boolean storedAsDirs = this.analyzeStoredAdDirs(skewedNode);
        AlterTableDesc alterTblDesc = new AlterTableDesc(tableName, false, skewedColNames, skewedValues);
        alterTblDesc.setStoredAsSubDirectories(storedAsDirs);
        alterTblDesc.setTable(tab);
        alterTblDesc.validate();
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private List<String> analyzeAlterTableSkewedColNames(List<String> skewedColNames, ASTNode child) throws SemanticException {
        Tree nNode = child.getChild(0);
        if (nNode == null) {
            throw new SemanticException(ErrorMsg.SKEWED_TABLE_NO_COLUMN_NAME.getMsg());
        }
        ASTNode nAstNode = (ASTNode)nNode;
        if (nAstNode.getToken().getType() != 763) {
            throw new SemanticException(ErrorMsg.SKEWED_TABLE_NO_COLUMN_NAME.getMsg());
        }
        skewedColNames = this.getColumnNames(nAstNode);
        return skewedColNames;
    }

    private List<String> getColumnValues(ASTNode ast) {
        ArrayList<String> colList = new ArrayList<String>();
        int numCh = ast.getChildCount();
        for (int i = 0; i < numCh; ++i) {
            ASTNode child = (ASTNode)ast.getChild(i);
            colList.add(DDLSemanticAnalyzer.stripQuotes(child.getText()).toLowerCase());
        }
        return colList;
    }

    private void analyzeAlterTableSkewedLocation(ASTNode ast, String tableName, HashMap<String, String> partSpec) throws SemanticException {
        HiveConf hiveConf = SessionState.get().getConf();
        HashMap<List<String>, String> locations = new HashMap<List<String>, String>();
        List locNodes = ast.getChildren();
        if (null == locNodes) {
            throw new SemanticException(ErrorMsg.ALTER_TBL_SKEWED_LOC_NO_LOC.getMsg());
        }
        for (Node locNode : locNodes) {
            ASTNode locAstNode = (ASTNode)locNode;
            List locListNodes = locAstNode.getChildren();
            if (null == locListNodes) {
                throw new SemanticException(ErrorMsg.ALTER_TBL_SKEWED_LOC_NO_LOC.getMsg());
            }
            for (Node locListNode : locListNodes) {
                ASTNode locListAstNode = (ASTNode)locListNode;
                List locMapNodes = locListAstNode.getChildren();
                if (null == locMapNodes) {
                    throw new SemanticException(ErrorMsg.ALTER_TBL_SKEWED_LOC_NO_LOC.getMsg());
                }
                for (Node locMapNode : locMapNodes) {
                    ASTNode locMapAstNode = (ASTNode)locMapNode;
                    List locMapAstNodeMaps = locMapAstNode.getChildren();
                    if (null == locMapAstNodeMaps || ((ArrayList)locMapAstNodeMaps).size() != 2) {
                        throw new SemanticException(ErrorMsg.ALTER_TBL_SKEWED_LOC_NO_MAP.getMsg());
                    }
                    List<Object> keyList = new LinkedList();
                    ASTNode node = (ASTNode)((ArrayList)locMapAstNodeMaps).get(0);
                    if (node.getToken().getType() == 765) {
                        keyList = this.getSkewedValuesFromASTNode(node);
                    } else if (this.isConstant(node)) {
                        keyList.add(PlanUtils.stripQuotes(node.getText()));
                    } else {
                        throw new SemanticException(ErrorMsg.SKEWED_TABLE_NO_COLUMN_VALUE.getMsg());
                    }
                    String newLocation = PlanUtils.stripQuotes(DDLSemanticAnalyzer.unescapeSQLString(((ASTNode)((ArrayList)locMapAstNodeMaps).get(1)).getText()));
                    this.validateSkewedLocationString(newLocation);
                    locations.put(keyList, newLocation);
                }
            }
        }
        AlterTableDesc alterTblDesc = new AlterTableDesc(tableName, locations, partSpec);
        this.addInputsOutputsAlterTable(tableName, partSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private boolean isConstant(ASTNode node) {
        boolean result = false;
        switch (node.getToken().getType()) {
            case 272: {
                result = true;
                break;
            }
            case 282: {
                result = true;
                break;
            }
            case 7: {
                result = true;
                break;
            }
            case 281: {
                result = true;
                break;
            }
            case 284: {
                result = true;
                break;
            }
            case 18: {
                result = true;
                break;
            }
            case 13: {
                result = true;
                break;
            }
            case 96: 
            case 239: {
                result = true;
                break;
            }
        }
        return result;
    }

    private void validateSkewedLocationString(String newLocation) throws SemanticException {
        try {
            URI locUri = new URI(newLocation);
            if (!locUri.isAbsolute() || locUri.getScheme() == null || locUri.getScheme().trim().equals("")) {
                throw new SemanticException(newLocation + " is not absolute or has no scheme information. " + "Please specify a complete absolute uri with scheme information.");
            }
        }
        catch (URISyntaxException e) {
            throw new SemanticException(e);
        }
    }

    private Table getTable(String tblName) throws SemanticException {
        return this.getTable(null, tblName, true);
    }

    private Table getTable(String tblName, boolean throwException) throws SemanticException {
        return this.getTable(this.db.getCurrentDatabase(), tblName, throwException);
    }

    private Table getTable(String database, String tblName, boolean throwException) throws SemanticException {
        try {
            Table tab;
            Table table = tab = database == null ? this.db.getTable(tblName, false) : this.db.getTable(database, tblName, false);
            if (tab == null && throwException) {
                throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tblName));
            }
            return tab;
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tblName));
        }
    }

    private Partition getPartition(Table table, Map<String, String> partSpec, boolean throwException) throws SemanticException {
        try {
            Partition partition = this.db.getPartition(table, partSpec, false);
            if (partition == null && throwException) {
                throw new SemanticException(this.toMessage(ErrorMsg.INVALID_PARTITION, partSpec));
            }
            return partition;
        }
        catch (HiveException e) {
            throw new SemanticException(this.toMessage(ErrorMsg.INVALID_PARTITION, partSpec), e);
        }
    }

    private List<Partition> getPartitions(Table table, Map<String, String> partSpec, boolean throwException) throws SemanticException {
        try {
            List<Partition> partitions;
            List<Partition> list = partitions = partSpec == null ? this.db.getPartitions(table) : this.db.getPartitions(table, partSpec);
            if (partitions.isEmpty() && throwException) {
                throw new SemanticException(this.toMessage(ErrorMsg.INVALID_PARTITION, partSpec));
            }
            return partitions;
        }
        catch (HiveException e) {
            throw new SemanticException(this.toMessage(ErrorMsg.INVALID_PARTITION, partSpec), e);
        }
    }

    private String toMessage(ErrorMsg message, Object detail) {
        return detail == null ? message.getMsg() : message.getMsg(detail.toString());
    }

    static {
        TokenToTypeName.put(583, "boolean");
        TokenToTypeName.put(797, "tinyint");
        TokenToTypeName.put(749, "smallint");
        TokenToTypeName.put(654, "int");
        TokenToTypeName.put(581, "bigint");
        TokenToTypeName.put(627, "float");
        TokenToTypeName.put(612, "double");
        TokenToTypeName.put(754, "string");
        TokenToTypeName.put(582, "binary");
        TokenToTypeName.put(600, "date");
        TokenToTypeName.put(601, "datetime");
        TokenToTypeName.put(796, "timestamp");
        TokenToTypeName.put(603, "decimal");
    }

    static class QualifiedNameUtil {
        static String delimiter = "\\.";

        QualifiedNameUtil() {
        }

        public static String getFullyQualifiedName(ASTNode ast) {
            if (ast.getChildCount() == 0) {
                return ast.getText();
            }
            if (ast.getChildCount() == 2) {
                return QualifiedNameUtil.getFullyQualifiedName((ASTNode)ast.getChild(0)) + "." + QualifiedNameUtil.getFullyQualifiedName((ASTNode)ast.getChild(1));
            }
            if (ast.getChildCount() == 3) {
                return QualifiedNameUtil.getFullyQualifiedName((ASTNode)ast.getChild(0)) + "." + QualifiedNameUtil.getFullyQualifiedName((ASTNode)ast.getChild(1)) + "." + QualifiedNameUtil.getFullyQualifiedName((ASTNode)ast.getChild(2));
            }
            return null;
        }

        public static String getAttemptTableName(Hive db, String qualifiedName, boolean isColumn) {
            String tableName = qualifiedName.substring(0, qualifiedName.indexOf(46) == -1 ? qualifiedName.length() : qualifiedName.indexOf(46));
            try {
                Table tab = db.getTable(tableName);
                if (tab != null) {
                    if (isColumn) {
                        return qualifiedName;
                    }
                    return tableName;
                }
            }
            catch (HiveException e) {
                return null;
            }
            return null;
        }

        public static String getDBName(Hive db, ASTNode ast) {
            String dbName;
            block4: {
                dbName = null;
                String fullyQualifiedName = QualifiedNameUtil.getFullyQualifiedName(ast);
                if (ast.getChildCount() >= 2) {
                    dbName = fullyQualifiedName.substring(0, fullyQualifiedName.indexOf(46) == -1 ? fullyQualifiedName.length() : fullyQualifiedName.indexOf(46));
                    try {
                        if (!db.databaseExists(dbName)) {
                            return null;
                        }
                        break block4;
                    }
                    catch (HiveException e) {
                        return null;
                    }
                }
                return null;
            }
            return dbName;
        }

        public static String getTableName(Hive db, ASTNode ast) throws SemanticException {
            String tableName = null;
            String fullyQualifiedName = QualifiedNameUtil.getFullyQualifiedName(ast);
            String attemptTableName = QualifiedNameUtil.getAttemptTableName(db, fullyQualifiedName, false);
            if (attemptTableName != null) {
                return attemptTableName;
            }
            if (fullyQualifiedName.split(delimiter).length == 3) {
                if (ast.getChildCount() == 2) {
                    throw new SemanticException(ErrorMsg.INVALID_TABLE_OR_COLUMN.getMsg(fullyQualifiedName));
                }
                tableName = fullyQualifiedName.substring(0, fullyQualifiedName.lastIndexOf(46));
            } else if (fullyQualifiedName.split(delimiter).length == 2) {
                tableName = fullyQualifiedName;
            } else {
                throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(fullyQualifiedName));
            }
            return tableName;
        }

        public static String getColPath(Hive db, ASTNode parentAst, ASTNode ast, String tableName, Map<String, String> partSpec) {
            if (parentAst.getChildCount() == 2 && partSpec == null) {
                return QualifiedNameUtil.getFullyQualifiedName(parentAst);
            }
            String attemptTableName = QualifiedNameUtil.getAttemptTableName(db, tableName, true);
            if (attemptTableName != null) {
                return attemptTableName;
            }
            if (tableName.split(delimiter).length == 3) {
                return tableName.substring(tableName.indexOf(".") + 1, tableName.length());
            }
            return tableName;
        }

        public static Map<String, String> getPartitionSpec(Hive db, ASTNode ast, String tableName) throws SemanticException {
            if (ast.getChildCount() == 2) {
                ASTNode partNode = (ASTNode)ast.getChild(1);
                HashMap partSpec = null;
                try {
                    partSpec = DDLSemanticAnalyzer.getPartSpec(partNode);
                }
                catch (SemanticException e) {
                    return null;
                }
                Table tab = null;
                try {
                    tab = db.getTable(tableName);
                }
                catch (HiveException e) {
                    throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tableName), e);
                }
                if (partSpec != null) {
                    Partition part = null;
                    try {
                        part = db.getPartition(tab, partSpec, false);
                    }
                    catch (HiveException e) {
                        return null;
                    }
                    if (part == null) {
                        throw new SemanticException(ErrorMsg.INVALID_PARTITION.getMsg(partSpec.toString()));
                    }
                    return partSpec;
                }
            }
            return null;
        }
    }

    static class TablePartition {
        String tableName;
        HashMap<String, String> partSpec = null;

        public TablePartition() {
        }

        public TablePartition(ASTNode tblPart) throws SemanticException {
            ASTNode part;
            this.tableName = BaseSemanticAnalyzer.unescapeIdentifier(tblPart.getChild(0).getText());
            if (tblPart.getChildCount() > 1 && (part = (ASTNode)tblPart.getChild(1)).getToken().getType() == 699) {
                this.partSpec = DDLSemanticAnalyzer.getPartSpec(part);
            }
        }
    }
}

