/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.CommonJoinOperator;
import org.apache.hadoop.hive.ql.exec.ExtractOperator;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.LateralViewForwardOperator;
import org.apache.hadoop.hive.ql.exec.LateralViewJoinOperator;
import org.apache.hadoop.hive.ql.exec.LimitOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.PTFOperator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.ScriptOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.UDTFOperator;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.ColumnPrunerProcCtx;
import org.apache.hadoop.hive.ql.parse.OpParseContext;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.LateralViewJoinDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PTFDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public final class ColumnPrunerProcFactory {
    protected static final Log LOG = LogFactory.getLog((String)ColumnPrunerProcFactory.class.getName());

    private ColumnPrunerProcFactory() {
    }

    public static ColumnPrunerFilterProc getFilterProc() {
        return new ColumnPrunerFilterProc();
    }

    public static ColumnPrunerGroupByProc getGroupByProc() {
        return new ColumnPrunerGroupByProc();
    }

    public static ColumnPrunerPTFProc getPTFProc() {
        return new ColumnPrunerPTFProc();
    }

    public static ColumnPrunerDefaultProc getDefaultProc() {
        return new ColumnPrunerDefaultProc();
    }

    public static ColumnPrunerTableScanProc getTableScanProc() {
        return new ColumnPrunerTableScanProc();
    }

    public static ColumnPrunerReduceSinkProc getReduceSinkProc() {
        return new ColumnPrunerReduceSinkProc();
    }

    private static boolean[] getPruneReduceSinkOpRetainFlags(List<String> retainedParentOpOutputCols, ReduceSinkOperator reduce) {
        ReduceSinkDesc reduceConf = (ReduceSinkDesc)reduce.getConf();
        ArrayList<ExprNodeDesc> originalValueEval = reduceConf.getValueCols();
        boolean[] flags = new boolean[originalValueEval.size()];
        block0: for (int i = 0; i < originalValueEval.size(); ++i) {
            flags[i] = false;
            List<String> current = originalValueEval.get(i).getCols();
            if (current == null || current.size() == 0) {
                flags[i] = true;
                continue;
            }
            for (int j = 0; j < current.size(); ++j) {
                if (!retainedParentOpOutputCols.contains(current.get(j))) continue;
                flags[i] = true;
                continue block0;
            }
        }
        return flags;
    }

    private static void pruneReduceSinkOperator(boolean[] retainFlags, ReduceSinkOperator reduce, ColumnPrunerProcCtx cppCtx) throws SemanticException {
        ReduceSinkDesc reduceConf = (ReduceSinkDesc)reduce.getConf();
        Map<String, ExprNodeDesc> oldMap = reduce.getColumnExprMap();
        RowResolver oldRR = cppCtx.getOpToParseCtxMap().get(reduce).getRowResolver();
        ArrayList<ColumnInfo> signature = oldRR.getRowSchema().getSignature();
        ArrayList<String> valueColNames = reduceConf.getOutputValueColumnNames();
        ArrayList<String> newValueColNames = new ArrayList<String>();
        ArrayList<ExprNodeDesc> valueExprs = reduceConf.getValueCols();
        ArrayList<ExprNodeDesc> newValueExprs = new ArrayList<ExprNodeDesc>();
        for (int i = 0; i < retainFlags.length; ++i) {
            String outputCol = (String)valueColNames.get(i);
            ExprNodeDesc outputColExpr = (ExprNodeDesc)valueExprs.get(i);
            if (!retainFlags[i]) {
                String[] nm = oldRR.reverseLookup(outputCol);
                if (nm == null) {
                    outputCol = Utilities.ReduceField.VALUE.toString() + "." + outputCol;
                    nm = oldRR.reverseLookup(outputCol);
                }
                ColumnInfo colInfo = oldRR.getFieldMap(nm[0]).remove(nm[1]);
                oldRR.getInvRslvMap().remove(colInfo.getInternalName());
                oldMap.remove(outputCol);
                signature.remove(colInfo);
                continue;
            }
            newValueColNames.add(outputCol);
            newValueExprs.add(outputColExpr);
        }
        reduceConf.setOutputValueColumnNames(newValueColNames);
        reduceConf.setValueCols(newValueExprs);
        TableDesc newValueTable = PlanUtils.getReduceValueTableDesc(PlanUtils.getFieldSchemasFromColumnList(reduceConf.getValueCols(), newValueColNames, 0, ""));
        reduceConf.setValueSerializeInfo(newValueTable);
    }

    public static ColumnPrunerSelectProc getSelectProc() {
        return new ColumnPrunerSelectProc();
    }

    public static ColumnPrunerLateralViewJoinProc getLateralViewJoinProc() {
        return new ColumnPrunerLateralViewJoinProc();
    }

    public static ColumnPrunerLateralViewForwardProc getLateralViewForwardProc() {
        return new ColumnPrunerLateralViewForwardProc();
    }

    public static ColumnPrunerJoinProc getJoinProc() {
        return new ColumnPrunerJoinProc();
    }

    private static void pruneOperator(NodeProcessorCtx ctx, Operator<? extends OperatorDesc> op, List<String> cols) throws SemanticException {
        RowSchema inputSchema = op.getSchema();
        if (inputSchema != null) {
            ArrayList<ColumnInfo> rs = new ArrayList<ColumnInfo>();
            ArrayList<ColumnInfo> inputCols = inputSchema.getSignature();
            for (ColumnInfo i : inputCols) {
                if (!cols.contains(i.getInternalName())) continue;
                rs.add(i);
            }
            op.getSchema().setSignature(rs);
        }
    }

    private static List<String> preserveColumnOrder(Operator<? extends OperatorDesc> op, List<String> cols) throws SemanticException {
        RowSchema inputSchema = op.getSchema();
        if (inputSchema != null) {
            ArrayList<String> rs = new ArrayList<String>();
            ArrayList<ColumnInfo> inputCols = inputSchema.getSignature();
            for (ColumnInfo i : inputCols) {
                if (!cols.contains(i.getInternalName())) continue;
                rs.add(i.getInternalName());
            }
            return rs;
        }
        return cols;
    }

    private static void pruneJoinOperator(NodeProcessorCtx ctx, CommonJoinOperator op, JoinDesc conf, Map<String, ExprNodeDesc> columnExprMap, Map<Byte, List<Integer>> retainMap, boolean mapJoin) throws SemanticException {
        String internalName;
        ColumnPrunerProcCtx cppCtx = (ColumnPrunerProcCtx)ctx;
        HashMap<Byte, List<String>> prunedColLists = new HashMap<Byte, List<String>>();
        List<Operator<OperatorDesc>> childOperators = op.getChildOperators();
        for (Operator<OperatorDesc> child : childOperators) {
            if (!(child instanceof FileSinkOperator)) continue;
            return;
        }
        List<String> childColLists = cppCtx.genColLists(op);
        Set<Map.Entry<Byte, List<ExprNodeDesc>>> filters = conf.getFilters().entrySet();
        for (Map.Entry<Byte, List<ExprNodeDesc>> entry : filters) {
            Byte tag = entry.getKey();
            for (ExprNodeDesc desc : entry.getValue()) {
                List<String> cols = (List<String>)prunedColLists.get(tag);
                cols = Utilities.mergeUniqElems(cols, desc.getCols());
                prunedColLists.put(tag, cols);
            }
        }
        RowResolver joinRR = cppCtx.getOpToParseCtxMap().get(op).getRowResolver();
        RowResolver newJoinRR = new RowResolver();
        ArrayList<String> outputCols = new ArrayList<String>();
        ArrayList<ColumnInfo> rs = new ArrayList<ColumnInfo>();
        HashMap<String, ExprNodeDesc> newColExprMap = new HashMap<String, ExprNodeDesc>();
        for (int i = 0; i < conf.getOutputColumnNames().size(); ++i) {
            internalName = conf.getOutputColumnNames().get(i);
            ExprNodeDesc desc = columnExprMap.get(internalName);
            Byte tag = conf.getReversedExprs().get(internalName);
            if (!childColLists.contains(internalName)) {
                int index = conf.getExprs().get(tag).indexOf(desc);
                if (index < 0) continue;
                conf.getExprs().get(tag).remove(desc);
                if (retainMap == null) continue;
                retainMap.get(tag).remove(index);
                continue;
            }
            List<String> prunedRSList = (ArrayList<String>)prunedColLists.get(tag);
            if (prunedRSList == null) {
                prunedRSList = new ArrayList<String>();
                prunedColLists.put(tag, prunedRSList);
            }
            prunedRSList = Utilities.mergeUniqElems(prunedRSList, desc.getCols());
            outputCols.add(internalName);
            newColExprMap.put(internalName, desc);
        }
        if (mapJoin) {
            ArrayList<TableDesc> valueTableDescs = new ArrayList<TableDesc>();
            for (int pos = 0; pos < op.getParentOperators().size(); ++pos) {
                List<ExprNodeDesc> valueCols = conf.getExprs().get((byte)pos);
                StringBuilder keyOrder = new StringBuilder();
                for (int i = 0; i < valueCols.size(); ++i) {
                    keyOrder.append("+");
                }
                TableDesc valueTableDesc = PlanUtils.getMapJoinValueTableDesc(PlanUtils.getFieldSchemasFromColumnList(valueCols, "mapjoinvalue"));
                valueTableDescs.add(valueTableDesc);
            }
            ((MapJoinDesc)conf).setValueTblDescs(valueTableDescs);
            Set<Map.Entry<Byte, List<ExprNodeDesc>>> exprs = ((MapJoinDesc)conf).getKeys().entrySet();
            for (Map.Entry<Byte, List<ExprNodeDesc>> entry : exprs) {
                List<ExprNodeDesc> lists = entry.getValue();
                for (int j = 0; j < lists.size(); ++j) {
                    ExprNodeDesc desc = lists.get(j);
                    Byte tag = entry.getKey();
                    List<String> cols = (List<String>)prunedColLists.get(tag);
                    cols = Utilities.mergeUniqElems(cols, desc.getCols());
                    prunedColLists.put(tag, cols);
                }
            }
        }
        for (Operator<OperatorDesc> child : childOperators) {
            if (!(child instanceof ReduceSinkOperator)) continue;
            boolean[] flags = ColumnPrunerProcFactory.getPruneReduceSinkOpRetainFlags(childColLists, (ReduceSinkOperator)child);
            ColumnPrunerProcFactory.pruneReduceSinkOperator(flags, (ReduceSinkOperator)child, cppCtx);
        }
        for (int i = 0; i < outputCols.size(); ++i) {
            internalName = (String)outputCols.get(i);
            String[] nm = joinRR.reverseLookup(internalName);
            ColumnInfo col = joinRR.get(nm[0], nm[1]);
            newJoinRR.put(nm[0], nm[1], col);
            rs.add(col);
        }
        op.setColumnExprMap(newColExprMap);
        conf.setOutputColumnNames(outputCols);
        op.getSchema().setSignature(rs);
        cppCtx.getOpToParseCtxMap().get(op).setRowResolver(newJoinRR);
        cppCtx.getJoinPrunedColLists().put(op, prunedColLists);
    }

    public static ColumnPrunerMapJoinProc getMapJoinProc() {
        return new ColumnPrunerMapJoinProc();
    }

    public static class ColumnPrunerMapJoinProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            MapJoinOperator op = (MapJoinOperator)nd;
            ColumnPrunerProcFactory.pruneJoinOperator(ctx, op, (JoinDesc)op.getConf(), op.getColumnExprMap(), ((MapJoinDesc)op.getConf()).getRetainList(), true);
            return null;
        }
    }

    public static class ColumnPrunerJoinProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            JoinOperator op = (JoinOperator)nd;
            ColumnPrunerProcFactory.pruneJoinOperator(ctx, op, (JoinDesc)op.getConf(), op.getColumnExprMap(), null, false);
            return null;
        }
    }

    public static class ColumnPrunerSelectProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            SelectOperator op = (SelectOperator)nd;
            ColumnPrunerProcCtx cppCtx = (ColumnPrunerProcCtx)ctx;
            LateralViewJoinOperator lvJoin = null;
            if (op.getChildOperators() != null) {
                for (Operator<OperatorDesc> child : op.getChildOperators()) {
                    if (child instanceof FileSinkOperator || child instanceof ScriptOperator || child instanceof UDTFOperator || child instanceof LimitOperator || child instanceof UnionOperator) {
                        cppCtx.getPrunedColLists().put(op, cppCtx.getColsFromSelectExpr(op));
                        return null;
                    }
                    if (!((SelectDesc)op.getConf()).isSelStarNoCompute() || !(child instanceof LateralViewJoinOperator)) continue;
                    lvJoin = (LateralViewJoinOperator)child;
                }
            }
            List<String> cols = cppCtx.genColLists(op);
            SelectDesc conf = (SelectDesc)op.getConf();
            if (lvJoin != null) {
                RowResolver rr = cppCtx.getOpToParseCtxMap().get(op).getRowResolver();
                cppCtx.getPrunedColLists().put(op, cppCtx.getSelectColsFromLVJoin(rr, cols));
                return null;
            }
            cppCtx.getPrunedColLists().put(op, cppCtx.getSelectColsFromChildren(op, cols));
            if (conf.isSelStarNoCompute()) {
                return null;
            }
            List<ExprNodeDesc> originalColList = ((SelectDesc)op.getConf()).getColList();
            ArrayList<String> columns = new ArrayList<String>();
            for (ExprNodeDesc expr : originalColList) {
                Utilities.mergeUniqElems(columns, expr.getCols());
            }
            List<String> originalOutputColumnNames = conf.getOutputColumnNames();
            if (cols.size() < originalOutputColumnNames.size()) {
                ArrayList<ExprNodeDesc> newColList = new ArrayList<ExprNodeDesc>();
                ArrayList<String> newOutputColumnNames = new ArrayList<String>();
                ArrayList<ColumnInfo> rs_oldsignature = op.getSchema().getSignature();
                ArrayList<ColumnInfo> rs_newsignature = new ArrayList<ColumnInfo>();
                RowResolver old_rr = cppCtx.getOpToParseCtxMap().get(op).getRowResolver();
                RowResolver new_rr = new RowResolver();
                for (String col : cols) {
                    int index = originalOutputColumnNames.indexOf(col);
                    newOutputColumnNames.add(col);
                    newColList.add(originalColList.get(index));
                    rs_newsignature.add(rs_oldsignature.get(index));
                    String[] tabcol = old_rr.reverseLookup(col);
                    ColumnInfo columnInfo = old_rr.get(tabcol[0], tabcol[1]);
                    new_rr.put(tabcol[0], tabcol[1], columnInfo);
                }
                cppCtx.getOpToParseCtxMap().get(op).setRowResolver(new_rr);
                op.getSchema().setSignature(rs_newsignature);
                conf.setColList(newColList);
                conf.setOutputColumnNames(newOutputColumnNames);
                this.handleChildren(op, cols, cppCtx);
            }
            return null;
        }

        private void handleChildren(SelectOperator op, List<String> retainedSelOutputCols, ColumnPrunerProcCtx cppCtx) throws SemanticException {
            for (Operator<OperatorDesc> child : op.getChildOperators()) {
                if (child instanceof ReduceSinkOperator) {
                    boolean[] flags = ColumnPrunerProcFactory.getPruneReduceSinkOpRetainFlags(retainedSelOutputCols, (ReduceSinkOperator)child);
                    ColumnPrunerProcFactory.pruneReduceSinkOperator(flags, (ReduceSinkOperator)child, cppCtx);
                    continue;
                }
                if (!(child instanceof FilterOperator)) continue;
                for (Operator<OperatorDesc> filterChild : child.getChildOperators()) {
                    if (!(filterChild instanceof ReduceSinkOperator)) continue;
                    boolean[] flags = ColumnPrunerProcFactory.getPruneReduceSinkOpRetainFlags(retainedSelOutputCols, (ReduceSinkOperator)filterChild);
                    ColumnPrunerProcFactory.pruneReduceSinkOperator(flags, (ReduceSinkOperator)filterChild, cppCtx);
                }
            }
        }
    }

    public static class ColumnPrunerLateralViewForwardProc
    extends ColumnPrunerDefaultProc {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            super.process(nd, stack, ctx, nodeOutputs);
            LateralViewForwardOperator op = (LateralViewForwardOperator)nd;
            ColumnPrunerProcCtx cppCtx = (ColumnPrunerProcCtx)ctx;
            Operator<OperatorDesc> select = op.getChildOperators().get(0);
            List<String> cols = cppCtx.getPrunedColList(select);
            RowResolver rr = cppCtx.getOpToParseCtxMap().get(op).getRowResolver();
            if (rr.getColumnInfos().size() != cols.size()) {
                ArrayList<ExprNodeDesc> colList = new ArrayList<ExprNodeDesc>();
                ArrayList<String> outputColNames = new ArrayList<String>();
                for (String col : cols) {
                    String[] tabcol = rr.reverseLookup(col);
                    ColumnInfo colInfo = rr.get(tabcol[0], tabcol[1]);
                    ExprNodeColumnDesc colExpr = new ExprNodeColumnDesc(colInfo.getType(), colInfo.getInternalName(), colInfo.getTabAlias(), colInfo.getIsVirtualCol());
                    colList.add(colExpr);
                    outputColNames.add(col);
                }
                ((SelectDesc)select.getConf()).setSelStarNoCompute(false);
                ((SelectDesc)select.getConf()).setColList(colList);
                ((SelectDesc)select.getConf()).setOutputColumnNames(outputColNames);
            }
            return null;
        }
    }

    public static class ColumnPrunerLateralViewJoinProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            LateralViewJoinOperator op = (LateralViewJoinOperator)nd;
            ColumnPrunerProcCtx cppCtx = (ColumnPrunerProcCtx)ctx;
            List<String> cols = cppCtx.genColLists(op);
            Map<String, ExprNodeDesc> colExprMap = op.getColumnExprMap();
            ArrayList<String> colsAfterReplacement = new ArrayList<String>();
            for (String col : cols) {
                if (colExprMap.containsKey(col)) {
                    ExprNodeDesc expr = colExprMap.get(col);
                    colsAfterReplacement.addAll(expr.getCols());
                    continue;
                }
                colsAfterReplacement.add(col);
            }
            ArrayList<String> outputCols = ((LateralViewJoinDesc)op.getConf()).getOutputInternalColNames();
            if (outputCols.size() != cols.size()) {
                ArrayList<String> newColNames = new ArrayList<String>();
                for (String col : cols) {
                    int index = outputCols.indexOf(col);
                    if (index < 0 || index >= colExprMap.size()) continue;
                    newColNames.add(col);
                }
                newColNames.addAll(outputCols.subList(colExprMap.size(), outputCols.size()));
                ((LateralViewJoinDesc)op.getConf()).setOutputInternalColNames(newColNames);
            }
            cppCtx.getPrunedColLists().put(op, colsAfterReplacement);
            return null;
        }
    }

    public static class ColumnPrunerReduceSinkProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            ReduceSinkOperator op = (ReduceSinkOperator)nd;
            ColumnPrunerProcCtx cppCtx = (ColumnPrunerProcCtx)ctx;
            HashMap<Operator<? extends OperatorDesc>, OpParseContext> opToParseCtxMap = cppCtx.getOpToParseCtxMap();
            RowResolver redSinkRR = opToParseCtxMap.get(op).getRowResolver();
            ReduceSinkDesc conf = (ReduceSinkDesc)op.getConf();
            List<Operator<OperatorDesc>> childOperators = op.getChildOperators();
            List<Operator<OperatorDesc>> parentOperators = op.getParentOperators();
            List<String> colLists = new ArrayList<String>();
            ArrayList<ExprNodeDesc> keys = conf.getKeyCols();
            for (ExprNodeDesc key : keys) {
                colLists = Utilities.mergeUniqElems(colLists, key.getCols());
            }
            if (childOperators.size() == 1 && childOperators.get(0) instanceof JoinOperator) {
                assert (parentOperators.size() == 1);
                Operator<OperatorDesc> par = parentOperators.get(0);
                JoinOperator childJoin = (JoinOperator)childOperators.get(0);
                RowResolver parRR = opToParseCtxMap.get(par).getRowResolver();
                List<String> childJoinCols = cppCtx.getJoinPrunedColLists().get(childJoin).get((byte)conf.getTag());
                boolean[] flags = new boolean[conf.getValueCols().size()];
                for (int i = 0; i < flags.length; ++i) {
                    flags[i] = false;
                }
                if (childJoinCols != null && childJoinCols.size() > 0) {
                    Map<String, ExprNodeDesc> exprMap = op.getColumnExprMap();
                    for (String childCol : childJoinCols) {
                        ColumnInfo cInfo;
                        ExprNodeDesc desc = exprMap.get(childCol);
                        int index = conf.getValueCols().indexOf(desc);
                        flags[index] = true;
                        String[] nm = redSinkRR.reverseLookup(childCol);
                        if (nm == null || colLists.contains((cInfo = parRR.get(nm[0], nm[1])).getInternalName())) continue;
                        colLists.add(cInfo.getInternalName());
                    }
                }
                Collections.sort(colLists);
                ColumnPrunerProcFactory.pruneReduceSinkOperator(flags, op, cppCtx);
            } else if (childOperators.size() == 1 && childOperators.get(0) instanceof ExtractOperator && childOperators.get(0).getChildOperators().size() == 1 && childOperators.get(0).getChildOperators().get(0) instanceof PTFOperator && ((PTFDesc)((PTFOperator)childOperators.get(0).getChildOperators().get(0)).getConf()).forWindowing()) {
                assert (parentOperators.size() == 1);
                PTFOperator ptfOp = (PTFOperator)childOperators.get(0).getChildOperators().get(0);
                List<String> childCols = cppCtx.getPrunedColList(ptfOp);
                boolean[] flags = new boolean[conf.getValueCols().size()];
                for (int i = 0; i < flags.length; ++i) {
                    flags[i] = false;
                }
                if (childCols != null && childCols.size() > 0) {
                    ArrayList<String> outColNames = ((ReduceSinkDesc)op.getConf()).getOutputValueColumnNames();
                    for (int i = 0; i < outColNames.size(); ++i) {
                        if (!childCols.contains(outColNames.get(i))) continue;
                        ExprNodeDesc exprNode = ((ReduceSinkDesc)op.getConf()).getValueCols().get(i);
                        flags[i] = true;
                        Utilities.mergeUniqElems(colLists, exprNode.getCols());
                    }
                }
                Collections.sort(colLists);
                ColumnPrunerProcFactory.pruneReduceSinkOperator(flags, op, cppCtx);
            } else {
                ArrayList<ExprNodeDesc> vals = conf.getValueCols();
                for (ExprNodeDesc val : vals) {
                    colLists = Utilities.mergeUniqElems(colLists, val.getCols());
                }
            }
            cppCtx.getPrunedColLists().put(op, colLists);
            return null;
        }
    }

    public static class ColumnPrunerTableScanProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            TableScanOperator scanOp = (TableScanOperator)nd;
            ColumnPrunerProcCtx cppCtx = (ColumnPrunerProcCtx)ctx;
            List<String> cols = cppCtx.genColLists((Operator)nd);
            cppCtx.getPrunedColLists().put((Operator)nd, cols);
            ArrayList<Integer> needed_columns = new ArrayList<Integer>();
            ArrayList<String> neededColumnNames = new ArrayList<String>();
            RowResolver inputRR = cppCtx.getOpToParseCtxMap().get(scanOp).getRowResolver();
            TableScanDesc desc = (TableScanDesc)scanOp.getConf();
            List<VirtualColumn> virtualCols = desc.getVirtualCols();
            ArrayList<VirtualColumn> newVirtualCols = new ArrayList<VirtualColumn>();
            if (((TableScanDesc)scanOp.getConf()).isGatherStats()) {
                cols.add(VirtualColumn.RAWDATASIZE.getName());
            }
            for (int i = 0; i < cols.size(); ++i) {
                String[] tabCol = inputRR.reverseLookup(cols.get(i));
                if (tabCol == null) continue;
                ColumnInfo colInfo = inputRR.get(tabCol[0], tabCol[1]);
                if (colInfo.getIsVirtualCol()) {
                    for (int j = 0; j < virtualCols.size(); ++j) {
                        VirtualColumn vc = virtualCols.get(j);
                        if (!vc.getName().equals(colInfo.getInternalName())) continue;
                        newVirtualCols.add(vc);
                    }
                    continue;
                }
                int position = inputRR.getPosition(cols.get(i));
                if (position < 0) continue;
                needed_columns.add(position);
                neededColumnNames.add(cols.get(i));
            }
            desc.setVirtualCols(newVirtualCols);
            scanOp.setNeededColumnIDs(needed_columns);
            scanOp.setNeededColumns(neededColumnNames);
            return null;
        }
    }

    public static class ColumnPrunerDefaultProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            ColumnPrunerProcCtx cppCtx = (ColumnPrunerProcCtx)ctx;
            cppCtx.getPrunedColLists().put((Operator)nd, cppCtx.genColLists((Operator)nd));
            return null;
        }
    }

    public static class ColumnPrunerPTFProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            PTFOperator op = (PTFOperator)nd;
            PTFDesc conf = (PTFDesc)op.getConf();
            if (!conf.forWindowing()) {
                return ColumnPrunerProcFactory.getDefaultProc().process(nd, stack, ctx, nodeOutputs);
            }
            ColumnPrunerProcCtx cppCtx = (ColumnPrunerProcCtx)ctx;
            PTFDesc.WindowTableFunctionDef def = (PTFDesc.WindowTableFunctionDef)conf.getFuncDef();
            ArrayList<ColumnInfo> sig = new ArrayList<ColumnInfo>();
            List<String> prunedCols = cppCtx.getPrunedColList(op.getChildOperators().get(0));
            prunedCols = new ArrayList<String>(prunedCols);
            this.prunedColumnsList(prunedCols, def);
            RowResolver oldRR = cppCtx.getOpToParseCtxMap().get(op).getRowResolver();
            RowResolver newRR = ColumnPrunerPTFProc.buildPrunedRR(prunedCols, oldRR, sig);
            cppCtx.getPrunedColLists().put(op, this.prunedInputList(prunedCols, def));
            cppCtx.getOpToParseCtxMap().get(op).setRowResolver(newRR);
            op.getSchema().setSignature(sig);
            return null;
        }

        private static RowResolver buildPrunedRR(List<String> prunedCols, RowResolver oldRR, ArrayList<ColumnInfo> sig) throws SemanticException {
            RowResolver newRR = new RowResolver();
            HashSet<String> prunedColsSet = new HashSet<String>(prunedCols);
            for (ColumnInfo cInfo : oldRR.getRowSchema().getSignature()) {
                if (!prunedColsSet.contains(cInfo.getInternalName())) continue;
                String[] nm = oldRR.reverseLookup(cInfo.getInternalName());
                newRR.put(nm[0], nm[1], cInfo);
                sig.add(cInfo);
            }
            return newRR;
        }

        private void prunedColumnsList(List<String> prunedCols, PTFDesc.WindowTableFunctionDef tDef) {
            ExprNodeDesc exprNode;
            if (tDef.getWindowFunctions() != null) {
                for (PTFDesc.WindowFunctionDef windowFunctionDef : tDef.getWindowFunctions()) {
                    if (windowFunctionDef.getArgs() == null) continue;
                    for (PTFDesc.PTFExpressionDef arg : windowFunctionDef.getArgs()) {
                        ExprNodeDesc exprNode2 = arg.getExprNode();
                        Utilities.mergeUniqElems(prunedCols, exprNode2.getCols());
                    }
                }
            }
            if (tDef.getWindowExpressions() != null) {
                for (PTFDesc.WindowExpressionDef windowExpressionDef : tDef.getWindowExpressions()) {
                    exprNode = windowExpressionDef.getExprNode();
                    Utilities.mergeUniqElems(prunedCols, exprNode.getCols());
                }
            }
            if (tDef.getPartition() != null) {
                for (PTFDesc.PTFExpressionDef pTFExpressionDef : tDef.getPartition().getExpressions()) {
                    exprNode = pTFExpressionDef.getExprNode();
                    Utilities.mergeUniqElems(prunedCols, exprNode.getCols());
                }
            }
            if (tDef.getOrder() != null) {
                for (PTFDesc.PTFExpressionDef pTFExpressionDef : tDef.getOrder().getExpressions()) {
                    exprNode = pTFExpressionDef.getExprNode();
                    Utilities.mergeUniqElems(prunedCols, exprNode.getCols());
                }
            }
        }

        private ArrayList<String> prunedInputList(List<String> prunedCols, PTFDesc.WindowTableFunctionDef tDef) {
            ArrayList<String> prunedInputCols = new ArrayList<String>();
            StructObjectInspector OI = tDef.getInput().getOutputShape().getOI();
            for (StructField structField : OI.getAllStructFieldRefs()) {
                String fName = structField.getFieldName();
                if (!prunedCols.contains(fName)) continue;
                prunedInputCols.add(fName);
            }
            return prunedInputCols;
        }
    }

    public static class ColumnPrunerGroupByProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            GroupByOperator op = (GroupByOperator)nd;
            ColumnPrunerProcCtx cppCtx = (ColumnPrunerProcCtx)ctx;
            List<String> colLists = new ArrayList<String>();
            GroupByDesc conf = (GroupByDesc)op.getConf();
            ArrayList<ExprNodeDesc> keys = conf.getKeys();
            for (ExprNodeDesc key : keys) {
                colLists = Utilities.mergeUniqElems(colLists, key.getCols());
            }
            ArrayList<AggregationDesc> aggrs = conf.getAggregators();
            for (AggregationDesc aggr : aggrs) {
                ArrayList<ExprNodeDesc> params = aggr.getParameters();
                for (ExprNodeDesc param : params) {
                    colLists = Utilities.mergeUniqElems(colLists, param.getCols());
                }
            }
            cppCtx.getPrunedColLists().put(op, colLists);
            return null;
        }
    }

    public static class ColumnPrunerFilterProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            FilterOperator op = (FilterOperator)nd;
            ColumnPrunerProcCtx cppCtx = (ColumnPrunerProcCtx)ctx;
            ExprNodeDesc condn = ((FilterDesc)op.getConf()).getPredicate();
            List<String> cl = condn.getCols();
            List<String> filterOpPrunedColLists = Utilities.mergeUniqElems(cppCtx.genColLists(op), cl);
            List filterOpPrunedColListsOrderPreserved = ColumnPrunerProcFactory.preserveColumnOrder(op, filterOpPrunedColLists);
            cppCtx.getPrunedColLists().put(op, filterOpPrunedColListsOrderPreserved);
            ColumnPrunerProcFactory.pruneOperator(cppCtx, op, cppCtx.getPrunedColLists().get(op));
            return null;
        }
    }
}

