/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.BucketJoinProcCtx;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.QB;
import org.apache.hadoop.hive.ql.parse.QBJoinTree;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.TableAccessAnalyzer;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.util.StringUtils;

public abstract class AbstractBucketJoinProc
implements NodeProcessor {
    private static final Log LOG = LogFactory.getLog((String)AbstractBucketJoinProc.class.getName());
    protected ParseContext pGraphContext;

    public AbstractBucketJoinProc(ParseContext pGraphContext) {
        this.pGraphContext = pGraphContext;
    }

    public AbstractBucketJoinProc() {
    }

    @Override
    public abstract Object process(Node var1, Stack<Node> var2, NodeProcessorCtx var3, Object ... var4) throws SemanticException;

    private static List<String> getBucketFilePathsOfPartition(URI location, ParseContext pGraphContext) throws SemanticException {
        ArrayList<String> fileNames = new ArrayList<String>();
        try {
            FileSystem fs = FileSystem.get((URI)location, (Configuration)pGraphContext.getConf());
            FileStatus[] files = fs.listStatus(new Path(location.toString()));
            if (files != null) {
                for (FileStatus file : files) {
                    fileNames.add(file.getPath().toString());
                }
            }
        }
        catch (IOException e) {
            throw new SemanticException(e);
        }
        return fileNames;
    }

    private boolean checkBucketColumns(List<String> bucketColumns, List<String> joinKeys, Integer[] joinKeyOrders) {
        if (joinKeys == null || bucketColumns == null || bucketColumns.isEmpty()) {
            return false;
        }
        for (int i = 0; i < joinKeys.size(); ++i) {
            int index = bucketColumns.indexOf(joinKeys.get(i));
            if (joinKeyOrders[i] != null && joinKeyOrders[i] != index) {
                return false;
            }
            joinKeyOrders[i] = index;
        }
        return joinKeys.containsAll(bucketColumns);
    }

    private boolean checkNumberOfBucketsAgainstBigTable(Map<String, List<Integer>> tblAliasToNumberOfBucketsInEachPartition, int numberOfBucketsInPartitionOfBigTable) {
        for (List<Integer> bucketNums : tblAliasToNumberOfBucketsInEachPartition.values()) {
            for (int nxt : bucketNums) {
                boolean ok = nxt >= numberOfBucketsInPartitionOfBigTable ? nxt % numberOfBucketsInPartitionOfBigTable == 0 : numberOfBucketsInPartitionOfBigTable % nxt == 0;
                if (ok) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean canConvertMapJoinToBucketMapJoin(MapJoinOperator mapJoinOp, ParseContext pGraphContext, BucketJoinProcCtx context) throws SemanticException {
        String subQueryAlias;
        QBJoinTree joinCtx = this.pGraphContext.getMapJoinContext().get(mapJoinOp);
        if (joinCtx == null) {
            return false;
        }
        ArrayList<String> joinAliases = new ArrayList<String>();
        String[] srcs = joinCtx.getBaseSrc();
        String[] left = joinCtx.getLeftAliases();
        List<String> mapAlias = joinCtx.getMapAliases();
        String baseBigAlias = null;
        for (String s : left) {
            if (s == null || joinAliases.contains(subQueryAlias = QB.getAppendedAliasFromId(joinCtx.getId(), s))) continue;
            joinAliases.add(subQueryAlias);
            if (mapAlias.contains(s)) continue;
            baseBigAlias = subQueryAlias;
        }
        for (String s : srcs) {
            if (s == null || joinAliases.contains(subQueryAlias = QB.getAppendedAliasFromId(joinCtx.getId(), s))) continue;
            joinAliases.add(subQueryAlias);
            if (mapAlias.contains(s)) continue;
            baseBigAlias = subQueryAlias;
        }
        Map<Byte, List<ExprNodeDesc>> keysMap = ((MapJoinDesc)mapJoinOp.getConf()).getKeys();
        return this.checkConvertBucketMapJoin(pGraphContext, context, joinCtx, keysMap, baseBigAlias, joinAliases);
    }

    protected boolean checkConvertBucketMapJoin(ParseContext pGraphContext, BucketJoinProcCtx context, QBJoinTree joinCtx, Map<Byte, List<ExprNodeDesc>> keysMap, String baseBigAlias, List<String> joinAliases) throws SemanticException {
        LinkedHashMap<String, List<Integer>> tblAliasToNumberOfBucketsInEachPartition = new LinkedHashMap<String, List<Integer>>();
        LinkedHashMap<String, List<List<String>>> tblAliasToBucketedFilePathsInEachPartition = new LinkedHashMap<String, List<List<String>>>();
        HashMap<String, Operator<? extends OperatorDesc>> topOps = pGraphContext.getTopOps();
        HashMap<TableScanOperator, Table> topToTable = pGraphContext.getTopToTable();
        LinkedHashMap<Partition, List<String>> bigTblPartsToBucketFileNames = new LinkedHashMap<Partition, List<String>>();
        LinkedHashMap<Partition, Integer> bigTblPartsToBucketNumber = new LinkedHashMap<Partition, Integer>();
        Integer[] joinKeyOrder = null;
        boolean bigTablePartitioned = true;
        for (int index = 0; index < joinAliases.size(); ++index) {
            Table tbl;
            String alias = joinAliases.get(index);
            Operator<? extends OperatorDesc> topOp = joinCtx.getAliasToOpInfo().get(alias);
            if (topOp == null) {
                return false;
            }
            List<String> keys = this.toColumns(keysMap.get((byte)index));
            if (keys == null || keys.isEmpty()) {
                return false;
            }
            int oldKeySize = keys.size();
            TableScanOperator tso = TableAccessAnalyzer.genRootTableScan(topOp, keys);
            if (tso == null) {
                return false;
            }
            if (topOps.containsValue(tso)) {
                for (Map.Entry<String, Operator<? extends OperatorDesc>> topOpEntry : topOps.entrySet()) {
                    if (topOpEntry.getValue() != tso) continue;
                    String newAlias = topOpEntry.getKey();
                    joinAliases.set(index, newAlias);
                    if (baseBigAlias.equals(alias)) {
                        baseBigAlias = newAlias;
                    }
                    alias = newAlias;
                    break;
                }
            } else {
                return false;
            }
            if (keys.size() != oldKeySize) {
                return false;
            }
            if (joinKeyOrder == null) {
                joinKeyOrder = new Integer[keys.size()];
            }
            if ((tbl = (Table)topToTable.get(tso)).isPartitioned()) {
                PrunedPartitionList prunedParts;
                try {
                    prunedParts = pGraphContext.getOpToPartList().get(tso);
                    if (prunedParts == null) {
                        prunedParts = PartitionPruner.prune(tbl, pGraphContext.getOpToPartPruner().get(tso), pGraphContext.getConf(), alias, pGraphContext.getPrunedPartitions());
                        pGraphContext.getOpToPartList().put(tso, prunedParts);
                    }
                }
                catch (HiveException e) {
                    LOG.error((Object)StringUtils.stringifyException((Throwable)e));
                    throw new SemanticException(e.getMessage(), e);
                }
                List<Partition> partitions = prunedParts.getNotDeniedPartns();
                if (partitions.isEmpty()) {
                    if (alias.equals(baseBigAlias)) continue;
                    tblAliasToNumberOfBucketsInEachPartition.put(alias, Arrays.asList(new Integer[0]));
                    tblAliasToBucketedFilePathsInEachPartition.put(alias, new ArrayList());
                    continue;
                }
                ArrayList<Integer> buckets = new ArrayList<Integer>();
                ArrayList<List<String>> files = new ArrayList<List<String>>();
                for (Partition p : partitions) {
                    if (!this.checkBucketColumns(p.getBucketCols(), keys, joinKeyOrder)) {
                        return false;
                    }
                    List<String> fileNames = AbstractBucketJoinProc.getBucketFilePathsOfPartition(p.getDataLocation(), pGraphContext);
                    int bucketCount = p.getBucketCount();
                    if (fileNames.size() != 0 && fileNames.size() != bucketCount) {
                        String msg = "The number of buckets for table " + tbl.getTableName() + " partition " + p.getName() + " is " + p.getBucketCount() + ", whereas the number of files is " + fileNames.size();
                        throw new SemanticException(ErrorMsg.BUCKETED_TABLE_METADATA_INCORRECT.getMsg(msg));
                    }
                    if (alias.equals(baseBigAlias)) {
                        bigTblPartsToBucketFileNames.put(p, fileNames);
                        bigTblPartsToBucketNumber.put(p, bucketCount);
                        continue;
                    }
                    files.add(fileNames);
                    buckets.add(bucketCount);
                }
                if (alias.equals(baseBigAlias)) continue;
                tblAliasToNumberOfBucketsInEachPartition.put(alias, buckets);
                tblAliasToBucketedFilePathsInEachPartition.put(alias, files);
                continue;
            }
            if (!this.checkBucketColumns(tbl.getBucketCols(), keys, joinKeyOrder)) {
                return false;
            }
            List<String> fileNames = AbstractBucketJoinProc.getBucketFilePathsOfPartition(tbl.getDataLocation(), pGraphContext);
            Integer num = new Integer(tbl.getNumBuckets());
            if (fileNames.size() != 0 && fileNames.size() != num.intValue()) {
                String msg = "The number of buckets for table " + tbl.getTableName() + " is " + tbl.getNumBuckets() + ", whereas the number of files is " + fileNames.size();
                throw new SemanticException(ErrorMsg.BUCKETED_TABLE_METADATA_INCORRECT.getMsg(msg));
            }
            if (alias.equals(baseBigAlias)) {
                bigTblPartsToBucketFileNames.put(null, fileNames);
                bigTblPartsToBucketNumber.put(null, tbl.getNumBuckets());
                bigTablePartitioned = false;
                continue;
            }
            tblAliasToNumberOfBucketsInEachPartition.put(alias, Arrays.asList(num));
            tblAliasToBucketedFilePathsInEachPartition.put(alias, Arrays.asList(fileNames));
        }
        for (Integer numBucketsInPartitionOfBigTable : bigTblPartsToBucketNumber.values()) {
            if (this.checkNumberOfBucketsAgainstBigTable(tblAliasToNumberOfBucketsInEachPartition, numBucketsInPartitionOfBigTable)) continue;
            return false;
        }
        context.setTblAliasToNumberOfBucketsInEachPartition(tblAliasToNumberOfBucketsInEachPartition);
        context.setTblAliasToBucketedFilePathsInEachPartition(tblAliasToBucketedFilePathsInEachPartition);
        context.setBigTblPartsToBucketFileNames(bigTblPartsToBucketFileNames);
        context.setBigTblPartsToBucketNumber(bigTblPartsToBucketNumber);
        context.setJoinAliases(joinAliases);
        context.setBaseBigAlias(baseBigAlias);
        context.setBigTablePartitioned(bigTablePartitioned);
        return true;
    }

    protected void convertMapJoinToBucketMapJoin(MapJoinOperator mapJoinOp, BucketJoinProcCtx context) throws SemanticException {
        MapJoinDesc desc = (MapJoinDesc)mapJoinOp.getConf();
        LinkedHashMap<String, Map<String, List<String>>> aliasBucketFileNameMapping = new LinkedHashMap<String, Map<String, List<String>>>();
        Map<String, List<Integer>> tblAliasToNumberOfBucketsInEachPartition = context.getTblAliasToNumberOfBucketsInEachPartition();
        Map<String, List<List<String>>> tblAliasToBucketedFilePathsInEachPartition = context.getTblAliasToBucketedFilePathsInEachPartition();
        Map<Partition, List<String>> bigTblPartsToBucketFileNames = context.getBigTblPartsToBucketFileNames();
        Map<Partition, Integer> bigTblPartsToBucketNumber = context.getBigTblPartsToBucketNumber();
        List<String> joinAliases = context.getJoinAliases();
        String baseBigAlias = context.getBaseBigAlias();
        for (List<String> partBucketNames : bigTblPartsToBucketFileNames.values()) {
            Collections.sort(partBucketNames);
        }
        for (int j = 0; j < joinAliases.size(); ++j) {
            String alias = joinAliases.get(j);
            if (alias.equals(baseBigAlias)) continue;
            for (List<String> names : tblAliasToBucketedFilePathsInEachPartition.get(alias)) {
                Collections.sort(names);
            }
            List<Integer> smallTblBucketNums = tblAliasToNumberOfBucketsInEachPartition.get(alias);
            List<List<String>> smallTblFilesList = tblAliasToBucketedFilePathsInEachPartition.get(alias);
            LinkedHashMap<String, List<String>> mappingBigTableBucketFileNameToSmallTableBucketFileNames = new LinkedHashMap<String, List<String>>();
            aliasBucketFileNameMapping.put(alias, mappingBigTableBucketFileNameToSmallTableBucketFileNames);
            Iterator<Map.Entry<Partition, List<String>>> bigTblPartToBucketNames = bigTblPartsToBucketFileNames.entrySet().iterator();
            Iterator<Map.Entry<Partition, Integer>> bigTblPartToBucketNum = bigTblPartsToBucketNumber.entrySet().iterator();
            while (bigTblPartToBucketNames.hasNext()) {
                assert (bigTblPartToBucketNum.hasNext());
                int bigTblBucketNum = bigTblPartToBucketNum.next().getValue();
                List<String> bigTblBucketNameList = bigTblPartToBucketNames.next().getValue();
                AbstractBucketJoinProc.fillMappingBigTableBucketFileNameToSmallTableBucketFileNames(smallTblBucketNums, smallTblFilesList, mappingBigTableBucketFileNameToSmallTableBucketFileNames, bigTblBucketNum, bigTblBucketNameList, desc.getBigTableBucketNumMapping());
            }
        }
        desc.setAliasBucketFileNameMapping(aliasBucketFileNameMapping);
        desc.setBigTableAlias(baseBigAlias);
        boolean bigTablePartitioned = context.isBigTablePartitioned();
        if (bigTablePartitioned) {
            desc.setBigTablePartSpecToFileMapping(AbstractBucketJoinProc.convert(bigTblPartsToBucketFileNames));
        }
        desc.setBucketMapJoin(true);
    }

    private static Map<String, List<String>> convert(Map<Partition, List<String>> mapping) {
        HashMap<String, List<String>> converted = new HashMap<String, List<String>>();
        for (Map.Entry<Partition, List<String>> entry : mapping.entrySet()) {
            converted.put(entry.getKey().getName(), entry.getValue());
        }
        return converted;
    }

    public List<String> toColumns(List<ExprNodeDesc> keys) {
        ArrayList<String> columns = new ArrayList<String>();
        for (ExprNodeDesc key : keys) {
            if (!(key instanceof ExprNodeColumnDesc)) {
                return null;
            }
            columns.add(((ExprNodeColumnDesc)key).getColumn());
        }
        return columns;
    }

    private static void fillMappingBigTableBucketFileNameToSmallTableBucketFileNames(List<Integer> smallTblBucketNums, List<List<String>> smallTblFilesList, Map<String, List<String>> bigTableBucketFileNameToSmallTableBucketFileNames, int bigTblBucketNum, List<String> bigTblBucketNameList, Map<String, Integer> bucketFileNameMapping) {
        for (int bindex = 0; bindex < bigTblBucketNameList.size(); ++bindex) {
            ArrayList<String> resultFileNames = new ArrayList<String>();
            for (int sindex = 0; sindex < smallTblBucketNums.size(); ++sindex) {
                int smallTblBucketNum = smallTblBucketNums.get(sindex);
                List<String> smallTblFileNames = smallTblFilesList.get(sindex);
                if (bigTblBucketNum >= smallTblBucketNum) {
                    int toAddSmallIndex = bindex % smallTblBucketNum;
                    resultFileNames.add(smallTblFileNames.get(toAddSmallIndex));
                    continue;
                }
                int jump = smallTblBucketNum / bigTblBucketNum;
                for (int i = bindex; i < smallTblFileNames.size(); i += jump) {
                    resultFileNames.add(smallTblFileNames.get(i));
                }
            }
            String inputBigTBLBucket = bigTblBucketNameList.get(bindex);
            bigTableBucketFileNameToSmallTableBucketFileNames.put(inputBigTBLBucket, resultFileNames);
            bucketFileNameMapping.put(inputBigTBLBucket, bindex);
        }
    }
}

