/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.rcfile.merge;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.hive.ql.io.RCFile;
import org.apache.hadoop.hive.ql.io.merge.MergeMapper;
import org.apache.hadoop.hive.ql.io.rcfile.merge.RCFileKeyBufferWrapper;
import org.apache.hadoop.hive.ql.io.rcfile.merge.RCFileValueBufferWrapper;
import org.apache.hadoop.hive.shims.CombineHiveKey;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;

public class RCFileMergeMapper
extends MergeMapper
implements Mapper<Object, RCFileValueBufferWrapper, Object, Object> {
    protected CompressionCodec codec = null;
    protected int columnNumber = 0;
    private RCFile.Writer outWriter;

    public void map(Object k, RCFileValueBufferWrapper value, OutputCollector<Object, Object> output, Reporter reporter) throws IOException {
        try {
            boolean sameCodec;
            RCFileKeyBufferWrapper key = null;
            key = k instanceof CombineHiveKey ? (RCFileKeyBufferWrapper)((CombineHiveKey)k).getKey() : (RCFileKeyBufferWrapper)k;
            this.checkAndFixTmpPath(key.inputPath);
            if (this.outWriter == null) {
                this.codec = key.codec;
                this.columnNumber = key.keyBuffer.getColumnNumber();
                this.jc.setInt("hive.io.rcfile.column.number.conf", this.columnNumber);
                this.outWriter = new RCFile.Writer(this.fs, (Configuration)this.jc, this.outPath, null, this.codec);
            }
            boolean bl = sameCodec = this.codec == key.codec || this.codec.getClass().equals(key.codec.getClass());
            if (key.keyBuffer.getColumnNumber() != this.columnNumber || !sameCodec) {
                throw new IOException("RCFileMerge failed because the input files use different CompressionCodec or have different column number setting.");
            }
            this.outWriter.flushBlock(key.keyBuffer, value.valueBuffer, key.recordLength, key.keyLength, key.compressedKeyLength);
        }
        catch (Throwable e) {
            this.exception = true;
            this.close();
            throw new IOException(e);
        }
    }

    public void close() throws IOException {
        if (this.outWriter == null) {
            return;
        }
        this.outWriter.close();
        this.outWriter = null;
        if (!this.exception) {
            FileStatus fss = this.fs.getFileStatus(this.outPath);
            LOG.info((Object)("renamed path " + this.outPath + " to " + this.finalPath + " . File size is " + fss.getLen()));
            if (!this.fs.rename(this.outPath, this.finalPath)) {
                throw new IOException("Unable to rename output to " + this.finalPath);
            }
        } else if (!this.autoDelete) {
            this.fs.delete(this.outPath, true);
        }
    }
}

