/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.merge.MergeMapper;
import org.apache.hadoop.hive.ql.io.orc.ColumnStatisticsImpl;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.WriterImpl;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.shims.CombineHiveKey;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;

public class OrcMergeMapper
extends MergeMapper
implements Mapper<Object, OrcFile.ValueWrapper, Object, Object> {
    private ObjectInspector objectInspector;
    private CompressionKind compression;
    private int compressionSize;
    private int rowIndexStride;
    private ColumnStatisticsImpl[] columnStats;
    private Map<String, ByteBuffer> userMetadata;
    private WriterImpl outWriter;

    public void map(Object k, OrcFile.ValueWrapper value, OutputCollector<Object, Object> output, Reporter reporter) throws IOException {
        try {
            OrcFile.KeyWrapper key = null;
            key = k instanceof CombineHiveKey ? (OrcFile.KeyWrapper)((CombineHiveKey)k).getKey() : (OrcFile.KeyWrapper)k;
            this.checkAndFixTmpPath(key.inputPath);
            if (this.outWriter == null) {
                this.objectInspector = key.objectInspector;
                this.compression = key.compression;
                this.compressionSize = key.compressionSize;
                this.rowIndexStride = key.rowIndexStride;
                this.userMetadata = key.userMetadata;
                this.outWriter = (WriterImpl)OrcFile.createWriter(this.fs, this.outPath, new HiveConf(OrcMergeMapper.class), this.objectInspector, Long.valueOf("268435456"), this.compression, this.compressionSize, this.rowIndexStride);
                for (Map.Entry<String, ByteBuffer> metadataEntry : this.userMetadata.entrySet()) {
                    this.outWriter.addUserMetadata(metadataEntry.getKey(), metadataEntry.getValue());
                }
            }
            if (this.columnStats == null) {
                this.columnStats = new ColumnStatisticsImpl[key.columnStats.length];
                for (int i = 0; i < this.columnStats.length; ++i) {
                    this.columnStats[i] = (ColumnStatisticsImpl)key.columnStats[i];
                }
            } else {
                if (this.columnStats.length != key.columnStats.length) {
                    throw new IOException("OrcMerge failed because the input files have a different number of columns");
                }
                for (int i = 0; i < this.columnStats.length; ++i) {
                    this.columnStats[i].merge((ColumnStatisticsImpl)key.columnStats[i]);
                }
            }
            if (this.objectInspector != key.objectInspector && !this.objectInspector.equals(this.objectInspector)) {
                throw new IOException("OrcMerge failed because the input files use different ObjectInspectors.");
            }
            if (this.compression != key.compression || this.compressionSize != key.compressionSize) {
                throw new IOException("OrcMerge failed because the input files have different compression settings.");
            }
            if (this.rowIndexStride != key.rowIndexStride) {
                throw new IOException("OrcMerge failed because the input files have different row index strides.");
            }
            if (!this.userMetadata.equals(key.userMetadata)) {
                throw new IOException("OrcMerge failed because the input files have different user metadata.");
            }
            this.outWriter.addStripe(key.key, value.value);
        }
        catch (Throwable e) {
            this.exception = true;
            this.close();
            throw new IOException(e);
        }
    }

    public void close() throws IOException {
        if (this.outWriter == null) {
            return;
        }
        this.outWriter.close(this.columnStats);
        this.outWriter = null;
        if (!this.exception) {
            FileStatus fss = this.fs.getFileStatus(this.outPath);
            LOG.info((Object)("renamed path " + this.outPath + " to " + this.finalPath + " . File size is " + fss.getLen()));
            if (!this.fs.rename(this.outPath, this.finalPath)) {
                throw new IOException("Unable to rename output to " + this.finalPath);
            }
        } else if (!this.autoDelete) {
            this.fs.delete(this.outPath, true);
        }
    }
}

