/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.ColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.MemoryManager;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.ReaderImpl;
import org.apache.hadoop.hive.ql.io.orc.StripeInformation;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.ql.io.orc.WriterImpl;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.WritableComparable;

public final class OrcFile {
    public static final String MAGIC = "ORC";
    public static final int MAJOR_VERSION = 0;
    public static final int MINOR_VERSION = 11;
    public static final String COMPRESSION = "orc.compress";
    static final String DEFAULT_COMPRESSION = "ZLIB";
    public static final String COMPRESSION_BLOCK_SIZE = "orc.compress.size";
    static final String DEFAULT_COMPRESSION_BLOCK_SIZE = "262144";
    public static final String STRIPE_SIZE = "orc.stripe.size";
    static final String DEFAULT_STRIPE_SIZE = "268435456";
    public static final String ROW_INDEX_STRIDE = "orc.row.index.stride";
    static final String DEFAULT_ROW_INDEX_STRIDE = "10000";
    public static final String ENABLE_INDEXES = "orc.create.index";
    private static MemoryManager memoryManager = null;

    private OrcFile() {
    }

    public static Reader createReader(FileSystem fs, Path path) throws IOException {
        return new ReaderImpl(fs, path);
    }

    public static Writer createWriter(FileSystem fs, Path path, Configuration conf, ObjectInspector inspector, long stripeSize, CompressionKind compress, int bufferSize, int rowIndexStride) throws IOException {
        return new WriterImpl(fs, path, inspector, stripeSize, compress, bufferSize, rowIndexStride, OrcFile.getMemoryManager(conf));
    }

    private static synchronized MemoryManager getMemoryManager(Configuration conf) {
        if (memoryManager == null) {
            memoryManager = new MemoryManager(conf);
        }
        return memoryManager;
    }

    public static class ValueWrapper
    implements WritableComparable<ValueWrapper> {
        public byte[] value;

        public void readFields(DataInput in) throws IOException {
            throw new RuntimeException("Not supported.");
        }

        public void write(DataOutput out) throws IOException {
            throw new RuntimeException("Not supported.");
        }

        public int compareTo(ValueWrapper o) {
            throw new RuntimeException("Not supported.");
        }
    }

    public static class KeyWrapper
    implements WritableComparable<KeyWrapper> {
        public StripeInformation key;
        public Path inputPath;
        public ObjectInspector objectInspector;
        public CompressionKind compression;
        public int compressionSize;
        public int rowIndexStride;
        public ColumnStatistics[] columnStats;
        public Map<String, ByteBuffer> userMetadata;

        public void readFields(DataInput in) throws IOException {
            throw new RuntimeException("Not supported.");
        }

        public void write(DataOutput out) throws IOException {
            throw new RuntimeException("Not supported.");
        }

        public int compareTo(KeyWrapper o) {
            throw new RuntimeException("Not supported.");
        }
    }
}

