/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.ReaderImpl;
import org.apache.hadoop.hive.ql.io.orc.StripeReader;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.RecordReader;

public class OrcBlockMergeRecordReader
implements RecordReader<OrcFile.KeyWrapper, OrcFile.ValueWrapper> {
    private final Reader in;
    private final StripeReader stripeIn;
    private boolean more = true;
    private final Path path;
    protected Configuration conf;

    public OrcBlockMergeRecordReader(Configuration conf, FileSplit split) throws IOException {
        this.path = split.getPath();
        FileSystem fs = this.path.getFileSystem(conf);
        this.in = new ReaderImpl(fs, this.path);
        this.stripeIn = this.in.stripes(split.getStart(), split.getLength());
        this.conf = conf;
        this.more = this.stripeIn.hasNext();
    }

    public Class<?> getKeyClass() {
        return OrcFile.KeyWrapper.class;
    }

    public Class<?> getValueClass() {
        return OrcFile.ValueWrapper.class;
    }

    public OrcFile.KeyWrapper createKey() {
        return new OrcFile.KeyWrapper();
    }

    public OrcFile.ValueWrapper createValue() {
        return new OrcFile.ValueWrapper();
    }

    public boolean next(OrcFile.KeyWrapper keyWrapper, OrcFile.ValueWrapper valueWrapper) throws IOException {
        if (this.more) {
            this.more = this.stripeIn.nextStripe(keyWrapper, valueWrapper);
            keyWrapper.inputPath = this.path;
            keyWrapper.objectInspector = this.in.getObjectInspector();
            keyWrapper.compression = this.in.getCompression();
            keyWrapper.compressionSize = this.in.getCompressionSize();
            keyWrapper.rowIndexStride = this.in.getRowIndexStride();
            keyWrapper.columnStats = this.in.getStatistics();
            keyWrapper.userMetadata = new HashMap<String, ByteBuffer>();
            for (String key : this.in.getMetadataKeys()) {
                keyWrapper.userMetadata.put(key, this.in.getMetadataValue(key));
            }
            return true;
        }
        return false;
    }

    public float getProgress() throws IOException {
        return this.stripeIn.getProgress();
    }

    public long getPos() throws IOException {
        return this.stripeIn.getPosition();
    }

    public void close() throws IOException {
        this.stripeIn.close();
    }
}

