/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.merge;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.merge.BlockMergeOutputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Reporter;

public abstract class MergeMapper
extends MapReduceBase {
    protected JobConf jc;
    protected Class<? extends Writable> outputClass;
    protected Path finalPath;
    protected FileSystem fs;
    protected boolean exception = false;
    protected boolean autoDelete = false;
    protected Path outPath;
    protected boolean hasDynamicPartitions = false;
    protected boolean isListBucketingDML = false;
    protected boolean isListBucketingAlterTableConcatenate = false;
    protected int listBucketingDepth;
    protected boolean tmpPathFixedConcatenate = false;
    protected boolean tmpPathFixed = false;
    protected Path tmpPath;
    protected Path taskTmpPath;
    protected Path dpPath;
    public static final Log LOG = LogFactory.getLog((String)"MergeMapper");
    public static String BACKUP_PREFIX = "_backup.";

    public void configure(JobConf job) {
        this.jc = job;
        this.hasDynamicPartitions = HiveConf.getBoolVar((Configuration)job, HiveConf.ConfVars.HIVEMERGECURRENTJOBHASDYNAMICPARTITIONS);
        this.isListBucketingAlterTableConcatenate = HiveConf.getBoolVar((Configuration)job, HiveConf.ConfVars.HIVEMERGECURRENTJOBCONCATENATELISTBUCKETING);
        this.listBucketingDepth = HiveConf.getIntVar((Configuration)job, HiveConf.ConfVars.HIVEMERGECURRENTJOBCONCATENATELISTBUCKETINGDEPTH);
        String specPath = BlockMergeOutputFormat.getMergeOutputPath(job).toString();
        Path tmpPath = Utilities.toTempPath(specPath);
        Path taskTmpPath = Utilities.toTaskTempPath(specPath);
        this.updatePaths(tmpPath, taskTmpPath);
        try {
            this.fs = new Path(specPath).getFileSystem((Configuration)job);
            this.autoDelete = ShimLoader.getHadoopShims().fileSystemDeleteOnExit(this.fs, this.outPath);
        }
        catch (IOException e) {
            this.exception = true;
            throw new RuntimeException(e);
        }
    }

    protected void updatePaths(Path tmpPath, Path taskTmpPath) {
        String taskId = Utilities.getTaskId((Configuration)this.jc);
        this.tmpPath = tmpPath;
        this.taskTmpPath = taskTmpPath;
        this.finalPath = new Path(tmpPath, taskId);
        this.outPath = new Path(taskTmpPath, Utilities.toTempPath(taskId));
    }

    protected void checkPartitionsMatch(Path inputPath) throws HiveException {
        if (!this.dpPath.equals((Object)inputPath)) {
            String msg = "Multiple partitions for one block merge mapper: " + this.dpPath + " NOT EQUAL TO " + inputPath;
            LOG.error((Object)msg);
            throw new HiveException(msg);
        }
    }

    protected void fixTmpPath(Path inputPath) throws HiveException, IOException {
        this.dpPath = inputPath;
        Path newPath = new Path(".");
        int inputDepth = inputPath.depth();
        int tmpDepth = this.tmpPath.depth();
        while (inputPath != null && inputPath.depth() > tmpDepth) {
            newPath = new Path(inputPath.getName(), newPath);
            --inputDepth;
            inputPath = inputPath.getParent();
        }
        Path newTmpPath = new Path(this.tmpPath, newPath);
        Path newTaskTmpPath = new Path(this.taskTmpPath, newPath);
        if (!this.fs.exists(newTmpPath)) {
            this.fs.mkdirs(newTmpPath);
        }
        this.updatePaths(newTmpPath, newTaskTmpPath);
    }

    protected void fixTmpPathConcatenate(Path inputPath) throws HiveException, IOException {
        this.dpPath = inputPath;
        Path newPath = new Path(".");
        for (int depth = this.listBucketingDepth; inputPath != null && depth > 0; inputPath = inputPath.getParent(), --depth) {
            newPath = new Path(inputPath.getName(), newPath);
        }
        Path newTmpPath = new Path(this.tmpPath, newPath);
        Path newTaskTmpPath = new Path(this.taskTmpPath, newPath);
        if (!this.fs.exists(newTmpPath)) {
            this.fs.mkdirs(newTmpPath);
        }
        this.updatePaths(newTmpPath, newTaskTmpPath);
    }

    protected void checkAndFixTmpPath(Path inputPath) throws HiveException, IOException {
        if (this.isListBucketingAlterTableConcatenate) {
            if (this.tmpPathFixedConcatenate) {
                this.checkPartitionsMatch(inputPath.getParent());
            } else {
                this.fixTmpPathConcatenate(inputPath.getParent());
                this.tmpPathFixedConcatenate = true;
            }
        } else if (this.hasDynamicPartitions || this.listBucketingDepth > 0) {
            if (this.tmpPathFixed) {
                this.checkPartitionsMatch(inputPath.getParent());
            } else {
                this.fixTmpPath(inputPath.getParent());
                this.tmpPathFixed = true;
            }
        }
    }

    public static Path backupOutputPath(FileSystem fs, Path outpath, JobConf job) throws IOException, HiveException {
        if (fs.exists(outpath)) {
            Path backupPath = new Path(outpath.getParent(), BACKUP_PREFIX + outpath.getName());
            Utilities.rename(fs, outpath, backupPath);
            return backupPath;
        }
        return null;
    }

    public static void jobClose(String outputPath, boolean success, JobConf job, SessionState.LogHelper console, DynamicPartitionCtx dynPartCtx, Reporter reporter) throws HiveException, IOException {
        Path outpath = new Path(outputPath);
        FileSystem fs = outpath.getFileSystem((Configuration)job);
        Path backupPath = MergeMapper.backupOutputPath(fs, outpath, job);
        Utilities.mvFileToFinalPath(outputPath, (Configuration)job, success, LOG, dynPartCtx, null, reporter);
        fs.delete(backupPath, true);
    }
}

