/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.HashTableSinkOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.persistence.AbstractMapJoinKey;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.io.Writable;

public class MapJoinObjectKey
extends AbstractMapJoinKey {
    protected transient Object[] obj;

    public MapJoinObjectKey() {
    }

    public MapJoinObjectKey(Object[] obj) {
        this.obj = obj;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof MapJoinObjectKey) {
            MapJoinObjectKey mObj = (MapJoinObjectKey)o;
            Object[] mObjArray = mObj.getObj();
            if (this.obj == null && mObjArray == null) {
                return true;
            }
            if (this.obj != null && mObjArray != null && this.obj.length == mObjArray.length) {
                for (int i = 0; i < this.obj.length; ++i) {
                    if (this.obj[i] == null) {
                        return mObjArray[i] == null;
                    }
                    if (this.obj[i].equals(mObjArray[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hashCode;
        if (this.obj == null) {
            hashCode = metadataTag;
        } else {
            hashCode = 1;
            for (int i = 0; i < this.obj.length; ++i) {
                Object o = this.obj[i];
                hashCode = 31 * hashCode + (o == null ? 0 : o.hashCode());
            }
        }
        return hashCode;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            HashTableSinkOperator.HashTableSinkObjectCtx ctx = MapJoinOperator.getMetadata().get(metadataTag);
            Writable val = ctx.getSerDe().getSerializedClass().newInstance();
            val.readFields((DataInput)in);
            ArrayList list = (ArrayList)ObjectInspectorUtils.copyToStandardObject(ctx.getSerDe().deserialize(val), ctx.getSerDe().getObjectInspector(), ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            this.obj = list == null ? new ArrayList(0).toArray() : list.toArray();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        try {
            HashTableSinkOperator.HashTableSinkObjectCtx ctx = HashTableSinkOperator.getMetadata().get(metadataTag);
            Writable outVal = ctx.getSerDe().serialize(this.obj, ctx.getStandardOI());
            outVal.write((DataOutput)out);
        }
        catch (SerDeException e) {
            throw new IOException(e);
        }
    }

    public Object[] getObj() {
        return this.obj;
    }

    public void setObj(Object[] obj) {
        this.obj = obj;
    }

    @Override
    public boolean hasAnyNulls(boolean[] nullsafes) {
        if (this.obj != null && this.obj.length > 0) {
            for (int i = 0; i < this.obj.length; ++i) {
                if (this.obj[i] != null || nullsafes != null && nullsafes[i]) continue;
                return true;
            }
        }
        return false;
    }
}

