/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.Writable;

public class PTFPersistence {
    public static ThreadLocal<ByteArrayIS> bis = new ThreadLocal<ByteArrayIS>(){

        @Override
        protected ByteArrayIS initialValue() {
            return new ByteArrayIS();
        }
    };
    public static ThreadLocal<DataIStream> dis = new ThreadLocal<DataIStream>(){

        @Override
        protected DataIStream initialValue() {
            return new DataIStream(bis.get());
        }
    };
    public static ThreadLocal<ByteArrayOS> bos = new ThreadLocal<ByteArrayOS>(){

        @Override
        protected ByteArrayOS initialValue() {
            return new ByteArrayOS();
        }
    };
    public static ThreadLocal<DataOStream> dos = new ThreadLocal<DataOStream>(){

        @Override
        protected DataOStream initialValue() {
            return new DataOStream(bos.get());
        }
    };

    public static ByteBasedList createList(String clsName, int capacity) throws HiveException {
        try {
            Class<?> cls = Class.forName(clsName);
            Constructor<?> cons = cls.getConstructor(Integer.TYPE);
            return (ByteBasedList)cons.newInstance(capacity);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public static void lock(Lock lock) throws HiveException {
        try {
            lock.lockInterruptibly();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new HiveException("Operation interrupted", ie);
        }
    }

    public static class ByteArrayIS
    extends ByteArrayInputStream {
        public ByteArrayIS() {
            super(new byte[0]);
        }

        public final byte[] bytearray() {
            return this.buf;
        }

        public final void setBuffer(byte[] buf, int offset, int len) {
            this.buf = buf;
            this.pos = offset;
            this.count = Math.min(offset + len, buf.length);
            this.mark = offset;
        }
    }

    public static class ByteArrayOS
    extends ByteArrayOutputStream {
        public ByteArrayOS() {
        }

        public ByteArrayOS(int size) {
            super(size);
        }

        public final byte[] bytearray() {
            return this.buf;
        }

        public final int len() {
            return this.count;
        }
    }

    public static class DataOStream
    extends DataOutputStream {
        public DataOStream(ByteArrayOS out) {
            super(out);
        }

        public ByteArrayOS getUnderlyingStream() {
            return (ByteArrayOS)this.out;
        }
    }

    public static class DataIStream
    extends DataInputStream {
        public DataIStream(ByteArrayIS in) {
            super(in);
        }

        public ByteArrayIS getUnderlyingStream() {
            return (ByteArrayIS)this.in;
        }
    }

    public static class ByteBufferOutputStream
    extends OutputStream {
        ByteBuffer buffer;

        public void intialize(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        public void intialize(ByteBuffer buffer, int off, int len) {
            buffer = buffer.duplicate();
            buffer.position(off);
            buffer.limit(off + len);
            this.buffer = buffer.slice();
        }

        @Override
        public void write(int b) throws IOException {
            this.buffer.put((byte)b);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            int remaining = this.buffer.remaining();
            if (len > remaining) {
                throw new IndexOutOfBoundsException();
            }
            this.buffer.put(b, off, len);
        }
    }

    public static class ByteBufferInputStream
    extends InputStream {
        ByteBuffer buffer;
        int mark = -1;

        public void intialize(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        public void intialize(ByteBuffer buffer, int off, int len) {
            buffer = buffer.duplicate();
            buffer.position(off);
            buffer.limit(off + len);
            this.buffer = buffer.slice();
        }

        @Override
        public int read() throws IOException {
            return this.buffer.hasRemaining() ? this.buffer.get() & 0xFF : -1;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int remaining = this.buffer.remaining();
            len = len <= remaining ? len : remaining;
            this.buffer.get(b, off, len);
            return len;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public void mark(int readAheadLimit) {
            this.mark = this.buffer.position();
        }

        @Override
        public void reset() {
            if (this.mark == -1) {
                throw new IllegalStateException();
            }
            this.buffer.position(this.mark);
            this.mark = -1;
        }
    }

    static class PersistentByteBasedList
    extends ByteBasedList {
        File file;
        SoftReference<ByteBasedList> memList;

        private static int headerSize() {
            return 20;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected static void store(ByteBasedList l, File f) throws IOException {
            int hdrSize = PersistentByteBasedList.headerSize();
            ByteBuffer buf = ByteBuffer.allocate(hdrSize);
            buf.putInt(l.startOffset);
            buf.putInt(l.bytesUsed);
            buf.putInt(l.currentSize);
            buf.putLong(l.lastModified);
            buf.flip();
            ByteBuffer offsetB = ByteBuffer.allocate(8 * l.currentSize);
            IntBuffer iB = offsetB.asIntBuffer();
            iB.put(l.offsetsArray, 0, l.currentSize * 2);
            ByteBuffer bytesB = ByteBuffer.wrap(l.bytes, 0, l.bytesUsed);
            ByteBuffer[] bufs = new ByteBuffer[]{buf, offsetB, bytesB};
            try (FileOutputStream fos = new FileOutputStream(f);){
                FileChannel fc = fos.getChannel();
                while (fc.write(bufs, 0, bufs.length) > 0L) {
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected static void load(ByteBasedList l, File f) throws IOException {
            int hdr = PersistentByteBasedList.headerSize();
            try (FileInputStream fis = new FileInputStream(f);){
                FileChannel fc = fis.getChannel();
                ByteBuffer buf0 = ByteBuffer.allocate(hdr);
                while (buf0.hasRemaining()) {
                    fc.read(buf0);
                }
                buf0.flip();
                l.startOffset = buf0.getInt();
                l.bytesUsed = buf0.getInt();
                l.currentSize = buf0.getInt();
                l.lastModified = buf0.getLong();
                ByteBuffer offsetB = ByteBuffer.allocate(8 * l.currentSize);
                ByteBuffer bytesB = ByteBuffer.allocate(l.bytesUsed);
                ByteBuffer[] bufs = new ByteBuffer[]{offsetB, bytesB};
                while (fc.read(bufs) > 0L) {
                }
                l.offsetsArray = new int[l.currentSize * 2];
                offsetB.flip();
                IntBuffer iB = offsetB.asIntBuffer();
                iB.get(l.offsetsArray);
                l.bytes = bytesB.array();
            }
        }

        protected PersistentByteBasedList(File file, ByteBasedList l) {
            super(file);
            this.file = file;
            this.memList = new SoftReference<ByteBasedList>(l);
        }

        protected PersistentByteBasedList(File file) {
            this(file, null);
        }

        @Override
        protected void reset(int startOffset) throws HiveException {
            throw new HiveException("Reset on PersistentByteBasedList not supported");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ByteBasedList getList() throws HiveException {
            PTFPersistence.lock(this.lock.readLock());
            try {
                ByteBasedList list = this.memList.get();
                if (list == null) {
                    try {
                        list = new ByteBasedList(this.file);
                        PersistentByteBasedList.load(list, this.file);
                        this.memList = new SoftReference<ByteBasedList>(list);
                    }
                    catch (Exception ie) {
                        throw new RuntimeException(ie);
                    }
                }
                ByteBasedList byteBasedList = list;
                return byteBasedList;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        File getFile() {
            return this.file;
        }

        @Override
        public int size() throws HiveException {
            return this.getList().size();
        }

        @Override
        public void get(int i, Writable wObj) throws HiveException {
            this.getList().get(i, wObj);
        }

        @Override
        public void append(Writable obj) throws HiveException {
            throw new UnsupportedOperationException("Cannot append to a Persisted List");
        }

        @Override
        public Object get(int i, Deserializer deserializer, Writable wObj) throws HiveException {
            return this.getList().get(i, deserializer, wObj);
        }

        @Override
        public void append(Object obj, ObjectInspector OI, Serializer serializer) throws HiveException {
            throw new UnsupportedOperationException("Cannot append to a Persisted List");
        }

        @Override
        public Iterator<Writable> iterator(Writable wObj) throws HiveException {
            return this.getList().iterator(wObj);
        }

        @Override
        public Iterator<Object> iterator(Deserializer deserializer, Writable wObj) throws HiveException {
            return this.getList().iterator(deserializer, wObj);
        }

        @Override
        public void dump(StringBuilder bldr, Writable wObj) throws IOException, HiveException {
            this.getList().dump(bldr, wObj);
        }

        @Override
        public void dump(StringBuilder bldr, Deserializer deserializer, Writable wObj) throws IOException, HiveException {
            this.getList().dump(bldr, deserializer, wObj);
        }
    }

    public static class PartitionedByteBasedList
    extends ByteBasedList {
        ArrayList<ByteBasedList> partitions;
        ArrayList<Integer> partitionOffsets;
        ArrayList<File> reusableFiles;
        File dir;
        int batchSize;
        private static final int TEMP_DIR_ATTEMPTS = 10000;

        public PartitionedByteBasedList(int batchSize) throws HiveException {
            this.batchSize = batchSize;
            this.currentSize = 0;
            this.dir = PartitionedByteBasedList.createTempDir();
            Runtime.getRuntime().addShutdownHook(new ShutdownHook(this.dir));
            this.partitions = new ArrayList();
            this.partitionOffsets = new ArrayList();
            this.reusableFiles = new ArrayList();
            this.addPartition();
        }

        public PartitionedByteBasedList() throws HiveException {
            this(ByteBasedList.LARGE_SIZE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void reset(int startOffset) throws HiveException {
            PTFPersistence.lock(this.lock.writeLock());
            try {
                this.currentSize = 0;
                for (int i = 0; i < this.partitions.size() - 1; ++i) {
                    PersistentByteBasedList p = (PersistentByteBasedList)this.partitions.remove(0);
                    this.reusableFiles.add(p.getFile());
                    this.partitionOffsets.remove(0);
                }
                this.partitions.get(0).reset(0);
                this.partitionOffsets.set(0, this.currentSize);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        private void addPartition() throws HiveException {
            try {
                if (this.partitions.size() > 0) {
                    int idx = this.partitions.size() - 1;
                    ByteBasedList bl = this.partitions.get(idx);
                    File f = this.reusableFiles.size() > 0 ? this.reusableFiles.remove(0) : File.createTempFile("wdw", null, this.dir);
                    PersistentByteBasedList.store(bl, f);
                    this.partitions.set(idx, new PersistentByteBasedList(f, bl));
                }
                ByteBasedList bl = new ByteBasedList(this.currentSize, this.batchSize);
                this.partitions.add(bl);
                this.partitionOffsets.add(this.currentSize);
            }
            catch (IOException ie) {
                throw new HiveException(ie);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ByteBasedList getPartition(int i) throws HiveException {
            PTFPersistence.lock(this.lock.readLock());
            try {
                int numSplits = this.partitions.size();
                if (numSplits == 0) {
                    ByteBasedList byteBasedList = this.partitions.get(0);
                    return byteBasedList;
                }
                int start = 0;
                int end = numSplits - 1;
                while (start < end) {
                    int mid = start + end + 1 >>> 1;
                    int val = this.partitionOffsets.get(mid);
                    if (val == i) {
                        ByteBasedList byteBasedList = this.partitions.get(mid);
                        return byteBasedList;
                    }
                    if (val < i) {
                        if (end == mid) {
                            ByteBasedList byteBasedList = this.partitions.get(end);
                            return byteBasedList;
                        }
                        start = mid;
                        continue;
                    }
                    end = mid - 1;
                }
                ByteBasedList byteBasedList = this.partitions.get(start);
                return byteBasedList;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        @Override
        public void get(int i, Writable wObj) throws HiveException {
            ByteBasedList bl = this.getPartition(i);
            bl.get(i, wObj);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void append(Writable obj) throws HiveException {
            PTFPersistence.lock(this.lock.writeLock());
            try {
                this.partitions.get(this.partitions.size() - 1).append(obj);
                ++this.currentSize;
                this.lastModified = System.nanoTime();
            }
            catch (ByteBasedList.ListFullException le) {
                this.addPartition();
                this.append(obj);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        @Override
        public Object get(int i, Deserializer deserializer, Writable wObj) throws HiveException {
            ByteBasedList bl = this.getPartition(i);
            return bl.get(i, deserializer, wObj);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void append(Object obj, ObjectInspector OI, Serializer serializer) throws HiveException {
            PTFPersistence.lock(this.lock.writeLock());
            try {
                this.partitions.get(this.partitions.size() - 1).append(obj, OI, serializer);
                ++this.currentSize;
                this.lastModified = System.nanoTime();
            }
            catch (ByteBasedList.ListFullException le) {
                this.addPartition();
                this.append(obj, OI, serializer);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        @Override
        public Iterator<Writable> iterator(Writable wObj) throws HiveException {
            return new WIterator(wObj);
        }

        public static void deleteRecursively(File file) throws IOException {
            if (file.isDirectory()) {
                PartitionedByteBasedList.deleteDirectoryContents(file);
            }
            if (!file.delete()) {
                throw new IOException("Failed to delete " + file);
            }
        }

        public static void deleteDirectoryContents(File directory) throws IOException {
            if (!directory.isDirectory()) {
                throw new IOException(String.format("Not a directory: %s", directory));
            }
            if (!directory.getCanonicalPath().equals(directory.getAbsolutePath())) {
                return;
            }
            File[] files = directory.listFiles();
            if (files == null) {
                throw new IOException("Error listing files for " + directory);
            }
            for (File file : files) {
                PartitionedByteBasedList.deleteRecursively(file);
            }
        }

        public static File createTempDir() {
            File baseDir = new File(System.getProperty("java.io.tmpdir"));
            String baseName = System.currentTimeMillis() + "-";
            for (int counter = 0; counter < 10000; ++counter) {
                File tempDir = new File(baseDir, baseName + counter);
                if (!tempDir.mkdir()) continue;
                return tempDir;
            }
            throw new IllegalStateException("Failed to create directory within 10000 attempts (tried " + baseName + "0 to " + baseName + 9999 + ')');
        }

        static class ShutdownHook
        extends Thread {
            File dir;

            public ShutdownHook(File dir) {
                this.dir = dir;
            }

            @Override
            public void run() {
                try {
                    PartitionedByteBasedList.deleteRecursively(this.dir);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        class WIterator
        implements Iterator<Writable> {
            Writable wObj;
            long checkTime;
            int i;
            Iterator<Writable> pIter;

            WIterator(Writable wObj) throws HiveException {
                this.wObj = wObj;
                this.checkTime = PartitionedByteBasedList.this.lastModified;
                this.i = 0;
                this.pIter = PartitionedByteBasedList.this.partitions.get(this.i).iterator(wObj);
            }

            @Override
            public boolean hasNext() {
                if (this.pIter.hasNext()) {
                    return true;
                }
                if (this.checkTime != PartitionedByteBasedList.this.lastModified) {
                    throw new ConcurrentModificationException();
                }
                try {
                    if (this.i < PartitionedByteBasedList.this.partitions.size()) {
                        this.pIter = PartitionedByteBasedList.this.partitions.get(this.i++).iterator(this.wObj);
                        return this.hasNext();
                    }
                    return false;
                }
                catch (HiveException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public Writable next() {
                if (this.checkTime != PartitionedByteBasedList.this.lastModified) {
                    throw new ConcurrentModificationException();
                }
                return this.pIter.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static class ByteBasedList {
        int startOffset;
        int[] offsetsArray;
        byte[] bytes;
        int bytesUsed;
        int currentSize;
        ReentrantReadWriteLock lock;
        volatile long lastModified;
        private static final int INCREMENT_SIZE = (int)Math.pow(2.0, 16.0);
        public static final int SMALL_SIZE = (int)Math.pow(2.0, 16.0);
        public static final int MEDIUM_SIZE = (int)Math.pow(2.0, 23.0);
        public static final int LARGE_SIZE = (int)Math.pow(2.0, 26.0);

        public ByteBasedList(int startOffset, int capacity) {
            this.startOffset = startOffset;
            this.bytes = new byte[capacity];
            this.offsetsArray = new int[INCREMENT_SIZE];
            this.bytesUsed = 0;
            this.currentSize = 0;
            this.lock = new ReentrantReadWriteLock();
            this.lastModified = System.nanoTime();
        }

        public ByteBasedList() {
            this(0, MEDIUM_SIZE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void reset(int startOffset) throws HiveException {
            PTFPersistence.lock(this.lock.writeLock());
            try {
                this.startOffset = startOffset;
                this.bytesUsed = 0;
                this.currentSize = 0;
                Arrays.fill(this.offsetsArray, 0);
                this.lastModified = System.nanoTime();
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        public ByteBasedList(int capacity) {
            this(0, capacity);
        }

        protected ByteBasedList(File file) {
            this.lock = new ReentrantReadWriteLock();
        }

        private void ensureCapacity(int wlen) throws ListFullException {
            if (this.bytesUsed + wlen > this.bytes.length) {
                throw new ListFullException();
            }
            if (2 * this.currentSize + 1 > this.offsetsArray.length) {
                int[] na = new int[this.offsetsArray.length + INCREMENT_SIZE];
                System.arraycopy(this.offsetsArray, 0, na, 0, this.offsetsArray.length);
                this.offsetsArray = na;
            }
        }

        private int index(int i) throws HiveException {
            int j = i - this.startOffset;
            if ((j <<= 1) > 2 * this.currentSize) {
                throw new HiveException(String.format("index invalid %d", i));
            }
            return j;
        }

        private void write(Writable w) throws HiveException, IOException {
            DataOStream dos = PTFPersistence.dos.get();
            ByteArrayOS bos = dos.getUnderlyingStream();
            bos.reset();
            w.write((DataOutput)dos);
            this.ensureCapacity(bos.len());
            int i = this.currentSize * 2;
            System.arraycopy(bos.bytearray(), 0, this.bytes, this.bytesUsed, bos.len());
            this.offsetsArray[i] = this.bytesUsed;
            this.offsetsArray[i + 1] = bos.len();
            ++this.currentSize;
            this.bytesUsed += bos.len();
            this.lastModified = System.nanoTime();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() throws HiveException {
            PTFPersistence.lock(this.lock.readLock());
            try {
                int n = this.currentSize;
                return n;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public void get(int i, Writable wObj) throws HiveException {
            PTFPersistence.lock(this.lock.readLock());
            try {
                i = this.index(i);
                DataIStream dis = PTFPersistence.dis.get();
                ByteArrayIS bis = dis.getUnderlyingStream();
                bis.setBuffer(this.bytes, this.offsetsArray[i], this.offsetsArray[i + 1]);
                wObj.readFields((DataInput)dis);
            }
            catch (IOException ie) {
                throw new HiveException(ie);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public void append(Writable obj) throws HiveException {
            PTFPersistence.lock(this.lock.writeLock());
            try {
                this.write(obj);
            }
            catch (IOException ie) {
                throw new HiveException(ie);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        public Object get(int i, Deserializer deserializer, Writable wObj) throws HiveException {
            try {
                this.get(i, wObj);
                return deserializer.deserialize(wObj);
            }
            catch (SerDeException ie) {
                throw new HiveException(ie);
            }
        }

        public void append(Object obj, ObjectInspector OI, Serializer serializer) throws HiveException {
            try {
                this.append(serializer.serialize(obj, OI));
            }
            catch (SerDeException ie) {
                throw new HiveException(ie);
            }
        }

        public Iterator<Writable> iterator(Writable wObj) throws HiveException {
            return new WIterator(wObj, this.startOffset);
        }

        public Iterator<Object> iterator(Deserializer deserializer, Writable wObj) throws HiveException {
            return new OIterator(deserializer, wObj);
        }

        public void dump(StringBuilder bldr, Writable wObj) throws IOException, HiveException {
            bldr.append("[");
            Iterator<Writable> wi = this.iterator(wObj);
            while (wi.hasNext()) {
                wObj = wi.next();
                bldr.append(wObj).append(", ");
            }
            bldr.append("]\n");
        }

        public void dump(StringBuilder bldr, Deserializer deserializer, Writable wObj) throws IOException, HiveException {
            bldr.append("[");
            Iterator<Object> oi = this.iterator(deserializer, wObj);
            while (oi.hasNext()) {
                bldr.append(oi.next()).append(", ");
            }
            bldr.append("]\n");
        }

        public static class ListFullException
        extends HiveException {
            private static final long serialVersionUID = 4745303310812778989L;

            public ListFullException() {
            }

            public ListFullException(String message, Throwable cause) {
                super(message, cause);
            }

            public ListFullException(String message) {
                super(message);
            }

            public ListFullException(Throwable cause) {
                super(cause);
            }
        }

        class OIterator
        implements Iterator<Object> {
            Deserializer deserializer;
            Iterator<Writable> wi;

            OIterator(Deserializer deserializer, Writable wObj) throws HiveException {
                this.wi = ByteBasedList.this.iterator(wObj);
                this.deserializer = deserializer;
            }

            @Override
            public boolean hasNext() {
                return this.wi.hasNext();
            }

            @Override
            public Object next() {
                Writable wObj = this.wi.next();
                try {
                    return this.deserializer.deserialize(wObj);
                }
                catch (SerDeException se) {
                    throw new RuntimeException(se);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }

        class WIterator
        implements Iterator<Writable> {
            Writable wObj;
            long checkTime;
            int i;

            WIterator(Writable wObj, int offset) {
                this.wObj = wObj;
                this.checkTime = ByteBasedList.this.lastModified;
                this.i = offset;
            }

            @Override
            public boolean hasNext() {
                return this.i < ByteBasedList.this.currentSize;
            }

            @Override
            public Writable next() {
                if (this.checkTime != ByteBasedList.this.lastModified) {
                    throw new ConcurrentModificationException();
                }
                try {
                    ByteBasedList.this.get(this.i++, this.wObj);
                    return this.wObj;
                }
                catch (HiveException be) {
                    throw new RuntimeException(be);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

