/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExecMapperContext;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.StringUtils;

public class MapOperator
extends Operator<MapredWork>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private final transient LongWritable deserialize_error_count = new LongWritable();
    private transient Deserializer deserializer;
    private transient Object[] rowWithPart;
    private transient Writable[] vcValues;
    private transient List<VirtualColumn> vcs;
    private transient Object[] rowWithPartAndVC;
    private transient StructObjectInspector tblRowObjectInspector;
    private transient ObjectInspectorConverters.Converter partTblObjectInspectorConverter;
    private transient boolean isPartitioned;
    private Map<MapInputPath, MapOpCtx> opCtxMap;
    private final Set<MapInputPath> listInputPaths = new HashSet<MapInputPath>();
    private Map<Operator<? extends OperatorDesc>, ArrayList<String>> operatorToPaths;
    private final Map<Operator<? extends OperatorDesc>, MapOpCtx> childrenOpToOpCtxMap = new HashMap<Operator<? extends OperatorDesc>, MapOpCtx>();
    private ArrayList<Operator<? extends OperatorDesc>> extraChildrenToClose = null;

    public void initializeAsRoot(Configuration hconf, MapredWork mrwork) throws HiveException {
        this.setConf(mrwork);
        this.setChildren(hconf);
        this.initialize(hconf, null);
    }

    private MapOpCtx initObjectInspector(MapredWork conf, Configuration hconf, String onefile, Map<TableDesc, StructObjectInspector> convertedOI) throws HiveException, ClassNotFoundException, InstantiationException, IllegalAccessException, SerDeException {
        PartitionDesc pd = conf.getPathToPartitionInfo().get(onefile);
        LinkedHashMap<String, String> partSpec = pd.getPartSpec();
        Properties partProps = pd.getPartSpec() == null || pd.getPartSpec().isEmpty() ? pd.getTableDesc().getProperties() : pd.getProperties();
        Class serdeclass = pd.getDeserializerClass();
        if (serdeclass == null) {
            String className = pd.getSerdeClassName();
            if (className == null || className.isEmpty()) {
                throw new HiveException("SerDe class or the SerDe class name is not set for table: " + pd.getProperties().getProperty("name"));
            }
            serdeclass = hconf.getClassByName(className);
        }
        String tableName = String.valueOf(partProps.getProperty("name"));
        String partName = String.valueOf(partSpec);
        Deserializer partDeserializer = serdeclass.newInstance();
        partDeserializer.initialize(hconf, partProps);
        StructObjectInspector partRawRowObjectInspector = (StructObjectInspector)partDeserializer.getObjectInspector();
        StructObjectInspector tblRawRowObjectInspector = convertedOI.get(pd.getTableDesc());
        this.partTblObjectInspectorConverter = ObjectInspectorConverters.getConverter(partRawRowObjectInspector, tblRawRowObjectInspector);
        MapOpCtx opCtx = null;
        String pcols = partProps.getProperty("partition_columns");
        if (pcols != null && pcols.length() > 0) {
            String[] partKeys = pcols.trim().split("/");
            ArrayList<String> partNames = new ArrayList<String>(partKeys.length);
            Object[] partValues = new Object[partKeys.length];
            ArrayList<ObjectInspector> partObjectInspectors = new ArrayList<ObjectInspector>(partKeys.length);
            for (int i = 0; i < partKeys.length; ++i) {
                String key = partKeys[i];
                partNames.add(key);
                partValues[i] = partSpec == null ? null : new Text(partSpec.get(key));
                partObjectInspectors.add(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
            }
            StandardStructObjectInspector partObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(partNames, partObjectInspectors);
            Object[] rowWithPart = new Object[2];
            rowWithPart[1] = partValues;
            UnionStructObjectInspector rowObjectInspector = ObjectInspectorFactory.getUnionStructObjectInspector(Arrays.asList(tblRawRowObjectInspector, partObjectInspector));
            opCtx = new MapOpCtx(true, rowObjectInspector, tblRawRowObjectInspector, partObjectInspector, rowWithPart, null, partDeserializer, this.partTblObjectInspectorConverter);
        } else {
            opCtx = new MapOpCtx(false, tblRawRowObjectInspector, tblRawRowObjectInspector, null, null, null, partDeserializer, this.partTblObjectInspectorConverter);
        }
        opCtx.tableName = tableName;
        opCtx.partName = partName;
        return opCtx;
    }

    private void setInspectorInput(MapInputPath inp) {
        Operator<? extends OperatorDesc> op = inp.getOp();
        this.deserializer = this.opCtxMap.get(inp).getDeserializer();
        this.isPartitioned = this.opCtxMap.get(inp).isPartitioned();
        this.rowWithPart = this.opCtxMap.get(inp).getRowWithPart();
        this.rowWithPartAndVC = this.opCtxMap.get(inp).getRowWithPartAndVC();
        this.tblRowObjectInspector = this.opCtxMap.get(inp).getRowObjectInspector();
        this.partTblObjectInspectorConverter = this.opCtxMap.get(inp).getPartTblObjectInspectorConverter();
        if (this.listInputPaths.contains(inp)) {
            return;
        }
        this.listInputPaths.add(inp);
        if (op instanceof TableScanOperator) {
            StructObjectInspector tblRawRowObjectInspector = this.opCtxMap.get(inp).getTblRawRowObjectInspector();
            StructObjectInspector partObjectInspector = this.opCtxMap.get(inp).partObjectInspector;
            TableScanOperator tsOp = (TableScanOperator)op;
            TableScanDesc tsDesc = (TableScanDesc)tsOp.getConf();
            if (tsDesc != null) {
                this.vcs = tsDesc.getVirtualCols();
                if (this.vcs != null && this.vcs.size() > 0) {
                    ArrayList<String> vcNames = new ArrayList<String>(this.vcs.size());
                    this.vcValues = new Writable[this.vcs.size()];
                    ArrayList<ObjectInspector> vcsObjectInspectors = new ArrayList<ObjectInspector>(this.vcs.size());
                    for (int i = 0; i < this.vcs.size(); ++i) {
                        VirtualColumn vc = this.vcs.get(i);
                        vcsObjectInspectors.add(PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(vc.getTypeInfo().getPrimitiveCategory()));
                        vcNames.add(vc.getName());
                    }
                    StandardStructObjectInspector vcStructObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(vcNames, vcsObjectInspectors);
                    if (this.isPartitioned) {
                        this.rowWithPartAndVC = new Object[3];
                        this.rowWithPartAndVC[1] = this.rowWithPart[1];
                    } else {
                        this.rowWithPartAndVC = new Object[2];
                    }
                    this.tblRowObjectInspector = partObjectInspector == null ? ObjectInspectorFactory.getUnionStructObjectInspector(Arrays.asList(this.tblRowObjectInspector, vcStructObjectInspector)) : ObjectInspectorFactory.getUnionStructObjectInspector(Arrays.asList(tblRawRowObjectInspector, partObjectInspector, vcStructObjectInspector));
                    this.opCtxMap.get(inp).rowObjectInspector = this.tblRowObjectInspector;
                    MapOpCtx.access$402(this.opCtxMap.get(inp), this.rowWithPartAndVC);
                }
            }
        }
    }

    private Map<TableDesc, StructObjectInspector> getConvertedOI(Configuration hconf) throws HiveException {
        HashMap<TableDesc, StructObjectInspector> tableDescOI = new HashMap<TableDesc, StructObjectInspector>();
        HashSet<TableDesc> identityConverterTableDesc = new HashSet<TableDesc>();
        try {
            for (String onefile : ((MapredWork)this.conf).getPathToAliases().keySet()) {
                PartitionDesc pd = ((MapredWork)this.conf).getPathToPartitionInfo().get(onefile);
                TableDesc tableDesc = pd.getTableDesc();
                Properties tblProps = tableDesc.getProperties();
                Properties partProps = pd.getPartSpec() == null || pd.getPartSpec().isEmpty() ? tblProps : pd.getProperties();
                Class sdclass = pd.getDeserializerClass();
                if (sdclass == null) {
                    String className = pd.getSerdeClassName();
                    if (className == null || className.isEmpty()) {
                        throw new HiveException("SerDe class or the SerDe class name is not set for table: " + pd.getProperties().getProperty("name"));
                    }
                    sdclass = hconf.getClassByName(className);
                }
                Deserializer partDeserializer = sdclass.newInstance();
                partDeserializer.initialize(hconf, partProps);
                StructObjectInspector partRawRowObjectInspector = (StructObjectInspector)partDeserializer.getObjectInspector();
                StructObjectInspector tblRawRowObjectInspector = (StructObjectInspector)tableDescOI.get(tableDesc);
                if (tblRawRowObjectInspector != null && !identityConverterTableDesc.contains(tableDesc)) continue;
                sdclass = tableDesc.getDeserializerClass();
                if (sdclass == null) {
                    String className = tableDesc.getSerdeClassName();
                    if (className == null || className.isEmpty()) {
                        throw new HiveException("SerDe class or the SerDe class name is not set for table: " + tableDesc.getProperties().getProperty("name"));
                    }
                    sdclass = hconf.getClassByName(className);
                }
                Deserializer tblDeserializer = sdclass.newInstance();
                tblDeserializer.initialize(hconf, tblProps);
                tblRawRowObjectInspector = (StructObjectInspector)ObjectInspectorConverters.getConvertedOI(partRawRowObjectInspector, (StructObjectInspector)tblDeserializer.getObjectInspector());
                if (identityConverterTableDesc.contains(tableDesc)) {
                    if (!partRawRowObjectInspector.equals(tblRawRowObjectInspector)) {
                        identityConverterTableDesc.remove(tableDesc);
                    }
                } else if (partRawRowObjectInspector.equals(tblRawRowObjectInspector)) {
                    identityConverterTableDesc.add(tableDesc);
                }
                tableDescOI.put(tableDesc, tblRawRowObjectInspector);
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        return tableDescOI;
    }

    public void setChildren(Configuration hconf) throws HiveException {
        Path fpath = new Path(HiveConf.getVar(hconf, HiveConf.ConfVars.HADOOPMAPFILENAME));
        ArrayList<Operator<? extends OperatorDesc>> children = new ArrayList<Operator<? extends OperatorDesc>>();
        this.opCtxMap = new HashMap<MapInputPath, MapOpCtx>();
        this.operatorToPaths = new HashMap<Operator<? extends OperatorDesc>, ArrayList<String>>();
        this.statsMap.put(Counter.DESERIALIZE_ERRORS, this.deserialize_error_count);
        Map<TableDesc, StructObjectInspector> convertedOI = this.getConvertedOI(hconf);
        try {
            for (String onefile : ((MapredWork)this.conf).getPathToAliases().keySet()) {
                MapOpCtx opCtx = this.initObjectInspector((MapredWork)this.conf, hconf, onefile, convertedOI);
                Path onepath = new Path(onefile);
                List aliases = ((MapredWork)this.conf).getPathToAliases().get(onefile);
                for (String onealias : aliases) {
                    Operator<? extends OperatorDesc> op = ((MapredWork)this.conf).getAliasToWork().get(onealias);
                    this.LOG.info((Object)("Adding alias " + onealias + " to work list for file " + onefile));
                    MapInputPath inp = new MapInputPath(onefile, onealias, op);
                    this.opCtxMap.put(inp, opCtx);
                    if (this.operatorToPaths.get(op) == null) {
                        this.operatorToPaths.put(op, new ArrayList());
                    }
                    this.operatorToPaths.get(op).add(onefile);
                    op.setParentOperators(new ArrayList<Operator<? extends OperatorDesc>>());
                    op.getParentOperators().add(this);
                    if (!onepath.toUri().relativize(fpath.toUri()).equals(fpath.toUri())) {
                        children.add(op);
                        this.childrenOpToOpCtxMap.put(op, opCtx);
                        this.LOG.info((Object)("dump " + op.getName() + " " + this.opCtxMap.get(inp).getRowObjectInspector().getTypeName()));
                    }
                    this.setInspectorInput(inp);
                }
            }
            if (children.size() == 0) {
                this.LOG.error((Object)("Configuration does not have any alias for path: " + fpath.toUri()));
                throw new HiveException("Configuration and input path are inconsistent");
            }
            this.setChildOperators(children);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    @Override
    public void initializeOp(Configuration hconf) throws HiveException {
        this.state = Operator.State.INIT;
        List<Operator<OperatorDesc>> children = this.getChildOperators();
        for (Map.Entry<Operator<? extends OperatorDesc>, MapOpCtx> entry : this.childrenOpToOpCtxMap.entrySet()) {
            Operator<? extends OperatorDesc> child = entry.getKey();
            MapOpCtx mapOpCtx = entry.getValue();
            HiveConf.setVar(hconf, HiveConf.ConfVars.HIVETABLENAME, mapOpCtx.tableName);
            HiveConf.setVar(hconf, HiveConf.ConfVars.HIVEPARTITIONNAME, mapOpCtx.partName);
            child.initialize(hconf, new ObjectInspector[]{mapOpCtx.getRowObjectInspector()});
        }
        for (Map.Entry<Object, MapOpCtx> entry : this.opCtxMap.entrySet()) {
            HiveConf.setVar(hconf, HiveConf.ConfVars.HIVETABLENAME, entry.getValue().tableName);
            HiveConf.setVar(hconf, HiveConf.ConfVars.HIVEPARTITIONNAME, entry.getValue().partName);
            MapInputPath input = (MapInputPath)entry.getKey();
            Operator<? extends OperatorDesc> op = input.op;
            if (children.indexOf(op) != -1) continue;
            if (this.extraChildrenToClose == null) {
                this.extraChildrenToClose = new ArrayList();
            }
            this.extraChildrenToClose.add(op);
            op.initialize(hconf, new ObjectInspector[]{entry.getValue().getRowObjectInspector()});
        }
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        if (this.extraChildrenToClose != null) {
            for (Operator<? extends OperatorDesc> op : this.extraChildrenToClose) {
                op.close(abort);
            }
        }
    }

    @Override
    public void cleanUpInputFileChangedOp() throws HiveException {
        Path fpath = new Path(new Path(this.getExecContext().getCurrentInputFile()).toUri().getPath());
        for (String onefile : ((MapredWork)this.conf).getPathToAliases().keySet()) {
            Path onepath = new Path(new Path(onefile).toUri().getPath());
            if (onepath.toUri().relativize(fpath.toUri()).equals(fpath.toUri())) continue;
            String onealias = ((MapredWork)this.conf).getPathToAliases().get(onefile).get(0);
            Operator<? extends OperatorDesc> op = ((MapredWork)this.conf).getAliasToWork().get(onealias);
            this.LOG.info((Object)("Processing alias " + onealias + " for file " + onefile));
            MapInputPath inp = new MapInputPath(onefile, onealias, op);
            this.setInspectorInput(inp);
            break;
        }
    }

    public void process(Writable value) throws HiveException {
        if (this.getExecContext() != null && this.getExecContext().inputFileChanged()) {
            this.cleanUpInputFileChanged();
        }
        ExecMapperContext context = this.getExecContext();
        Object row = null;
        try {
            if (null != this.rowWithPartAndVC) {
                int vcPos;
                this.rowWithPartAndVC[0] = this.partTblObjectInspectorConverter.convert(this.deserializer.deserialize(value));
                int n = vcPos = this.isPartitioned ? 2 : 1;
                if (context != null) {
                    MapOperator.populateVirtualColumnValues(context, this.vcs, this.vcValues, this.deserializer);
                }
                this.rowWithPartAndVC[vcPos] = this.vcValues;
            } else if (!this.isPartitioned) {
                row = this.partTblObjectInspectorConverter.convert(this.deserializer.deserialize(value));
            } else {
                this.rowWithPart[0] = this.partTblObjectInspectorConverter.convert(this.deserializer.deserialize(value));
            }
        }
        catch (Exception e) {
            String rawRowString;
            try {
                rawRowString = value.toString();
            }
            catch (Exception e2) {
                rawRowString = "[Error getting row data with exception " + StringUtils.stringifyException((Throwable)e2) + " ]";
            }
            this.deserialize_error_count.set(this.deserialize_error_count.get() + 1L);
            throw new HiveException("Hive Runtime Error while processing writable " + rawRowString, e);
        }
        try {
            if (null != this.rowWithPartAndVC) {
                this.forward(this.rowWithPartAndVC, this.tblRowObjectInspector);
            } else if (!this.isPartitioned) {
                this.forward(row, this.tblRowObjectInspector);
            } else {
                this.forward(this.rowWithPart, this.tblRowObjectInspector);
            }
        }
        catch (Exception e) {
            String rowString;
            try {
                rowString = null != this.rowWithPartAndVC ? SerDeUtils.getJSONString(this.rowWithPartAndVC, this.tblRowObjectInspector) : (!this.isPartitioned ? SerDeUtils.getJSONString(row, this.tblRowObjectInspector) : SerDeUtils.getJSONString(this.rowWithPart, this.tblRowObjectInspector));
            }
            catch (Exception e2) {
                rowString = "[Error getting row data with exception " + StringUtils.stringifyException((Throwable)e2) + " ]";
            }
            throw new HiveException("Hive Runtime Error while processing row " + rowString, e);
        }
    }

    public static Writable[] populateVirtualColumnValues(ExecMapperContext ctx, List<VirtualColumn> vcs, Writable[] vcValues, Deserializer deserializer) {
        if (vcs == null) {
            return vcValues;
        }
        if (vcValues == null) {
            vcValues = new Writable[vcs.size()];
        }
        for (int i = 0; i < vcs.size(); ++i) {
            LongWritable old;
            LongWritable old2;
            long current;
            VirtualColumn vc = vcs.get(i);
            if (vc.equals(VirtualColumn.FILENAME)) {
                if (!ctx.inputFileChanged()) continue;
                vcValues[i] = new Text(ctx.getCurrentInputFile());
                continue;
            }
            if (vc.equals(VirtualColumn.BLOCKOFFSET)) {
                current = ctx.getIoCxt().getCurrentBlockStart();
                old2 = (LongWritable)vcValues[i];
                if (old2 == null) {
                    old2 = new LongWritable(current);
                    vcValues[i] = old2;
                    continue;
                }
                if (current == old2.get()) continue;
                old2.set(current);
                continue;
            }
            if (vc.equals(VirtualColumn.ROWOFFSET)) {
                current = ctx.getIoCxt().getCurrentRow();
                old2 = (LongWritable)vcValues[i];
                if (old2 == null) {
                    old2 = new LongWritable(current);
                    vcValues[i] = old2;
                    continue;
                }
                if (current == old2.get()) continue;
                old2.set(current);
                continue;
            }
            if (!vc.equals(VirtualColumn.RAWDATASIZE)) continue;
            current = 0L;
            SerDeStats stats = deserializer.getSerDeStats();
            if (stats != null) {
                current = stats.getRawDataSize();
            }
            if ((old = (LongWritable)vcValues[i]) == null) {
                old = new LongWritable(current);
                vcValues[i] = old;
                continue;
            }
            if (current == old.get()) continue;
            old.set(current);
        }
        return vcValues;
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        throw new HiveException("Hive 2 Internal error: should not be called!");
    }

    @Override
    public String getName() {
        return MapOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "MAP";
    }

    @Override
    public OperatorType getType() {
        return null;
    }

    private static class MapOpCtx {
        private final boolean isPartitioned;
        private final StructObjectInspector tblRawRowObjectInspector;
        private final StructObjectInspector partObjectInspector;
        private StructObjectInspector rowObjectInspector;
        private final ObjectInspectorConverters.Converter partTblObjectInspectorConverter;
        private final Object[] rowWithPart;
        private Object[] rowWithPartAndVC;
        private final Deserializer deserializer;
        private String tableName;
        private String partName;

        public MapOpCtx(boolean isPartitioned, StructObjectInspector rowObjectInspector, StructObjectInspector tblRawRowObjectInspector, StructObjectInspector partObjectInspector, Object[] rowWithPart, Object[] rowWithPartAndVC, Deserializer deserializer, ObjectInspectorConverters.Converter partTblObjectInspectorConverter) {
            this.isPartitioned = isPartitioned;
            this.rowObjectInspector = rowObjectInspector;
            this.tblRawRowObjectInspector = tblRawRowObjectInspector;
            this.partObjectInspector = partObjectInspector;
            this.rowWithPart = rowWithPart;
            this.rowWithPartAndVC = rowWithPartAndVC;
            this.deserializer = deserializer;
            this.partTblObjectInspectorConverter = partTblObjectInspectorConverter;
        }

        public boolean isPartitioned() {
            return this.isPartitioned;
        }

        public StructObjectInspector getRowObjectInspector() {
            return this.rowObjectInspector;
        }

        public StructObjectInspector getTblRawRowObjectInspector() {
            return this.tblRawRowObjectInspector;
        }

        public Object[] getRowWithPart() {
            return this.rowWithPart;
        }

        public Object[] getRowWithPartAndVC() {
            return this.rowWithPartAndVC;
        }

        public Deserializer getDeserializer() {
            return this.deserializer;
        }

        public ObjectInspectorConverters.Converter getPartTblObjectInspectorConverter() {
            return this.partTblObjectInspectorConverter;
        }

        static /* synthetic */ Object[] access$402(MapOpCtx x0, Object[] x1) {
            x0.rowWithPartAndVC = x1;
            return x1;
        }
    }

    private static class MapInputPath {
        String path;
        String alias;
        Operator<? extends OperatorDesc> op;

        public MapInputPath(String path, String alias, Operator<? extends OperatorDesc> op) {
            this.path = path;
            this.alias = alias;
            this.op = op;
        }

        public boolean equals(Object o) {
            if (o instanceof MapInputPath) {
                MapInputPath mObj = (MapInputPath)o;
                return this.path.equals(mObj.path) && this.alias.equals(mObj.alias) && this.op.equals(mObj.op);
            }
            return false;
        }

        public int hashCode() {
            int ret = this.path == null ? 0 : this.path.hashCode();
            ret += this.alias == null ? 0 : this.alias.hashCode();
            return ret += this.op == null ? 0 : this.op.hashCode();
        }

        public Operator<? extends OperatorDesc> getOp() {
            return this.op;
        }

        public void setOp(Operator<? extends OperatorDesc> op) {
            this.op = op;
        }
    }

    public static enum Counter {
        DESERIALIZE_ERRORS;

    }
}

