/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.MapJoinMetaData;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.TerminalOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.persistence.AbstractMapJoinKey;
import org.apache.hadoop.hive.ql.exec.persistence.HashMapWrapper;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinObjectValue;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinRowContainer;
import org.apache.hadoop.hive.ql.exec.persistence.RowContainer;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.HashTableSinkDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.util.ReflectionUtils;

public class HashTableSinkOperator
extends TerminalOperator<HashTableSinkDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog((String)HashTableSinkOperator.class.getName());
    protected static MapJoinMetaData metadata = new MapJoinMetaData();
    protected transient List<ExprNodeEvaluator>[] joinKeys;
    protected transient List<ObjectInspector>[] joinKeysObjectInspectors;
    protected transient List<ObjectInspector>[] joinKeysStandardObjectInspectors;
    protected transient int posBigTableAlias = -1;
    transient int mapJoinRowsKey;
    protected transient RowContainer<ArrayList<Object>> emptyList = null;
    transient int numMapRowsRead;
    protected transient int totalSz;
    transient boolean firstRow;
    protected transient List<ExprNodeEvaluator>[] joinFilters;
    protected transient int[][] filterMaps;
    protected transient int numAliases;
    protected transient List<ExprNodeEvaluator>[] joinValues;
    protected transient List<ObjectInspector>[] joinValuesObjectInspectors;
    protected transient List<ObjectInspector>[] joinFilterObjectInspectors;
    protected transient List<ObjectInspector>[] joinValuesStandardObjectInspectors;
    protected transient List<ObjectInspector>[] rowContainerStandardObjectInspectors;
    protected transient Byte[] order;
    Configuration hconf;
    protected transient Byte alias;
    protected transient TableDesc[] spillTableDesc;
    protected transient HashMapWrapper<AbstractMapJoinKey, MapJoinObjectValue>[] mapJoinTables;
    protected transient boolean noOuterJoin;
    private long rowNumber = 0L;
    protected transient SessionState.LogHelper console;
    private long hashTableScale;
    private boolean isAbort = false;
    private static final transient String[] FATAL_ERR_MSG = new String[]{null, "Mapside join exceeds available memory. Please try removing the mapjoin hint."};
    private final int metadataKeyTag = -1;
    transient int[] metadataValueTag;

    public static MapJoinMetaData getMetadata() {
        return metadata;
    }

    public HashTableSinkOperator() {
    }

    public HashTableSinkOperator(MapJoinOperator mjop) {
        this.conf = new HashTableSinkDesc((MapJoinDesc)mjop.getConf());
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        boolean isSilent = HiveConf.getBoolVar(hconf, HiveConf.ConfVars.HIVESESSIONSILENT);
        this.console = new SessionState.LogHelper(LOG, isSilent);
        this.numMapRowsRead = 0;
        this.firstRow = true;
        this.posBigTableAlias = ((HashTableSinkDesc)this.conf).getPosBigTable();
        this.order = ((HashTableSinkDesc)this.conf).getTagOrder();
        this.numAliases = ((HashTableSinkDesc)this.conf).getExprs().size();
        this.hconf = hconf;
        this.totalSz = 0;
        this.noOuterJoin = ((HashTableSinkDesc)this.conf).isNoOuterJoin();
        this.filterMaps = ((HashTableSinkDesc)this.conf).getFilterMap();
        int tagLen = ((HashTableSinkDesc)this.conf).getTagLength();
        this.joinKeys = new List[tagLen];
        JoinUtil.populateJoinKeyValue(this.joinKeys, ((HashTableSinkDesc)this.conf).getKeys(), this.posBigTableAlias);
        this.joinKeysObjectInspectors = JoinUtil.getObjectInspectorsFromEvaluators(this.joinKeys, this.inputObjInspectors, this.posBigTableAlias, tagLen);
        this.joinKeysStandardObjectInspectors = JoinUtil.getStandardObjectInspectors(this.joinKeysObjectInspectors, this.posBigTableAlias, tagLen);
        this.joinValues = new List[tagLen];
        JoinUtil.populateJoinKeyValue(this.joinValues, ((HashTableSinkDesc)this.conf).getExprs(), this.posBigTableAlias);
        this.joinValuesObjectInspectors = JoinUtil.getObjectInspectorsFromEvaluators(this.joinValues, this.inputObjInspectors, this.posBigTableAlias, tagLen);
        this.joinValuesStandardObjectInspectors = JoinUtil.getStandardObjectInspectors(this.joinValuesObjectInspectors, this.posBigTableAlias, tagLen);
        this.joinFilters = new List[tagLen];
        JoinUtil.populateJoinKeyValue(this.joinFilters, ((HashTableSinkDesc)this.conf).getFilters(), this.posBigTableAlias);
        this.joinFilterObjectInspectors = JoinUtil.getObjectInspectorsFromEvaluators(this.joinFilters, this.inputObjInspectors, this.posBigTableAlias, tagLen);
        if (this.noOuterJoin) {
            this.rowContainerStandardObjectInspectors = this.joinValuesStandardObjectInspectors;
        } else {
            List[] rowContainerObjectInspectors = new List[tagLen];
            for (Byte alias : this.order) {
                if (alias == this.posBigTableAlias) continue;
                List<ObjectInspector> rcOIs = this.joinValuesObjectInspectors[alias];
                if (this.filterMaps != null && this.filterMaps[alias] != null) {
                    rcOIs = new ArrayList<ObjectInspector>(rcOIs);
                    rcOIs.add(PrimitiveObjectInspectorFactory.writableShortObjectInspector);
                }
                rowContainerObjectInspectors[alias.byteValue()] = rcOIs;
            }
            this.rowContainerStandardObjectInspectors = HashTableSinkOperator.getStandardObjectInspectors(rowContainerObjectInspectors, tagLen);
        }
        this.metadataValueTag = new int[this.numAliases];
        for (int pos = 0; pos < this.numAliases; ++pos) {
            this.metadataValueTag[pos] = -1;
        }
        this.mapJoinTables = new HashMapWrapper[tagLen];
        int hashTableThreshold = HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVEHASHTABLETHRESHOLD);
        float hashTableLoadFactor = HiveConf.getFloatVar(hconf, HiveConf.ConfVars.HIVEHASHTABLELOADFACTOR);
        float hashTableMaxMemoryUsage = ((HashTableSinkDesc)this.getConf()).getHashtableMemoryUsage();
        this.hashTableScale = HiveConf.getLongVar(hconf, HiveConf.ConfVars.HIVEHASHTABLESCALE);
        if (this.hashTableScale <= 0L) {
            this.hashTableScale = 1L;
        }
        for (Byte pos : this.order) {
            if (pos == this.posBigTableAlias) continue;
            HashMapWrapper hashTable = new HashMapWrapper(hashTableThreshold, hashTableLoadFactor, hashTableMaxMemoryUsage);
            this.mapJoinTables[pos.byteValue()] = hashTable;
        }
    }

    protected static List<ObjectInspector>[] getStandardObjectInspectors(List<ObjectInspector>[] aliasToObjectInspectors, int maxTag) {
        List[] result = new List[maxTag];
        for (int alias = 0; alias < aliasToObjectInspectors.length; alias = (int)((byte)(alias + 1))) {
            List<ObjectInspector> oiList = aliasToObjectInspectors[alias];
            if (oiList == null) continue;
            ArrayList<ObjectInspector> fieldOIList = new ArrayList<ObjectInspector>(oiList.size());
            for (int i = 0; i < oiList.size(); ++i) {
                fieldOIList.add(ObjectInspectorUtils.getStandardObjectInspector(oiList.get(i), ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE));
            }
            result[alias] = fieldOIList;
        }
        return result;
    }

    private void setKeyMetaData() throws SerDeException {
        TableDesc keyTableDesc = ((HashTableSinkDesc)this.conf).getKeyTblDesc();
        SerDe keySerializer = (SerDe)ReflectionUtils.newInstance(keyTableDesc.getDeserializerClass(), null);
        keySerializer.initialize(null, keyTableDesc.getProperties());
        metadata.put(-1, new HashTableSinkObjectCtx(ObjectInspectorUtils.getStandardObjectInspector(keySerializer.getObjectInspector(), ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE), keySerializer, keyTableDesc, false, this.hconf));
    }

    private boolean hasFilter(int alias) {
        return this.filterMaps != null && this.filterMaps[alias] != null;
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        try {
            if (this.firstRow) {
                this.setKeyMetaData();
                this.firstRow = false;
            }
            this.alias = (byte)tag;
            AbstractMapJoinKey keyMap = JoinUtil.computeMapJoinKeys(row, this.joinKeys[this.alias], this.joinKeysObjectInspectors[this.alias]);
            Object[] value = JoinUtil.computeMapJoinValues(row, this.joinValues[this.alias], this.joinValuesObjectInspectors[this.alias], this.joinFilters[this.alias], this.joinFilterObjectInspectors[this.alias], this.filterMaps == null ? null : this.filterMaps[this.alias]);
            HashMapWrapper<AbstractMapJoinKey, MapJoinObjectValue> hashTable = this.mapJoinTables[this.alias];
            MapJoinObjectValue o = hashTable.get(keyMap);
            MapJoinRowContainer<Object> res = null;
            boolean needNewKey = true;
            if (o == null) {
                res = new MapJoinRowContainer();
                res.add(value);
                if (this.metadataValueTag[tag] == -1) {
                    this.metadataValueTag[tag] = this.order[tag].byteValue();
                    this.setValueMetaData(tag);
                }
                if (needNewKey) {
                    MapJoinObjectValue valueObj = new MapJoinObjectValue(this.metadataValueTag[tag], res);
                    ++this.rowNumber;
                    if (this.rowNumber > this.hashTableScale && this.rowNumber % this.hashTableScale == 0L) {
                        this.isAbort = hashTable.isAbort(this.rowNumber, this.console);
                        if (this.isAbort) {
                            throw new HiveException("RunOutOfMeomoryUsage");
                        }
                    }
                    hashTable.put(keyMap, valueObj);
                }
            } else {
                res = o.getObj();
                res.add(value);
            }
        }
        catch (SerDeException e) {
            throw new HiveException(e);
        }
    }

    private void setValueMetaData(int tag) throws SerDeException {
        TableDesc valueTableDesc = ((HashTableSinkDesc)this.conf).getValueTblFilteredDescs().get(tag);
        SerDe valueSerDe = (SerDe)ReflectionUtils.newInstance(valueTableDesc.getDeserializerClass(), null);
        valueSerDe.initialize(null, valueTableDesc.getProperties());
        List<ObjectInspector> newFields = this.rowContainerStandardObjectInspectors[this.alias];
        int length = newFields.size();
        ArrayList<String> newNames = new ArrayList<String>(length);
        for (int i = 0; i < length; ++i) {
            String tmp = new String("tmp_" + i);
            newNames.add(tmp);
        }
        StandardStructObjectInspector standardOI = ObjectInspectorFactory.getStandardStructObjectInspector(newNames, newFields);
        int alias = this.metadataValueTag[tag];
        metadata.put(this.metadataValueTag[tag], new HashTableSinkObjectCtx(standardOI, valueSerDe, valueTableDesc, this.hasFilter(alias), this.hconf));
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        try {
            if (this.mapJoinTables != null) {
                String tmpURI = this.getExecContext().getLocalWork().getTmpFileURI();
                LOG.info((Object)("Get TMP URI: " + tmpURI));
                for (byte tag = 0; tag < this.mapJoinTables.length; tag = (byte)((byte)(tag + 1))) {
                    HashMapWrapper<AbstractMapJoinKey, MapJoinObjectValue> hashTable = this.mapJoinTables[tag];
                    if (hashTable == null) continue;
                    String bigBucketFileName = this.getExecContext().getCurrentBigBucketFile();
                    String fileName = this.getExecContext().getLocalWork().getBucketFileName(bigBucketFileName);
                    String dumpFilePrefix = ((HashTableSinkDesc)this.conf).getDumpFilePrefix();
                    String tmpURIPath = Utilities.generatePath(tmpURI, dumpFilePrefix, tag, fileName);
                    hashTable.isAbort(this.rowNumber, this.console);
                    this.console.printInfo(Utilities.now() + "\tDump the hashtable into file: " + tmpURIPath);
                    Path path = new Path(tmpURIPath);
                    FileSystem fs = path.getFileSystem(this.hconf);
                    File file = new File(path.toUri().getPath());
                    fs.create(path);
                    long fileLength = hashTable.flushMemoryCacheToPersistent(file);
                    this.console.printInfo(Utilities.now() + "\tUpload 1 File to: " + tmpURIPath + " File size: " + fileLength);
                    hashTable.close();
                }
            }
            super.closeOp(abort);
        }
        catch (Exception e) {
            LOG.error((Object)"Generate Hashtable error", (Throwable)e);
            e.printStackTrace();
        }
    }

    @Override
    public String getName() {
        return HashTableSinkOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "HASHTABLESINK";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.HASHTABLESINK;
    }

    public static class HashTableSinkObjectCtx {
        ObjectInspector standardOI;
        SerDe serde;
        TableDesc tblDesc;
        Configuration conf;
        boolean hasFilter;

        public HashTableSinkObjectCtx(ObjectInspector standardOI, SerDe serde, TableDesc tblDesc, boolean hasFilter, Configuration conf) {
            this.standardOI = standardOI;
            this.serde = serde;
            this.tblDesc = tblDesc;
            this.hasFilter = hasFilter;
            this.conf = conf;
        }

        public ObjectInspector getStandardOI() {
            return this.standardOI;
        }

        public SerDe getSerDe() {
            return this.serde;
        }

        public TableDesc getTblDesc() {
            return this.tblDesc;
        }

        public boolean hasFilterTag() {
            return this.hasFilter;
        }

        public Configuration getConf() {
            return this.conf;
        }
    }
}

