/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ASTNodeOrigin;

public final class ErrorMsg
extends Enum<ErrorMsg> {
    public static final /* enum */ ErrorMsg GENERIC_ERROR = new ErrorMsg(40000, "Exception while processing");
    public static final /* enum */ ErrorMsg INVALID_TABLE = new ErrorMsg(10001, "Table not found", "42S02");
    public static final /* enum */ ErrorMsg INVALID_COLUMN = new ErrorMsg(10002, "Invalid column reference");
    public static final /* enum */ ErrorMsg INVALID_INDEX = new ErrorMsg(10003, "Invalid index");
    public static final /* enum */ ErrorMsg INVALID_TABLE_OR_COLUMN = new ErrorMsg(10004, "Invalid table alias or column reference");
    public static final /* enum */ ErrorMsg AMBIGUOUS_TABLE_OR_COLUMN = new ErrorMsg(10005, "Ambiguous table alias or column reference");
    public static final /* enum */ ErrorMsg INVALID_PARTITION = new ErrorMsg(10006, "Partition not found");
    public static final /* enum */ ErrorMsg AMBIGUOUS_COLUMN = new ErrorMsg(10007, "Ambiguous column reference");
    public static final /* enum */ ErrorMsg AMBIGUOUS_TABLE_ALIAS = new ErrorMsg(10008, "Ambiguous table alias");
    public static final /* enum */ ErrorMsg INVALID_TABLE_ALIAS = new ErrorMsg(10009, "Invalid table alias");
    public static final /* enum */ ErrorMsg NO_TABLE_ALIAS = new ErrorMsg(10010, "No table alias");
    public static final /* enum */ ErrorMsg INVALID_FUNCTION = new ErrorMsg(10011, "Invalid function");
    public static final /* enum */ ErrorMsg INVALID_FUNCTION_SIGNATURE = new ErrorMsg(10012, "Function argument type mismatch");
    public static final /* enum */ ErrorMsg INVALID_OPERATOR_SIGNATURE = new ErrorMsg(10013, "Operator argument type mismatch");
    public static final /* enum */ ErrorMsg INVALID_ARGUMENT = new ErrorMsg(10014, "Wrong arguments");
    public static final /* enum */ ErrorMsg INVALID_ARGUMENT_LENGTH = new ErrorMsg(10015, "Arguments length mismatch", "21000");
    public static final /* enum */ ErrorMsg INVALID_ARGUMENT_TYPE = new ErrorMsg(10016, "Argument type mismatch");
    public static final /* enum */ ErrorMsg INVALID_JOIN_CONDITION_1 = new ErrorMsg(10017, "Both left and right aliases encountered in JOIN");
    public static final /* enum */ ErrorMsg INVALID_JOIN_CONDITION_2 = new ErrorMsg(10018, "Neither left nor right aliases encountered in JOIN");
    public static final /* enum */ ErrorMsg INVALID_JOIN_CONDITION_3 = new ErrorMsg(10019, "OR not supported in JOIN currently");
    public static final /* enum */ ErrorMsg INVALID_TRANSFORM = new ErrorMsg(10020, "TRANSFORM with other SELECT columns not supported");
    public static final /* enum */ ErrorMsg DUPLICATE_GROUPBY_KEY = new ErrorMsg(10021, "Repeated key in GROUP BY");
    public static final /* enum */ ErrorMsg NO_SUBQUERY_ALIAS = new ErrorMsg(10023, "No alias for subquery");
    public static final /* enum */ ErrorMsg NO_INSERT_INSUBQUERY = new ErrorMsg(10024, "Cannot insert in a subquery. Inserting to table ");
    public static final /* enum */ ErrorMsg NON_KEY_EXPR_IN_GROUPBY = new ErrorMsg(10025, "Expression not in GROUP BY key");
    public static final /* enum */ ErrorMsg INVALID_XPATH = new ErrorMsg(10026, "General . and [] operators are not supported");
    public static final /* enum */ ErrorMsg INVALID_PATH = new ErrorMsg(10027, "Invalid path");
    public static final /* enum */ ErrorMsg ILLEGAL_PATH = new ErrorMsg(10028, "Path is not legal");
    public static final /* enum */ ErrorMsg INVALID_NUMERICAL_CONSTANT = new ErrorMsg(10029, "Invalid numerical constant");
    public static final /* enum */ ErrorMsg INVALID_ARRAYINDEX_CONSTANT = new ErrorMsg(10030, "Non-constant expressions for array indexes not supported");
    public static final /* enum */ ErrorMsg INVALID_MAPINDEX_CONSTANT = new ErrorMsg(10031, "Non-constant expression for map indexes not supported");
    public static final /* enum */ ErrorMsg INVALID_MAPINDEX_TYPE = new ErrorMsg(10032, "MAP key type does not match index expression type");
    public static final /* enum */ ErrorMsg NON_COLLECTION_TYPE = new ErrorMsg(10033, "[] not valid on non-collection types");
    public static final /* enum */ ErrorMsg SELECT_DISTINCT_WITH_GROUPBY = new ErrorMsg(10034, "SELECT DISTINCT and GROUP BY can not be in the same query");
    public static final /* enum */ ErrorMsg COLUMN_REPEATED_IN_PARTITIONING_COLS = new ErrorMsg(10035, "Column repeated in partitioning columns");
    public static final /* enum */ ErrorMsg DUPLICATE_COLUMN_NAMES = new ErrorMsg(10036, "Duplicate column name:");
    public static final /* enum */ ErrorMsg INVALID_BUCKET_NUMBER = new ErrorMsg(10037, "Bucket number should be bigger than zero");
    public static final /* enum */ ErrorMsg COLUMN_REPEATED_IN_CLUSTER_SORT = new ErrorMsg(10038, "Same column cannot appear in CLUSTER BY and SORT BY");
    public static final /* enum */ ErrorMsg SAMPLE_RESTRICTION = new ErrorMsg(10039, "Cannot SAMPLE on more than two columns");
    public static final /* enum */ ErrorMsg SAMPLE_COLUMN_NOT_FOUND = new ErrorMsg(10040, "SAMPLE column not found");
    public static final /* enum */ ErrorMsg NO_PARTITION_PREDICATE = new ErrorMsg(10041, "No partition predicate found");
    public static final /* enum */ ErrorMsg INVALID_DOT = new ErrorMsg(10042, ". Operator is only supported on struct or list of struct types");
    public static final /* enum */ ErrorMsg INVALID_TBL_DDL_SERDE = new ErrorMsg(10043, "Either list of columns or a custom serializer should be specified");
    public static final /* enum */ ErrorMsg TARGET_TABLE_COLUMN_MISMATCH = new ErrorMsg(10044, "Cannot insert into target table because column number/types are different");
    public static final /* enum */ ErrorMsg TABLE_ALIAS_NOT_ALLOWED = new ErrorMsg(10045, "Table alias not allowed in sampling clause");
    public static final /* enum */ ErrorMsg CLUSTERBY_DISTRIBUTEBY_CONFLICT = new ErrorMsg(10046, "Cannot have both CLUSTER BY and DISTRIBUTE BY clauses");
    public static final /* enum */ ErrorMsg ORDERBY_DISTRIBUTEBY_CONFLICT = new ErrorMsg(10047, "Cannot have both ORDER BY and DISTRIBUTE BY clauses");
    public static final /* enum */ ErrorMsg CLUSTERBY_SORTBY_CONFLICT = new ErrorMsg(10048, "Cannot have both CLUSTER BY and SORT BY clauses");
    public static final /* enum */ ErrorMsg ORDERBY_SORTBY_CONFLICT = new ErrorMsg(10049, "Cannot have both ORDER BY and SORT BY clauses");
    public static final /* enum */ ErrorMsg CLUSTERBY_ORDERBY_CONFLICT = new ErrorMsg(10050, "Cannot have both CLUSTER BY and ORDER BY clauses");
    public static final /* enum */ ErrorMsg NO_LIMIT_WITH_ORDERBY = new ErrorMsg(10051, "In strict mode, if ORDER BY is specified, LIMIT must also be specified");
    public static final /* enum */ ErrorMsg NO_CARTESIAN_PRODUCT = new ErrorMsg(10052, "In strict mode, cartesian product is not allowed. If you really want to perform the operation, set hive.mapred.mode=nonstrict");
    public static final /* enum */ ErrorMsg UNION_NOTIN_SUBQ = new ErrorMsg(10053, "Top level UNION is not supported currently; use a subquery for the UNION");
    public static final /* enum */ ErrorMsg INVALID_INPUT_FORMAT_TYPE = new ErrorMsg(10054, "Input format must implement InputFormat");
    public static final /* enum */ ErrorMsg INVALID_OUTPUT_FORMAT_TYPE = new ErrorMsg(10055, "Output Format must implement HiveOutputFormat, otherwise it should be either IgnoreKeyTextOutputFormat or SequenceFileOutputFormat");
    public static final /* enum */ ErrorMsg NO_VALID_PARTN = new ErrorMsg(10056, "The query does not reference any valid partition. To run this query, set hive.mapred.mode=nonstrict");
    public static final /* enum */ ErrorMsg NO_OUTER_MAPJOIN = new ErrorMsg(10057, "MAPJOIN cannot be performed with OUTER JOIN");
    public static final /* enum */ ErrorMsg INVALID_MAPJOIN_HINT = new ErrorMsg(10058, "All tables are specified as map-table for join");
    public static final /* enum */ ErrorMsg INVALID_MAPJOIN_TABLE = new ErrorMsg(10059, "Result of a union cannot be a map table");
    public static final /* enum */ ErrorMsg NON_BUCKETED_TABLE = new ErrorMsg(10060, "Sampling expression needed for non-bucketed table");
    public static final /* enum */ ErrorMsg BUCKETED_NUMERATOR_BIGGER_DENOMINATOR = new ErrorMsg(10061, "Numerator should not be bigger than denominator in sample clause for table");
    public static final /* enum */ ErrorMsg NEED_PARTITION_ERROR = new ErrorMsg(10062, "Need to specify partition columns because the destination table is partitioned");
    public static final /* enum */ ErrorMsg CTAS_CTLT_COEXISTENCE = new ErrorMsg(10063, "Create table command does not allow LIKE and AS-SELECT in the same command");
    public static final /* enum */ ErrorMsg LINES_TERMINATED_BY_NON_NEWLINE = new ErrorMsg(10064, "LINES TERMINATED BY only supports newline '\\n' right now");
    public static final /* enum */ ErrorMsg CTAS_COLLST_COEXISTENCE = new ErrorMsg(10065, "CREATE TABLE AS SELECT command cannot specify the list of columns for the target table");
    public static final /* enum */ ErrorMsg CTLT_COLLST_COEXISTENCE = new ErrorMsg(10066, "CREATE TABLE LIKE command cannot specify the list of columns for the target table");
    public static final /* enum */ ErrorMsg INVALID_SELECT_SCHEMA = new ErrorMsg(10067, "Cannot derive schema from the select-clause");
    public static final /* enum */ ErrorMsg CTAS_PARCOL_COEXISTENCE = new ErrorMsg(10068, "CREATE-TABLE-AS-SELECT does not support partitioning in the target table ");
    public static final /* enum */ ErrorMsg CTAS_MULTI_LOADFILE = new ErrorMsg(10069, "CREATE-TABLE-AS-SELECT results in multiple file load");
    public static final /* enum */ ErrorMsg CTAS_EXTTBL_COEXISTENCE = new ErrorMsg(10070, "CREATE-TABLE-AS-SELECT cannot create external table");
    public static final /* enum */ ErrorMsg INSERT_EXTERNAL_TABLE = new ErrorMsg(10071, "Inserting into a external table is not allowed");
    public static final /* enum */ ErrorMsg DATABASE_NOT_EXISTS = new ErrorMsg(10072, "Database does not exist:");
    public static final /* enum */ ErrorMsg TABLE_ALREADY_EXISTS = new ErrorMsg(10073, "Table already exists:", "42S02");
    public static final /* enum */ ErrorMsg COLUMN_ALIAS_ALREADY_EXISTS = new ErrorMsg(10074, "Column alias already exists:", "42S02");
    public static final /* enum */ ErrorMsg UDTF_MULTIPLE_EXPR = new ErrorMsg(10075, "Only a single expression in the SELECT clause is supported with UDTF's");
    public static final /* enum */ ErrorMsg UDTF_REQUIRE_AS = new ErrorMsg(10076, "UDTF's require an AS clause");
    public static final /* enum */ ErrorMsg UDTF_NO_GROUP_BY = new ErrorMsg(10077, "GROUP BY is not supported with a UDTF in the SELECT clause");
    public static final /* enum */ ErrorMsg UDTF_NO_SORT_BY = new ErrorMsg(10078, "SORT BY is not supported with a UDTF in the SELECT clause");
    public static final /* enum */ ErrorMsg UDTF_NO_CLUSTER_BY = new ErrorMsg(10079, "CLUSTER BY is not supported with a UDTF in the SELECT clause");
    public static final /* enum */ ErrorMsg UDTF_NO_DISTRIBUTE_BY = new ErrorMsg(10080, "DISTRUBTE BY is not supported with a UDTF in the SELECT clause");
    public static final /* enum */ ErrorMsg UDTF_INVALID_LOCATION = new ErrorMsg(10081, "UDTF's are not supported outside the SELECT clause, nor nested in expressions");
    public static final /* enum */ ErrorMsg UDTF_LATERAL_VIEW = new ErrorMsg(10082, "UDTF's cannot be in a select expression when there is a lateral view");
    public static final /* enum */ ErrorMsg UDTF_ALIAS_MISMATCH = new ErrorMsg(10083, "The number of aliases supplied in the AS clause does not match the number of columns output by the UDTF");
    public static final /* enum */ ErrorMsg UDF_STATEFUL_INVALID_LOCATION = new ErrorMsg(10084, "Stateful UDF's can only be invoked in the SELECT list");
    public static final /* enum */ ErrorMsg LATERAL_VIEW_WITH_JOIN = new ErrorMsg(10085, "JOIN with a LATERAL VIEW is not supported");
    public static final /* enum */ ErrorMsg LATERAL_VIEW_INVALID_CHILD = new ErrorMsg(10086, "LATERAL VIEW AST with invalid child");
    public static final /* enum */ ErrorMsg OUTPUT_SPECIFIED_MULTIPLE_TIMES = new ErrorMsg(10087, "The same output cannot be present multiple times: ");
    public static final /* enum */ ErrorMsg INVALID_AS = new ErrorMsg(10088, "AS clause has an invalid number of aliases");
    public static final /* enum */ ErrorMsg VIEW_COL_MISMATCH = new ErrorMsg(10089, "The number of columns produced by the SELECT clause does not match the number of column names specified by CREATE VIEW");
    public static final /* enum */ ErrorMsg DML_AGAINST_VIEW = new ErrorMsg(10090, "A view cannot be used as target table for LOAD or INSERT");
    public static final /* enum */ ErrorMsg ANALYZE_VIEW = new ErrorMsg(10091, "ANALYZE is not supported for views");
    public static final /* enum */ ErrorMsg VIEW_PARTITION_TOTAL = new ErrorMsg(10092, "At least one non-partitioning column must be present in view");
    public static final /* enum */ ErrorMsg VIEW_PARTITION_MISMATCH = new ErrorMsg(10093, "Rightmost columns in view output do not match PARTITIONED ON clause");
    public static final /* enum */ ErrorMsg PARTITION_DYN_STA_ORDER = new ErrorMsg(10094, "Dynamic partition cannot be the parent of a static partition");
    public static final /* enum */ ErrorMsg DYNAMIC_PARTITION_DISABLED = new ErrorMsg(10095, "Dynamic partition is disabled. Either enable it by setting hive.exec.dynamic.partition=true or specify partition column values");
    public static final /* enum */ ErrorMsg DYNAMIC_PARTITION_STRICT_MODE = new ErrorMsg(10096, "Dynamic partition strict mode requires at least one static partition column. To turn this off set hive.exec.dynamic.partition.mode=nonstrict");
    public static final /* enum */ ErrorMsg NONEXISTPARTCOL = new ErrorMsg(10098, "Non-Partition column appears in the partition specification: ");
    public static final /* enum */ ErrorMsg UNSUPPORTED_TYPE = new ErrorMsg(10099, "DATE and DATETIME types aren't supported yet. Please use TIMESTAMP instead");
    public static final /* enum */ ErrorMsg CREATE_NON_NATIVE_AS = new ErrorMsg(10100, "CREATE TABLE AS SELECT cannot be used for a non-native table");
    public static final /* enum */ ErrorMsg LOAD_INTO_NON_NATIVE = new ErrorMsg(10101, "A non-native table cannot be used as target for LOAD");
    public static final /* enum */ ErrorMsg LOCKMGR_NOT_SPECIFIED = new ErrorMsg(10102, "Lock manager not specified correctly, set hive.lock.manager");
    public static final /* enum */ ErrorMsg LOCKMGR_NOT_INITIALIZED = new ErrorMsg(10103, "Lock manager could not be initialized, check hive.lock.manager ");
    public static final /* enum */ ErrorMsg LOCK_CANNOT_BE_ACQUIRED = new ErrorMsg(10104, "Locks on the underlying objects cannot be acquired. retry after some time");
    public static final /* enum */ ErrorMsg ZOOKEEPER_CLIENT_COULD_NOT_BE_INITIALIZED = new ErrorMsg(10105, "Check hive.zookeeper.quorum and hive.zookeeper.client.port");
    public static final /* enum */ ErrorMsg OVERWRITE_ARCHIVED_PART = new ErrorMsg(10106, "Cannot overwrite an archived partition. Unarchive before running this command");
    public static final /* enum */ ErrorMsg ARCHIVE_METHODS_DISABLED = new ErrorMsg(10107, "Archiving methods are currently disabled. Please see the Hive wiki for more information about enabling archiving");
    public static final /* enum */ ErrorMsg ARCHIVE_ON_MULI_PARTS = new ErrorMsg(10108, "ARCHIVE can only be run on a single partition");
    public static final /* enum */ ErrorMsg UNARCHIVE_ON_MULI_PARTS = new ErrorMsg(10109, "ARCHIVE can only be run on a single partition");
    public static final /* enum */ ErrorMsg ARCHIVE_ON_TABLE = new ErrorMsg(10110, "ARCHIVE can only be run on partitions");
    public static final /* enum */ ErrorMsg RESERVED_PART_VAL = new ErrorMsg(10111, "Partition value contains a reserved substring");
    public static final /* enum */ ErrorMsg HOLD_DDLTIME_ON_NONEXIST_PARTITIONS = new ErrorMsg(10112, "HOLD_DDLTIME hint cannot be applied to dynamic partitions or non-existent partitions");
    public static final /* enum */ ErrorMsg OFFLINE_TABLE_OR_PARTITION = new ErrorMsg(10113, "Query against an offline table or partition");
    public static final /* enum */ ErrorMsg OUTERJOIN_USES_FILTERS = new ErrorMsg(10114, "The query results could be wrong. Turn on hive.outerjoin.supports.filters");
    public static final /* enum */ ErrorMsg NEED_PARTITION_SPECIFICATION = new ErrorMsg(10115, "Table is partitioned and partition specification is needed");
    public static final /* enum */ ErrorMsg INVALID_METADATA = new ErrorMsg(10116, "The metadata file could not be parsed ");
    public static final /* enum */ ErrorMsg NEED_TABLE_SPECIFICATION = new ErrorMsg(10117, "Table name could be determined; It should be specified ");
    public static final /* enum */ ErrorMsg PARTITION_EXISTS = new ErrorMsg(10118, "Partition already exists");
    public static final /* enum */ ErrorMsg TABLE_DATA_EXISTS = new ErrorMsg(10119, "Table exists and contains data files");
    public static final /* enum */ ErrorMsg INCOMPATIBLE_SCHEMA = new ErrorMsg(10120, "The existing table is not compatible with the import spec. ");
    public static final /* enum */ ErrorMsg EXIM_FOR_NON_NATIVE = new ErrorMsg(10121, "Export/Import cannot be done for a non-native table. ");
    public static final /* enum */ ErrorMsg INSERT_INTO_BUCKETIZED_TABLE = new ErrorMsg(10122, "Bucketized tables do not support INSERT INTO:");
    public static final /* enum */ ErrorMsg NO_COMPARE_BIGINT_STRING = new ErrorMsg(10123, "In strict mode, comparing bigints and strings is not allowed, it may result in a loss of precision. If you really want to perform the operation, set hive.mapred.mode=nonstrict");
    public static final /* enum */ ErrorMsg NO_COMPARE_BIGINT_DOUBLE = new ErrorMsg(10124, "In strict mode, comparing bigints and doubles is not allowed, it may result in a loss of precision. If you really want to perform the operation, set hive.mapred.mode=nonstrict");
    public static final /* enum */ ErrorMsg PARTSPEC_DIFFER_FROM_SCHEMA = new ErrorMsg(10125, "Partition columns in partition specification are not the same as that defined in the table schema. The names and orders have to be exactly the same.");
    public static final /* enum */ ErrorMsg PARTITION_COLUMN_NON_PRIMITIVE = new ErrorMsg(10126, "Partition column must be of primitive type.");
    public static final /* enum */ ErrorMsg INSERT_INTO_DYNAMICPARTITION_IFNOTEXISTS = new ErrorMsg(10127, "Dynamic partitions do not support IF NOT EXISTS. Specified partitions with value :");
    public static final /* enum */ ErrorMsg UDAF_INVALID_LOCATION = new ErrorMsg(10128, "Not yet supported place for UDAF");
    public static final /* enum */ ErrorMsg DROP_PARTITION_NON_STRING_PARTCOLS_NONEQUALITY = new ErrorMsg(10129, "Drop partitions for a non string partition columns is not allowed using non-equality");
    public static final /* enum */ ErrorMsg ALTER_COMMAND_FOR_VIEWS = new ErrorMsg(10131, "To alter a view you need to use the ALTER VIEW command.");
    public static final /* enum */ ErrorMsg ALTER_COMMAND_FOR_TABLES = new ErrorMsg(10132, "To alter a base table you need to use the ALTER TABLE command.");
    public static final /* enum */ ErrorMsg ALTER_VIEW_DISALLOWED_OP = new ErrorMsg(10133, "Cannot use this form of ALTER on a view");
    public static final /* enum */ ErrorMsg ALTER_TABLE_NON_NATIVE = new ErrorMsg(10134, "ALTER TABLE cannot be used for a non-native table");
    public static final /* enum */ ErrorMsg SORTMERGE_MAPJOIN_FAILED = new ErrorMsg(10135, "Sort merge bucketed join could not be performed. If you really want to perform the operation, either set hive.optimize.bucketmapjoin.sortedmerge=false, or set hive.enforce.sortmergebucketmapjoin=false.");
    public static final /* enum */ ErrorMsg BUCKET_MAPJOIN_NOT_POSSIBLE = new ErrorMsg(10136, "Bucketed mapjoin cannot be performed. This can be due to multiple reasons:  . Join columns dont match bucketed columns.  . Number of buckets are not a multiple of each other. If you really want to perform the operation, either remove the mapjoin hint from your query or set hive.enforce.bucketmapjoin to false.");
    public static final /* enum */ ErrorMsg BUCKETED_TABLE_METADATA_INCORRECT = new ErrorMsg(10141, "Bucketed table metadata is not correct. Fix the metadata or don't use bucketed mapjoin, by setting hive.enforce.bucketmapjoin to false.");
    public static final /* enum */ ErrorMsg JOINNODE_OUTERJOIN_MORETHAN_16 = new ErrorMsg(10142, "Single join node containing outer join(s) cannot have more than 16 aliases");
    public static final /* enum */ ErrorMsg INVALID_JDO_FILTER_EXPRESSION = new ErrorMsg(10043, "Invalid expression for JDO filter");
    public static final /* enum */ ErrorMsg SHOW_CREATETABLE_INDEX = new ErrorMsg(10144, "SHOW CREATE TABLE does not support tables of type INDEX_TABLE.");
    public static final /* enum */ ErrorMsg ALTER_BUCKETNUM_NONBUCKETIZED_TBL = new ErrorMsg(10145, "Table is not bucketized.");
    public static final /* enum */ ErrorMsg TRUNCATE_FOR_NON_MANAGED_TABLE = new ErrorMsg(10146, "Cannot truncate non-managed table {0}.", true);
    public static final /* enum */ ErrorMsg TRUNCATE_FOR_NON_NATIVE_TABLE = new ErrorMsg(10147, "Cannot truncate non-native table {0}.", true);
    public static final /* enum */ ErrorMsg PARTSPEC_FOR_NON_PARTITIONED_TABLE = new ErrorMsg(10148, "Partition spec for non partitioned table {0}.", true);
    public static final /* enum */ ErrorMsg LOAD_INTO_STORED_AS_DIR = new ErrorMsg(10195, "A stored-as-directories table cannot be used as target for LOAD");
    public static final /* enum */ ErrorMsg ALTER_TBL_STOREDASDIR_NOT_SKEWED = new ErrorMsg(10196, "This operation is only valid on skewed table.");
    public static final /* enum */ ErrorMsg ALTER_TBL_SKEWED_LOC_NO_LOC = new ErrorMsg(10197, "Alter table skewed location doesn't have locations.");
    public static final /* enum */ ErrorMsg ALTER_TBL_SKEWED_LOC_NO_MAP = new ErrorMsg(10198, "Alter table skewed location doesn't have location map.");
    public static final /* enum */ ErrorMsg SUPPORT_DIR_MUST_TRUE_FOR_LIST_BUCKETING = new ErrorMsg(10199, "hive.mapred.supports.subdirectories must be true if any one of following is true:  hive.optimize.listbucketing , mapred.input.dir.recursive and hive.optimize.union.remove.");
    public static final /* enum */ ErrorMsg SKEWED_TABLE_NO_COLUMN_NAME = new ErrorMsg(10200, "No skewed column name.");
    public static final /* enum */ ErrorMsg SKEWED_TABLE_NO_COLUMN_VALUE = new ErrorMsg(10201, "No skewed values.");
    public static final /* enum */ ErrorMsg SKEWED_TABLE_DUPLICATE_COLUMN_NAMES = new ErrorMsg(10202, "Duplicate skewed column name:");
    public static final /* enum */ ErrorMsg SKEWED_TABLE_INVALID_COLUMN = new ErrorMsg(10203, "Invalid skewed column name:");
    public static final /* enum */ ErrorMsg SKEWED_TABLE_SKEWED_COL_NAME_VALUE_MISMATCH_1 = new ErrorMsg(10204, "Skewed column name is empty but skewed value is not.");
    public static final /* enum */ ErrorMsg SKEWED_TABLE_SKEWED_COL_NAME_VALUE_MISMATCH_2 = new ErrorMsg(10205, "Skewed column value is empty but skewed name is not.");
    public static final /* enum */ ErrorMsg SKEWED_TABLE_SKEWED_COL_NAME_VALUE_MISMATCH_3 = new ErrorMsg(10206, "The number of skewed column names and the number of skewed column values are different: ");
    public static final /* enum */ ErrorMsg ALTER_TABLE_NOT_ALLOWED_RENAME_SKEWED_COLUMN = new ErrorMsg(10207, " is a skewed column. It's not allowed to rename skewed column or change skewed column type.");
    public static final /* enum */ ErrorMsg HIVE_GROUPING_SETS_AGGR_NOMAPAGGR = new ErrorMsg(10209, "Grouping sets aggregations (with rollups or cubes) are not allowed if map-side  aggregation is turned off. Set hive.map.aggr=true if you want to use grouping sets");
    public static final /* enum */ ErrorMsg HIVE_GROUPING_SETS_AGGR_EXPRESSION_INVALID = new ErrorMsg(10210, "Grouping sets aggregations (with rollups or cubes) are not allowed if aggregation function parameters overlap with the aggregation functions columns");
    public static final /* enum */ ErrorMsg HIVE_GROUPING_SETS_AGGR_NOFUNC = new ErrorMsg(10211, "Grouping sets aggregations are not allowed if no aggregation function is presented");
    public static final /* enum */ ErrorMsg HIVE_UNION_REMOVE_OPTIMIZATION_NEEDS_SUBDIRECTORIES = new ErrorMsg(10212, "In order to use hive.optimize.union.remove, the hadoop version that you are using should support sub-directories for tables/partitions. If that is true, set hive.hadoop.supports.subdirectories to true. Otherwise, set hive.optimize.union.remove to false");
    public static final /* enum */ ErrorMsg HIVE_GROUPING_SETS_EXPR_NOT_IN_GROUPBY = new ErrorMsg(10213, "Grouping sets expression is not in GROUP BY key");
    public static final /* enum */ ErrorMsg INVALID_PARTITION_SPEC = new ErrorMsg(10214, "Invalid partition spec specified");
    public static final /* enum */ ErrorMsg ALTER_TBL_UNSET_NON_EXIST_PROPERTY = new ErrorMsg(10215, "Please use the following syntax if not sure whether the property existed or not:\nALTER TABLE tableName UNSET TBLPROPERTIES IF EXISTS (key1, key2, ...)\n");
    public static final /* enum */ ErrorMsg ALTER_VIEW_AS_SELECT_NOT_EXIST = new ErrorMsg(10216, "Cannot ALTER VIEW AS SELECT if view currently does not exist\n");
    public static final /* enum */ ErrorMsg REPLACE_VIEW_WITH_PARTITION = new ErrorMsg(10217, "Cannot replace a view with CREATE VIEW or REPLACE VIEW or ALTER VIEW AS SELECT if the view has paritions\n");
    public static final /* enum */ ErrorMsg EXISTING_TABLE_IS_NOT_VIEW = new ErrorMsg(10218, "Existing table is not a view\n");
    public static final /* enum */ ErrorMsg NO_SUPPORTED_ORDERBY_ALLCOLREF_POS = new ErrorMsg(10219, "Position in ORDER BY is not supported when using SELECT *");
    public static final /* enum */ ErrorMsg INVALID_POSITION_ALIAS_IN_GROUPBY = new ErrorMsg(10220, "Invalid position alias in Group By\n");
    public static final /* enum */ ErrorMsg INVALID_POSITION_ALIAS_IN_ORDERBY = new ErrorMsg(10221, "Invalid position alias in Order By\n");
    public static final /* enum */ ErrorMsg HIVE_GROUPING_SETS_THRESHOLD_NOT_ALLOWED_WITH_SKEW = new ErrorMsg(10225, "An additional MR job is introduced since the number of rows created per input row due to grouping sets is more than hive.new.job.grouping.set.cardinality. There is no need to handle skew separately. set hive.groupby.skewindata to false.");
    public static final /* enum */ ErrorMsg HIVE_GROUPING_SETS_THRESHOLD_NOT_ALLOWED_WITH_DISTINCTS = new ErrorMsg(10226, "An additional MR job is introduced since the cardinality of grouping sets is more than hive.new.job.grouping.set.cardinality. This functionality is not supported with distincts. Either set hive.new.job.grouping.set.cardinality to a high number (higher than the number of rows per input row due to grouping sets in the query), or rewrite the query to not use distincts.");
    public static final /* enum */ ErrorMsg OPERATOR_NOT_ALLOWED_WITH_MAPJOIN = new ErrorMsg(10227, "Not all clauses are supported with mapjoin hint. Please remove mapjoin hint.");
    public static final /* enum */ ErrorMsg ANALYZE_TABLE_NOSCAN_NON_NATIVE = new ErrorMsg(10228, "ANALYZE TABLE NOSCAN cannot be used for a non-native table");
    public static final /* enum */ ErrorMsg ANALYZE_TABLE_PARTIALSCAN_NON_NATIVE = new ErrorMsg(10229, "ANALYZE TABLE PARTIALSCAN cannot be used for a non-native table");
    public static final /* enum */ ErrorMsg ANALYZE_TABLE_PARTIALSCAN_NON_RCFILE = new ErrorMsg(10230, "ANALYZE TABLE PARTIALSCAN doesn't support non-RCfile. ");
    public static final /* enum */ ErrorMsg ANALYZE_TABLE_PARTIALSCAN_EXTERNAL_TABLE = new ErrorMsg(10231, "ANALYZE TABLE PARTIALSCAN doesn't support external table: ");
    public static final /* enum */ ErrorMsg ANALYZE_TABLE_PARTIALSCAN_AGGKEY = new ErrorMsg(10232, "Analyze partialscan command fails to construct aggregation for the partition ");
    public static final /* enum */ ErrorMsg ANALYZE_TABLE_PARTIALSCAN_AUTOGATHER = new ErrorMsg(10233, "Analyze partialscan is not allowed if hive.stats.autogather is set to false");
    public static final /* enum */ ErrorMsg SCRIPT_INIT_ERROR = new ErrorMsg(20000, "Unable to initialize custom script.");
    public static final /* enum */ ErrorMsg SCRIPT_IO_ERROR = new ErrorMsg(20001, "An error occurred while reading or writing to your custom script. It may have crashed with an error.");
    public static final /* enum */ ErrorMsg SCRIPT_GENERIC_ERROR = new ErrorMsg(20002, "Hive encountered some unknown error while running your custom script.");
    public static final /* enum */ ErrorMsg SCRIPT_CLOSING_ERROR = new ErrorMsg(20003, "An error occurred when trying to close the Operator running your custom script.");
    public static final /* enum */ ErrorMsg STATSPUBLISHER_NOT_OBTAINED = new ErrorMsg(30000, "StatsPublisher cannot be obtained. There was a error to retrieve the StatsPublisher, and retrying might help. If you dont want the query to fail because accurate statistics could not be collected, set hive.stats.reliable=false");
    public static final /* enum */ ErrorMsg STATSPUBLISHER_INITIALIZATION_ERROR = new ErrorMsg(30001, "StatsPublisher cannot be initialized. There was a error in the initialization of StatsPublisher, and retrying might help. If you dont want the query to fail because accurate statistics could not be collected, set hive.stats.reliable=false");
    public static final /* enum */ ErrorMsg STATSPUBLISHER_CONNECTION_ERROR = new ErrorMsg(30002, "StatsPublisher cannot be connected to.There was a error while connecting to the StatsPublisher, and retrying might help. If you dont want the query to fail because accurate statistics could not be collected, set hive.stats.reliable=false");
    public static final /* enum */ ErrorMsg STATSPUBLISHER_PUBLISHING_ERROR = new ErrorMsg(30003, "Error in publishing stats. There was an error in publishing stats via StatsPublisher, and retrying might help. If you dont want the query to fail because accurate statistics could not be collected, set hive.stats.reliable=false");
    public static final /* enum */ ErrorMsg STATSPUBLISHER_CLOSING_ERROR = new ErrorMsg(30004, "StatsPublisher cannot be closed.There was a error while closing the StatsPublisher, and retrying might help. If you dont want the query to fail because accurate statistics could not be collected, set hive.stats.reliable=false");
    public static final /* enum */ ErrorMsg COLUMNSTATSCOLLECTOR_INVALID_PART_KEY = new ErrorMsg(30005, "Invalid partitioning key specified in ANALYZE statement");
    public static final /* enum */ ErrorMsg COLUMNSTATSCOLLECTOR_INCORRECT_NUM_PART_KEY = new ErrorMsg(30006, "Incorrect number of partitioning key specified in ANALYZE statement");
    public static final /* enum */ ErrorMsg COLUMNSTATSCOLLECTOR_INVALID_PARTITION = new ErrorMsg(30007, "Invalid partitioning key/value specified in ANALYZE statement");
    public static final /* enum */ ErrorMsg COLUMNSTATSCOLLECTOR_INVALID_SYNTAX = new ErrorMsg(30008, "Dynamic partitioning is not supported yet while gathering column statistics through ANALYZE statement");
    public static final /* enum */ ErrorMsg COLUMNSTATSCOLLECTOR_PARSE_ERROR = new ErrorMsg(30009, "Encountered parse error while parsing rewritten query");
    public static final /* enum */ ErrorMsg COLUMNSTATSCOLLECTOR_IO_ERROR = new ErrorMsg(30010, "Encountered I/O exception while parsing rewritten query");
    public static final /* enum */ ErrorMsg DROP_COMMAND_NOT_ALLOWED_FOR_PARTITION = new ErrorMsg(30011, "Partition protected from being dropped");
    private int errorCode;
    private String mesg;
    private String sqlState;
    private MessageFormat format;
    private static final char SPACE = ' ';
    private static final Pattern ERROR_MESSAGE_PATTERN;
    private static final Pattern ERROR_CODE_PATTERN;
    private static Map<String, ErrorMsg> mesgToErrorMsgMap;
    private static Map<Pattern, ErrorMsg> formatToErrorMsgMap;
    private static int minMesgLength;
    private static final /* synthetic */ ErrorMsg[] $VALUES;

    public static ErrorMsg[] values() {
        return (ErrorMsg[])$VALUES.clone();
    }

    public static ErrorMsg valueOf(String name) {
        return Enum.valueOf(ErrorMsg.class, name);
    }

    public static ErrorMsg getErrorMsg(String mesg) {
        if (mesg == null) {
            return GENERIC_ERROR;
        }
        ErrorMsg errorMsg = mesgToErrorMsgMap.get(mesg);
        if (errorMsg != null) {
            return errorMsg;
        }
        for (Map.Entry<Pattern, ErrorMsg> entry : formatToErrorMsgMap.entrySet()) {
            if (!entry.getKey().matcher(mesg).matches()) continue;
            return entry.getValue();
        }
        String truncatedMesg = mesg.trim();
        Matcher match = ERROR_MESSAGE_PATTERN.matcher(mesg);
        if (match.matches()) {
            truncatedMesg = match.group(1);
        }
        while (truncatedMesg.length() > minMesgLength) {
            errorMsg = mesgToErrorMsgMap.get(truncatedMesg.trim());
            if (errorMsg != null) {
                return errorMsg;
            }
            int lastSpace = truncatedMesg.lastIndexOf(32);
            if (lastSpace == -1) break;
            truncatedMesg = truncatedMesg.substring(0, lastSpace).trim();
        }
        return GENERIC_ERROR;
    }

    public static ErrorMsg getErrorMsg(int errorCode) {
        for (ErrorMsg errorMsg : ErrorMsg.values()) {
            if (errorMsg.getErrorCode() != errorCode) continue;
            return errorMsg;
        }
        return null;
    }

    public static String findSQLState(String mesg) {
        ErrorMsg error = ErrorMsg.getErrorMsg(mesg);
        return error.getSQLState();
    }

    private ErrorMsg(int errorCode, String mesg) {
        this(errorCode, mesg, "42000", false);
    }

    private ErrorMsg(int errorCode, String mesg, boolean format) {
        this(errorCode, mesg, "42000", format);
    }

    private ErrorMsg(int errorCode, String mesg, String sqlState) {
        this(errorCode, mesg, sqlState, false);
    }

    private ErrorMsg(int errorCode, String mesg, String sqlState, boolean format) {
        this.errorCode = errorCode;
        this.mesg = mesg;
        this.sqlState = sqlState;
        this.format = format ? new MessageFormat(mesg) : null;
    }

    private static int getLine(ASTNode tree) {
        if (tree.getChildCount() == 0) {
            return tree.getToken().getLine();
        }
        return ErrorMsg.getLine((ASTNode)tree.getChild(0));
    }

    private static int getCharPositionInLine(ASTNode tree) {
        if (tree.getChildCount() == 0) {
            return tree.getToken().getCharPositionInLine();
        }
        return ErrorMsg.getCharPositionInLine((ASTNode)tree.getChild(0));
    }

    public static String getText(ASTNode tree) {
        if (tree.getChildCount() == 0) {
            return tree.getText();
        }
        return ErrorMsg.getText((ASTNode)tree.getChild(tree.getChildCount() - 1));
    }

    public String getMsg(ASTNode tree) {
        StringBuilder sb = new StringBuilder();
        ErrorMsg.renderPosition(sb, tree);
        sb.append(" ");
        sb.append(this.mesg);
        sb.append(" '");
        sb.append(ErrorMsg.getText(tree));
        sb.append("'");
        ErrorMsg.renderOrigin(sb, tree.getOrigin());
        return sb.toString();
    }

    public static void renderOrigin(StringBuilder sb, ASTNodeOrigin origin) {
        while (origin != null) {
            sb.append(" in definition of ");
            sb.append(origin.getObjectType());
            sb.append(" ");
            sb.append(origin.getObjectName());
            sb.append(" [");
            sb.append(HiveUtils.LINE_SEP);
            sb.append(origin.getObjectDefinition());
            sb.append(HiveUtils.LINE_SEP);
            sb.append("] used as ");
            sb.append(origin.getUsageAlias());
            sb.append(" at ");
            ASTNode usageNode = origin.getUsageNode();
            ErrorMsg.renderPosition(sb, usageNode);
            origin = usageNode.getOrigin();
        }
    }

    private static void renderPosition(StringBuilder sb, ASTNode tree) {
        sb.append("Line ");
        sb.append(ErrorMsg.getLine(tree));
        sb.append(":");
        sb.append(ErrorMsg.getCharPositionInLine(tree));
    }

    public String getMsg(Tree tree) {
        return this.getMsg((ASTNode)tree);
    }

    public String getMsg(ASTNode tree, String reason) {
        return this.getMsg(tree) + ": " + reason;
    }

    public String getMsg(Tree tree, String reason) {
        return this.getMsg((ASTNode)tree, reason);
    }

    public String getMsg(String reason) {
        return this.mesg + " " + reason;
    }

    public String format(String reason) {
        return this.format(new String[]{reason});
    }

    public String format(String ... reasons) {
        assert (this.format != null);
        return this.format.format(reasons);
    }

    public String getErrorCodedMsg() {
        return "[Error " + this.errorCode + "]: " + this.mesg;
    }

    public static Pattern getErrorCodePattern() {
        return ERROR_CODE_PATTERN;
    }

    public String getMsg() {
        return this.mesg;
    }

    public String getSQLState() {
        return this.sqlState;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    static {
        $VALUES = new ErrorMsg[]{GENERIC_ERROR, INVALID_TABLE, INVALID_COLUMN, INVALID_INDEX, INVALID_TABLE_OR_COLUMN, AMBIGUOUS_TABLE_OR_COLUMN, INVALID_PARTITION, AMBIGUOUS_COLUMN, AMBIGUOUS_TABLE_ALIAS, INVALID_TABLE_ALIAS, NO_TABLE_ALIAS, INVALID_FUNCTION, INVALID_FUNCTION_SIGNATURE, INVALID_OPERATOR_SIGNATURE, INVALID_ARGUMENT, INVALID_ARGUMENT_LENGTH, INVALID_ARGUMENT_TYPE, INVALID_JOIN_CONDITION_1, INVALID_JOIN_CONDITION_2, INVALID_JOIN_CONDITION_3, INVALID_TRANSFORM, DUPLICATE_GROUPBY_KEY, NO_SUBQUERY_ALIAS, NO_INSERT_INSUBQUERY, NON_KEY_EXPR_IN_GROUPBY, INVALID_XPATH, INVALID_PATH, ILLEGAL_PATH, INVALID_NUMERICAL_CONSTANT, INVALID_ARRAYINDEX_CONSTANT, INVALID_MAPINDEX_CONSTANT, INVALID_MAPINDEX_TYPE, NON_COLLECTION_TYPE, SELECT_DISTINCT_WITH_GROUPBY, COLUMN_REPEATED_IN_PARTITIONING_COLS, DUPLICATE_COLUMN_NAMES, INVALID_BUCKET_NUMBER, COLUMN_REPEATED_IN_CLUSTER_SORT, SAMPLE_RESTRICTION, SAMPLE_COLUMN_NOT_FOUND, NO_PARTITION_PREDICATE, INVALID_DOT, INVALID_TBL_DDL_SERDE, TARGET_TABLE_COLUMN_MISMATCH, TABLE_ALIAS_NOT_ALLOWED, CLUSTERBY_DISTRIBUTEBY_CONFLICT, ORDERBY_DISTRIBUTEBY_CONFLICT, CLUSTERBY_SORTBY_CONFLICT, ORDERBY_SORTBY_CONFLICT, CLUSTERBY_ORDERBY_CONFLICT, NO_LIMIT_WITH_ORDERBY, NO_CARTESIAN_PRODUCT, UNION_NOTIN_SUBQ, INVALID_INPUT_FORMAT_TYPE, INVALID_OUTPUT_FORMAT_TYPE, NO_VALID_PARTN, NO_OUTER_MAPJOIN, INVALID_MAPJOIN_HINT, INVALID_MAPJOIN_TABLE, NON_BUCKETED_TABLE, BUCKETED_NUMERATOR_BIGGER_DENOMINATOR, NEED_PARTITION_ERROR, CTAS_CTLT_COEXISTENCE, LINES_TERMINATED_BY_NON_NEWLINE, CTAS_COLLST_COEXISTENCE, CTLT_COLLST_COEXISTENCE, INVALID_SELECT_SCHEMA, CTAS_PARCOL_COEXISTENCE, CTAS_MULTI_LOADFILE, CTAS_EXTTBL_COEXISTENCE, INSERT_EXTERNAL_TABLE, DATABASE_NOT_EXISTS, TABLE_ALREADY_EXISTS, COLUMN_ALIAS_ALREADY_EXISTS, UDTF_MULTIPLE_EXPR, UDTF_REQUIRE_AS, UDTF_NO_GROUP_BY, UDTF_NO_SORT_BY, UDTF_NO_CLUSTER_BY, UDTF_NO_DISTRIBUTE_BY, UDTF_INVALID_LOCATION, UDTF_LATERAL_VIEW, UDTF_ALIAS_MISMATCH, UDF_STATEFUL_INVALID_LOCATION, LATERAL_VIEW_WITH_JOIN, LATERAL_VIEW_INVALID_CHILD, OUTPUT_SPECIFIED_MULTIPLE_TIMES, INVALID_AS, VIEW_COL_MISMATCH, DML_AGAINST_VIEW, ANALYZE_VIEW, VIEW_PARTITION_TOTAL, VIEW_PARTITION_MISMATCH, PARTITION_DYN_STA_ORDER, DYNAMIC_PARTITION_DISABLED, DYNAMIC_PARTITION_STRICT_MODE, NONEXISTPARTCOL, UNSUPPORTED_TYPE, CREATE_NON_NATIVE_AS, LOAD_INTO_NON_NATIVE, LOCKMGR_NOT_SPECIFIED, LOCKMGR_NOT_INITIALIZED, LOCK_CANNOT_BE_ACQUIRED, ZOOKEEPER_CLIENT_COULD_NOT_BE_INITIALIZED, OVERWRITE_ARCHIVED_PART, ARCHIVE_METHODS_DISABLED, ARCHIVE_ON_MULI_PARTS, UNARCHIVE_ON_MULI_PARTS, ARCHIVE_ON_TABLE, RESERVED_PART_VAL, HOLD_DDLTIME_ON_NONEXIST_PARTITIONS, OFFLINE_TABLE_OR_PARTITION, OUTERJOIN_USES_FILTERS, NEED_PARTITION_SPECIFICATION, INVALID_METADATA, NEED_TABLE_SPECIFICATION, PARTITION_EXISTS, TABLE_DATA_EXISTS, INCOMPATIBLE_SCHEMA, EXIM_FOR_NON_NATIVE, INSERT_INTO_BUCKETIZED_TABLE, NO_COMPARE_BIGINT_STRING, NO_COMPARE_BIGINT_DOUBLE, PARTSPEC_DIFFER_FROM_SCHEMA, PARTITION_COLUMN_NON_PRIMITIVE, INSERT_INTO_DYNAMICPARTITION_IFNOTEXISTS, UDAF_INVALID_LOCATION, DROP_PARTITION_NON_STRING_PARTCOLS_NONEQUALITY, ALTER_COMMAND_FOR_VIEWS, ALTER_COMMAND_FOR_TABLES, ALTER_VIEW_DISALLOWED_OP, ALTER_TABLE_NON_NATIVE, SORTMERGE_MAPJOIN_FAILED, BUCKET_MAPJOIN_NOT_POSSIBLE, BUCKETED_TABLE_METADATA_INCORRECT, JOINNODE_OUTERJOIN_MORETHAN_16, INVALID_JDO_FILTER_EXPRESSION, SHOW_CREATETABLE_INDEX, ALTER_BUCKETNUM_NONBUCKETIZED_TBL, TRUNCATE_FOR_NON_MANAGED_TABLE, TRUNCATE_FOR_NON_NATIVE_TABLE, PARTSPEC_FOR_NON_PARTITIONED_TABLE, LOAD_INTO_STORED_AS_DIR, ALTER_TBL_STOREDASDIR_NOT_SKEWED, ALTER_TBL_SKEWED_LOC_NO_LOC, ALTER_TBL_SKEWED_LOC_NO_MAP, SUPPORT_DIR_MUST_TRUE_FOR_LIST_BUCKETING, SKEWED_TABLE_NO_COLUMN_NAME, SKEWED_TABLE_NO_COLUMN_VALUE, SKEWED_TABLE_DUPLICATE_COLUMN_NAMES, SKEWED_TABLE_INVALID_COLUMN, SKEWED_TABLE_SKEWED_COL_NAME_VALUE_MISMATCH_1, SKEWED_TABLE_SKEWED_COL_NAME_VALUE_MISMATCH_2, SKEWED_TABLE_SKEWED_COL_NAME_VALUE_MISMATCH_3, ALTER_TABLE_NOT_ALLOWED_RENAME_SKEWED_COLUMN, HIVE_GROUPING_SETS_AGGR_NOMAPAGGR, HIVE_GROUPING_SETS_AGGR_EXPRESSION_INVALID, HIVE_GROUPING_SETS_AGGR_NOFUNC, HIVE_UNION_REMOVE_OPTIMIZATION_NEEDS_SUBDIRECTORIES, HIVE_GROUPING_SETS_EXPR_NOT_IN_GROUPBY, INVALID_PARTITION_SPEC, ALTER_TBL_UNSET_NON_EXIST_PROPERTY, ALTER_VIEW_AS_SELECT_NOT_EXIST, REPLACE_VIEW_WITH_PARTITION, EXISTING_TABLE_IS_NOT_VIEW, NO_SUPPORTED_ORDERBY_ALLCOLREF_POS, INVALID_POSITION_ALIAS_IN_GROUPBY, INVALID_POSITION_ALIAS_IN_ORDERBY, HIVE_GROUPING_SETS_THRESHOLD_NOT_ALLOWED_WITH_SKEW, HIVE_GROUPING_SETS_THRESHOLD_NOT_ALLOWED_WITH_DISTINCTS, OPERATOR_NOT_ALLOWED_WITH_MAPJOIN, ANALYZE_TABLE_NOSCAN_NON_NATIVE, ANALYZE_TABLE_PARTIALSCAN_NON_NATIVE, ANALYZE_TABLE_PARTIALSCAN_NON_RCFILE, ANALYZE_TABLE_PARTIALSCAN_EXTERNAL_TABLE, ANALYZE_TABLE_PARTIALSCAN_AGGKEY, ANALYZE_TABLE_PARTIALSCAN_AUTOGATHER, SCRIPT_INIT_ERROR, SCRIPT_IO_ERROR, SCRIPT_GENERIC_ERROR, SCRIPT_CLOSING_ERROR, STATSPUBLISHER_NOT_OBTAINED, STATSPUBLISHER_INITIALIZATION_ERROR, STATSPUBLISHER_CONNECTION_ERROR, STATSPUBLISHER_PUBLISHING_ERROR, STATSPUBLISHER_CLOSING_ERROR, COLUMNSTATSCOLLECTOR_INVALID_PART_KEY, COLUMNSTATSCOLLECTOR_INCORRECT_NUM_PART_KEY, COLUMNSTATSCOLLECTOR_INVALID_PARTITION, COLUMNSTATSCOLLECTOR_INVALID_SYNTAX, COLUMNSTATSCOLLECTOR_PARSE_ERROR, COLUMNSTATSCOLLECTOR_IO_ERROR, DROP_COMMAND_NOT_ALLOWED_FOR_PARTITION};
        ERROR_MESSAGE_PATTERN = Pattern.compile(".*Line [0-9]+:[0-9]+ (.*)");
        ERROR_CODE_PATTERN = Pattern.compile("HiveException:\\s+\\[Error ([0-9]+)\\]: (.*)");
        mesgToErrorMsgMap = new HashMap<String, ErrorMsg>();
        formatToErrorMsgMap = new HashMap<Pattern, ErrorMsg>();
        minMesgLength = -1;
        for (ErrorMsg errorMsg : ErrorMsg.values()) {
            if (errorMsg.format != null) {
                String pattern = errorMsg.mesg.replaceAll("\\{.*\\}", ".*");
                formatToErrorMsgMap.put(Pattern.compile("^" + pattern + "$"), errorMsg);
                continue;
            }
            mesgToErrorMsgMap.put(errorMsg.getMsg().trim(), errorMsg);
            int length = errorMsg.getMsg().trim().length();
            if (minMesgLength != -1 && length >= minMesgLength) continue;
            minMesgLength = length;
        }
    }
}

