/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.jsontoken.crypto;

import java.security.InvalidKeyException;
import java.security.SignatureException;
import java.util.Arrays;
import net.oauth.jsontoken.crypto.HmacSHA256Signer;
import net.oauth.jsontoken.crypto.Verifier;

public class HmacSHA256Verifier
implements Verifier {
    private final HmacSHA256Signer signer;

    public HmacSHA256Verifier(byte[] verificationKey) throws InvalidKeyException {
        this.signer = new HmacSHA256Signer("verifier", null, verificationKey);
    }

    @Override
    public void verifySignature(byte[] source, byte[] signature) throws SignatureException {
        byte[] comparison = this.signer.sign(source);
        if (!Arrays.equals(comparison, signature)) {
            throw new SignatureException("signature did not verify");
        }
    }
}

