/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.jsontoken;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.security.SignatureException;
import net.oauth.jsontoken.Clock;
import net.oauth.jsontoken.JsonTokenUtil;
import net.oauth.jsontoken.SystemClock;
import net.oauth.jsontoken.crypto.AsciiStringSigner;
import net.oauth.jsontoken.crypto.SignatureAlgorithm;
import net.oauth.jsontoken.crypto.Signer;
import org.apache.commons.codec.binary.Base64;
import org.joda.time.Instant;

public class JsonToken {
    public static final String ALGORITHM_HEADER = "alg";
    public static final String KEY_ID_HEADER = "kid";
    public static final String TYPE_HEADER = "typ";
    public static final String ISSUER = "iss";
    public static final String ISSUED_AT = "iat";
    public static final String EXPIRATION = "exp";
    public static final String AUDIENCE = "aud";
    public static final String BASE64URL_ENCODING = "base64url";
    public static final int DEFAULT_LIFETIME_IN_MINS = 2;
    protected final Clock clock;
    private final JsonObject payload;
    private final Signer signer;
    private final SignatureAlgorithm sigAlg;
    private String signature;
    private String baseString;

    public JsonToken(Signer signer) {
        this(signer, (Clock)new SystemClock());
    }

    public JsonToken(Signer signer, Clock clock) {
        Preconditions.checkNotNull((Object)signer);
        Preconditions.checkNotNull((Object)clock);
        this.payload = new JsonObject();
        this.signer = signer;
        this.clock = clock;
        this.sigAlg = signer.getSignatureAlgorithm();
        this.signature = null;
        this.baseString = null;
        String issuer = signer.getIssuer();
        if (issuer != null) {
            this.setParam(ISSUER, issuer);
        }
    }

    public JsonToken(JsonObject payload) {
        this.payload = payload;
        this.baseString = null;
        this.signature = null;
        this.sigAlg = null;
        this.signer = null;
        this.clock = null;
    }

    public JsonToken(JsonObject payload, Clock clock) {
        this.payload = payload;
        this.clock = clock;
        this.baseString = null;
        this.signature = null;
        this.sigAlg = null;
        this.signer = null;
    }

    public String serializeAndSign() throws SignatureException {
        String baseString = this.computeSignatureBaseString();
        String sig = this.getSignature();
        return JsonTokenUtil.toDotFormat(baseString, sig);
    }

    public String toString() {
        return JsonTokenUtil.toJson(this.payload);
    }

    public String getIssuer() {
        return this.getParamAsString(ISSUER);
    }

    public Instant getIssuedAt() {
        Long issuedAt = this.getParamAsLong(ISSUED_AT);
        if (issuedAt == null) {
            return null;
        }
        return new Instant(issuedAt * 1000L);
    }

    public void setIssuedAt(Instant instant) {
        this.setParam(ISSUED_AT, instant.getMillis() / 1000L);
    }

    public Instant getExpiration() {
        Long expiration = this.getParamAsLong(EXPIRATION);
        if (expiration == null) {
            return null;
        }
        return new Instant(expiration * 1000L);
    }

    public void setExpiration(Instant instant) {
        this.setParam(EXPIRATION, instant.getMillis() / 1000L);
    }

    public String getAudience() {
        return this.getParamAsString(AUDIENCE);
    }

    public void setAudience(String audience) {
        this.setParam(AUDIENCE, audience);
    }

    public void setParam(String name, String value) {
        this.payload.addProperty(name, value);
    }

    public void setParam(String name, Number value) {
        this.payload.addProperty(name, value);
    }

    public JsonPrimitive getParamAsPrimitive(String param) {
        return this.payload.getAsJsonPrimitive(param);
    }

    public JsonObject getPayloadAsJsonObject() {
        return this.payload;
    }

    public String getKeyId() {
        return this.signer.getKeyId();
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.sigAlg;
    }

    private String getParamAsString(String param) {
        JsonPrimitive value = this.getParamAsPrimitive(param);
        if (value == null) {
            return null;
        }
        return value.getAsString();
    }

    private Long getParamAsLong(String param) {
        JsonPrimitive value = this.getParamAsPrimitive(param);
        if (value == null) {
            return null;
        }
        return value.getAsLong();
    }

    protected String computeSignatureBaseString() {
        if (this.baseString != null && !this.baseString.isEmpty()) {
            return this.baseString;
        }
        this.baseString = JsonTokenUtil.toDotFormat(JsonTokenUtil.toBase64(this.getHeader()), JsonTokenUtil.toBase64(this.payload));
        return this.baseString;
    }

    public JsonObject getHeader() {
        JsonObject header = new JsonObject();
        header.addProperty(ALGORITHM_HEADER, this.getSignatureAlgorithm().getNameForJson());
        String keyId = this.getKeyId();
        if (keyId != null) {
            header.addProperty(KEY_ID_HEADER, keyId);
        }
        return header;
    }

    private String getSignature() throws SignatureException {
        if (this.signature != null && !this.signature.isEmpty()) {
            return this.signature;
        }
        if (this.signer == null) {
            throw new SignatureException("can't sign JsonToken with signer.");
        }
        AsciiStringSigner asciiSigner = new AsciiStringSigner(this.signer);
        String signature = Base64.encodeBase64URLSafeString((byte[])asciiSigner.sign(this.baseString));
        return signature;
    }
}

