/*
 * Decompiled with CFR 0.152.
 */
package com.battcn.boot.swagger.utils;

import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpRequest;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UrlPathHelper;

public class HostNameProvider {
    public HostNameProvider() {
        throw new UnsupportedOperationException();
    }

    public static UriComponents componentsFrom(HttpServletRequest request, String basePath) {
        ServletUriComponentsBuilder builder = HostNameProvider.fromServletMapping(request, basePath);
        UriComponents components = UriComponentsBuilder.fromHttpRequest((HttpRequest)new ServletServerHttpRequest(request)).build();
        String host = components.getHost();
        if (!StringUtils.hasText((String)host)) {
            return builder.build();
        }
        builder.host(host);
        builder.port(components.getPort());
        return builder.build();
    }

    private static ServletUriComponentsBuilder fromServletMapping(HttpServletRequest request, String basePath) {
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromContextPath((HttpServletRequest)request);
        builder.replacePath(HostNameProvider.prependForwardedPrefix(request, basePath));
        if (StringUtils.hasText((String)new UrlPathHelper().getPathWithinServletMapping(request))) {
            builder.path(request.getServletPath());
        }
        return builder;
    }

    private static String prependForwardedPrefix(HttpServletRequest request, String path) {
        String prefix = request.getHeader("X-Forwarded-Prefix");
        if (prefix != null) {
            return prefix + path;
        }
        return path;
    }
}

