/*
 * Decompiled with CFR 0.152.
 */
package com.arronlong.httpclientutil.common;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.log4j.Logger;

public class Utils {
    public static final String ENTITY_STRING = "$ENTITY_STRING$";
    public static final String ENTITY_FILE = "$ENTITY_FILEE$";
    public static final String ENTITY_BYTES = "$ENTITY_BYTES$";
    public static final String ENTITY_INPUTSTREAM = "$ENTITY_INPUTSTREAM$";
    public static final String ENTITY_SERIALIZABLE = "$ENTITY_SERIALIZABLE$";
    public static final String ENTITY_MULTIPART = "$ENTITY_MULTIPART$";
    private static final List<String> SPECIAL_ENTITIY = Arrays.asList("$ENTITY_STRING$", "$ENTITY_BYTES$", "$ENTITY_FILEE$", "$ENTITY_INPUTSTREAM$", "$ENTITY_SERIALIZABLE$", "$ENTITY_MULTIPART$");
    private static boolean debug = false;
    private static final Logger logger = Logger.getLogger((String)"HttpClient(\u5f02\u6b65)\u5de5\u5177\u7c7b");

    public static String checkHasParas(String url, List<NameValuePair> nvps, String encoding) throws UnsupportedEncodingException {
        if (url.contains("?") && url.indexOf("?") < url.indexOf("=")) {
            Map<String, Object> map = Utils.buildParas(url.substring(url.indexOf("?") + 1));
            Utils.map2HttpEntity(nvps, map, encoding);
            url = url.substring(0, url.indexOf("?"));
        }
        return url;
    }

    public static HttpEntity map2HttpEntity(List<NameValuePair> nvps, Map<String, Object> map, String encoding) throws UnsupportedEncodingException {
        UrlEncodedFormEntity entity = null;
        if (map != null && map.size() > 0) {
            boolean isSpecial = false;
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if (SPECIAL_ENTITIY.contains(entry.getKey())) {
                    isSpecial = true;
                    if (ENTITY_STRING.equals(entry.getKey())) {
                        entity = new StringEntity(String.valueOf(entry.getValue()), encoding);
                        break;
                    }
                    if (ENTITY_BYTES.equals(entry.getKey())) {
                        entity = new ByteArrayEntity((byte[])entry.getValue());
                        break;
                    }
                    if (ENTITY_FILE.equals(entry.getKey())) {
                        if (File.class.isAssignableFrom(entry.getValue().getClass())) {
                            entity = new FileEntity((File)entry.getValue(), ContentType.APPLICATION_OCTET_STREAM);
                            break;
                        }
                        if (entry.getValue().getClass() != String.class) break;
                        entity = new FileEntity(new File((String)entry.getValue()), ContentType.create((String)"text/plain", (String)"UTF-8"));
                        break;
                    }
                    if (ENTITY_INPUTSTREAM.equals(entry.getKey()) || ENTITY_SERIALIZABLE.equals(entry.getKey())) break;
                    if (ENTITY_MULTIPART.equals(entry.getKey())) {
                        File[] files = null;
                        if (File.class.isAssignableFrom(entry.getValue().getClass().getComponentType())) {
                            files = (File[])entry.getValue();
                        } else if (entry.getValue().getClass().getComponentType() == String.class) {
                            String[] names = (String[])entry.getValue();
                            files = new File[names.length];
                            for (int i = 0; i < names.length; ++i) {
                                files[i] = new File(names[i]);
                            }
                        }
                        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                        builder.setCharset(Charset.forName(encoding));
                        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
                        int count = 0;
                        for (File file : files) {
                            builder.addBinaryBody(String.valueOf(map.get("$ENTITY_MULTIPART$.name")) + count++, file);
                        }
                        boolean forceRemoveContentTypeCharset = (Boolean)map.get("$ENTITY_MULTIPART$.rmCharset");
                        HashMap<String, Object> m = new HashMap<String, Object>();
                        m.putAll(map);
                        m.remove(ENTITY_MULTIPART);
                        m.remove("$ENTITY_MULTIPART$.name");
                        m.remove("$ENTITY_MULTIPART$.rmCharset");
                        for (Map.Entry e : m.entrySet()) {
                            builder.addTextBody((String)e.getKey(), String.valueOf(e.getValue()), ContentType.create((String)"text/plain", (String)encoding));
                        }
                        entity = builder.build();
                        if (!forceRemoveContentTypeCharset) break;
                        Utils.removeContentTypeCharset(encoding, (HttpEntity)entity);
                        break;
                    }
                    nvps.add((NameValuePair)new BasicNameValuePair(entry.getKey(), String.valueOf(entry.getValue())));
                    continue;
                }
                nvps.add((NameValuePair)new BasicNameValuePair(entry.getKey(), String.valueOf(entry.getValue())));
            }
            if (!isSpecial) {
                entity = new UrlEncodedFormEntity(nvps, encoding);
            }
        }
        return entity;
    }

    private static void removeContentTypeCharset(String encoding, HttpEntity entity) {
        try {
            Class<?> clazz = entity.getClass();
            Field field = clazz.getDeclaredField("contentType");
            field.setAccessible(true);
            if (Modifier.isFinal(field.getModifiers())) {
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
                modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            }
            BasicHeader o = (BasicHeader)field.get(entity);
            field.set(entity, new BasicHeader("Content-Type", o.getValue().replace("; charset=" + encoding, "")));
        }
        catch (NoSuchFieldException e) {
            Utils.exception(e);
        }
        catch (SecurityException e) {
            Utils.exception(e);
        }
        catch (IllegalArgumentException e) {
            Utils.exception(e);
        }
        catch (IllegalAccessException e) {
            Utils.exception(e);
        }
    }

    public static Map<String, Object> buildParas(String paras) {
        String[] p = paras.split("&");
        String[][] ps = new String[p.length][2];
        int pos = 0;
        for (int i = 0; i < p.length; ++i) {
            pos = p[i].indexOf("=");
            ps[i][0] = p[i].substring(0, pos);
            ps[i][1] = p[i].substring(pos + 1);
            pos = 0;
        }
        return Utils.buildParas(ps);
    }

    public static Map<String, Object> buildParas(String[][] paras) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String[] para : paras) {
            map.put(para[0], para[1]);
        }
        return map;
    }

    public static void info(String msg) {
        if (debug) {
            logger.info((Object)msg);
        }
    }

    public static void infoException(String msg, Throwable t) {
        if (debug) {
            logger.info((Object)msg, t);
        }
    }

    public static void error(String msg) {
        logger.error((Object)msg);
    }

    public static void errorException(String msg, Throwable t) {
        logger.error((Object)msg, t);
    }

    public static void exception(Throwable t) {
        logger.error((Object)t);
    }

    public static void debug() {
        Utils.debug(true);
    }

    public static void debug(boolean debug) {
        Utils.debug = debug;
    }
}

