/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AdbHelper;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.Device;
import com.android.ddmlib.EmulatorConsole;
import com.android.ddmlib.GetPropReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.MonitorThread;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DeviceMonitor {
    private byte[] mLengthBuffer = new byte[4];
    private byte[] mLengthBuffer2 = new byte[4];
    private boolean mQuit = false;
    private AndroidDebugBridge mServer;
    private SocketChannel mMainAdbConnection = null;
    private boolean mMonitoring = false;
    private int mConnectionAttempt = 0;
    private int mRestartAttemptCount = 0;
    private boolean mInitialDeviceListDone = false;
    private Selector mSelector;
    private final ArrayList<Device> mDevices = new ArrayList();
    private final ArrayList<Integer> mDebuggerPorts = new ArrayList();
    private final HashMap<Client, Integer> mClientsToReopen = new HashMap();

    DeviceMonitor(AndroidDebugBridge androidDebugBridge) {
        this.mServer = androidDebugBridge;
        this.mDebuggerPorts.add(DdmPreferences.getDebugPortBase());
    }

    void start() {
        new Thread("Device List Monitor"){

            public void run() {
                DeviceMonitor.this.deviceMonitorLoop();
            }
        }.start();
    }

    void stop() {
        this.mQuit = true;
        try {
            if (this.mMainAdbConnection != null) {
                this.mMainAdbConnection.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.mSelector != null) {
            this.mSelector.wakeup();
        }
    }

    boolean isMonitoring() {
        return this.mMonitoring;
    }

    int getConnectionAttemptCount() {
        return this.mConnectionAttempt;
    }

    int getRestartAttemptCount() {
        return this.mRestartAttemptCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Device[] getDevices() {
        ArrayList<Device> arrayList = this.mDevices;
        synchronized (arrayList) {
            return this.mDevices.toArray(new Device[this.mDevices.size()]);
        }
    }

    boolean hasInitialDeviceList() {
        return this.mInitialDeviceListDone;
    }

    AndroidDebugBridge getServer() {
        return this.mServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addClientToDropAndReopen(Client client, int n) {
        HashMap<Client, Integer> hashMap = this.mClientsToReopen;
        synchronized (hashMap) {
            Log.d("DeviceMonitor", "Adding " + client + " to list of client to reopen (" + n + ").");
            if (this.mClientsToReopen.get(client) == null) {
                this.mClientsToReopen.put(client, n);
            }
        }
        this.mSelector.wakeup();
    }

    private void deviceMonitorLoop() {
        do {
            try {
                int n;
                if (this.mMainAdbConnection == null) {
                    Log.d("DeviceMonitor", "Opening adb connection");
                    this.mMainAdbConnection = this.openAdbConnection();
                    if (this.mMainAdbConnection == null) {
                        ++this.mConnectionAttempt;
                        Log.e("DeviceMonitor", "Connection attempts: " + this.mConnectionAttempt);
                        if (this.mConnectionAttempt > 10) {
                            if (!this.mServer.startAdb()) {
                                ++this.mRestartAttemptCount;
                                Log.e("DeviceMonitor", "adb restart attempts: " + this.mRestartAttemptCount);
                            } else {
                                this.mRestartAttemptCount = 0;
                            }
                        }
                        this.waitABit();
                    } else {
                        Log.d("DeviceMonitor", "Connected to adb for device monitoring");
                        this.mConnectionAttempt = 0;
                    }
                }
                if (this.mMainAdbConnection != null && !this.mMonitoring) {
                    this.mMonitoring = this.sendDeviceListMonitoringRequest();
                }
                if (!this.mMonitoring || (n = this.readLength(this.mMainAdbConnection, this.mLengthBuffer)) < 0) continue;
                this.processIncomingDeviceData(n);
                this.mInitialDeviceListDone = true;
            }
            catch (AsynchronousCloseException asynchronousCloseException) {
            }
            catch (TimeoutException timeoutException) {
                this.handleExpectioninMonitorLoop(timeoutException);
            }
            catch (IOException iOException) {
                this.handleExpectioninMonitorLoop(iOException);
            }
        } while (!this.mQuit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleExpectioninMonitorLoop(Exception exception) {
        if (!this.mQuit) {
            if (exception instanceof TimeoutException) {
                Log.e("DeviceMonitor", "Adb connection Error: timeout");
            } else {
                Log.e("DeviceMonitor", "Adb connection Error:" + exception.getMessage());
            }
            this.mMonitoring = false;
            if (this.mMainAdbConnection != null) {
                try {
                    this.mMainAdbConnection.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.mMainAdbConnection = null;
                Object object = AndroidDebugBridge.getLock();
                synchronized (object) {
                    ArrayList<Device> arrayList = this.mDevices;
                    synchronized (arrayList) {
                        for (int i = this.mDevices.size() - 1; i >= 0; --i) {
                            Device device = this.mDevices.get(0);
                            this.removeDevice(device);
                            this.mServer.deviceDisconnected(device);
                        }
                    }
                }
            }
        }
    }

    private void waitABit() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private SocketChannel openAdbConnection() {
        Log.d("DeviceMonitor", "Connecting to adb for Device List Monitoring...");
        SocketChannel socketChannel = null;
        try {
            socketChannel = SocketChannel.open(AndroidDebugBridge.getSocketAddress());
            socketChannel.socket().setTcpNoDelay(true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return socketChannel;
    }

    private boolean sendDeviceListMonitoringRequest() throws TimeoutException, IOException {
        byte[] byArray = AdbHelper.formAdbRequest("host:track-devices");
        try {
            AdbHelper.write(this.mMainAdbConnection, byArray);
            AdbHelper.AdbResponse adbResponse = AdbHelper.readAdbResponse(this.mMainAdbConnection, false);
            if (!adbResponse.okay) {
                Log.e("DeviceMonitor", "adb refused request: " + adbResponse.message);
            }
            return adbResponse.okay;
        }
        catch (IOException iOException) {
            Log.e("DeviceMonitor", "Sending Tracking request failed!");
            this.mMainAdbConnection.close();
            throw iOException;
        }
    }

    private void processIncomingDeviceData(int n) throws IOException {
        ArrayList<Device> arrayList = new ArrayList<Device>();
        if (n > 0) {
            String[] stringArray;
            byte[] byArray = new byte[n];
            String string = this.read(this.mMainAdbConnection, byArray);
            for (String string2 : stringArray = string.split("\n")) {
                String[] stringArray2 = string2.split("\t");
                if (stringArray2.length != 2) continue;
                Device device = new Device(this, stringArray2[0], IDevice.DeviceState.getState(stringArray2[1]));
                arrayList.add(device);
            }
        }
        this.updateDevices(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void updateDevices(ArrayList<Device> arrayList) {
        Object object = AndroidDebugBridge.getLock();
        synchronized (object) {
            ArrayList<Device> arrayList2 = new ArrayList<Device>();
            ArrayList<Device> arrayList3 = this.mDevices;
            synchronized (arrayList3) {
                void object2;
                boolean n = false;
                while (object2 < this.mDevices.size()) {
                    Device device = this.mDevices.get((int)object2);
                    int n2 = arrayList.size();
                    boolean bl = false;
                    for (int i = 0; i < n2; ++i) {
                        Device device2 = arrayList.get(i);
                        if (!device2.getSerialNumber().equals(device.getSerialNumber())) continue;
                        bl = true;
                        if (device.getState() != device2.getState()) {
                            device.setState(device2.getState());
                            device.update(1);
                            if (device.isOnline()) {
                                if (AndroidDebugBridge.getClientSupport() && !this.startMonitoringDevice(device)) {
                                    Log.e("DeviceMonitor", "Failed to start monitoring " + device.getSerialNumber());
                                }
                                if (device.getPropertyCount() == 0) {
                                    arrayList2.add(device);
                                }
                            }
                        }
                        arrayList.remove(i);
                        break;
                    }
                    if (!bl) {
                        this.removeDevice(device);
                        this.mServer.deviceDisconnected(device);
                        continue;
                    }
                    ++object2;
                }
                for (Device device : arrayList) {
                    this.mDevices.add(device);
                    this.mServer.deviceConnected(device);
                    if (AndroidDebugBridge.getClientSupport() && device.isOnline()) {
                        this.startMonitoringDevice(device);
                    }
                    if (!device.isOnline()) continue;
                    arrayList2.add(device);
                }
            }
            for (Device device : arrayList2) {
                this.queryNewDeviceForInfo(device);
            }
        }
        arrayList.clear();
    }

    private void removeDevice(Device device) {
        device.clearClientList();
        this.mDevices.remove(device);
        SocketChannel socketChannel = device.getClientMonitoringSocket();
        if (socketChannel != null) {
            try {
                socketChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void queryNewDeviceForInfo(Device device) {
        try {
            EmulatorConsole emulatorConsole;
            device.executeShellCommand("getprop", new GetPropReceiver(device));
            this.queryNewDeviceForMountingPoint(device, "EXTERNAL_STORAGE");
            this.queryNewDeviceForMountingPoint(device, "ANDROID_DATA");
            this.queryNewDeviceForMountingPoint(device, "ANDROID_ROOT");
            if (device.isEmulator() && (emulatorConsole = EmulatorConsole.getConsole(device)) != null) {
                device.setAvdName(emulatorConsole.getAvdName());
            }
        }
        catch (TimeoutException timeoutException) {
            Log.w("DeviceMonitor", String.format("Connection timeout getting info for device %s", device.getSerialNumber()));
        }
        catch (AdbCommandRejectedException adbCommandRejectedException) {
            Log.w("DeviceMonitor", String.format("Adb rejected command to get  device %1$s info: %2$s", device.getSerialNumber(), adbCommandRejectedException.getMessage()));
        }
        catch (ShellCommandUnresponsiveException shellCommandUnresponsiveException) {
            Log.w("DeviceMonitor", String.format("Adb shell command took too long returning info for device %s", device.getSerialNumber()));
        }
        catch (IOException iOException) {
            Log.w("DeviceMonitor", String.format("IO Error getting info for device %s", device.getSerialNumber()));
        }
    }

    private void queryNewDeviceForMountingPoint(final Device device, final String string) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        device.executeShellCommand("echo $" + string, new MultiLineReceiver(){

            public boolean isCancelled() {
                return false;
            }

            public void processNewLines(String[] stringArray) {
                for (String string2 : stringArray) {
                    if (string2.length() <= 0) continue;
                    device.setMountingPoint(string, string2);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startMonitoringDevice(Device device) {
        block15: {
            SocketChannel socketChannel = this.openAdbConnection();
            if (socketChannel != null) {
                try {
                    boolean bl = this.sendDeviceMonitoringRequest(socketChannel, device);
                    if (!bl) break block15;
                    if (this.mSelector == null) {
                        this.startDeviceMonitorThread();
                    }
                    device.setClientMonitoringSocket(socketChannel);
                    ArrayList<Device> arrayList = this.mDevices;
                    synchronized (arrayList) {
                        this.mSelector.wakeup();
                        socketChannel.configureBlocking(false);
                        socketChannel.register(this.mSelector, 1, device);
                    }
                    return true;
                }
                catch (TimeoutException timeoutException) {
                    try {
                        socketChannel.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    Log.d("DeviceMonitor", "Connection Failure when starting to monitor device '" + device + "' : timeout");
                }
                catch (AdbCommandRejectedException adbCommandRejectedException) {
                    try {
                        socketChannel.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    Log.d("DeviceMonitor", "Adb refused to start monitoring device '" + device + "' : " + adbCommandRejectedException.getMessage());
                }
                catch (IOException iOException) {
                    try {
                        socketChannel.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    Log.d("DeviceMonitor", "Connection Failure when starting to monitor device '" + device + "' : " + iOException.getMessage());
                }
            }
        }
        return false;
    }

    private void startDeviceMonitorThread() throws IOException {
        this.mSelector = Selector.open();
        new Thread("Device Client Monitor"){

            public void run() {
                DeviceMonitor.this.deviceClientMonitorLoop();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void deviceClientMonitorLoop() {
        do {
            try {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                ArrayList<Device> arrayList = this.mDevices;
                // MONITORENTER : arrayList
                // MONITOREXIT : arrayList
                int n = this.mSelector.select();
                if (this.mQuit) {
                    return;
                }
                Object object6 = this.mClientsToReopen;
                // MONITORENTER : object6
                if (this.mClientsToReopen.size() > 0) {
                    object5 = this.mClientsToReopen.keySet();
                    object4 = MonitorThread.getInstance();
                    object3 = object5.iterator();
                    while (object3.hasNext()) {
                        object2 = object3.next();
                        object = ((Client)object2).getDeviceImpl();
                        int n2 = ((Client)object2).getClientData().getPid();
                        ((MonitorThread)object4).dropClient((Client)object2, false);
                        this.waitABit();
                        int n3 = this.mClientsToReopen.get(object2);
                        if (n3 == -1) {
                            n3 = this.getNextDebuggerPort();
                        }
                        Log.d("DeviceMonitor", "Reopening " + object2);
                        this.openClient((Device)object, n2, n3, (MonitorThread)object4);
                        ((Device)object).update(2);
                    }
                    this.mClientsToReopen.clear();
                }
                // MONITOREXIT : object6
                if (n == 0) continue;
                object6 = this.mSelector.selectedKeys();
                object5 = object6.iterator();
                while (object5.hasNext()) {
                    object4 = (SelectionKey)object5.next();
                    object5.remove();
                    if (!((SelectionKey)object4).isValid() || !((SelectionKey)object4).isReadable() || !((object3 = ((SelectionKey)object4).attachment()) instanceof Device) || (object = ((Device)(object2 = (Device)object3)).getClientMonitoringSocket()) == null) continue;
                    try {
                        int n4 = this.readLength((SocketChannel)object, this.mLengthBuffer2);
                        this.processIncomingJdwpData((Device)object2, (SocketChannel)object, n4);
                    }
                    catch (IOException iOException) {
                        Log.d("DeviceMonitor", "Error reading jdwp list: " + iOException.getMessage());
                        ((AbstractInterruptibleChannel)object).close();
                        ArrayList<Device> arrayList2 = this.mDevices;
                        // MONITORENTER : arrayList2
                        if (this.mDevices.contains(object2)) {
                            Log.d("DeviceMonitor", "Restarting monitoring service for " + object2);
                            this.startMonitoringDevice((Device)object2);
                        }
                        // MONITOREXIT : arrayList2
                    }
                }
            }
            catch (IOException iOException) {
                if (this.mQuit) continue;
            }
        } while (!this.mQuit);
    }

    private boolean sendDeviceMonitoringRequest(SocketChannel socketChannel, Device device) throws TimeoutException, AdbCommandRejectedException, IOException {
        try {
            AdbHelper.setDevice(socketChannel, device);
            byte[] byArray = AdbHelper.formAdbRequest("track-jdwp");
            AdbHelper.write(socketChannel, byArray);
            AdbHelper.AdbResponse adbResponse = AdbHelper.readAdbResponse(socketChannel, false);
            if (!adbResponse.okay) {
                Log.e("DeviceMonitor", "adb refused request: " + adbResponse.message);
            }
            return adbResponse.okay;
        }
        catch (TimeoutException timeoutException) {
            Log.e("DeviceMonitor", "Sending jdwp tracking request timed out!");
            throw timeoutException;
        }
        catch (IOException iOException) {
            Log.e("DeviceMonitor", "Sending jdwp tracking request failed!");
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processIncomingJdwpData(Device device, SocketChannel socketChannel, int n) throws IOException {
        Object object;
        String[] stringArray;
        if (n < 0) return;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (n > 0) {
            stringArray = (String[])new byte[n];
            object = this.read(socketChannel, (byte[])stringArray);
            String[] stringArray2 = ((String)object).split("\n");
            for (String string : stringArray2) {
                try {
                    arrayList.add(Integer.valueOf(string));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        stringArray = MonitorThread.getInstance();
        object = device.getClientList();
        boolean bl = false;
        Object object2 = stringArray;
        synchronized (stringArray) {
            Object object3 = object;
            synchronized (object3) {
                int n2 = 0;
                while (n2 < object.size()) {
                    Client client = (Client)object.get(n2);
                    int n3 = client.getClientData().getPid();
                    Integer n4 = null;
                    for (Integer n5 : arrayList) {
                        if (n3 != n5) continue;
                        n4 = n5;
                        break;
                    }
                    if (n4 != null) {
                        arrayList.remove(n4);
                        ++n2;
                        continue;
                    }
                    stringArray.dropClient(client, false);
                    bl = true;
                }
            }
            // ** MonitorExit[var8_9] (shouldn't be in output)
            object2 = arrayList.iterator();
            while (object2.hasNext()) {
                int n6 = (Integer)object2.next();
                this.openClient(device, n6, this.getNextDebuggerPort(), (MonitorThread)stringArray);
                bl = true;
            }
            if (!bl) return;
            this.mServer.deviceChanged(device, 2);
            return;
        }
    }

    private void openClient(Device device, int n, int n2, MonitorThread monitorThread) {
        SocketChannel socketChannel;
        try {
            socketChannel = AdbHelper.createPassThroughConnection(AndroidDebugBridge.getSocketAddress(), device, n);
            socketChannel.configureBlocking(false);
        }
        catch (UnknownHostException unknownHostException) {
            Log.d("DeviceMonitor", "Unknown Jdwp pid: " + n);
            return;
        }
        catch (TimeoutException timeoutException) {
            Log.w("DeviceMonitor", "Failed to connect to client '" + n + "': timeout");
            return;
        }
        catch (AdbCommandRejectedException adbCommandRejectedException) {
            Log.w("DeviceMonitor", "Adb rejected connection to client '" + n + "': " + adbCommandRejectedException.getMessage());
            return;
        }
        catch (IOException iOException) {
            Log.w("DeviceMonitor", "Failed to connect to client '" + n + "': " + iOException.getMessage());
            return;
        }
        this.createClient(device, n, socketChannel, n2, monitorThread);
    }

    private void createClient(Device device, int n, SocketChannel socketChannel, int n2, MonitorThread monitorThread) {
        Client client = new Client(device, socketChannel, n);
        if (client.sendHandshake()) {
            try {
                if (AndroidDebugBridge.getClientSupport()) {
                    client.listenForDebugger(n2);
                }
            }
            catch (IOException iOException) {
                client.getClientData().setDebuggerConnectionStatus(ClientData.DebuggerStatus.ERROR);
                Log.e("ddms", "Can't bind to local " + n2 + " for debugger");
            }
            client.requestAllocationStatus();
        } else {
            Log.e("ddms", "Handshake with " + client + " failed!");
        }
        if (client.isValid()) {
            device.addClient(client);
            monitorThread.addClient(client);
        } else {
            client = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextDebuggerPort() {
        ArrayList<Integer> arrayList = this.mDebuggerPorts;
        synchronized (arrayList) {
            if (this.mDebuggerPorts.size() > 0) {
                int n = this.mDebuggerPorts.get(0);
                this.mDebuggerPorts.remove(0);
                if (this.mDebuggerPorts.size() == 0) {
                    this.mDebuggerPorts.add(n + 1);
                }
                return n;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPortToAvailableList(int n) {
        if (n > 0) {
            ArrayList<Integer> arrayList = this.mDebuggerPorts;
            synchronized (arrayList) {
                if (this.mDebuggerPorts.indexOf(n) == -1) {
                    int n2 = this.mDebuggerPorts.size();
                    for (int i = 0; i < n2; ++i) {
                        if (n >= this.mDebuggerPorts.get(i)) continue;
                        this.mDebuggerPorts.add(i, n);
                        break;
                    }
                }
            }
        }
    }

    private int readLength(SocketChannel socketChannel, byte[] byArray) throws IOException {
        String string = this.read(socketChannel, byArray);
        if (string != null) {
            try {
                return Integer.parseInt(string, 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IOException("Unable to read length");
    }

    private String read(SocketChannel socketChannel, byte[] byArray) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, byArray.length);
        while (byteBuffer.position() != byteBuffer.limit()) {
            int n = socketChannel.read(byteBuffer);
            if (n >= 0) continue;
            throw new IOException("EOF");
        }
        try {
            return new String(byArray, 0, byteBuffer.position(), "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }
}

