/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for results of a <code>DescribeReservedInstanceOfferings</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReservedInstanceOfferingsResponse extends OpenSearchResponse implements
        ToCopyableBuilder<DescribeReservedInstanceOfferingsResponse.Builder, DescribeReservedInstanceOfferingsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeReservedInstanceOfferingsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<ReservedInstanceOffering>> RESERVED_INSTANCE_OFFERINGS_FIELD = SdkField
            .<List<ReservedInstanceOffering>> builder(MarshallingType.LIST)
            .memberName("ReservedInstanceOfferings")
            .getter(getter(DescribeReservedInstanceOfferingsResponse::reservedInstanceOfferings))
            .setter(setter(Builder::reservedInstanceOfferings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstanceOfferings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReservedInstanceOffering> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReservedInstanceOffering::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            RESERVED_INSTANCE_OFFERINGS_FIELD));

    private final String nextToken;

    private final List<ReservedInstanceOffering> reservedInstanceOfferings;

    private DescribeReservedInstanceOfferingsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.reservedInstanceOfferings = builder.reservedInstanceOfferings;
    }

    /**
     * <p>
     * When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is
     * a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * </p>
     * 
     * @return When <code>nextToken</code> is returned, there are more results available. The value of
     *         <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned
     *         token to retrieve the next page.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReservedInstanceOfferings property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasReservedInstanceOfferings() {
        return reservedInstanceOfferings != null && !(reservedInstanceOfferings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of Reserved Instance offerings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReservedInstanceOfferings} method.
     * </p>
     * 
     * @return List of Reserved Instance offerings.
     */
    public final List<ReservedInstanceOffering> reservedInstanceOfferings() {
        return reservedInstanceOfferings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasReservedInstanceOfferings() ? reservedInstanceOfferings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedInstanceOfferingsResponse)) {
            return false;
        }
        DescribeReservedInstanceOfferingsResponse other = (DescribeReservedInstanceOfferingsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasReservedInstanceOfferings() == other.hasReservedInstanceOfferings()
                && Objects.equals(reservedInstanceOfferings(), other.reservedInstanceOfferings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeReservedInstanceOfferingsResponse").add("NextToken", nextToken())
                .add("ReservedInstanceOfferings", hasReservedInstanceOfferings() ? reservedInstanceOfferings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ReservedInstanceOfferings":
            return Optional.ofNullable(clazz.cast(reservedInstanceOfferings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedInstanceOfferingsResponse, T> g) {
        return obj -> g.apply((DescribeReservedInstanceOfferingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeReservedInstanceOfferingsResponse> {
        /**
         * <p>
         * When <code>nextToken</code> is returned, there are more results available. The value of
         * <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned
         * token to retrieve the next page.
         * </p>
         * 
         * @param nextToken
         *        When <code>nextToken</code> is returned, there are more results available. The value of
         *        <code>nextToken</code> is a unique pagination token for each page. Make the call again using the
         *        returned token to retrieve the next page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * List of Reserved Instance offerings.
         * </p>
         * 
         * @param reservedInstanceOfferings
         *        List of Reserved Instance offerings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstanceOfferings(Collection<ReservedInstanceOffering> reservedInstanceOfferings);

        /**
         * <p>
         * List of Reserved Instance offerings.
         * </p>
         * 
         * @param reservedInstanceOfferings
         *        List of Reserved Instance offerings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstanceOfferings(ReservedInstanceOffering... reservedInstanceOfferings);

        /**
         * <p>
         * List of Reserved Instance offerings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opensearch.model.ReservedInstanceOffering.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.opensearch.model.ReservedInstanceOffering#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opensearch.model.ReservedInstanceOffering.Builder#build()} is called
         * immediately and its result is passed to {@link #reservedInstanceOfferings(List<ReservedInstanceOffering>)}.
         * 
         * @param reservedInstanceOfferings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opensearch.model.ReservedInstanceOffering.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reservedInstanceOfferings(java.util.Collection<ReservedInstanceOffering>)
         */
        Builder reservedInstanceOfferings(Consumer<ReservedInstanceOffering.Builder>... reservedInstanceOfferings);
    }

    static final class BuilderImpl extends OpenSearchResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ReservedInstanceOffering> reservedInstanceOfferings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedInstanceOfferingsResponse model) {
            super(model);
            nextToken(model.nextToken);
            reservedInstanceOfferings(model.reservedInstanceOfferings);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ReservedInstanceOffering.Builder> getReservedInstanceOfferings() {
            List<ReservedInstanceOffering.Builder> result = ReservedInstanceOfferingListCopier
                    .copyToBuilder(this.reservedInstanceOfferings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReservedInstanceOfferings(Collection<ReservedInstanceOffering.BuilderImpl> reservedInstanceOfferings) {
            this.reservedInstanceOfferings = ReservedInstanceOfferingListCopier.copyFromBuilder(reservedInstanceOfferings);
        }

        @Override
        public final Builder reservedInstanceOfferings(Collection<ReservedInstanceOffering> reservedInstanceOfferings) {
            this.reservedInstanceOfferings = ReservedInstanceOfferingListCopier.copy(reservedInstanceOfferings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstanceOfferings(ReservedInstanceOffering... reservedInstanceOfferings) {
            reservedInstanceOfferings(Arrays.asList(reservedInstanceOfferings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstanceOfferings(Consumer<ReservedInstanceOffering.Builder>... reservedInstanceOfferings) {
            reservedInstanceOfferings(Stream.of(reservedInstanceOfferings)
                    .map(c -> ReservedInstanceOffering.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeReservedInstanceOfferingsResponse build() {
            return new DescribeReservedInstanceOfferingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
