/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for fine-grained access control settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdvancedSecurityOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<AdvancedSecurityOptions.Builder, AdvancedSecurityOptions> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(AdvancedSecurityOptions::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<Boolean> INTERNAL_USER_DATABASE_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("InternalUserDatabaseEnabled")
            .getter(getter(AdvancedSecurityOptions::internalUserDatabaseEnabled))
            .setter(setter(Builder::internalUserDatabaseEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternalUserDatabaseEnabled")
                    .build()).build();

    private static final SdkField<SAMLOptionsOutput> SAML_OPTIONS_FIELD = SdkField
            .<SAMLOptionsOutput> builder(MarshallingType.SDK_POJO).memberName("SAMLOptions")
            .getter(getter(AdvancedSecurityOptions::samlOptions)).setter(setter(Builder::samlOptions))
            .constructor(SAMLOptionsOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAMLOptions").build()).build();

    private static final SdkField<Instant> ANONYMOUS_AUTH_DISABLE_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("AnonymousAuthDisableDate")
            .getter(getter(AdvancedSecurityOptions::anonymousAuthDisableDate)).setter(setter(Builder::anonymousAuthDisableDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnonymousAuthDisableDate").build())
            .build();

    private static final SdkField<Boolean> ANONYMOUS_AUTH_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AnonymousAuthEnabled").getter(getter(AdvancedSecurityOptions::anonymousAuthEnabled))
            .setter(setter(Builder::anonymousAuthEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnonymousAuthEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            INTERNAL_USER_DATABASE_ENABLED_FIELD, SAML_OPTIONS_FIELD, ANONYMOUS_AUTH_DISABLE_DATE_FIELD,
            ANONYMOUS_AUTH_ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final Boolean internalUserDatabaseEnabled;

    private final SAMLOptionsOutput samlOptions;

    private final Instant anonymousAuthDisableDate;

    private final Boolean anonymousAuthEnabled;

    private AdvancedSecurityOptions(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.internalUserDatabaseEnabled = builder.internalUserDatabaseEnabled;
        this.samlOptions = builder.samlOptions;
        this.anonymousAuthDisableDate = builder.anonymousAuthDisableDate;
        this.anonymousAuthEnabled = builder.anonymousAuthEnabled;
    }

    /**
     * <p>
     * True if fine-grained access control is enabled.
     * </p>
     * 
     * @return True if fine-grained access control is enabled.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * True if the internal user database is enabled.
     * </p>
     * 
     * @return True if the internal user database is enabled.
     */
    public final Boolean internalUserDatabaseEnabled() {
        return internalUserDatabaseEnabled;
    }

    /**
     * <p>
     * Container for information about the SAML configuration for OpenSearch Dashboards.
     * </p>
     * 
     * @return Container for information about the SAML configuration for OpenSearch Dashboards.
     */
    public final SAMLOptionsOutput samlOptions() {
        return samlOptions;
    }

    /**
     * <p>
     * Date and time when the migration period will be disabled. Only necessary when <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html#fgac-enabling-existing"
     * >enabling fine-grained access control on an existing domain</a>.
     * </p>
     * 
     * @return Date and time when the migration period will be disabled. Only necessary when <a
     *         href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html#fgac-enabling-existing"
     *         >enabling fine-grained access control on an existing domain</a>.
     */
    public final Instant anonymousAuthDisableDate() {
        return anonymousAuthDisableDate;
    }

    /**
     * <p>
     * True if a 30-day migration period is enabled, during which administrators can create role mappings. Only
     * necessary when <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html#fgac-enabling-existing"
     * >enabling fine-grained access control on an existing domain</a>.
     * </p>
     * 
     * @return True if a 30-day migration period is enabled, during which administrators can create role mappings. Only
     *         necessary when <a href=
     *         "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html#fgac-enabling-existing"
     *         >enabling fine-grained access control on an existing domain</a>.
     */
    public final Boolean anonymousAuthEnabled() {
        return anonymousAuthEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(internalUserDatabaseEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(samlOptions());
        hashCode = 31 * hashCode + Objects.hashCode(anonymousAuthDisableDate());
        hashCode = 31 * hashCode + Objects.hashCode(anonymousAuthEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdvancedSecurityOptions)) {
            return false;
        }
        AdvancedSecurityOptions other = (AdvancedSecurityOptions) obj;
        return Objects.equals(enabled(), other.enabled())
                && Objects.equals(internalUserDatabaseEnabled(), other.internalUserDatabaseEnabled())
                && Objects.equals(samlOptions(), other.samlOptions())
                && Objects.equals(anonymousAuthDisableDate(), other.anonymousAuthDisableDate())
                && Objects.equals(anonymousAuthEnabled(), other.anonymousAuthEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AdvancedSecurityOptions").add("Enabled", enabled())
                .add("InternalUserDatabaseEnabled", internalUserDatabaseEnabled()).add("SAMLOptions", samlOptions())
                .add("AnonymousAuthDisableDate", anonymousAuthDisableDate()).add("AnonymousAuthEnabled", anonymousAuthEnabled())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "InternalUserDatabaseEnabled":
            return Optional.ofNullable(clazz.cast(internalUserDatabaseEnabled()));
        case "SAMLOptions":
            return Optional.ofNullable(clazz.cast(samlOptions()));
        case "AnonymousAuthDisableDate":
            return Optional.ofNullable(clazz.cast(anonymousAuthDisableDate()));
        case "AnonymousAuthEnabled":
            return Optional.ofNullable(clazz.cast(anonymousAuthEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdvancedSecurityOptions, T> g) {
        return obj -> g.apply((AdvancedSecurityOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AdvancedSecurityOptions> {
        /**
         * <p>
         * True if fine-grained access control is enabled.
         * </p>
         * 
         * @param enabled
         *        True if fine-grained access control is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * True if the internal user database is enabled.
         * </p>
         * 
         * @param internalUserDatabaseEnabled
         *        True if the internal user database is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder internalUserDatabaseEnabled(Boolean internalUserDatabaseEnabled);

        /**
         * <p>
         * Container for information about the SAML configuration for OpenSearch Dashboards.
         * </p>
         * 
         * @param samlOptions
         *        Container for information about the SAML configuration for OpenSearch Dashboards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samlOptions(SAMLOptionsOutput samlOptions);

        /**
         * <p>
         * Container for information about the SAML configuration for OpenSearch Dashboards.
         * </p>
         * This is a convenience method that creates an instance of the {@link SAMLOptionsOutput.Builder} avoiding the
         * need to create one manually via {@link SAMLOptionsOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SAMLOptionsOutput.Builder#build()} is called immediately and its
         * result is passed to {@link #samlOptions(SAMLOptionsOutput)}.
         * 
         * @param samlOptions
         *        a consumer that will call methods on {@link SAMLOptionsOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #samlOptions(SAMLOptionsOutput)
         */
        default Builder samlOptions(Consumer<SAMLOptionsOutput.Builder> samlOptions) {
            return samlOptions(SAMLOptionsOutput.builder().applyMutation(samlOptions).build());
        }

        /**
         * <p>
         * Date and time when the migration period will be disabled. Only necessary when <a href=
         * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html#fgac-enabling-existing"
         * >enabling fine-grained access control on an existing domain</a>.
         * </p>
         * 
         * @param anonymousAuthDisableDate
         *        Date and time when the migration period will be disabled. Only necessary when <a href=
         *        "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html#fgac-enabling-existing"
         *        >enabling fine-grained access control on an existing domain</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anonymousAuthDisableDate(Instant anonymousAuthDisableDate);

        /**
         * <p>
         * True if a 30-day migration period is enabled, during which administrators can create role mappings. Only
         * necessary when <a href=
         * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html#fgac-enabling-existing"
         * >enabling fine-grained access control on an existing domain</a>.
         * </p>
         * 
         * @param anonymousAuthEnabled
         *        True if a 30-day migration period is enabled, during which administrators can create role mappings.
         *        Only necessary when <a href=
         *        "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html#fgac-enabling-existing"
         *        >enabling fine-grained access control on an existing domain</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anonymousAuthEnabled(Boolean anonymousAuthEnabled);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private Boolean internalUserDatabaseEnabled;

        private SAMLOptionsOutput samlOptions;

        private Instant anonymousAuthDisableDate;

        private Boolean anonymousAuthEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(AdvancedSecurityOptions model) {
            enabled(model.enabled);
            internalUserDatabaseEnabled(model.internalUserDatabaseEnabled);
            samlOptions(model.samlOptions);
            anonymousAuthDisableDate(model.anonymousAuthDisableDate);
            anonymousAuthEnabled(model.anonymousAuthEnabled);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Boolean getInternalUserDatabaseEnabled() {
            return internalUserDatabaseEnabled;
        }

        public final void setInternalUserDatabaseEnabled(Boolean internalUserDatabaseEnabled) {
            this.internalUserDatabaseEnabled = internalUserDatabaseEnabled;
        }

        @Override
        public final Builder internalUserDatabaseEnabled(Boolean internalUserDatabaseEnabled) {
            this.internalUserDatabaseEnabled = internalUserDatabaseEnabled;
            return this;
        }

        public final SAMLOptionsOutput.Builder getSamlOptions() {
            return samlOptions != null ? samlOptions.toBuilder() : null;
        }

        public final void setSamlOptions(SAMLOptionsOutput.BuilderImpl samlOptions) {
            this.samlOptions = samlOptions != null ? samlOptions.build() : null;
        }

        @Override
        public final Builder samlOptions(SAMLOptionsOutput samlOptions) {
            this.samlOptions = samlOptions;
            return this;
        }

        public final Instant getAnonymousAuthDisableDate() {
            return anonymousAuthDisableDate;
        }

        public final void setAnonymousAuthDisableDate(Instant anonymousAuthDisableDate) {
            this.anonymousAuthDisableDate = anonymousAuthDisableDate;
        }

        @Override
        public final Builder anonymousAuthDisableDate(Instant anonymousAuthDisableDate) {
            this.anonymousAuthDisableDate = anonymousAuthDisableDate;
            return this;
        }

        public final Boolean getAnonymousAuthEnabled() {
            return anonymousAuthEnabled;
        }

        public final void setAnonymousAuthEnabled(Boolean anonymousAuthEnabled) {
            this.anonymousAuthEnabled = anonymousAuthEnabled;
        }

        @Override
        public final Builder anonymousAuthEnabled(Boolean anonymousAuthEnabled) {
            this.anonymousAuthEnabled = anonymousAuthEnabled;
            return this;
        }

        @Override
        public AdvancedSecurityOptions build() {
            return new AdvancedSecurityOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
