/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.toolkit.search.expression;

import org.terracotta.toolkit.search.SearchException;
import org.terracotta.toolkit.search.attribute.ToolkitAttributeType;
import org.terracotta.toolkit.search.expression.BaseClause;

public abstract class RelationalClause
extends BaseClause {
    private final String attributeName;
    private final String tag;
    private final Comparable value;

    protected RelationalClause(String attributeName, String tag, Object value) {
        ToolkitAttributeType type = ToolkitAttributeType.typeFor(attributeName, value);
        if (!type.isComparable()) {
            throw new SearchException("Illegal (non-comparable) type for comparsion (" + (Object)((Object)type) + ")");
        }
        this.attributeName = attributeName;
        this.tag = tag;
        this.value = (Comparable)value;
    }

    public Comparable getValue() {
        return this.value;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getAttributeName()).append(" ").append(this.tag).append(" ").append(this.getValue());
        return sb.toString();
    }

    public static RelationalClause lt(String name, Object value) {
        return new LessThan(name, value);
    }

    public static RelationalClause gt(String name, Object value) {
        return new GreaterThan(name, value);
    }

    public static RelationalClause lte(String name, Object value) {
        return new LessThanOrEqual(name, value);
    }

    public static RelationalClause gte(String name, Object value) {
        return new GreaterThanOrEqual(name, value);
    }

    public static final class GreaterThanOrEqual
    extends RelationalClause {
        public GreaterThanOrEqual(String attributeName, Object value) {
            super(attributeName, ">=", value);
        }
    }

    public static final class LessThanOrEqual
    extends RelationalClause {
        public LessThanOrEqual(String attributeName, Object value) {
            super(attributeName, "<=", value);
        }
    }

    public static final class GreaterThan
    extends RelationalClause {
        public GreaterThan(String attributeName, Object value) {
            super(attributeName, ">", value);
        }
    }

    public static final class LessThan
    extends RelationalClause {
        public LessThan(String attributeName, Object value) {
            super(attributeName, "<", value);
        }
    }
}

