/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.forge.plugin;

import com.softwareag.ibit.tools.util.Finder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAGFinderMojo
extends AbstractMojo {
    protected MavenProject project;
    private String excludeGroupIds;
    private String excludeArtifactIds;
    private boolean skip;
    private boolean onlyRunWhenSagDepsIsTrue;
    private String scanDirectory;
    private String exclusionList;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"skip is set to true. Skipping");
            return;
        }
        if (this.onlyRunWhenSagDepsIsTrue && !Boolean.getBoolean("sag-deps")) {
            this.getLog().info((CharSequence)"Skipped condition found: onlyRunWhenSagDepsIsTrue = true and sag-deps = false");
            return;
        }
        try {
            if (!SAGFinderMojo.isEmpty(this.scanDirectory)) {
                this.doScanDirectory();
            } else {
                this.doScanDependencies();
            }
            this.getLog().info((CharSequence)"Scanning completed! Nothing flagged by Finder");
        }
        catch (Exception e) {
            if (e instanceof MojoExecutionException) {
                throw (MojoExecutionException)e;
            }
            throw new MojoExecutionException("Error", e);
        }
    }

    private void doScanDirectory() throws Exception {
        this.getLog().info((CharSequence)("About to scan " + this.scanDirectory + " with Finder"));
        if (this.isFlaggedByFinder(this.scanDirectory)) {
            throw new MojoExecutionException("Finder found Oracle jar(s)");
        }
    }

    private void doScanDependencies() throws Exception {
        this.getLog().info((CharSequence)"About to scan dependencies with Finder");
        Set<Artifact> artifacts = SAGFinderMojo.filterCompileAndRuntimeScope(this.project.getArtifacts());
        artifacts = this.filterExcludeGroupIds(artifacts);
        artifacts = this.filterExcludeArtifactIds(artifacts);
        for (Artifact a : artifacts) {
            this.getLog().info((CharSequence)("Scanning " + a));
            if (!this.isFlaggedByFinder(a.getFile().getAbsolutePath())) continue;
            throw new MojoExecutionException("Artifact " + a + " was flagged by Finder");
        }
    }

    private static Set<Artifact> filterCompileAndRuntimeScope(Set<Artifact> artifacts) {
        HashSet<Artifact> result = new HashSet<Artifact>();
        for (Artifact a : artifacts) {
            if (!a.getArtifactHandler().isAddedToClasspath() || !"compile".equals(a.getScope()) && !"runtime".equals(a.getScope())) continue;
            result.add(a);
        }
        return result;
    }

    private Set<Artifact> filterExcludeGroupIds(Set<Artifact> artifacts) {
        if (SAGFinderMojo.isEmpty(this.excludeGroupIds)) {
            return artifacts;
        }
        HashSet<Artifact> result = new HashSet<Artifact>();
        List<String> excludes = Arrays.asList(this.excludeGroupIds.split("\\s*,\\s*"));
        for (Artifact a : artifacts) {
            if (!excludes.contains(a.getGroupId())) {
                result.add(a);
                continue;
            }
            this.getLog().info((CharSequence)("Exclude " + a + " from scanning"));
        }
        return result;
    }

    private Set<Artifact> filterExcludeArtifactIds(Set<Artifact> artifacts) {
        if (SAGFinderMojo.isEmpty(this.excludeArtifactIds)) {
            return artifacts;
        }
        HashSet<Artifact> result = new HashSet<Artifact>();
        List<String> excludes = Arrays.asList(this.excludeArtifactIds.split("\\s*,\\s*"));
        for (Artifact a : artifacts) {
            if (!excludes.contains(a.getArtifactId())) {
                result.add(a);
                continue;
            }
            this.getLog().info((CharSequence)("Exclude " + a + " from scanning"));
        }
        return result;
    }

    private boolean isFlaggedByFinder(String file) throws Exception {
        List resultList;
        Finder finder = new Finder();
        finder.setPackageOnlySearch(true);
        finder.setSearchRootDirectory(file);
        finder.setUniqueEnabled(true);
        if (!SAGFinderMojo.isEmpty(this.exclusionList)) {
            finder.setExcludesListFilename(this.exclusionList);
        }
        if ((resultList = finder.doSearch()).size() > 0) {
            for (String result : resultList) {
                this.getLog().error((CharSequence)("Flagged: " + result));
            }
            return true;
        }
        return false;
    }

    private static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }
}

