/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.forge.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.terracotta.forge.plugin.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManifestMojo
extends AbstractMojo {
    private File manifestFile;
    protected MavenProject project;
    private final Map<String, String> manifestEntries = new HashMap<String, String>();
    private String rootPath;
    private boolean addClasspath;
    private String excludeGroupIds;

    public void execute() throws MojoExecutionException {
        Manifest manifest = this.createOrLoadManifest();
        Attributes attributes = manifest.getMainAttributes();
        this.addClasspath(attributes);
        this.addExtraManifestEntries(attributes);
        this.addBuildAttributes(attributes);
        this.saveManifestFile(manifest);
    }

    private void addClasspath(Attributes attributes) {
        if (!this.addClasspath) {
            return;
        }
        Set artifacts = this.project.getArtifacts();
        Set<String> excludedGroupIds = this.getExcludedGroupIds();
        StringBuilder mavenStyleClassPath = new StringBuilder();
        StringBuilder classpath = new StringBuilder();
        for (Artifact a : artifacts) {
            File file;
            if (excludedGroupIds.contains(a.getGroupId())) {
                this.getLog().info((CharSequence)("Excluding " + a + " from manifest's classpath"));
                continue;
            }
            if (!a.getArtifactHandler().isAddedToClasspath() || !"compile".equals(a.getScope()) && !"runtime".equals(a.getScope()) || (file = a.getFile()).isDirectory() && file.getName().endsWith("classes")) continue;
            classpath.append(file.getName()).append(" ");
            mavenStyleClassPath.append(a.getGroupId() + ":" + a.getArtifactId() + ":" + a.getBaseVersion() + ":" + a.getType()).append(" ");
        }
        if (classpath.length() > 0) {
            classpath.deleteCharAt(classpath.length() - 1);
            mavenStyleClassPath.deleteCharAt(mavenStyleClassPath.length() - 1);
        }
        attributes.putValue("Class-Path", classpath.toString());
        attributes.putValue("Maven-Class-Path", mavenStyleClassPath.toString());
    }

    private Set<String> getExcludedGroupIds() {
        if (this.excludeGroupIds == null || "".equals(this.excludeGroupIds)) {
            return Collections.EMPTY_SET;
        }
        String[] groupIds = this.excludeGroupIds.split(",");
        HashSet<String> rv = new HashSet<String>();
        for (String groupId : groupIds) {
            rv.add(groupId.trim());
        }
        return rv;
    }

    private void saveManifestFile(Manifest manifest) throws MojoExecutionException {
        FileOutputStream out = null;
        try {
            this.manifestFile.getAbsoluteFile().getParentFile().mkdirs();
            out = new FileOutputStream(this.manifestFile);
            manifest.write(out);
            out.flush();
        }
        catch (IOException ex) {
            try {
                throw new MojoExecutionException("Failed to write out manifest file", (Exception)ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    protected Manifest createOrLoadManifest() throws MojoExecutionException {
        Manifest manifest = new Manifest();
        if (this.manifestFile != null && this.manifestFile.exists()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(this.manifestFile);
                Manifest existingManifest = new Manifest(in);
                manifest = new Manifest(existingManifest);
            }
            catch (IOException ex) {
                try {
                    throw new MojoExecutionException("Failed to read existing manifest", (Exception)ex);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)in);
        }
        return manifest;
    }

    private void addExtraManifestEntries(Attributes attributes) {
        if (this.manifestEntries == null) {
            return;
        }
        for (Map.Entry<String, String> entry : this.manifestEntries.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if ("Class-Path".equals(key) && attributes.containsKey(new Attributes.Name("Class-Path"))) {
                String extendedClasspath = attributes.getValue("Class-Path") + " " + value;
                attributes.putValue(key, extendedClasspath);
                continue;
            }
            attributes.putValue(key, value);
        }
    }

    private void addBuildAttributes(Attributes attributes) throws MojoExecutionException {
        String UNKNOWN = "unknown";
        String BUILDINFO = "BuildInfo-";
        String urlKey = "URL: ";
        String revisionKey = "Last Changed Rev: ";
        String host = "unknown";
        String svnUrl = "unknown";
        String revision = "unknown";
        String user = System.getProperty("user.name", "unknown");
        String timestamp = new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            this.getLog().warn((CharSequence)"Exception while finding host name", (Throwable)e);
        }
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attributes.putValue("BuildInfo-User", user);
        attributes.putValue("BuildInfo-Host", host);
        attributes.putValue("BuildInfo-Timestamp", timestamp);
        if (this.rootPath == null) {
            this.rootPath = this.project.getBasedir().getAbsolutePath();
        }
        try {
            this.getLog().debug((CharSequence)("root path " + this.rootPath));
            String svnInfo = Util.getSvnInfo(new File(this.rootPath).getCanonicalPath());
            this.getLog().debug((CharSequence)("svn info " + svnInfo));
            BufferedReader br = new BufferedReader(new StringReader(svnInfo));
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("URL: ")) {
                    svnUrl = line.substring("URL: ".length());
                }
                if (!line.startsWith("Last Changed Rev: ")) continue;
                revision = line.substring("Last Changed Rev: ".length());
            }
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Exception reading svn info", (Exception)ioe);
        }
        attributes.putValue("BuildInfo-URL", svnUrl);
        attributes.putValue("BuildInfo-Revision", revision);
    }
}

