/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.forge.plugin;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.CumulativeScopeArtifactFilter;
import org.apache.maven.model.Repository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="enforceDependencies", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class EnforceMatchingDependenciesMojo
extends AbstractMojo {
    @Parameter(required=true, property="project", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}")
    private List<Repository> remoteRepositories;
    @Parameter(required=true, property="localRepository", readonly=true)
    private ArtifactRepository localRepository;
    @Parameter(required=true, property="enforceArtifactId")
    private String enforceArtifactId;
    @Parameter(required=true, property="enforceGroupId")
    private String enforceGroupId;
    @Parameter(required=false, property="enforceType", defaultValue="jar")
    private String enforceType;
    @Parameter(required=true, property="enforceVersion")
    private String enforceVersion;
    @Parameter(required=false, property="excludeGroupIds")
    private String excludeGroupIds;
    @Component
    private RepositorySystem repositorySystem;
    @Component
    private ProjectDependenciesResolver projectDependenciesResolver;
    @Component
    private MavenProjectBuilder mavenProjectBuilder;
    @Component
    private DependencyGraphBuilder dependencyGraphBuilder;
    @Component
    private ArtifactFactory defaultArtifactFactory;

    public void execute() throws MojoExecutionException {
        try {
            Artifact enforceArtifact = this.defaultArtifactFactory.createArtifact(this.enforceGroupId, this.enforceArtifactId, this.enforceVersion, "", this.enforceType);
            MavenProject enforcePom = this.mavenProjectBuilder.buildFromRepository(enforceArtifact, this.remoteRepositories, this.localRepository);
            DependencyNode rootNode = this.dependencyGraphBuilder.buildDependencyGraph(enforcePom, (ArtifactFilter)new CumulativeScopeArtifactFilter(Arrays.asList("compile", "runtime")));
            HashSet<DependencyNode> nodes = new HashSet<DependencyNode>();
            this.getAllNodes(rootNode, nodes);
            nodes.remove(rootNode);
            Set<Artifact> enforceArtifacts = new HashSet<Artifact>();
            for (DependencyNode node : nodes) {
                Artifact artifact = node.getArtifact();
                enforceArtifacts.add(this.defaultArtifactFactory.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getScope(), artifact.getType()));
            }
            this.getLog().debug((CharSequence)("enforce artifacts before exclusions: " + enforceArtifacts));
            enforceArtifacts = EnforceMatchingDependenciesMojo.filterCompileAndRuntimeScope(enforceArtifacts);
            if (this.excludeGroupIds != null) {
                enforceArtifacts = EnforceMatchingDependenciesMojo.filterExcludeGroupIds(enforceArtifacts, this.excludeGroupIds);
                this.getLog().debug((CharSequence)("enforce artifacts after exclusions: " + enforceArtifacts));
            }
            Set artifacts = this.project.getArtifacts();
            Set<Artifact> thisProjectArtifacts = EnforceMatchingDependenciesMojo.filterCompileAndRuntimeScope(artifacts);
            this.getLog().debug((CharSequence)("current artifacts: " + thisProjectArtifacts));
            if (!thisProjectArtifacts.containsAll(enforceArtifacts)) {
                HashSet<Artifact> missingArtifacts = new HashSet<Artifact>(enforceArtifacts);
                missingArtifacts.removeAll(thisProjectArtifacts);
                String message = "This pom is missing some dependencies of the enforcing artifact " + enforceArtifact + "\n";
                message = message + "Missing " + missingArtifacts;
                throw new MojoFailureException(message);
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)e.getMessage());
            throw new MojoExecutionException("Error", e);
        }
    }

    private void getAllNodes(DependencyNode node, Set<DependencyNode> currentNodes) {
        currentNodes.add(node);
        for (DependencyNode currentNode : node.getChildren()) {
            this.getAllNodes(currentNode, currentNodes);
        }
    }

    private static Set<Artifact> filterCompileAndRuntimeScope(Set<Artifact> artifacts) {
        HashSet<Artifact> result = new HashSet<Artifact>();
        for (Artifact a : artifacts) {
            if (!a.getArtifactHandler().isAddedToClasspath() || !"compile".equals(a.getScope()) && !"runtime".equals(a.getScope())) continue;
            result.add(a);
        }
        return result;
    }

    private static Set<Artifact> filterExcludeGroupIds(Set<Artifact> artifacts, String excludeGroupIds) {
        HashSet<Artifact> result = new HashSet<Artifact>();
        List<String> excludes = Arrays.asList(excludeGroupIds.split("\\s*,\\s*"));
        for (Artifact a : artifacts) {
            if (excludes.contains(a.getGroupId())) continue;
            result.add(a);
        }
        return result;
    }
}

