/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.commonj;

import commonj.work.Work;
import commonj.work.WorkException;
import commonj.work.WorkItem;
import commonj.work.WorkListener;
import commonj.work.WorkManager;
import java.util.Collection;
import javax.naming.NamingException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jndi.JndiLocatorSupport;
import org.springframework.scheduling.SchedulingException;
import org.springframework.scheduling.SchedulingTaskExecutor;
import org.springframework.scheduling.commonj.DelegatingWork;
import org.springframework.util.Assert;

public class WorkManagerTaskExecutor
extends JndiLocatorSupport
implements SchedulingTaskExecutor,
WorkManager,
InitializingBean {
    private WorkManager workManager;
    private String workManagerName;
    static /* synthetic */ Class class$commonj$work$WorkManager;

    public void setWorkManager(WorkManager workManager) {
        this.workManager = workManager;
    }

    public void setWorkManagerName(String workManagerName) {
        this.workManagerName = workManagerName;
    }

    public void afterPropertiesSet() throws NamingException {
        if (this.workManager == null) {
            if (this.workManagerName == null) {
                throw new IllegalArgumentException("Either 'workManager' or 'workManagerName' must be specified");
            }
            this.workManager = (WorkManager)this.lookup(this.workManagerName, class$commonj$work$WorkManager == null ? (class$commonj$work$WorkManager = WorkManagerTaskExecutor.class$("commonj.work.WorkManager")) : class$commonj$work$WorkManager);
        }
    }

    public void execute(Runnable task) {
        Assert.notNull(this.workManager, "WorkManager is required");
        try {
            this.workManager.schedule((Work)new DelegatingWork(task));
        }
        catch (WorkException ex) {
            throw new SchedulingException("Could not schedule work on CommonJ WorkManager", ex);
        }
    }

    public boolean prefersShortLivedTasks() {
        return true;
    }

    public WorkItem schedule(Work work) throws WorkException, IllegalArgumentException {
        return this.workManager.schedule(work);
    }

    public WorkItem schedule(Work work, WorkListener workListener) throws WorkException, IllegalArgumentException {
        return this.workManager.schedule(work, workListener);
    }

    public boolean waitForAll(Collection workItems, long timeout) throws InterruptedException, IllegalArgumentException {
        return this.workManager.waitForAll(workItems, timeout);
    }

    public Collection waitForAny(Collection workItems, long timeout) throws InterruptedException, IllegalArgumentException {
        return this.workManager.waitForAny(workItems, timeout);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

