/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.ExpressionInvocationTargetException;
import org.springframework.expression.MethodExecutor;
import org.springframework.expression.MethodResolver;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.FormatHelper;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.ast.ValueRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodReference
extends SpelNodeImpl {
    private final String name;
    private final boolean nullSafe;
    private volatile CachedMethodExecutor cachedExecutor;

    public MethodReference(boolean nullSafe, String methodName, int pos, SpelNodeImpl ... arguments) {
        super(pos, arguments);
        this.name = methodName;
        this.nullSafe = nullSafe;
    }

    public final String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ValueRef getValueRef(ExpressionState state) throws EvaluationException {
        TypedValue currentContext = state.getActiveContextObject();
        Object[] arguments = new Object[this.getChildCount()];
        for (int i = 0; i < arguments.length; ++i) {
            try {
                state.pushActiveContextObject(state.getRootContextObject());
                arguments[i] = this.children[i].getValueInternal(state).getValue();
                continue;
            }
            finally {
                state.popActiveContextObject();
            }
        }
        if (currentContext.getValue() == null) {
            if (this.nullSafe) {
                return ValueRef.NullValueRef.instance;
            }
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.METHOD_CALL_ON_NULL_OBJECT_NOT_ALLOWED, FormatHelper.formatMethodForMessage(this.name, this.getTypes(arguments)));
        }
        return new MethodValueRef(state, state.getEvaluationContext(), state.getActiveContextObject().getValue(), arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        TypedValue currentContext = state.getActiveContextObject();
        Object[] arguments = new Object[this.getChildCount()];
        for (int i = 0; i < arguments.length; ++i) {
            try {
                state.pushActiveContextObject(state.getRootContextObject());
                arguments[i] = this.children[i].getValueInternal(state).getValue();
                continue;
            }
            finally {
                state.popActiveContextObject();
            }
        }
        List<TypeDescriptor> argumentTypes = this.getTypes(arguments);
        if (currentContext.getValue() == null) {
            if (this.nullSafe) {
                return TypedValue.NULL;
            }
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.METHOD_CALL_ON_NULL_OBJECT_NOT_ALLOWED, FormatHelper.formatMethodForMessage(this.name, argumentTypes));
        }
        MethodExecutor executorToUse = this.getCachedExecutor(argumentTypes);
        if (executorToUse != null) {
            try {
                return executorToUse.execute(state.getEvaluationContext(), state.getActiveContextObject().getValue(), arguments);
            }
            catch (AccessException ae) {
                this.throwSimpleExceptionIfPossible(state, ae);
                this.cachedExecutor = null;
            }
        }
        executorToUse = this.findAccessorForMethod(this.name, argumentTypes, state);
        this.cachedExecutor = new CachedMethodExecutor(executorToUse, argumentTypes);
        try {
            return executorToUse.execute(state.getEvaluationContext(), state.getActiveContextObject().getValue(), arguments);
        }
        catch (AccessException ae) {
            this.throwSimpleExceptionIfPossible(state, ae);
            throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ae, SpelMessage.EXCEPTION_DURING_METHOD_INVOCATION, this.name, state.getActiveContextObject().getValue().getClass().getName(), ae.getMessage());
        }
    }

    private void throwSimpleExceptionIfPossible(ExpressionState state, AccessException ae) {
        if (ae.getCause() instanceof InvocationTargetException) {
            Throwable rootCause = ae.getCause().getCause();
            if (rootCause instanceof RuntimeException) {
                throw (RuntimeException)rootCause;
            }
            throw new ExpressionInvocationTargetException(this.getStartPosition(), "A problem occurred when trying to execute method '" + this.name + "' on object of type '" + state.getActiveContextObject().getValue().getClass().getName() + "'", rootCause);
        }
    }

    private List<TypeDescriptor> getTypes(Object ... arguments) {
        ArrayList<TypeDescriptor> descriptors = new ArrayList<TypeDescriptor>(arguments.length);
        for (Object argument : arguments) {
            descriptors.add(TypeDescriptor.forObject((Object)argument));
        }
        return Collections.unmodifiableList(descriptors);
    }

    @Override
    public String toStringAST() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append("(");
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.getChild(i).toStringAST());
        }
        sb.append(")");
        return sb.toString();
    }

    private MethodExecutor findAccessorForMethod(String name, List<TypeDescriptor> argumentTypes, ExpressionState state) throws SpelEvaluationException {
        return this.findAccessorForMethod(name, argumentTypes, state.getActiveContextObject().getValue(), state.getEvaluationContext());
    }

    private MethodExecutor findAccessorForMethod(String name, List<TypeDescriptor> argumentTypes, Object contextObject, EvaluationContext eContext) throws SpelEvaluationException {
        List<MethodResolver> methodResolvers = eContext.getMethodResolvers();
        if (methodResolvers != null) {
            for (MethodResolver methodResolver : methodResolvers) {
                try {
                    MethodExecutor methodExecutor = methodResolver.resolve(eContext, contextObject, name, argumentTypes);
                    if (methodExecutor == null) continue;
                    return methodExecutor;
                }
                catch (AccessException ex) {
                    throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ex, SpelMessage.PROBLEM_LOCATING_METHOD, name, contextObject.getClass());
                }
            }
        }
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.METHOD_NOT_FOUND, FormatHelper.formatMethodForMessage(name, argumentTypes), FormatHelper.formatClassNameForMessage(contextObject instanceof Class ? (Class<?>)contextObject : contextObject.getClass()));
    }

    private MethodExecutor getCachedExecutor(List<TypeDescriptor> argumentTypes) {
        if (this.cachedExecutor == null || !this.cachedExecutor.isSuitable(argumentTypes)) {
            this.cachedExecutor = null;
            return null;
        }
        return this.cachedExecutor.get();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CachedMethodExecutor {
        private final MethodExecutor methodExecutor;
        private final List<TypeDescriptor> argumentTypes;

        public CachedMethodExecutor(MethodExecutor methodExecutor, List<TypeDescriptor> argumentTypes) {
            this.methodExecutor = methodExecutor;
            this.argumentTypes = argumentTypes;
        }

        public boolean isSuitable(List<TypeDescriptor> argumentTypes) {
            return this.methodExecutor != null && this.argumentTypes.equals(argumentTypes);
        }

        public MethodExecutor get() {
            return this.methodExecutor;
        }
    }

    private class MethodValueRef
    implements ValueRef {
        private final ExpressionState state;
        private final EvaluationContext evaluationContext;
        private final Object target;
        private final Object[] arguments;
        private final List<TypeDescriptor> argumentTypes;

        MethodValueRef(ExpressionState state, EvaluationContext evaluationContext, Object object, Object[] arguments) {
            this.state = state;
            this.evaluationContext = evaluationContext;
            this.target = object;
            this.arguments = arguments;
            this.argumentTypes = MethodReference.this.getTypes(this.arguments);
        }

        public TypedValue getValue() {
            MethodExecutor executorToUse = MethodReference.this.getCachedExecutor(this.argumentTypes);
            if (executorToUse != null) {
                try {
                    return executorToUse.execute(this.evaluationContext, this.target, this.arguments);
                }
                catch (AccessException ae) {
                    MethodReference.this.throwSimpleExceptionIfPossible(this.state, ae);
                    MethodReference.this.cachedExecutor = null;
                }
            }
            executorToUse = MethodReference.this.findAccessorForMethod(MethodReference.this.name, this.argumentTypes, this.target, this.evaluationContext);
            MethodReference.this.cachedExecutor = new CachedMethodExecutor(executorToUse, this.argumentTypes);
            try {
                return executorToUse.execute(this.evaluationContext, this.target, this.arguments);
            }
            catch (AccessException ex) {
                MethodReference.this.throwSimpleExceptionIfPossible(this.state, ex);
                throw new SpelEvaluationException(MethodReference.this.getStartPosition(), (Throwable)ex, SpelMessage.EXCEPTION_DURING_METHOD_INVOCATION, MethodReference.this.name, this.state.getActiveContextObject().getValue().getClass().getName(), ex.getMessage());
            }
        }

        public void setValue(Object newValue) {
            throw new IllegalAccessError();
        }

        public boolean isWritable() {
            return false;
        }
    }
}

