/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.connect.web;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.springframework.util.Assert;

class ThrowableAnalyzer {
    public static final ThrowableCauseExtractor DEFAULT_EXTRACTOR = new ThrowableCauseExtractor(){

        @Override
        public Throwable extractCause(Throwable throwable) {
            return throwable.getCause();
        }
    };
    public static final ThrowableCauseExtractor INVOCATIONTARGET_EXTRACTOR = new ThrowableCauseExtractor(){

        @Override
        public Throwable extractCause(Throwable throwable) {
            ThrowableAnalyzer.verifyThrowableHierarchy(throwable, InvocationTargetException.class);
            return ((InvocationTargetException)throwable).getTargetException();
        }
    };
    private static final Comparator<Class<? extends Throwable>> CLASS_HIERARCHY_COMPARATOR = new Comparator<Class<? extends Throwable>>(){

        @Override
        public int compare(Class<? extends Throwable> class1, Class<? extends Throwable> class2) {
            if (class1.isAssignableFrom(class2)) {
                return 1;
            }
            if (class2.isAssignableFrom(class1)) {
                return -1;
            }
            return class1.getName().compareTo(class2.getName());
        }
    };
    private final Map<Class<? extends Throwable>, ThrowableCauseExtractor> extractorMap = new TreeMap<Class<Throwable>, ThrowableCauseExtractor>(CLASS_HIERARCHY_COMPARATOR);

    public ThrowableAnalyzer() {
        this.initExtractorMap();
    }

    protected final void registerExtractor(Class<? extends Throwable> throwableType, ThrowableCauseExtractor extractor) {
        Assert.notNull((Object)extractor, (String)"Invalid extractor: null");
        this.extractorMap.put(throwableType, extractor);
    }

    protected void initExtractorMap() {
        this.registerExtractor(InvocationTargetException.class, INVOCATIONTARGET_EXTRACTOR);
        this.registerExtractor(Throwable.class, DEFAULT_EXTRACTOR);
    }

    final Class<? extends Throwable>[] getRegisteredTypes() {
        Set<Class<? extends Throwable>> typeList = this.extractorMap.keySet();
        Class[] a = new Class[typeList.size()];
        return typeList.toArray(a);
    }

    public final Throwable[] determineCauseChain(Throwable throwable) {
        if (throwable == null) {
            throw new IllegalArgumentException("Invalid throwable: null");
        }
        ArrayList<Throwable> chain = new ArrayList<Throwable>();
        Throwable currentThrowable = throwable;
        while (currentThrowable != null) {
            chain.add(currentThrowable);
            currentThrowable = this.extractCause(currentThrowable);
        }
        return chain.toArray(new Throwable[chain.size()]);
    }

    private Throwable extractCause(Throwable throwable) {
        for (Map.Entry<Class<? extends Throwable>, ThrowableCauseExtractor> entry : this.extractorMap.entrySet()) {
            Class<? extends Throwable> throwableType = entry.getKey();
            if (!throwableType.isInstance(throwable)) continue;
            ThrowableCauseExtractor extractor = entry.getValue();
            return extractor.extractCause(throwable);
        }
        return null;
    }

    public final Throwable getFirstThrowableOfType(Class<? extends Throwable> throwableType, Throwable[] chain) {
        if (chain != null) {
            for (Throwable t : chain) {
                if (t == null || !throwableType.isInstance(t)) continue;
                return t;
            }
        }
        return null;
    }

    public static void verifyThrowableHierarchy(Throwable throwable, Class<? extends Throwable> expectedBaseType) {
        if (expectedBaseType == null) {
            return;
        }
        if (throwable == null) {
            throw new IllegalArgumentException("Invalid throwable: null");
        }
        Class<?> throwableType = throwable.getClass();
        if (!expectedBaseType.isAssignableFrom(throwableType)) {
            throw new IllegalArgumentException("Invalid type: '" + throwableType.getName() + "'. Has to be a subclass of '" + expectedBaseType.getName() + "'");
        }
    }

    private static interface ThrowableCauseExtractor {
        public Throwable extractCause(Throwable var1);
    }
}

