/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.connect.web;

import org.springframework.social.connect.Connection;
import org.springframework.social.connect.ConnectionFactoryLocator;
import org.springframework.social.connect.UsersConnectionRepository;
import org.springframework.social.connect.web.HttpSessionSessionStrategy;
import org.springframework.social.connect.web.ProviderSignInAttempt;
import org.springframework.social.connect.web.SessionStrategy;
import org.springframework.web.context.request.RequestAttributes;

public class ProviderSignInUtils {
    private SessionStrategy sessionStrategy;
    private ConnectionFactoryLocator connectionFactoryLocator;
    private UsersConnectionRepository connectionRepository;

    public ProviderSignInUtils(ConnectionFactoryLocator connectionFactoryLocator, UsersConnectionRepository connectionRepository) {
        this(new HttpSessionSessionStrategy(), connectionFactoryLocator, connectionRepository);
    }

    public ProviderSignInUtils(SessionStrategy sessionStrategy, ConnectionFactoryLocator connectionFactoryLocator, UsersConnectionRepository connectionRepository) {
        this.sessionStrategy = sessionStrategy;
        this.connectionFactoryLocator = connectionFactoryLocator;
        this.connectionRepository = connectionRepository;
    }

    public Connection<?> getConnectionFromSession(RequestAttributes request) {
        ProviderSignInAttempt signInAttempt = this.getProviderUserSignInAttempt(request);
        return signInAttempt != null ? signInAttempt.getConnection(this.connectionFactoryLocator) : null;
    }

    public void doPostSignUp(String userId, RequestAttributes request) {
        ProviderSignInAttempt signInAttempt = (ProviderSignInAttempt)this.sessionStrategy.getAttribute(request, ProviderSignInAttempt.SESSION_ATTRIBUTE);
        if (signInAttempt != null) {
            signInAttempt.addConnection(userId, this.connectionFactoryLocator, this.connectionRepository);
            this.sessionStrategy.removeAttribute(request, ProviderSignInAttempt.SESSION_ATTRIBUTE);
        }
    }

    private ProviderSignInAttempt getProviderUserSignInAttempt(RequestAttributes request) {
        return (ProviderSignInAttempt)this.sessionStrategy.getAttribute(request, ProviderSignInAttempt.SESSION_ATTRIBUTE);
    }
}

