/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.connect.web;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.ConnectionFactory;
import org.springframework.social.connect.support.OAuth1ConnectionFactory;
import org.springframework.social.connect.support.OAuth2ConnectionFactory;
import org.springframework.social.connect.web.HttpSessionSessionStrategy;
import org.springframework.social.connect.web.SessionStrategy;
import org.springframework.social.oauth1.AuthorizedRequestToken;
import org.springframework.social.oauth1.OAuth1Operations;
import org.springframework.social.oauth1.OAuth1Parameters;
import org.springframework.social.oauth1.OAuth1Version;
import org.springframework.social.oauth1.OAuthToken;
import org.springframework.social.oauth2.AccessGrant;
import org.springframework.social.oauth2.OAuth2Operations;
import org.springframework.social.oauth2.OAuth2Parameters;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.WebRequest;

public class ConnectSupport {
    private static final Log logger = LogFactory.getLog(ConnectSupport.class);
    private boolean useAuthenticateUrl;
    private String applicationUrl;
    private String callbackUrl;
    private SessionStrategy sessionStrategy;
    private static final String OAUTH_TOKEN_ATTRIBUTE = "oauthToken";
    private static final String OAUTH2_STATE_ATTRIBUTE = "oauth2State";

    public ConnectSupport() {
        this(new HttpSessionSessionStrategy());
    }

    public ConnectSupport(SessionStrategy sessionStrategy) {
        this.sessionStrategy = sessionStrategy;
    }

    public void setUseAuthenticateUrl(boolean useAuthenticateUrl) {
        this.useAuthenticateUrl = useAuthenticateUrl;
    }

    public void setApplicationUrl(String applicationUrl) {
        this.applicationUrl = applicationUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public String buildOAuthUrl(ConnectionFactory<?> connectionFactory, NativeWebRequest request) {
        return this.buildOAuthUrl(connectionFactory, request, null);
    }

    public String buildOAuthUrl(ConnectionFactory<?> connectionFactory, NativeWebRequest request, MultiValueMap<String, String> additionalParameters) {
        if (connectionFactory instanceof OAuth1ConnectionFactory) {
            return this.buildOAuth1Url((OAuth1ConnectionFactory)connectionFactory, request, additionalParameters);
        }
        if (connectionFactory instanceof OAuth2ConnectionFactory) {
            return this.buildOAuth2Url((OAuth2ConnectionFactory)connectionFactory, request, additionalParameters);
        }
        throw new IllegalArgumentException("ConnectionFactory not supported");
    }

    public Connection<?> completeConnection(OAuth1ConnectionFactory<?> connectionFactory, NativeWebRequest request) {
        String verifier = request.getParameter("oauth_verifier");
        AuthorizedRequestToken requestToken = new AuthorizedRequestToken(this.extractCachedRequestToken((WebRequest)request), verifier);
        OAuthToken accessToken = connectionFactory.getOAuthOperations().exchangeForAccessToken(requestToken, null);
        return connectionFactory.createConnection(accessToken);
    }

    public Connection<?> completeConnection(OAuth2ConnectionFactory<?> connectionFactory, NativeWebRequest request) {
        if (connectionFactory.supportsStateParameter()) {
            this.verifyStateParameter(request);
        }
        String code = request.getParameter("code");
        try {
            AccessGrant accessGrant = connectionFactory.getOAuthOperations().exchangeForAccess(code, this.callbackUrl(request), null);
            return connectionFactory.createConnection(accessGrant);
        }
        catch (HttpClientErrorException e) {
            logger.warn((Object)("HttpClientErrorException while completing connection: " + e.getMessage()));
            logger.warn((Object)("      Response body: " + e.getResponseBodyAsString()));
            throw e;
        }
    }

    private void verifyStateParameter(NativeWebRequest request) {
        String state = request.getParameter("state");
        String originalState = this.extractCachedOAuth2State((WebRequest)request);
        if (state == null || !state.equals(originalState)) {
            throw new IllegalStateException("The OAuth2 'state' parameter is missing or doesn't match.");
        }
    }

    protected String callbackUrl(NativeWebRequest request) {
        if (this.callbackUrl != null) {
            return this.callbackUrl;
        }
        HttpServletRequest nativeRequest = (HttpServletRequest)request.getNativeRequest(HttpServletRequest.class);
        if (this.applicationUrl != null) {
            return this.applicationUrl + this.connectPath(nativeRequest);
        }
        return nativeRequest.getRequestURL().toString();
    }

    private String buildOAuth1Url(OAuth1ConnectionFactory<?> connectionFactory, NativeWebRequest request, MultiValueMap<String, String> additionalParameters) {
        OAuth1Operations oauthOperations = connectionFactory.getOAuthOperations();
        MultiValueMap<String, String> requestParameters = this.getRequestParameters(request, new String[0]);
        OAuth1Parameters parameters = this.getOAuth1Parameters(request, additionalParameters);
        parameters.putAll(requestParameters);
        if (oauthOperations.getVersion() == OAuth1Version.CORE_10) {
            parameters.setCallbackUrl(this.callbackUrl(request));
        }
        OAuthToken requestToken = this.fetchRequestToken(request, requestParameters, oauthOperations);
        this.sessionStrategy.setAttribute((RequestAttributes)request, OAUTH_TOKEN_ATTRIBUTE, requestToken);
        return this.buildOAuth1Url(oauthOperations, requestToken.getValue(), parameters);
    }

    private OAuth1Parameters getOAuth1Parameters(NativeWebRequest request, MultiValueMap<String, String> additionalParameters) {
        OAuth1Parameters parameters = new OAuth1Parameters(additionalParameters);
        parameters.putAll(this.getRequestParameters(request, new String[0]));
        return parameters;
    }

    private OAuthToken fetchRequestToken(NativeWebRequest request, MultiValueMap<String, String> requestParameters, OAuth1Operations oauthOperations) {
        if (oauthOperations.getVersion() == OAuth1Version.CORE_10_REVISION_A) {
            return oauthOperations.fetchRequestToken(this.callbackUrl(request), requestParameters);
        }
        return oauthOperations.fetchRequestToken(null, requestParameters);
    }

    private String buildOAuth2Url(OAuth2ConnectionFactory<?> connectionFactory, NativeWebRequest request, MultiValueMap<String, String> additionalParameters) {
        OAuth2Operations oauthOperations = connectionFactory.getOAuthOperations();
        String defaultScope = connectionFactory.getScope();
        OAuth2Parameters parameters = this.getOAuth2Parameters(request, defaultScope, additionalParameters);
        String state = connectionFactory.generateState();
        parameters.add("state", state);
        this.sessionStrategy.setAttribute((RequestAttributes)request, OAUTH2_STATE_ATTRIBUTE, state);
        if (this.useAuthenticateUrl) {
            return oauthOperations.buildAuthenticateUrl(parameters);
        }
        return oauthOperations.buildAuthorizeUrl(parameters);
    }

    private OAuth2Parameters getOAuth2Parameters(NativeWebRequest request, String defaultScope, MultiValueMap<String, String> additionalParameters) {
        OAuth2Parameters parameters = new OAuth2Parameters(additionalParameters);
        parameters.putAll(this.getRequestParameters(request, "scope"));
        parameters.setRedirectUri(this.callbackUrl(request));
        String scope = request.getParameter("scope");
        if (scope != null) {
            parameters.setScope(scope);
        } else if (defaultScope != null) {
            parameters.setScope(defaultScope);
        }
        return parameters;
    }

    private String connectPath(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        return request.getServletPath() + (pathInfo != null ? pathInfo : "");
    }

    private String buildOAuth1Url(OAuth1Operations oauthOperations, String requestToken, OAuth1Parameters parameters) {
        if (this.useAuthenticateUrl) {
            return oauthOperations.buildAuthenticateUrl(requestToken, parameters);
        }
        return oauthOperations.buildAuthorizeUrl(requestToken, parameters);
    }

    private OAuthToken extractCachedRequestToken(WebRequest request) {
        OAuthToken requestToken = (OAuthToken)this.sessionStrategy.getAttribute((RequestAttributes)request, OAUTH_TOKEN_ATTRIBUTE);
        this.sessionStrategy.removeAttribute((RequestAttributes)request, OAUTH_TOKEN_ATTRIBUTE);
        return requestToken;
    }

    private String extractCachedOAuth2State(WebRequest request) {
        String state = (String)this.sessionStrategy.getAttribute((RequestAttributes)request, OAUTH2_STATE_ATTRIBUTE);
        this.sessionStrategy.removeAttribute((RequestAttributes)request, OAUTH2_STATE_ATTRIBUTE);
        return state;
    }

    private MultiValueMap<String, String> getRequestParameters(NativeWebRequest request, String ... ignoredParameters) {
        List<String> ignoredParameterList = Arrays.asList(ignoredParameters);
        LinkedMultiValueMap convertedMap = new LinkedMultiValueMap();
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            if (ignoredParameterList.contains(entry.getKey())) continue;
            convertedMap.put(entry.getKey(), Arrays.asList((Object[])entry.getValue()));
        }
        return convertedMap;
    }
}

