/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.social.twitter.api.StreamListener;
import org.springframework.social.twitter.api.StreamingException;
import org.springframework.social.twitter.api.impl.StreamDispatcher;
import org.springframework.social.twitter.api.impl.StreamReader;

class StreamReaderImpl
implements StreamReader {
    private AtomicBoolean open;
    private final InputStream inputStream;
    private final BufferedReader reader;
    private final Queue<String> queue;
    private final StreamDispatcher dispatcher;
    private final ScheduledFuture<?> future;
    private final ScheduledThreadPoolExecutor executor;

    public StreamReaderImpl(InputStream inputStream, List<StreamListener> listeners) {
        this.inputStream = inputStream;
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
        this.queue = new ConcurrentLinkedQueue<String>();
        this.dispatcher = new StreamDispatcher(this.queue, listeners);
        this.executor = new ScheduledThreadPoolExecutor(10);
        this.future = this.executor.scheduleAtFixedRate(this.dispatcher, 0L, 10L, TimeUnit.MILLISECONDS);
        this.open = new AtomicBoolean(true);
    }

    @Override
    public void next() {
        block3: {
            try {
                String line = this.reader.readLine();
                if (line == null) {
                    throw new IOException("Stream closed");
                }
                this.queue.add(line);
            }
            catch (IOException e) {
                if (!this.open.get()) break block3;
                this.close();
                throw new StreamingException("The Stream is closed", e);
            }
        }
    }

    @Override
    public void close() {
        try {
            this.open.set(false);
            this.future.cancel(true);
            this.executor.shutdown();
            this.dispatcher.stop();
            this.inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

