/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api.impl;

import java.util.List;
import org.springframework.social.twitter.api.SavedSearch;
import org.springframework.social.twitter.api.SearchOperations;
import org.springframework.social.twitter.api.SearchParameters;
import org.springframework.social.twitter.api.SearchResults;
import org.springframework.social.twitter.api.Trends;
import org.springframework.social.twitter.api.impl.AbstractTwitterOperations;
import org.springframework.social.twitter.api.impl.LocalTrendsHolder;
import org.springframework.social.twitter.api.impl.SavedSearchList;
import org.springframework.social.twitter.api.impl.SearchParametersUtil;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

class SearchTemplate
extends AbstractTwitterOperations
implements SearchOperations {
    private final RestTemplate restTemplate;

    public SearchTemplate(RestTemplate restTemplate, boolean isAuthorizedForUser, boolean isAuthorizedForApp) {
        super(isAuthorizedForUser, isAuthorizedForApp);
        this.restTemplate = restTemplate;
    }

    @Override
    public SearchResults search(String query) {
        return this.search(new SearchParameters(query));
    }

    @Override
    public SearchResults search(String query, int resultsPerPage) {
        SearchParameters p = new SearchParameters(query).count(resultsPerPage);
        return this.search(p);
    }

    @Override
    public SearchResults search(String query, int resultsPerPage, long sinceId, long maxId) {
        SearchParameters p = new SearchParameters(query).count(resultsPerPage).sinceId(sinceId);
        if (maxId > 0L) {
            p.maxId(maxId);
        }
        return this.search(p);
    }

    @Override
    public SearchResults search(SearchParameters searchParameters) {
        this.requireEitherUserOrAppAuthorization();
        Assert.notNull((Object)searchParameters);
        MultiValueMap<String, String> parameters = SearchParametersUtil.buildQueryParametersFromSearchParameters(searchParameters);
        return (SearchResults)this.restTemplate.getForObject(this.buildUri("search/tweets.json", parameters), SearchResults.class);
    }

    @Override
    public List<SavedSearch> getSavedSearches() {
        this.requireUserAuthorization();
        return (List)this.restTemplate.getForObject(this.buildUri("saved_searches/list.json"), SavedSearchList.class);
    }

    @Override
    public SavedSearch getSavedSearch(long searchId) {
        this.requireUserAuthorization();
        return (SavedSearch)this.restTemplate.getForObject(this.buildUri("saved_searches/show/" + searchId + ".json"), SavedSearch.class);
    }

    @Override
    public SavedSearch createSavedSearch(String query) {
        this.requireUserAuthorization();
        LinkedMultiValueMap data = new LinkedMultiValueMap();
        data.set((Object)"query", (Object)query);
        return (SavedSearch)this.restTemplate.postForObject(this.buildUri("saved_searches/create.json"), (Object)data, SavedSearch.class);
    }

    @Override
    public void deleteSavedSearch(long searchId) {
        this.requireUserAuthorization();
        LinkedMultiValueMap data = new LinkedMultiValueMap();
        this.restTemplate.postForObject(this.buildUri("saved_searches/destroy/" + searchId + ".json"), (Object)data, SavedSearch.class);
    }

    @Override
    public Trends getLocalTrends(long whereOnEarthId) {
        return this.getLocalTrends(whereOnEarthId, false);
    }

    @Override
    public Trends getLocalTrends(long whereOnEarthId, boolean excludeHashtags) {
        this.requireEitherUserOrAppAuthorization();
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"id", (Object)String.valueOf(whereOnEarthId));
        if (excludeHashtags) {
            parameters.set((Object)"exclude", (Object)"hashtags");
        }
        return ((LocalTrendsHolder)this.restTemplate.getForObject(this.buildUri("trends/place.json", (MultiValueMap<String, String>)parameters), LocalTrendsHolder.class)).getTrends();
    }
}

