/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api.impl;

import org.springframework.social.twitter.api.BlockOperations;
import org.springframework.social.twitter.api.CursoredList;
import org.springframework.social.twitter.api.TwitterProfile;
import org.springframework.social.twitter.api.impl.AbstractTwitterOperations;
import org.springframework.social.twitter.api.impl.CursoredLongList;
import org.springframework.social.twitter.api.impl.CursoredTwitterProfileUsersList;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

class BlockTemplate
extends AbstractTwitterOperations
implements BlockOperations {
    private final RestTemplate restTemplate;

    public BlockTemplate(RestTemplate restTemplate, boolean isAuthorizedForUser, boolean isAuthorizedForApp) {
        super(isAuthorizedForUser, isAuthorizedForApp);
        this.restTemplate = restTemplate;
    }

    @Override
    public TwitterProfile block(long userId) {
        this.requireUserAuthorization();
        LinkedMultiValueMap request = new LinkedMultiValueMap();
        request.set((Object)"user_id", (Object)String.valueOf(userId));
        return (TwitterProfile)this.restTemplate.postForObject(this.buildUri("blocks/create.json"), (Object)request, TwitterProfile.class);
    }

    @Override
    public TwitterProfile block(String screenName) {
        this.requireUserAuthorization();
        LinkedMultiValueMap request = new LinkedMultiValueMap();
        request.set((Object)"screen_name", (Object)screenName);
        return (TwitterProfile)this.restTemplate.postForObject(this.buildUri("blocks/create.json"), (Object)request, TwitterProfile.class);
    }

    @Override
    public TwitterProfile unblock(long userId) {
        this.requireUserAuthorization();
        LinkedMultiValueMap request = new LinkedMultiValueMap();
        request.set((Object)"user_id", (Object)String.valueOf(userId));
        return (TwitterProfile)this.restTemplate.postForObject(this.buildUri("blocks/destroy.json"), (Object)request, TwitterProfile.class);
    }

    @Override
    public TwitterProfile unblock(String screenName) {
        this.requireUserAuthorization();
        LinkedMultiValueMap request = new LinkedMultiValueMap();
        request.set((Object)"screen_name", (Object)screenName);
        return (TwitterProfile)this.restTemplate.postForObject(this.buildUri("blocks/destroy.json"), (Object)request, TwitterProfile.class);
    }

    @Override
    public CursoredList<TwitterProfile> getBlockedUsers() {
        return this.getBlockedUsersInCursor(-1L);
    }

    @Override
    public CursoredList<TwitterProfile> getBlockedUsersInCursor(long cursor) {
        this.requireUserAuthorization();
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"cursor", (Object)String.valueOf(cursor));
        return ((CursoredTwitterProfileUsersList)this.restTemplate.getForObject(this.buildUri("blocks/list.json", (MultiValueMap<String, String>)parameters), CursoredTwitterProfileUsersList.class)).getList();
    }

    @Override
    public CursoredList<Long> getBlockedUserIds() {
        return this.getBlockedUserIdsInCursor(-1L);
    }

    @Override
    public CursoredList<Long> getBlockedUserIdsInCursor(long cursor) {
        this.requireUserAuthorization();
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"cursor", (Object)String.valueOf(cursor));
        return ((CursoredLongList)this.restTemplate.getForObject(this.buildUri("blocks/ids.json", (MultiValueMap<String, String>)parameters), CursoredLongList.class)).getList();
    }
}

