/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.social.twitter.api.Entities;
import org.springframework.social.twitter.api.TickerSymbolEntity;
import org.springframework.social.twitter.api.Tweet;
import org.springframework.social.twitter.api.TwitterProfile;
import org.springframework.social.twitter.api.impl.TwitterModule;

class TweetDeserializer
extends JsonDeserializer<Tweet> {
    private static final String TIMELINE_DATE_FORMAT = "EEE MMM dd HH:mm:ss ZZZZZ yyyy";

    TweetDeserializer() {
    }

    public Tweet deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
        JsonNode node = (JsonNode)jp.readValueAs(JsonNode.class);
        if (null == node || node.isMissingNode() || node.isNull()) {
            return null;
        }
        Tweet tweet = this.deserialize(node);
        jp.skipChildren();
        return tweet;
    }

    public Tweet deserialize(JsonNode node) throws IOException, JsonProcessingException {
        String id = node.path("id").asText();
        String text = node.path("text").asText();
        if (id == null || text == null || text.isEmpty()) {
            return null;
        }
        JsonNode fromUserNode = node.get("user");
        String dateFormat = TIMELINE_DATE_FORMAT;
        String fromScreenName = fromUserNode.get("screen_name").asText();
        long fromId = fromUserNode.get("id").asLong();
        String fromImageUrl = fromUserNode.get("profile_image_url").asText();
        Date createdAt = this.toDate(node.get("created_at").asText(), new SimpleDateFormat(dateFormat, Locale.ENGLISH));
        String source = node.get("source").asText();
        JsonNode toUserIdNode = node.get("in_reply_to_user_id");
        Long toUserId = toUserIdNode != null ? Long.valueOf(toUserIdNode.asLong()) : null;
        JsonNode languageCodeNode = node.get("lang");
        String languageCode = languageCodeNode != null && !languageCodeNode.isNull() ? languageCodeNode.asText() : null;
        Tweet tweet = new Tweet(id, text, createdAt, fromScreenName, fromImageUrl, toUserId, fromId, languageCode, source);
        JsonNode inReplyToStatusIdNode = node.get("in_reply_to_status_id");
        Long inReplyToStatusId = inReplyToStatusIdNode != null && !inReplyToStatusIdNode.isNull() ? Long.valueOf(inReplyToStatusIdNode.asLong()) : null;
        tweet.setInReplyToStatusId(inReplyToStatusId);
        JsonNode inReplyToUserIdNode = node.get("in_reply_to_user_id");
        Long inReplyUsersId = inReplyToUserIdNode != null && !inReplyToUserIdNode.isNull() ? Long.valueOf(inReplyToUserIdNode.asLong()) : null;
        tweet.setInReplyToUserId(inReplyUsersId);
        tweet.setInReplyToScreenName(node.path("in_reply_to_screen_name").asText());
        JsonNode retweetCountNode = node.get("retweet_count");
        Integer retweetCount = retweetCountNode != null && !retweetCountNode.isNull() ? Integer.valueOf(retweetCountNode.asInt()) : null;
        tweet.setRetweetCount(retweetCount);
        JsonNode retweetedNode = node.get("retweeted");
        JsonNode retweetedStatusNode = node.get("retweeted_status");
        boolean retweeted = retweetedNode != null && !retweetedNode.isNull() ? retweetedNode.asBoolean() : false;
        tweet.setRetweeted(retweeted);
        Tweet retweetedStatus = retweetedStatusNode != null ? this.deserialize(retweetedStatusNode) : null;
        tweet.setRetweetedStatus(retweetedStatus);
        JsonNode favoritedNode = node.get("favorited");
        boolean favorited = favoritedNode != null && !favoritedNode.isNull() ? favoritedNode.asBoolean() : false;
        tweet.setFavorited(favorited);
        JsonNode favoriteCountNode = node.get("favorite_count");
        Integer favoriteCount = favoriteCountNode != null && !favoriteCountNode.isNull() ? Integer.valueOf(favoriteCountNode.asInt()) : null;
        tweet.setFavoriteCount(favoriteCount);
        Entities entities = this.toEntities(node.get("entities"), text);
        tweet.setEntities(entities);
        TwitterProfile user = this.toProfile(fromUserNode);
        tweet.setUser(user);
        return tweet;
    }

    private ObjectMapper createMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new TwitterModule());
        return mapper;
    }

    private Date toDate(String dateString, DateFormat dateFormat) {
        if (dateString == null) {
            return null;
        }
        try {
            return dateFormat.parse(dateString);
        }
        catch (ParseException e) {
            return null;
        }
    }

    private Entities toEntities(JsonNode node, String text) throws IOException {
        if (null == node || node.isNull() || node.isMissingNode()) {
            return null;
        }
        ObjectMapper mapper = this.createMapper();
        Entities entities = (Entities)mapper.readerFor(Entities.class).readValue(node);
        this.extractTickerSymbolEntitiesFromText(text, entities);
        return entities;
    }

    private void extractTickerSymbolEntitiesFromText(String text, Entities entities) {
        Pattern pattern = Pattern.compile("\\$[A-Za-z]+");
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            MatchResult matchResult = matcher.toMatchResult();
            String tickerSymbol = matchResult.group().substring(1);
            String url = "https://twitter.com/search?q=%24" + tickerSymbol + "&src=ctag";
            entities.getTickerSymbols().add(new TickerSymbolEntity(tickerSymbol, url, new int[]{matchResult.start(), matchResult.end()}));
        }
    }

    private TwitterProfile toProfile(JsonNode node) throws IOException {
        if (null == node || node.isNull() || node.isMissingNode()) {
            return null;
        }
        ObjectMapper mapper = this.createMapper();
        return (TwitterProfile)mapper.readerFor(TwitterProfile.class).readValue(node);
    }
}

