/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.social.twitter.api.StreamDeleteEvent;
import org.springframework.social.twitter.api.StreamListener;
import org.springframework.social.twitter.api.StreamWarningEvent;
import org.springframework.social.twitter.api.Tweet;
import org.springframework.social.twitter.api.impl.StreamDeleteEventMixin;
import org.springframework.social.twitter.api.impl.StreamWarningEventMixin;
import org.springframework.social.twitter.api.impl.TrackLimitEvent;
import org.springframework.social.twitter.api.impl.TweetMixin;

class StreamDispatcher
implements Runnable {
    private final List<StreamListener> listeners;
    private ObjectMapper objectMapper;
    private AtomicBoolean active;
    private final Queue<String> queue;
    private final ExecutorService pool;

    public StreamDispatcher(Queue<String> queue, List<StreamListener> listeners) {
        this.queue = queue;
        this.listeners = listeners;
        this.pool = Executors.newCachedThreadPool();
        this.objectMapper = new ObjectMapper();
        this.objectMapper.addMixIn(Tweet.class, TweetMixin.class);
        this.objectMapper.addMixIn(StreamDeleteEvent.class, StreamDeleteEventMixin.class);
        this.objectMapper.addMixIn(StreamWarningEvent.class, StreamWarningEventMixin.class);
        this.active = new AtomicBoolean(true);
    }

    @Override
    public void run() {
        while (this.active.get()) {
            String line = this.queue.poll();
            if (line == null || line.length() == 0) {
                return;
            }
            try {
                if (line.contains("in_reply_to_status_id_str")) {
                    this.handleTweet(line);
                    continue;
                }
                if (line.startsWith("{\"limit")) {
                    this.handleLimit(line);
                    continue;
                }
                if (line.startsWith("{\"delete")) {
                    this.handleDelete(line);
                    continue;
                }
                if (!line.startsWith("{\"warning")) continue;
                this.handleWarning(line);
            }
            catch (IOException iOException) {}
        }
    }

    public void stop() {
        this.active.set(false);
        this.pool.shutdown();
    }

    private void handleDelete(String line) throws IOException {
        final StreamDeleteEvent deleteEvent = (StreamDeleteEvent)this.objectMapper.readValue(line, StreamDeleteEvent.class);
        for (final StreamListener listener : this.listeners) {
            this.pool.submit(new Runnable(){

                @Override
                public void run() {
                    listener.onDelete(deleteEvent);
                }
            });
        }
    }

    private void handleLimit(String line) throws IOException {
        final TrackLimitEvent limitEvent = (TrackLimitEvent)this.objectMapper.readValue(line, TrackLimitEvent.class);
        for (final StreamListener listener : this.listeners) {
            this.pool.submit(new Runnable(){

                @Override
                public void run() {
                    listener.onLimit(limitEvent.getNumberOfLimitedTweets());
                }
            });
        }
    }

    private void handleTweet(String line) throws IOException {
        final Tweet tweet = (Tweet)this.objectMapper.readValue(line, Tweet.class);
        for (final StreamListener listener : this.listeners) {
            this.pool.submit(new Runnable(){

                @Override
                public void run() {
                    listener.onTweet(tweet);
                }
            });
        }
    }

    private void handleWarning(String line) throws IOException {
        final StreamWarningEvent warningEvent = (StreamWarningEvent)this.objectMapper.readValue(line, StreamWarningEvent.class);
        for (final StreamListener listener : this.listeners) {
            this.pool.submit(new Runnable(){

                @Override
                public void run() {
                    listener.onWarning(warningEvent);
                }
            });
        }
    }
}

