/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api;

import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

abstract class AbstractStreamParameters {
    protected StringBuffer track = new StringBuffer();
    protected StringBuffer locations = new StringBuffer();
    protected boolean stallWarnings = false;
    protected String language;

    public AbstractStreamParameters track(String track) {
        if (this.track.length() > 0) {
            this.track.append(',');
        }
        this.track.append(track);
        return this;
    }

    public AbstractStreamParameters addLocation(float west, float south, float east, float north) {
        if (this.locations.length() > 0) {
            this.locations.append(',');
        }
        this.locations.append(west).append(',').append(south).append(',');
        this.locations.append(east).append(',').append(north).append(',');
        return this;
    }

    public AbstractStreamParameters stallWarnings(boolean stallWarnings) {
        this.stallWarnings = stallWarnings;
        return this;
    }

    public AbstractStreamParameters language(String language) {
        this.language = language;
        return this;
    }

    public String getTrackParameterValue() {
        return this.track.toString();
    }

    public String getLocationsParameterValue() {
        return this.locations.toString();
    }

    public MultiValueMap<String, String> toParameterMap() {
        LinkedMultiValueMap parameterMap = new LinkedMultiValueMap();
        if (this.track != null && this.track.length() > 0) {
            parameterMap.set((Object)"track", (Object)this.track.toString());
        }
        if (this.locations != null && this.locations.length() > 0) {
            parameterMap.set((Object)"locations", (Object)this.locations.toString());
        }
        if (this.stallWarnings) {
            parameterMap.set((Object)"stall_warnings", (Object)"true");
        }
        if (this.language != null) {
            parameterMap.set((Object)"language", (Object)this.language);
        }
        return parameterMap;
    }
}

