/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.inbound;

import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.integration.context.OrderlyShutdownCapable;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.kafka.listener.AbstractMessageListenerContainer;
import org.springframework.kafka.listener.adapter.MessagingMessageListenerAdapter;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.kafka.support.converter.MessageConverter;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class KafkaMessageDrivenChannelAdapter<K, V>
extends MessageProducerSupport
implements OrderlyShutdownCapable {
    private final AbstractMessageListenerContainer<K, V> messageListenerContainer;
    private final MessagingMessageListenerAdapter<K, V> listener = new IntegrationMessageListener();

    public KafkaMessageDrivenChannelAdapter(AbstractMessageListenerContainer<K, V> messageListenerContainer) {
        Assert.notNull(messageListenerContainer, (String)"messageListenerContainer is required");
        Assert.isNull((Object)messageListenerContainer.getMessageListener(), (String)"Container must not already have a listener");
        this.messageListenerContainer = messageListenerContainer;
        this.messageListenerContainer.setAutoStartup(false);
        this.messageListenerContainer.setMessageListener(this.listener);
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.listener.setMessageConverter(messageConverter);
    }

    protected void doStart() {
        this.messageListenerContainer.start();
    }

    protected void doStop() {
        this.messageListenerContainer.stop();
    }

    public String getComponentType() {
        return "kafka:message-driven-channel-adapter";
    }

    public int beforeShutdown() {
        this.messageListenerContainer.stop();
        return this.getPhase();
    }

    public int afterShutdown() {
        return this.getPhase();
    }

    private class IntegrationMessageListener
    extends MessagingMessageListenerAdapter<K, V> {
        IntegrationMessageListener() {
            super(null);
        }

        public void onMessage(ConsumerRecord<K, V> record, Acknowledgment acknowledgment) {
            Message message = this.toMessagingMessage(record, acknowledgment);
            KafkaMessageDrivenChannelAdapter.this.sendMessage(message);
        }
    }
}

