/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.springframework.integration.file.DefaultDirectoryScanner;
import org.springframework.integration.file.filters.CompositeFileListFilter;
import org.springframework.integration.file.filters.FileListFilter;

public class HeadDirectoryScanner
extends DefaultDirectoryScanner {
    private final HeadFilter headFilter;

    public HeadDirectoryScanner(int maxNumberOfFiles) {
        HeadFilter headFilter = new HeadFilter(maxNumberOfFiles);
        this.setFilter(headFilter);
        this.headFilter = headFilter;
    }

    @Override
    public void setFilter(FileListFilter<File> filter) {
        if (filter instanceof CompositeFileListFilter) {
            ((CompositeFileListFilter)filter).addFilter(this.headFilter);
            super.setFilter(filter);
        } else {
            CompositeFileListFilter<File> compositeFilter = new CompositeFileListFilter<File>();
            compositeFilter.addFilter(filter).addFilter(this.headFilter);
            super.setFilter(compositeFilter);
        }
    }

    private static class HeadFilter
    implements FileListFilter<File> {
        private final int maxNumberOfFiles;

        public HeadFilter(int maxNumberOfFiles) {
            this.maxNumberOfFiles = maxNumberOfFiles;
        }

        public List<File> filterFiles(File[] files) {
            return Arrays.asList(files).subList(0, Math.min(files.length, this.maxNumberOfFiles));
        }
    }
}

