/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.domain;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.util.Assert;

class TypedExampleMatcher
implements ExampleMatcher {
    private final ExampleMatcher.NullHandler nullHandler;
    private final ExampleMatcher.StringMatcher defaultStringMatcher;
    private final ExampleMatcher.PropertySpecifiers propertySpecifiers;
    private final Set<String> ignoredPaths;
    private final boolean defaultIgnoreCase;
    private final ExampleMatcher.MatchMode mode;

    TypedExampleMatcher() {
        this(ExampleMatcher.NullHandler.IGNORE, ExampleMatcher.StringMatcher.DEFAULT, new ExampleMatcher.PropertySpecifiers(), Collections.emptySet(), false, ExampleMatcher.MatchMode.ALL);
    }

    @Override
    public ExampleMatcher withIgnorePaths(String ... ignoredPaths) {
        Assert.notEmpty((Object[])ignoredPaths, (String)"IgnoredPaths must not be empty!");
        Assert.noNullElements((Object[])ignoredPaths, (String)"IgnoredPaths must not contain null elements!");
        LinkedHashSet<String> newIgnoredPaths = new LinkedHashSet<String>(this.ignoredPaths);
        newIgnoredPaths.addAll(Arrays.asList(ignoredPaths));
        return new TypedExampleMatcher(this.nullHandler, this.defaultStringMatcher, this.propertySpecifiers, newIgnoredPaths, this.defaultIgnoreCase, this.mode);
    }

    @Override
    public ExampleMatcher withStringMatcher(ExampleMatcher.StringMatcher defaultStringMatcher) {
        Assert.notNull(this.ignoredPaths, (String)"DefaultStringMatcher must not be empty!");
        return new TypedExampleMatcher(this.nullHandler, defaultStringMatcher, this.propertySpecifiers, this.ignoredPaths, this.defaultIgnoreCase, this.mode);
    }

    @Override
    public ExampleMatcher withIgnoreCase(boolean defaultIgnoreCase) {
        return new TypedExampleMatcher(this.nullHandler, this.defaultStringMatcher, this.propertySpecifiers, this.ignoredPaths, defaultIgnoreCase, this.mode);
    }

    @Override
    public ExampleMatcher withMatcher(String propertyPath, ExampleMatcher.GenericPropertyMatcher genericPropertyMatcher) {
        Assert.hasText((String)propertyPath, (String)"PropertyPath must not be empty!");
        Assert.notNull((Object)genericPropertyMatcher, (String)"GenericPropertyMatcher must not be empty!");
        ExampleMatcher.PropertySpecifiers propertySpecifiers = new ExampleMatcher.PropertySpecifiers(this.propertySpecifiers);
        ExampleMatcher.PropertySpecifier propertySpecifier = new ExampleMatcher.PropertySpecifier(propertyPath);
        if (genericPropertyMatcher.ignoreCase != null) {
            propertySpecifier = propertySpecifier.withIgnoreCase(genericPropertyMatcher.ignoreCase);
        }
        if (genericPropertyMatcher.stringMatcher != null) {
            propertySpecifier = propertySpecifier.withStringMatcher(genericPropertyMatcher.stringMatcher);
        }
        propertySpecifier = propertySpecifier.withValueTransformer(genericPropertyMatcher.valueTransformer);
        propertySpecifiers.add(propertySpecifier);
        return new TypedExampleMatcher(this.nullHandler, this.defaultStringMatcher, propertySpecifiers, this.ignoredPaths, this.defaultIgnoreCase, this.mode);
    }

    @Override
    public ExampleMatcher withTransformer(String propertyPath, ExampleMatcher.PropertyValueTransformer propertyValueTransformer) {
        Assert.hasText((String)propertyPath, (String)"PropertyPath must not be empty!");
        Assert.notNull((Object)propertyValueTransformer, (String)"PropertyValueTransformer must not be empty!");
        ExampleMatcher.PropertySpecifiers propertySpecifiers = new ExampleMatcher.PropertySpecifiers(this.propertySpecifiers);
        ExampleMatcher.PropertySpecifier propertySpecifier = this.getOrCreatePropertySpecifier(propertyPath, propertySpecifiers);
        propertySpecifiers.add(propertySpecifier.withValueTransformer(propertyValueTransformer));
        return new TypedExampleMatcher(this.nullHandler, this.defaultStringMatcher, propertySpecifiers, this.ignoredPaths, this.defaultIgnoreCase, this.mode);
    }

    @Override
    public ExampleMatcher withIgnoreCase(String ... propertyPaths) {
        Assert.notEmpty((Object[])propertyPaths, (String)"PropertyPaths must not be empty!");
        Assert.noNullElements((Object[])propertyPaths, (String)"PropertyPaths must not contain null elements!");
        ExampleMatcher.PropertySpecifiers propertySpecifiers = new ExampleMatcher.PropertySpecifiers(this.propertySpecifiers);
        for (String propertyPath : propertyPaths) {
            ExampleMatcher.PropertySpecifier propertySpecifier = this.getOrCreatePropertySpecifier(propertyPath, propertySpecifiers);
            propertySpecifiers.add(propertySpecifier.withIgnoreCase(true));
        }
        return new TypedExampleMatcher(this.nullHandler, this.defaultStringMatcher, propertySpecifiers, this.ignoredPaths, this.defaultIgnoreCase, this.mode);
    }

    @Override
    public ExampleMatcher withNullHandler(ExampleMatcher.NullHandler nullHandler) {
        Assert.notNull((Object)((Object)nullHandler), (String)"NullHandler must not be null!");
        return new TypedExampleMatcher(nullHandler, this.defaultStringMatcher, this.propertySpecifiers, this.ignoredPaths, this.defaultIgnoreCase, this.mode);
    }

    @Override
    public ExampleMatcher.NullHandler getNullHandler() {
        return this.nullHandler;
    }

    @Override
    public ExampleMatcher.StringMatcher getDefaultStringMatcher() {
        return this.defaultStringMatcher;
    }

    @Override
    public boolean isIgnoreCaseEnabled() {
        return this.defaultIgnoreCase;
    }

    @Override
    public Set<String> getIgnoredPaths() {
        return this.ignoredPaths;
    }

    @Override
    public ExampleMatcher.PropertySpecifiers getPropertySpecifiers() {
        return this.propertySpecifiers;
    }

    @Override
    public ExampleMatcher.MatchMode getMatchMode() {
        return this.mode;
    }

    private ExampleMatcher.PropertySpecifier getOrCreatePropertySpecifier(String propertyPath, ExampleMatcher.PropertySpecifiers propertySpecifiers) {
        if (propertySpecifiers.hasSpecifierForPath(propertyPath)) {
            return propertySpecifiers.getForPath(propertyPath);
        }
        return new ExampleMatcher.PropertySpecifier(propertyPath);
    }

    @Generated
    public String toString() {
        return "TypedExampleMatcher(nullHandler=" + (Object)((Object)this.getNullHandler()) + ", defaultStringMatcher=" + (Object)((Object)this.getDefaultStringMatcher()) + ", propertySpecifiers=" + this.getPropertySpecifiers() + ", ignoredPaths=" + this.getIgnoredPaths() + ", defaultIgnoreCase=" + this.defaultIgnoreCase + ", mode=" + (Object)((Object)this.mode) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TypedExampleMatcher)) {
            return false;
        }
        TypedExampleMatcher other = (TypedExampleMatcher)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ExampleMatcher.NullHandler this$nullHandler = this.getNullHandler();
        ExampleMatcher.NullHandler other$nullHandler = other.getNullHandler();
        if (this$nullHandler == null ? other$nullHandler != null : !((Object)((Object)this$nullHandler)).equals((Object)other$nullHandler)) {
            return false;
        }
        ExampleMatcher.StringMatcher this$defaultStringMatcher = this.getDefaultStringMatcher();
        ExampleMatcher.StringMatcher other$defaultStringMatcher = other.getDefaultStringMatcher();
        if (this$defaultStringMatcher == null ? other$defaultStringMatcher != null : !((Object)((Object)this$defaultStringMatcher)).equals((Object)other$defaultStringMatcher)) {
            return false;
        }
        ExampleMatcher.PropertySpecifiers this$propertySpecifiers = this.getPropertySpecifiers();
        ExampleMatcher.PropertySpecifiers other$propertySpecifiers = other.getPropertySpecifiers();
        if (this$propertySpecifiers == null ? other$propertySpecifiers != null : !((Object)this$propertySpecifiers).equals(other$propertySpecifiers)) {
            return false;
        }
        Set<String> this$ignoredPaths = this.getIgnoredPaths();
        Set<String> other$ignoredPaths = other.getIgnoredPaths();
        if (this$ignoredPaths == null ? other$ignoredPaths != null : !((Object)this$ignoredPaths).equals(other$ignoredPaths)) {
            return false;
        }
        if (this.defaultIgnoreCase != other.defaultIgnoreCase) {
            return false;
        }
        ExampleMatcher.MatchMode this$mode = this.mode;
        ExampleMatcher.MatchMode other$mode = other.mode;
        return !(this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TypedExampleMatcher;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ExampleMatcher.NullHandler $nullHandler = this.getNullHandler();
        result = result * 59 + ($nullHandler == null ? 43 : ((Object)((Object)$nullHandler)).hashCode());
        ExampleMatcher.StringMatcher $defaultStringMatcher = this.getDefaultStringMatcher();
        result = result * 59 + ($defaultStringMatcher == null ? 43 : ((Object)((Object)$defaultStringMatcher)).hashCode());
        ExampleMatcher.PropertySpecifiers $propertySpecifiers = this.getPropertySpecifiers();
        result = result * 59 + ($propertySpecifiers == null ? 43 : ((Object)$propertySpecifiers).hashCode());
        Set<String> $ignoredPaths = this.getIgnoredPaths();
        result = result * 59 + ($ignoredPaths == null ? 43 : ((Object)$ignoredPaths).hashCode());
        result = result * 59 + (this.defaultIgnoreCase ? 79 : 97);
        ExampleMatcher.MatchMode $mode = this.mode;
        result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
        return result;
    }

    @Generated
    private TypedExampleMatcher(ExampleMatcher.NullHandler nullHandler, ExampleMatcher.StringMatcher defaultStringMatcher, ExampleMatcher.PropertySpecifiers propertySpecifiers, Set<String> ignoredPaths, boolean defaultIgnoreCase, ExampleMatcher.MatchMode mode) {
        this.nullHandler = nullHandler;
        this.defaultStringMatcher = defaultStringMatcher;
        this.propertySpecifiers = propertySpecifiers;
        this.ignoredPaths = ignoredPaths;
        this.defaultIgnoreCase = defaultIgnoreCase;
        this.mode = mode;
    }

    @Generated
    TypedExampleMatcher withMode(ExampleMatcher.MatchMode mode) {
        return this.mode == mode ? this : new TypedExampleMatcher(this.nullHandler, this.defaultStringMatcher, this.propertySpecifiers, this.ignoredPaths, this.defaultIgnoreCase, mode);
    }
}

