/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.repository.NoRepositoryBean;
import org.springframework.data.repository.config.RepositoryFragmentDiscovery;
import org.springframework.data.util.StreamUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public final class FragmentMetadata {
    private final String fragmentInterfaceName;
    private final RepositoryFragmentDiscovery configuration;

    public static boolean isCandidate(String interfaceName, MetadataReaderFactory factory) {
        Assert.hasText((String)interfaceName, (String)"Interface name must not be null or empty!");
        Assert.notNull((Object)factory, (String)"MetadataReaderFactory must not be null!");
        AnnotationMetadata metadata = FragmentMetadata.getAnnotationMetadata(interfaceName, factory);
        return !metadata.hasAnnotation(NoRepositoryBean.class.getName());
    }

    public List<TypeFilter> getExclusions() {
        Stream<TypeFilter> configurationExcludes = this.configuration.getExcludeFilters().stream();
        Stream<AnnotationTypeFilter> noRepositoryBeans = Stream.of(new AnnotationTypeFilter(NoRepositoryBean.class));
        return Stream.concat(configurationExcludes, noRepositoryBeans).collect(StreamUtils.toUnmodifiableList());
    }

    public String getFragmentImplementationClassName() {
        String postfix = this.configuration.getRepositoryImplementationPostfix().orElse("Impl");
        return ClassUtils.getShortName((String)this.fragmentInterfaceName).concat(postfix);
    }

    public Iterable<String> getBasePackages() {
        return Collections.singleton(ClassUtils.getPackageName((String)this.fragmentInterfaceName));
    }

    private static AnnotationMetadata getAnnotationMetadata(String className, MetadataReaderFactory metadataReaderFactory) {
        try {
            return metadataReaderFactory.getMetadataReader(className).getAnnotationMetadata();
        }
        catch (IOException e) {
            throw new BeanDefinitionStoreException(String.format("Cannot parse %s metadata.", className), (Throwable)e);
        }
    }

    private FragmentMetadata(String fragmentInterfaceName, RepositoryFragmentDiscovery configuration) {
        this.fragmentInterfaceName = fragmentInterfaceName;
        this.configuration = configuration;
    }

    public static FragmentMetadata of(String fragmentInterfaceName, RepositoryFragmentDiscovery configuration) {
        return new FragmentMetadata(fragmentInterfaceName, configuration);
    }

    public String getFragmentInterfaceName() {
        return this.fragmentInterfaceName;
    }

    public RepositoryFragmentDiscovery getConfiguration() {
        return this.configuration;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FragmentMetadata)) {
            return false;
        }
        FragmentMetadata other = (FragmentMetadata)o;
        String this$fragmentInterfaceName = this.getFragmentInterfaceName();
        String other$fragmentInterfaceName = other.getFragmentInterfaceName();
        if (this$fragmentInterfaceName == null ? other$fragmentInterfaceName != null : !this$fragmentInterfaceName.equals(other$fragmentInterfaceName)) {
            return false;
        }
        RepositoryFragmentDiscovery this$configuration = this.getConfiguration();
        RepositoryFragmentDiscovery other$configuration = other.getConfiguration();
        return !(this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fragmentInterfaceName = this.getFragmentInterfaceName();
        result = result * 59 + ($fragmentInterfaceName == null ? 43 : $fragmentInterfaceName.hashCode());
        RepositoryFragmentDiscovery $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        return result;
    }

    public String toString() {
        return "FragmentMetadata(fragmentInterfaceName=" + this.getFragmentInterfaceName() + ", configuration=" + this.getConfiguration() + ")";
    }
}

