/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.cdi;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Stream;
import javax.enterprise.inject.CreationException;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.repository.NoRepositoryBean;
import org.springframework.data.repository.cdi.CdiRepositoryConfiguration;
import org.springframework.data.repository.config.CustomRepositoryImplementationDetector;
import org.springframework.data.repository.config.FragmentMetadata;
import org.springframework.data.repository.config.RepositoryFragmentConfiguration;
import org.springframework.data.repository.config.RepositoryFragmentDiscovery;
import org.springframework.data.util.Optionals;
import org.springframework.data.util.Streamable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class CdiRepositoryContext {
    private final ClassLoader classLoader;
    private final CustomRepositoryImplementationDetector detector;
    private final MetadataReaderFactory metadataReaderFactory;

    public CdiRepositoryContext(ClassLoader classLoader) {
        Assert.notNull((Object)classLoader, (String)"ClassLoader must not be null!");
        this.classLoader = classLoader;
        StandardEnvironment environment = new StandardEnvironment();
        PathMatchingResourcePatternResolver resourceLoader = new PathMatchingResourcePatternResolver(classLoader);
        this.metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)resourceLoader);
        this.detector = new CustomRepositoryImplementationDetector(this.metadataReaderFactory, (Environment)environment, (ResourceLoader)resourceLoader);
    }

    public CdiRepositoryContext(ClassLoader classLoader, CustomRepositoryImplementationDetector detector) {
        Assert.notNull((Object)classLoader, (String)"ClassLoader must not be null!");
        Assert.notNull((Object)detector, (String)"CustomRepositoryImplementationDetector must not be null!");
        PathMatchingResourcePatternResolver resourceLoader = new PathMatchingResourcePatternResolver(classLoader);
        this.classLoader = classLoader;
        this.metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)resourceLoader);
        this.detector = detector;
    }

    CustomRepositoryImplementationDetector getCustomRepositoryImplementationDetector() {
        return this.detector;
    }

    Class<?> loadClass(String className) {
        try {
            return ClassUtils.forName((String)className, (ClassLoader)this.classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new UnsatisfiedResolutionException(String.format("Unable to resolve class for '%s'", className), (Throwable)e);
        }
    }

    Stream<RepositoryFragmentConfiguration> getRepositoryFragments(CdiRepositoryConfiguration configuration, Class<?> repositoryInterface) {
        ClassMetadata classMetadata = CdiRepositoryContext.getClassMetadata(this.metadataReaderFactory, repositoryInterface.getName());
        CdiRepositoryFragmentDiscovery fragmentConfiguration = new CdiRepositoryFragmentDiscovery(configuration);
        return Arrays.stream(classMetadata.getInterfaceNames()).filter(it -> FragmentMetadata.isCandidate(it, this.metadataReaderFactory)).map(it -> FragmentMetadata.of(it, fragmentConfiguration)).map(this::detectRepositoryFragmentConfiguration).flatMap(xva$0 -> Optionals.toStream(xva$0));
    }

    Optional<Class<?>> getCustomImplementationClass(Class<?> repositoryType, CdiRepositoryConfiguration cdiRepositoryConfiguration) {
        String className = CdiRepositoryContext.getCustomImplementationClassName(repositoryType, cdiRepositoryConfiguration);
        Optional<AbstractBeanDefinition> beanDefinition = this.detector.detectCustomImplementation(className, className, Collections.singleton(repositoryType.getPackage().getName()), Collections.emptySet(), BeanDefinition::getBeanClassName);
        return beanDefinition.map(it -> this.loadClass(it.getBeanClassName()));
    }

    private Optional<RepositoryFragmentConfiguration> detectRepositoryFragmentConfiguration(FragmentMetadata configuration) {
        String className = configuration.getFragmentImplementationClassName();
        Optional<AbstractBeanDefinition> beanDefinition = this.detector.detectCustomImplementation(className, null, configuration.getBasePackages(), configuration.getExclusions(), BeanDefinition::getBeanClassName);
        return beanDefinition.map(bd -> new RepositoryFragmentConfiguration(configuration.getFragmentInterfaceName(), (AbstractBeanDefinition)bd));
    }

    private static ClassMetadata getClassMetadata(MetadataReaderFactory metadataReaderFactory, String className) {
        try {
            return metadataReaderFactory.getMetadataReader(className).getClassMetadata();
        }
        catch (IOException e) {
            throw new CreationException(String.format("Cannot parse %s metadata.", className), (Throwable)e);
        }
    }

    private static String getCustomImplementationClassName(Class<?> repositoryType, CdiRepositoryConfiguration cdiRepositoryConfiguration) {
        String configuredPostfix = cdiRepositoryConfiguration.getRepositoryImplementationPostfix();
        Assert.hasText((String)configuredPostfix, (String)"Configured repository postfix must not be null or empty!");
        return ClassUtils.getShortName(repositoryType) + configuredPostfix;
    }

    private static class CdiRepositoryFragmentDiscovery
    implements RepositoryFragmentDiscovery {
        private final CdiRepositoryConfiguration configuration;

        @Override
        public Streamable<TypeFilter> getExcludeFilters() {
            return Streamable.of(new AnnotationTypeFilter(NoRepositoryBean.class));
        }

        @Override
        public Optional<String> getRepositoryImplementationPostfix() {
            return Optional.of(this.configuration.getRepositoryImplementationPostfix());
        }

        public CdiRepositoryFragmentDiscovery(CdiRepositoryConfiguration configuration) {
            this.configuration = configuration;
        }
    }
}

