/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.springframework.util.Assert;

public class SimpleTypeHolder {
    private static final Set<Class<?>> DEFAULTS = new HashSet<Class<?>>(){
        private static final long serialVersionUID = -1738594126505221500L;
        {
            this.add(Boolean.TYPE);
            this.add(boolean[].class);
            this.add(Long.TYPE);
            this.add(long[].class);
            this.add(Short.TYPE);
            this.add(short[].class);
            this.add(Integer.TYPE);
            this.add(int[].class);
            this.add(Byte.TYPE);
            this.add(byte[].class);
            this.add(Float.TYPE);
            this.add(float[].class);
            this.add(Double.TYPE);
            this.add(double[].class);
            this.add(Character.TYPE);
            this.add(char[].class);
            this.add(Boolean.class);
            this.add(Long.class);
            this.add(Short.class);
            this.add(Integer.class);
            this.add(Byte.class);
            this.add(Float.class);
            this.add(Double.class);
            this.add(Character.class);
            this.add(String.class);
            this.add(Date.class);
            this.add(Locale.class);
            this.add(Class.class);
            this.add(Enum.class);
        }
    };
    public static final SimpleTypeHolder DEFAULT = new SimpleTypeHolder();
    private final Set<Class<?>> simpleTypes;

    protected SimpleTypeHolder() {
        this(Collections.emptySet(), true);
    }

    public SimpleTypeHolder(Set<? extends Class<?>> customSimpleTypes, boolean registerDefaults) {
        Assert.notNull(customSimpleTypes, (String)"CustomSimpleTypes must not be null!");
        this.simpleTypes = new CopyOnWriteArraySet(customSimpleTypes);
        if (registerDefaults) {
            this.simpleTypes.addAll(DEFAULTS);
        }
    }

    public SimpleTypeHolder(Set<? extends Class<?>> customSimpleTypes, SimpleTypeHolder source) {
        Assert.notNull(customSimpleTypes, (String)"CustomSimpleTypes must not be null!");
        Assert.notNull((Object)source, (String)"SourceTypeHolder must not be null!");
        this.simpleTypes = new CopyOnWriteArraySet(customSimpleTypes);
        this.simpleTypes.addAll(source.simpleTypes);
    }

    public boolean isSimpleType(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null!");
        if (Object.class.equals(type) || this.simpleTypes.contains(type)) {
            return true;
        }
        if (type.getName().startsWith("java.lang")) {
            return true;
        }
        return this.simpleTypes.stream().filter(it -> it.isAssignableFrom(type)).peek(it -> this.simpleTypes.add(type)).findFirst().isPresent();
    }
}

