/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.data.util.Lazy;
import org.springframework.util.Assert;

public class Property {
    private final Optional<Field> field;
    private final Optional<PropertyDescriptor> descriptor;
    private final Lazy<Class<?>> rawType;
    private final Lazy<Integer> hashCode;

    private Property(Optional<Field> field, Optional<PropertyDescriptor> descriptor) {
        this.field = field;
        this.descriptor = descriptor;
        this.hashCode = Lazy.of(this::computeHashCode);
        this.rawType = Lazy.of(() -> field.map(Field::getType).orElseGet(() -> descriptor.map(PropertyDescriptor::getPropertyType).orElseThrow(IllegalStateException::new)));
    }

    public static Property of(Field field) {
        Assert.notNull((Object)field, (String)"Field must not be null!");
        return new Property(Optional.of(field), Optional.empty());
    }

    public static Property of(Field field, PropertyDescriptor descriptor) {
        Assert.notNull((Object)field, (String)"Field must not be null!");
        Assert.notNull((Object)descriptor, (String)"PropertyDescriptor must not be null!");
        return new Property(Optional.of(field), Optional.of(descriptor));
    }

    public static Property of(PropertyDescriptor descriptor) {
        Assert.notNull((Object)descriptor, (String)"PropertyDescriptor must not be null!");
        return new Property(Optional.empty(), Optional.of(descriptor));
    }

    public boolean isFieldBacked() {
        return this.field.isPresent();
    }

    public Optional<Method> getGetter() {
        return this.descriptor.map(PropertyDescriptor::getReadMethod).filter(it -> this.getType().isAssignableFrom(it.getReturnType()));
    }

    public Optional<Method> getSetter() {
        return this.descriptor.map(PropertyDescriptor::getWriteMethod).filter(it -> it.getParameterTypes()[0].isAssignableFrom(this.getType()));
    }

    public boolean hasAccessor() {
        return this.getGetter().isPresent() || this.getSetter().isPresent();
    }

    public String getName() {
        return this.field.map(Field::getName).orElseGet(() -> this.descriptor.map(FeatureDescriptor::getName).orElseThrow(IllegalStateException::new));
    }

    public Class<?> getType() {
        return this.rawType.get();
    }

    private int computeHashCode() {
        return this.field.map(Field::hashCode).orElseGet(() -> this.descriptor.map(PropertyDescriptor::hashCode).orElseThrow(IllegalStateException::new));
    }

    public int hashCode() {
        return this.hashCode.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Property)) {
            return false;
        }
        Property that = (Property)obj;
        return this.field.isPresent() ? this.field.equals(that.field) : this.descriptor.equals(that.descriptor);
    }

    public String toString() {
        return this.field.map(Object::toString).orElseGet(() -> this.descriptor.map(Object::toString).orElseThrow(IllegalStateException::new));
    }

    public Optional<Field> getField() {
        return this.field;
    }
}

