/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.convert;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.data.convert.TypeInformationMapper;
import org.springframework.data.mapping.Alias;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.ClassUtils;

public class SimpleTypeInformationMapper
implements TypeInformationMapper {
    private final Map<String, Optional<ClassTypeInformation<?>>> CACHE = new ConcurrentHashMap();

    @Override
    public Optional<TypeInformation<?>> resolveTypeFrom(Alias alias) {
        return alias.mapTyped(String.class).flatMap(it -> this.CACHE.computeIfAbsent((String)it, SimpleTypeInformationMapper::loadClass).map(type -> type));
    }

    @Override
    public Alias createAliasFor(TypeInformation<?> type) {
        return Alias.of(type.getType().getName());
    }

    private static Optional<ClassTypeInformation<?>> loadClass(String typeName) {
        try {
            return Optional.of(ClassTypeInformation.from(ClassUtils.forName((String)typeName, null)));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }
}

