/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.support;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.data.support.IsNewStrategy;
import org.springframework.data.support.IsNewStrategyFactory;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingIsNewStrategyFactory
implements IsNewStrategyFactory {
    private final Map<Class<?>, IsNewStrategy> CACHE = new ConcurrentHashMap();
    private final IsNewStrategyFactory delegate;

    public CachingIsNewStrategyFactory(IsNewStrategyFactory delegate) {
        Assert.notNull((Object)delegate, (String)"IsNewStrategyFactory delegate must not be null!");
        this.delegate = delegate;
    }

    @Override
    public IsNewStrategy getIsNewStrategy(Class<?> type) {
        IsNewStrategy strategy = this.CACHE.get(type);
        if (strategy != null) {
            return strategy;
        }
        IsNewStrategy isNewStrategy = this.delegate.getIsNewStrategy(type);
        this.CACHE.put(type, isNewStrategy);
        return isNewStrategy;
    }
}

