/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.convert;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.data.convert.TypeInformationMapper;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleTypeInformationMapper
implements TypeInformationMapper {
    public static final SimpleTypeInformationMapper INSTANCE = new SimpleTypeInformationMapper();
    private static final Map<String, TypeInformation<?>> cache = new ConcurrentHashMap();

    @Override
    public TypeInformation<?> resolveTypeFrom(Object alias) {
        if (!(alias instanceof String)) {
            return null;
        }
        String value = (String)alias;
        if (!StringUtils.hasText((String)value)) {
            return null;
        }
        TypeInformation<Object> information = cache.get(value);
        if (information != null) {
            return information;
        }
        try {
            information = ClassTypeInformation.from(ClassUtils.forName((String)value, null));
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        if (information != null) {
            cache.put(value, information);
        }
        return information;
    }

    @Override
    public String createAliasFor(TypeInformation<?> type) {
        return type.getType().getName();
    }
}

