/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.web;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.TypeRef;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.projection.Accessor;
import org.springframework.data.projection.MethodInterceptorFactory;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.data.web.JsonPath;
import org.springframework.util.Assert;

public class JsonProjectingMethodInterceptorFactory
implements MethodInterceptorFactory {
    private final ParseContext context;

    public JsonProjectingMethodInterceptorFactory(MappingProvider mappingProvider) {
        Assert.notNull((Object)mappingProvider, (String)"MappingProvider must not be null!");
        Configuration build = Configuration.builder().options(new Option[]{Option.ALWAYS_RETURN_LIST}).mappingProvider(mappingProvider).build();
        this.context = com.jayway.jsonpath.JsonPath.using((Configuration)build);
    }

    @Override
    public MethodInterceptor createMethodInterceptor(Object source, Class<?> targetType) {
        DocumentContext context = InputStream.class.isInstance(source) ? this.context.parse((InputStream)source) : this.context.parse(source);
        return new InputMessageProjecting(context);
    }

    @Override
    public boolean supports(Object source, Class<?> targetType) {
        if (InputStream.class.isInstance(source) || JSONObject.class.isInstance(source) || JSONArray.class.isInstance(source)) {
            return true;
        }
        return Map.class.isInstance(source) && JsonProjectingMethodInterceptorFactory.hasJsonPathAnnotation(targetType);
    }

    private static boolean hasJsonPathAnnotation(Class<?> type) {
        for (Method method : type.getMethods()) {
            if (AnnotationUtils.findAnnotation((Method)method, JsonPath.class) == null) continue;
            return true;
        }
        return false;
    }

    private static class InputMessageProjecting
    implements MethodInterceptor {
        private final DocumentContext context;

        public Object invoke(MethodInvocation invocation) throws Throwable {
            Method method = invocation.getMethod();
            TypeInformation returnType = ClassTypeInformation.fromReturnTypeOf(method);
            ResolvableType type = ResolvableType.forMethodReturnType((Method)method);
            String jsonPath = InputMessageProjecting.getJsonPath(method);
            try {
                if (returnType.getActualType().getType().isInterface()) {
                    List result = (List)this.context.read(jsonPath, new Predicate[0]);
                    return result.isEmpty() ? null : result.get(0);
                }
                boolean isCollectionResult = Collection.class.isAssignableFrom(type.getRawClass());
                type = isCollectionResult ? type : ResolvableType.forClassWithGenerics(List.class, (ResolvableType[])new ResolvableType[]{type});
                type = isCollectionResult && com.jayway.jsonpath.JsonPath.isPathDefinite((String)jsonPath) ? ResolvableType.forClassWithGenerics(List.class, (ResolvableType[])new ResolvableType[]{type}) : type;
                List result = (List)this.context.read(jsonPath, (TypeRef)new ResolvableTypeRef(type));
                if (isCollectionResult && com.jayway.jsonpath.JsonPath.isPathDefinite((String)jsonPath)) {
                    result = (List)result.get(0);
                }
                return isCollectionResult ? result : (result.isEmpty() ? null : result.get(0));
            }
            catch (PathNotFoundException o_O) {
                return null;
            }
        }

        private static String getJsonPath(Method method) {
            JsonPath annotation = (JsonPath)AnnotationUtils.findAnnotation((Method)method, JsonPath.class);
            return annotation != null ? annotation.value() : "$.".concat(new Accessor(method).getPropertyName());
        }

        @ConstructorProperties(value={"context"})
        public InputMessageProjecting(DocumentContext context) {
            this.context = context;
        }

        private static class ResolvableTypeRef
        extends TypeRef<Object> {
            private final ResolvableType type;

            public Type getType() {
                return this.type.getType();
            }

            @ConstructorProperties(value={"type"})
            public ResolvableTypeRef(ResolvableType type) {
                this.type = type;
            }
        }
    }
}

