/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.discovery.dependency;

import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.AbstractLoadBalancerRule;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.Server;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StickyRule
extends AbstractLoadBalancerRule {
    private static final Log log = LogFactory.getLog(StickyRule.class);
    private final IRule masterStrategy;
    private final AtomicReference<Server> ourInstance = new AtomicReference<Object>(null);
    private final AtomicInteger instanceNumber = new AtomicInteger(-1);

    public StickyRule(IRule masterStrategy) {
        this.masterStrategy = masterStrategy;
    }

    public void initWithNiwsConfig(IClientConfig iClientConfig) {
    }

    public Server choose(Object key) {
        Server instance;
        List instances = this.getLoadBalancer().getServerList(true);
        log.debug((Object)String.format("Instances taken from load balancer [%s]", instances));
        Server localOurInstance = this.ourInstance.get();
        log.debug((Object)String.format("Current saved instance [%s]", localOurInstance));
        if (!instances.contains(localOurInstance)) {
            this.ourInstance.compareAndSet(localOurInstance, null);
        }
        if (this.ourInstance.get() == null && this.ourInstance.compareAndSet(null, instance = this.masterStrategy.choose(key))) {
            this.instanceNumber.incrementAndGet();
        }
        return this.ourInstance.get();
    }

    public int getInstanceNumber() {
        return this.instanceNumber.get();
    }
}

