/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PreDestroy;
import org.apache.curator.framework.CuratorFramework;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.zookeeper.config.ZookeeperConfigProperties;
import org.springframework.cloud.zookeeper.config.ZookeeperPropertySource;
import org.springframework.cloud.zookeeper.config.ZookeeperTreeCachePropertySource;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

public class ZookeeperPropertySourceLocator
implements PropertySourceLocator {
    private ZookeeperConfigProperties properties;
    private CuratorFramework curator;
    private ConcurrentHashMap<String, ZookeeperTreeCachePropertySource> lifecycleSources = new ConcurrentHashMap();

    public ZookeeperPropertySourceLocator(CuratorFramework curator, ZookeeperConfigProperties properties) {
        this.curator = curator;
        this.properties = properties;
    }

    public PropertySource<?> locate(Environment environment) {
        if (environment instanceof ConfigurableEnvironment) {
            ConfigurableEnvironment env = (ConfigurableEnvironment)environment;
            String appName = env.getProperty("spring.application.name");
            List<String> profiles = Arrays.asList(env.getActiveProfiles());
            String root = this.properties.getRoot();
            ArrayList<String> contexts = new ArrayList<String>();
            String defaultContext = root + "/" + this.properties.getDefaultContext();
            contexts.add(defaultContext);
            this.addProfiles(contexts, defaultContext, profiles);
            String baseContext = root + "/" + appName;
            contexts.add(baseContext);
            this.addProfiles(contexts, baseContext, profiles);
            CompositePropertySource composite = new CompositePropertySource("zookeeper");
            Collections.reverse(contexts);
            for (String propertySourceContext : contexts) {
                PropertySource<CuratorFramework> propertySource = this.create(propertySourceContext);
                composite.addPropertySource(propertySource);
            }
            return composite;
        }
        return null;
    }

    @PreDestroy
    public void destroy() {
        for (ZookeeperTreeCachePropertySource source : this.lifecycleSources.values()) {
            source.stop();
        }
    }

    private PropertySource<CuratorFramework> create(String context) {
        if (this.properties.isCacheEnabled()) {
            ZookeeperTreeCachePropertySource propertySource = new ZookeeperTreeCachePropertySource(context, this.curator);
            propertySource.start();
            this.lifecycleSources.put(propertySource.getName(), propertySource);
            return propertySource;
        }
        return new ZookeeperPropertySource(context, this.curator);
    }

    private void addProfiles(List<String> contexts, String baseContext, List<String> profiles) {
        for (String profile : profiles) {
            contexts.add(baseContext + this.properties.getProfileSeparator() + profile);
        }
    }
}

